use core:io;

/**
 * State for parsing strings with a recursive descent parser.
 */
class RecursiveStrState {
	// String to parse.
	Str input;

	// Current position.
	Str:Iter pos;

	init(Str input, Str:Iter start) {
		init {
			input = input;
			pos = start;
		}
	}

	// Set error.
	void error(Str error) : abstract;
}

/**
 * State for parsing binary objects with a recursive descent parser.
 */
class RecursiveBinaryState {
	// Input to parse.
	Buffer input;

	// Current position.
	Nat pos;

	// Error?
	Str error;

	init(Buffer input, Nat start) {
		init {
			input = input;
			pos = start;
			error = "";
		}
	}

	// Set error.
	void error(Str error) : abstract;
}
