% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay5.R
\name{split.StdAssay}
\alias{split.StdAssay}
\alias{split,StdAssay-method}
\title{Split an Assay}
\usage{
\method{split}{StdAssay}(
  x,
  f,
  drop = FALSE,
  layers = c("counts", "data"),
  ret = c("assay", "multiassays", "layers"),
  ...
)

\S4method{split}{StdAssay}(
  x,
  f,
  drop = FALSE,
  layers = c("counts", "data"),
  ret = c("assay", "multiassays", "layers"),
  ...
)
}
\arguments{
\item{x}{An \code{\link{Assay5}} object}

\item{f}{a \sQuote{factor} in the sense that \code{\link[base]{as.factor}(f)}
    defines the grouping, or a list of such factors in which case their
    interaction is used for the grouping. If \code{x} is a data frame,
    \code{f} can also be a formula of the form \code{ ~ g} to split by
    the variable \code{g}, or more generally of the form \code{ ~ g1 +
      \dots + gk} to split by the interaction of the variables
    \code{g1}, \dots, \code{gk}, where these variables are evaluated in
    the data frame \code{x} using the usual non-standard evaluation
    rules.}

\item{drop}{logical indicating if levels that do not occur should be dropped
    (if \code{f} is a \code{factor} or a list).}

\item{layers}{Names of layers to include in the split; pass \code{NA} for
all layers; pass \code{NULL} for the \link[=DefaultLayer]{default layer}}

\item{ret}{Type of return value; choose from:
\itemize{
 \item \dQuote{\code{assay}}: a single \code{\link{Assay5}} object
 \item \dQuote{\code{multiassay}}: a list of \code{\link{Assay5}} objects
 \item \dQuote{\code{layers}}: a list of layer matrices
}}

\item{...}{Ignored}
}
\value{
Depends on the value of \code{ret}:
\itemize{
 \item \dQuote{\code{assay}}: \code{x} with the layers requested in
 \code{layers} split based on \code{f}; all other layers are left as-is
 \item \dQuote{\code{multiassay}}: a list of \code{\link{Assay5}} objects;
 the list contains one value per split and each assay contains only the
 layers requested in \code{layers} with the \link[=Key]{key} set to the split
 \item \dQuote{\code{layers}}: a list of matrices of length
 \code{length(assays) * length(unique(f))}; the list is named as
 \dQuote{\code{layer.split}}
}
}
\description{
Split an Assay
}
\section{Progress Updates with \pkg{progressr}}{

This function uses
\href{https://cran.r-project.org/package=progressr}{\pkg{progressr}} to
render status updates and progress bars. To enable progress updates, wrap
the function call in \code{\link[progressr]{with_progress}} or run
\code{\link[progressr:handlers]{handlers(global = TRUE)}} before running
this function. For more details about \pkg{progressr}, please read
\href{https://progressr.futureverse.org/articles/progressr-01-intro.html}{\code{vignette("progressr-intro")}}
}

\seealso{
v5 Standard Assay object, validity, and interaction methods
\code{\link{$.StdAssay}()},
\code{\link{.DollarNames.StdAssay}()},
\code{\link{StdAssay-class}},
\code{\link{StdAssay-validity}},
\code{\link{[.StdAssay}()},
\code{\link{[[.StdAssay}()},
\code{\link{dim.StdAssay}()},
\code{\link{dimnames.StdAssay}()},
\code{\link{show,StdAssay-method}},
\code{\link{subset.StdAssay}()}
}
\concept{stdassay}
\keyword{internal}
