% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_flextable.R
\name{merge_v}
\alias{merge_v}
\title{Merge flextable cells vertically}
\usage{
merge_v(x, j = NULL, target = NULL, part = "body", combine = FALSE)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{target}{columns names where cells have to be merged.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' is not allowed by the function.}

\item{combine}{If the value is TRUE, the columns defined by \code{j} will
be combined into a single column/value and the consecutive values of
this result will be used. Otherwise, the columns are inspected one
by one to perform cell merges.}
}
\description{
Merge flextable cells vertically when consecutive cells have
identical values. Text of formatted values are used to compare
values if available.

Two options are available, either a column-by-column algorithm or an
algorithm where the combinations of these columns are used once for all
target columns.
}
\examples{
ft_merge <- flextable(mtcars)
ft_merge <- merge_v(ft_merge, j = c("gear", "carb"))
ft_merge

data_ex <- structure(list(srdr_id = c(
  "175124", "175124", "172525", "172525",
  "172545", "172545", "172609", "172609", "172609"
), substances = c(
  "alcohol",
  "alcohol", "alcohol", "alcohol", "cannabis",
  "cannabis", "alcohol\n cannabis\n other drugs",
  "alcohol\n cannabis\n other drugs",
  "alcohol\n cannabis\n other drugs"
), full_name = c(
  "TAU", "MI", "TAU", "MI (parent)", "TAU", "MI",
  "TAU", "MI", "MI"
), article_arm_name = c(
  "Control", "WISEteens",
  "Treatment as usual", "Brief MI (b-MI)", "Assessed control",
  "Intervention", "Control", "Computer BI", "Therapist BI"
)), row.names = c(
  NA,
  -9L
), class = c("tbl_df", "tbl", "data.frame"))


ft_1 <- flextable(data_ex)
ft_1 <- theme_box(ft_1)
ft_2 <- merge_v(ft_1,
  j = "srdr_id",
  target = c("srdr_id", "substances")
)
ft_2
}
\seealso{
Other flextable merging function: 
\code{\link{merge_at}()},
\code{\link{merge_h}()},
\code{\link{merge_h_range}()},
\code{\link{merge_none}()}
}
\concept{flextable merging function}
