% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{add_footer_lines}
\alias{add_footer_lines}
\title{Add full-width rows to the footer}
\usage{
add_footer_lines(x, values = character(0), top = FALSE)
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{values}{a character vector or a call to \code{\link[=as_paragraph]{as_paragraph()}}
to get formated content, each element will
be added as a new row.}

\item{top}{should the row be inserted at the top
or the bottom. Default to TRUE.}
}
\description{
Add one or more rows to the footer where each label
spans all columns (all cells merged into one). Useful for adding
footnotes or source notes below the table.
}
\examples{
ft_1 <- flextable(head(iris))
ft_1 <- add_footer_lines(ft_1,
  values = c("blah 1", "blah 2")
)
ft_1
}
\seealso{
Other functions for row and column operations in a flextable: 
\code{\link{add_body}()},
\code{\link{add_body_row}()},
\code{\link{add_footer}()},
\code{\link{add_footer_row}()},
\code{\link{add_header}()},
\code{\link{add_header_lines}()},
\code{\link{add_header_row}()},
\code{\link{delete_columns}()},
\code{\link{delete_part}()},
\code{\link{separate_header}()},
\code{\link{set_header_footer_df}},
\code{\link{set_header_labels}()}
}
\concept{functions for row and column operations in a flextable}
