
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <SelectBasics.hxx>
#include <SelectBasics_EntityOwner.hxx>
#include <SelectBasics_PickResult.hxx>
#include <SelectBasics_SelectingVolumeManager.hxx>
#include <SelectBasics_SensitiveEntity.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_SelectBasics(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("SelectBasics"));
py::object klass;

//Python trampoline classes
    class Py_SelectBasics_SelectingVolumeManager : public SelectBasics_SelectingVolumeManager{
    public:
        using SelectBasics_SelectingVolumeManager::SelectBasics_SelectingVolumeManager;


        // public pure virtual
        Standard_Integer GetActiveSelectionType() const  override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,GetActiveSelectionType,) };
        Standard_Boolean OverlapsBox( const NCollection_Vec3<Standard_Real> & theBoxMin, const NCollection_Vec3<Standard_Real> & theBoxMax,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsBox,theBoxMin,theBoxMax,thePickResult) };
        Standard_Boolean OverlapsBox( const NCollection_Vec3<Standard_Real> & theBoxMin, const NCollection_Vec3<Standard_Real> & theBoxMax,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsBox,theBoxMin,theBoxMax,theInside) };
        Standard_Boolean OverlapsPoint( const gp_Pnt & thePnt,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsPoint,thePnt,thePickResult) };
        Standard_Boolean OverlapsPoint( const gp_Pnt & thePnt) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsPoint,thePnt) };
        Standard_Boolean OverlapsPolygon( const TColgp_Array1OfPnt & theArrayOfPts,Standard_Integer theSensType,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsPolygon,theArrayOfPts,theSensType,thePickResult) };
        Standard_Boolean OverlapsSegment( const gp_Pnt & thePt1, const gp_Pnt & thePt2,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsSegment,thePt1,thePt2,thePickResult) };
        Standard_Boolean OverlapsTriangle( const gp_Pnt & thePt1, const gp_Pnt & thePt2, const gp_Pnt & thePt3,Standard_Integer theSensType,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsTriangle,thePt1,thePt2,thePt3,theSensType,thePickResult) };
        Standard_Boolean OverlapsSphere( const gp_Pnt & theCenter, const Standard_Real theRadius,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsSphere,theCenter,theRadius,thePickResult) };
        Standard_Boolean OverlapsSphere( const gp_Pnt & theCenter, const Standard_Real theRadius,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsSphere,theCenter,theRadius,theInside) };
        Standard_Boolean OverlapsCylinder( const Standard_Real theBottomRad, const Standard_Real theTopRad, const Standard_Real theHeight, const gp_Trsf & theTrsf, const Standard_Boolean theIsHollow,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsCylinder,theBottomRad,theTopRad,theHeight,theTrsf,theIsHollow,thePickResult) };
        Standard_Boolean OverlapsCylinder( const Standard_Real theBottomRad, const Standard_Real theTopRad, const Standard_Real theHeight, const gp_Trsf & theTrsf, const Standard_Boolean theIsHollow,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsCylinder,theBottomRad,theTopRad,theHeight,theTrsf,theIsHollow,theInside) };
        Standard_Boolean OverlapsCircle( const Standard_Real theRadius, const gp_Trsf & theTrsf, const Standard_Boolean theIsFilled,SelectBasics_PickResult & thePickResult) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsCircle,theRadius,theTrsf,theIsFilled,thePickResult) };
        Standard_Boolean OverlapsCircle( const Standard_Real theRadius, const gp_Trsf & theTrsf, const Standard_Boolean theIsFilled,Standard_Boolean * theInside) const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,OverlapsCircle,theRadius,theTrsf,theIsFilled,theInside) };
        Standard_Real DistToGeometryCenter( const gp_Pnt & theCOG) const  override { using return_type = Standard_Real;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,DistToGeometryCenter,theCOG) };
        gp_Pnt DetectedPoint( const Standard_Real theDepth) const  override { using return_type = gp_Pnt;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,DetectedPoint,theDepth) };
        Standard_Boolean IsOverlapAllowed() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,IsOverlapAllowed,) };
        gp_Pnt GetNearPickedPnt() const  override { using return_type = gp_Pnt;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,GetNearPickedPnt,) };
        gp_Pnt GetFarPickedPnt() const  override { using return_type = gp_Pnt;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,GetFarPickedPnt,) };
        gp_Dir GetViewRayDirection() const  override { using return_type = gp_Dir;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,GetViewRayDirection,) };
        Standard_Boolean IsScalableActiveVolume() const  override { using return_type = Standard_Boolean;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,IsScalableActiveVolume,) };
        gp_Pnt2d GetMousePosition() const  override { using return_type = gp_Pnt2d;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,GetMousePosition,) };
        void GetPlanes(NCollection_Vector<NCollection_Vec4<Standard_Real>> & thePlaneEquations) const  override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,SelectBasics_SelectingVolumeManager,GetPlanes,thePlaneEquations) };


        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class SelectBasics from ./opencascade/SelectBasics.hxx
    klass = m.attr("SelectBasics");

    // default constructor
    register_default_constructor<SelectBasics , shared_ptr<SelectBasics>>(m,"SelectBasics");

    // nested enums

    static_cast<py::class_<SelectBasics , shared_ptr<SelectBasics>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("MaxOwnerPriority_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&SelectBasics::MaxOwnerPriority),
                    R"#(Structure to provide all-in-one result of selection of sensitive for "Matches" method of Select3D_SensitiveEntity.)#" 
          )
        .def_static("MinOwnerPriority_s",
                    (Standard_Integer (*)() ) static_cast<Standard_Integer (*)() >(&SelectBasics::MinOwnerPriority),
                    R"#()#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class SelectBasics_PickResult from ./opencascade/SelectBasics_PickResult.hxx
    klass = m.attr("SelectBasics_PickResult");


    // nested enums

    static_cast<py::class_<SelectBasics_PickResult , shared_ptr<SelectBasics_PickResult>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< Standard_Real,Standard_Real, const gp_Pnt & >()  , py::arg("theDepth"),  py::arg("theDistToCenter"),  py::arg("theObjPickedPnt") )
    // custom constructors
    // methods
        .def("IsValid",
             (Standard_Boolean (SelectBasics_PickResult::*)() const) static_cast<Standard_Boolean (SelectBasics_PickResult::*)() const>(&SelectBasics_PickResult::IsValid),
             R"#(Return TRUE if result was been defined.)#" 
          )
        .def("Invalidate",
             (void (SelectBasics_PickResult::*)() ) static_cast<void (SelectBasics_PickResult::*)() >(&SelectBasics_PickResult::Invalidate),
             R"#(Reset depth value.)#" 
          )
        .def("Depth",
             (Standard_Real (SelectBasics_PickResult::*)() const) static_cast<Standard_Real (SelectBasics_PickResult::*)() const>(&SelectBasics_PickResult::Depth),
             R"#(Return depth along picking ray.)#" 
          )
        .def("SetDepth",
             (void (SelectBasics_PickResult::*)( Standard_Real  ) ) static_cast<void (SelectBasics_PickResult::*)( Standard_Real  ) >(&SelectBasics_PickResult::SetDepth),
             R"#(Set depth along picking ray.)#"  , py::arg("theDepth")
          )
        .def("HasPickedPoint",
             (Standard_Boolean (SelectBasics_PickResult::*)() const) static_cast<Standard_Boolean (SelectBasics_PickResult::*)() const>(&SelectBasics_PickResult::HasPickedPoint),
             R"#(Return TRUE if Picked Point lying on detected entity was set.)#" 
          )
        .def("SetPickedPoint",
             (void (SelectBasics_PickResult::*)(  const gp_Pnt &  ) ) static_cast<void (SelectBasics_PickResult::*)(  const gp_Pnt &  ) >(&SelectBasics_PickResult::SetPickedPoint),
             R"#(Set picked point.)#"  , py::arg("theObjPickedPnt")
          )
        .def("DistToGeomCenter",
             (Standard_Real (SelectBasics_PickResult::*)() const) static_cast<Standard_Real (SelectBasics_PickResult::*)() const>(&SelectBasics_PickResult::DistToGeomCenter),
             R"#(Return distance to geometry center (auxiliary value for comparing results).)#" 
          )
        .def("SetDistToGeomCenter",
             (void (SelectBasics_PickResult::*)( Standard_Real  ) ) static_cast<void (SelectBasics_PickResult::*)( Standard_Real  ) >(&SelectBasics_PickResult::SetDistToGeomCenter),
             R"#(Set distance to geometry center.)#"  , py::arg("theDistToCenter")
          )
        .def("SetSurfaceNormal",
             (void (SelectBasics_PickResult::*)(  const NCollection_Vec3<float> &  ) ) static_cast<void (SelectBasics_PickResult::*)(  const NCollection_Vec3<float> &  ) >(&SelectBasics_PickResult::SetSurfaceNormal),
             R"#(Set surface normal at picked point.)#"  , py::arg("theNormal")
          )
        .def("SetSurfaceNormal",
             (void (SelectBasics_PickResult::*)(  const gp_Vec &  ) ) static_cast<void (SelectBasics_PickResult::*)(  const gp_Vec &  ) >(&SelectBasics_PickResult::SetSurfaceNormal),
             R"#(Set surface normal at picked point.)#"  , py::arg("theNormal")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Min_s",
                    ( const SelectBasics_PickResult & (*)(  const SelectBasics_PickResult & ,   const SelectBasics_PickResult &  ) ) static_cast< const SelectBasics_PickResult & (*)(  const SelectBasics_PickResult & ,   const SelectBasics_PickResult &  ) >(&SelectBasics_PickResult::Min),
                    R"#(Return closest result between two Pick Results according to Depth value.)#"  , py::arg("thePickResult1"),  py::arg("thePickResult2")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("PickedPoint",
             ( const gp_Pnt & (SelectBasics_PickResult::*)() const) static_cast< const gp_Pnt & (SelectBasics_PickResult::*)() const>(&SelectBasics_PickResult::PickedPoint),
             R"#(Return picked point lying on detected entity. WARNING! Point is defined in local coordinate system and should be translated into World System before usage!)#"
             
         )
       .def("SurfaceNormal",
             ( const NCollection_Vec3<float> & (SelectBasics_PickResult::*)() const) static_cast< const NCollection_Vec3<float> & (SelectBasics_PickResult::*)() const>(&SelectBasics_PickResult::SurfaceNormal),
             R"#(Return (unnormalized) surface normal at picked point or zero vector if undefined. WARNING! Normal is defined in local coordinate system and should be translated into World System before usage!)#"
             
         )
;

    // Class SelectBasics_SelectingVolumeManager from ./opencascade/SelectBasics_SelectingVolumeManager.hxx
    klass = m.attr("SelectBasics_SelectingVolumeManager");


    // nested enums

    static_cast<py::class_<SelectBasics_SelectingVolumeManager , shared_ptr<SelectBasics_SelectingVolumeManager> ,Py_SelectBasics_SelectingVolumeManager >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("GetActiveSelectionType",
             (Standard_Integer (SelectBasics_SelectingVolumeManager::*)() const) static_cast<Standard_Integer (SelectBasics_SelectingVolumeManager::*)() const>(&SelectBasics_SelectingVolumeManager::GetActiveSelectionType),
             R"#(Return selection type.)#" 
          )
        .def("OverlapsBox",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const NCollection_Vec3<Standard_Real> & ,   const NCollection_Vec3<Standard_Real> & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const NCollection_Vec3<Standard_Real> & ,   const NCollection_Vec3<Standard_Real> & ,  SelectBasics_PickResult &  ) const>(&SelectBasics_SelectingVolumeManager::OverlapsBox),
             R"#(Returns true if selecting volume is overlapped by box theBox)#"  , py::arg("theBoxMin"),  py::arg("theBoxMax"),  py::arg("thePickResult")
          )
        .def("OverlapsBox",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const NCollection_Vec3<Standard_Real> & ,   const NCollection_Vec3<Standard_Real> & ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const NCollection_Vec3<Standard_Real> & ,   const NCollection_Vec3<Standard_Real> & ,  Standard_Boolean *  ) const>(&SelectBasics_SelectingVolumeManager::OverlapsBox),
             R"#(Returns true if selecting volume is overlapped by axis-aligned bounding box with minimum corner at point theMinPt and maximum at point theMaxPt)#"  , py::arg("theBoxMin"),  py::arg("theBoxMax"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsPoint",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,  SelectBasics_PickResult &  ) const>(&SelectBasics_SelectingVolumeManager::OverlapsPoint),
             R"#(Returns true if selecting volume is overlapped by point thePnt)#"  , py::arg("thePnt"),  py::arg("thePickResult")
          )
        .def("OverlapsPoint",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt &  ) const>(&SelectBasics_SelectingVolumeManager::OverlapsPoint),
             R"#(Returns true if selecting volume is overlapped by point thePnt. Does not perform depth calculation, so this method is defined as helper function for inclusion test.)#"  , py::arg("thePnt")
          )
        .def("OverlapsPolygon",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const TColgp_Array1OfPnt & ,  Standard_Integer ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const TColgp_Array1OfPnt & ,  Standard_Integer ,  SelectBasics_PickResult &  ) const>(&SelectBasics_SelectingVolumeManager::OverlapsPolygon),
             R"#(Returns true if selecting volume is overlapped by planar convex polygon, which points are stored in theArrayOfPts, taking into account sensitivity type theSensType)#"  , py::arg("theArrayOfPts"),  py::arg("theSensType"),  py::arg("thePickResult")
          )
        .def("OverlapsSegment",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,   const gp_Pnt & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,   const gp_Pnt & ,  SelectBasics_PickResult &  ) const>(&SelectBasics_SelectingVolumeManager::OverlapsSegment),
             R"#(Returns true if selecting volume is overlapped by line segment with start point at thePt1 and end point at thePt2)#"  , py::arg("thePt1"),  py::arg("thePt2"),  py::arg("thePickResult")
          )
        .def("OverlapsTriangle",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Standard_Integer ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Standard_Integer ,  SelectBasics_PickResult &  ) const>(&SelectBasics_SelectingVolumeManager::OverlapsTriangle),
             R"#(Returns true if selecting volume is overlapped by triangle with vertices thePt1, thePt2 and thePt3, taking into account sensitivity type theSensType)#"  , py::arg("thePt1"),  py::arg("thePt2"),  py::arg("thePt3"),  py::arg("theSensType"),  py::arg("thePickResult")
          )
        .def("OverlapsSphere",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,   const Standard_Real ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,   const Standard_Real ,  SelectBasics_PickResult &  ) const>(&SelectBasics_SelectingVolumeManager::OverlapsSphere),
             R"#(Returns true if selecting volume is overlapped by sphere with center theCenter and radius theRadius)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("thePickResult")
          )
        .def("OverlapsSphere",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,   const Standard_Real ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,   const Standard_Real ,  Standard_Boolean *  ) const>(&SelectBasics_SelectingVolumeManager::OverlapsSphere),
             R"#(Returns true if selecting volume is overlapped by sphere with center theCenter and radius theRadius)#"  , py::arg("theCenter"),  py::arg("theRadius"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsCylinder",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  SelectBasics_PickResult &  ) const>(&SelectBasics_SelectingVolumeManager::OverlapsCylinder),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight, the boolean theIsHollow and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theTrsf"),  py::arg("theIsHollow"),  py::arg("thePickResult")
          )
        .def("OverlapsCylinder",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const Standard_Real ,   const Standard_Real ,   const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const>(&SelectBasics_SelectingVolumeManager::OverlapsCylinder),
             R"#(Returns true if selecting volume is overlapped by cylinder (or cone) with radiuses theBottomRad and theTopRad, height theHeight, the boolean theIsHollow and transformation to apply theTrsf.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theTrsf"),  py::arg("theIsHollow"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("OverlapsCircle",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  SelectBasics_PickResult &  ) const>(&SelectBasics_SelectingVolumeManager::OverlapsCircle),
             R"#(Returns true if selecting volume is overlapped by circle with radius theRadius, the boolean theIsFilled, and transformation to apply theTrsf. The position and orientation of the circle are specified via theTrsf transformation for gp::XOY() with center in gp::Origin().)#"  , py::arg("theRadius"),  py::arg("theTrsf"),  py::arg("theIsFilled"),  py::arg("thePickResult")
          )
        .def("OverlapsCircle",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const Standard_Real ,   const gp_Trsf & ,   const Standard_Boolean ,  Standard_Boolean *  ) const>(&SelectBasics_SelectingVolumeManager::OverlapsCircle),
             R"#(Returns true if selecting volume is overlapped by circle with radius theRadius, the boolean theIsFilled, and transformation to apply theTrsf. The position and orientation of the circle are specified via theTrsf transformation for gp::XOY() with center in gp::Origin().)#"  , py::arg("theRadius"),  py::arg("theTrsf"),  py::arg("theIsFilled"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("DistToGeometryCenter",
             (Standard_Real (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt &  ) const) static_cast<Standard_Real (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt &  ) const>(&SelectBasics_SelectingVolumeManager::DistToGeometryCenter),
             R"#(Calculates distance from 3d projection of user-defined selection point to the given point theCOG)#"  , py::arg("theCOG")
          )
        .def("DetectedPoint",
             (gp_Pnt (SelectBasics_SelectingVolumeManager::*)(  const Standard_Real  ) const) static_cast<gp_Pnt (SelectBasics_SelectingVolumeManager::*)(  const Standard_Real  ) const>(&SelectBasics_SelectingVolumeManager::DetectedPoint),
             R"#(Return 3D point corresponding to specified depth within picking ray.)#"  , py::arg("theDepth")
          )
        .def("IsOverlapAllowed",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)() const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)() const>(&SelectBasics_SelectingVolumeManager::IsOverlapAllowed),
             R"#(Returns flag indicating if partial overlapping of entities is allowed or should be rejected.)#" 
          )
        .def("GetNearPickedPnt",
             (gp_Pnt (SelectBasics_SelectingVolumeManager::*)() const) static_cast<gp_Pnt (SelectBasics_SelectingVolumeManager::*)() const>(&SelectBasics_SelectingVolumeManager::GetNearPickedPnt),
             R"#(Valid only for point and rectangular selection. Returns projection of 2d mouse picked point or projection of center of 2d rectangle (for point and rectangular selection correspondingly) onto near view frustum plane)#" 
          )
        .def("GetFarPickedPnt",
             (gp_Pnt (SelectBasics_SelectingVolumeManager::*)() const) static_cast<gp_Pnt (SelectBasics_SelectingVolumeManager::*)() const>(&SelectBasics_SelectingVolumeManager::GetFarPickedPnt),
             R"#(Valid only for point and rectangular selection. Returns projection of 2d mouse picked point or projection of center of 2d rectangle (for point and rectangular selection correspondingly) onto far view frustum plane)#" 
          )
        .def("GetViewRayDirection",
             (gp_Dir (SelectBasics_SelectingVolumeManager::*)() const) static_cast<gp_Dir (SelectBasics_SelectingVolumeManager::*)() const>(&SelectBasics_SelectingVolumeManager::GetViewRayDirection),
             R"#(Valid only for point and rectangular selection. Returns view ray direction)#" 
          )
        .def("IsScalableActiveVolume",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)() const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)() const>(&SelectBasics_SelectingVolumeManager::IsScalableActiveVolume),
             R"#(Checks if it is possible to scale current active selecting volume)#" 
          )
        .def("GetMousePosition",
             (gp_Pnt2d (SelectBasics_SelectingVolumeManager::*)() const) static_cast<gp_Pnt2d (SelectBasics_SelectingVolumeManager::*)() const>(&SelectBasics_SelectingVolumeManager::GetMousePosition),
             R"#(Returns mouse coordinates for Point selection mode.)#" 
          )
        .def("GetPlanes",
             (void (SelectBasics_SelectingVolumeManager::*)( NCollection_Vector<NCollection_Vec4<Standard_Real>> &  ) const) static_cast<void (SelectBasics_SelectingVolumeManager::*)( NCollection_Vector<NCollection_Vec4<Standard_Real>> &  ) const>(&SelectBasics_SelectingVolumeManager::GetPlanes),
             R"#(Stores plane equation coefficients (in the following form: Ax + By + Cz + D = 0) to the given vector)#"  , py::arg("thePlaneEquations")
          )
        .def("DumpJson",
             (void (SelectBasics_SelectingVolumeManager::*)( Standard_OStream & ,  Standard_Integer  ) const) static_cast<void (SelectBasics_SelectingVolumeManager::*)( Standard_OStream & ,  Standard_Integer  ) const>(&SelectBasics_SelectingVolumeManager::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("Overlaps",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const NCollection_Vec3<Standard_Real> & ,   const NCollection_Vec3<Standard_Real> & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const NCollection_Vec3<Standard_Real> & ,   const NCollection_Vec3<Standard_Real> & ,  SelectBasics_PickResult &  ) const>(&SelectBasics_SelectingVolumeManager::Overlaps),
             R"#()#"  , py::arg("theBoxMin"),  py::arg("theBoxMax"),  py::arg("thePickResult")
          )
        .def("Overlaps",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const NCollection_Vec3<Standard_Real> & ,   const NCollection_Vec3<Standard_Real> & ,  Standard_Boolean *  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const NCollection_Vec3<Standard_Real> & ,   const NCollection_Vec3<Standard_Real> & ,  Standard_Boolean *  ) const>(&SelectBasics_SelectingVolumeManager::Overlaps),
             R"#()#"  , py::arg("theBoxMin"),  py::arg("theBoxMax"),  py::arg("theInside")=static_cast<Standard_Boolean *>(NULL)
          )
        .def("Overlaps",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,  SelectBasics_PickResult &  ) const>(&SelectBasics_SelectingVolumeManager::Overlaps),
             R"#()#"  , py::arg("thePnt"),  py::arg("thePickResult")
          )
        .def("Overlaps",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt &  ) const>(&SelectBasics_SelectingVolumeManager::Overlaps),
             R"#()#"  , py::arg("thePnt")
          )
        .def("Overlaps",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const handle<TColgp_HArray1OfPnt> & ,  Standard_Integer ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const handle<TColgp_HArray1OfPnt> & ,  Standard_Integer ,  SelectBasics_PickResult &  ) const>(&SelectBasics_SelectingVolumeManager::Overlaps),
             R"#()#"  , py::arg("theArrayOfPts"),  py::arg("theSensType"),  py::arg("thePickResult")
          )
        .def("Overlaps",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const TColgp_Array1OfPnt & ,  Standard_Integer ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const TColgp_Array1OfPnt & ,  Standard_Integer ,  SelectBasics_PickResult &  ) const>(&SelectBasics_SelectingVolumeManager::Overlaps),
             R"#()#"  , py::arg("theArrayOfPts"),  py::arg("theSensType"),  py::arg("thePickResult")
          )
        .def("Overlaps",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,   const gp_Pnt & ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,   const gp_Pnt & ,  SelectBasics_PickResult &  ) const>(&SelectBasics_SelectingVolumeManager::Overlaps),
             R"#()#"  , py::arg("thePnt1"),  py::arg("thePnt2"),  py::arg("thePickResult")
          )
        .def("Overlaps",
             (Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Standard_Integer ,  SelectBasics_PickResult &  ) const) static_cast<Standard_Boolean (SelectBasics_SelectingVolumeManager::*)(  const gp_Pnt & ,   const gp_Pnt & ,   const gp_Pnt & ,  Standard_Integer ,  SelectBasics_PickResult &  ) const>(&SelectBasics_SelectingVolumeManager::Overlaps),
             R"#()#"  , py::arg("thePnt1"),  py::arg("thePnt2"),  py::arg("thePnt3"),  py::arg("theSensType"),  py::arg("thePickResult")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions

// ./opencascade/SelectBasics.hxx
// ./opencascade/SelectBasics_EntityOwner.hxx
// ./opencascade/SelectBasics_PickResult.hxx
// ./opencascade/SelectBasics_SelectingVolumeManager.hxx
// ./opencascade/SelectBasics_SensitiveEntity.hxx

// Additional functions


// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
