# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import (
    AzureVoiceType,
    ClientEventType,
    ContentPartType,
    InterimResponseConfigType,
    ItemType,
    MessageRole,
    ResponseStatus,
    ServerEventType,
    ToolType,
    TurnDetectionType,
)

if TYPE_CHECKING:
    from .. import _types, models as _models


class AgentConfig(_Model):
    """Configuration for the agent.

    :ivar type: The type of agent to use. Required. Default value is "agent".
    :vartype type: str
    :ivar name: The name of the agent. Required.
    :vartype name: str
    :ivar description: Optional description of the agent.
    :vartype description: str
    :ivar agent_id: The ID of the agent. Required.
    :vartype agent_id: str
    :ivar thread_id: The ID of the conversation thread. Required.
    :vartype thread_id: str
    """

    type: Literal["agent"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of agent to use. Required. Default value is \"agent\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the agent. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional description of the agent."""
    agent_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the agent. Required."""
    thread_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the conversation thread. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        agent_id: str,
        thread_id: str,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["agent"] = "agent"


class Animation(_Model):
    """Configuration for animation outputs including blendshapes and visemes metadata.

    :ivar model_name: The name of the animation model to use.
    :vartype model_name: str
    :ivar outputs: Set of output data types requested from the animation system.
    :vartype outputs: list[str or ~azure.ai.voicelive.models.AnimationOutputType]
    """

    model_name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the animation model to use."""
    outputs: Optional[list[Union[str, "_models.AnimationOutputType"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Set of output data types requested from the animation system."""

    @overload
    def __init__(
        self,
        *,
        model_name: Optional[str] = None,
        outputs: Optional[list[Union[str, "_models.AnimationOutputType"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationRequestItem(_Model):
    """Base for any response item; discriminated by ``type``.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FunctionCallItem, FunctionCallOutputItem, MCPApprovalResponseRequestItem, MessageItem

    :ivar type: Required. Known values are: "message", "function_call", "function_call_output",
     "mcp_list_tools", "mcp_call", "mcp_approval_request", and "mcp_approval_response".
    :vartype type: str or ~azure.ai.voicelive.models.ItemType
    :ivar id:
    :vartype id: str
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"message\", \"function_call\", \"function_call_output\",
     \"mcp_list_tools\", \"mcp_call\", \"mcp_approval_request\", and \"mcp_approval_response\"."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        type: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MessageItem(ConversationRequestItem, discriminator="message"):
    """A message item within a conversation.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AssistantMessageItem, SystemMessageItem, UserMessageItem

    :ivar id:
    :vartype id: str
    :ivar type: The type of the item; must be 'message' for message items. Required. MESSAGE.
    :vartype type: str or ~azure.ai.voicelive.models.MESSAGE
    :ivar role: The role of the message origionator. Required. Known values are: "system", "user",
     and "assistant".
    :vartype role: str or ~azure.ai.voicelive.models.MessageRole
    :ivar content: The content parts of the message. Required.
    :vartype content: list[~azure.ai.voicelive.models.MessageContentPart]
    :ivar status: Processing status of the message item. Known values are: "completed" and
     "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ItemParamStatus
    """

    __mapping__: dict[str, _Model] = {}
    type: Literal[ItemType.MESSAGE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the item; must be 'message' for message items. Required. MESSAGE."""
    role: str = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])
    """The role of the message origionator. Required. Known values are: \"system\", \"user\", and
     \"assistant\"."""
    content: list["_models.MessageContentPart"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content parts of the message. Required."""
    status: Optional[Union[str, "_models.ItemParamStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Processing status of the message item. Known values are: \"completed\" and \"incomplete\"."""

    @overload
    def __init__(
        self,
        *,
        role: str,
        content: list["_models.MessageContentPart"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        status: Optional[Union[str, "_models.ItemParamStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MESSAGE  # type: ignore


class AssistantMessageItem(MessageItem, discriminator="assistant"):
    """An assistant message item within a conversation.

    :ivar id:
    :vartype id: str
    :ivar type: The type of the item; must be 'message' for message items. Required. MESSAGE.
    :vartype type: str or ~azure.ai.voicelive.models.MESSAGE
    :ivar content: The content parts of the message. Required.
    :vartype content: list[~azure.ai.voicelive.models.MessageContentPart]
    :ivar status: Processing status of the message item. Known values are: "completed" and
     "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ItemParamStatus
    :ivar role: Required. ASSISTANT.
    :vartype role: str or ~azure.ai.voicelive.models.ASSISTANT
    """

    __mapping__: dict[str, _Model] = {}
    role: Literal[MessageRole.ASSISTANT] = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. ASSISTANT."""

    @overload
    def __init__(
        self,
        *,
        content: list["_models.MessageContentPart"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        status: Optional[Union[str, "_models.ItemParamStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.role = MessageRole.ASSISTANT  # type: ignore


class AudioEchoCancellation(_Model):
    """Echo cancellation configuration for server-side audio processing.

    :ivar type: The type of echo cancellation model to use. Required. Default value is
     "server_echo_cancellation".
    :vartype type: str
    """

    type: Literal["server_echo_cancellation"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of echo cancellation model to use. Required. Default value is
     \"server_echo_cancellation\"."""

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["server_echo_cancellation"] = "server_echo_cancellation"


class AudioInputTranscriptionOptions(_Model):
    """Configuration for input audio transcription.

    :ivar model: The transcription model to use. Supported values: 'whisper-1',
     'gpt-4o-transcribe', 'gpt-4o-mini-transcribe', 'azure-speech'. Required. Is one of the
     following types: Literal["whisper-1"], Literal["gpt-4o-transcribe"],
     Literal["gpt-4o-mini-transcribe"], Literal["azure-speech"], str
    :vartype model: str
    :ivar language: Optional language code in BCP-47 (e.g., 'en-US'), or ISO-639-1 (e.g., 'en'), or
     multi languages with auto detection, (e.g., 'en,zh').
    :vartype language: str
    :ivar custom_speech: Optional configuration for custom speech models.
    :vartype custom_speech: dict[str, str]
    :ivar phrase_list: Optional list of phrase hints to bias recognition.
    :vartype phrase_list: list[str]
    """

    model: Union[
        Literal["whisper-1"],
        Literal["gpt-4o-transcribe"],
        Literal["gpt-4o-mini-transcribe"],
        Literal["azure-speech"],
        str,
    ] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The transcription model to use. Supported values: 'whisper-1', 'gpt-4o-transcribe',
     'gpt-4o-mini-transcribe', 'azure-speech'. Required. Is one of the following types:
     Literal[\"whisper-1\"], Literal[\"gpt-4o-transcribe\"], Literal[\"gpt-4o-mini-transcribe\"],
     Literal[\"azure-speech\"], str"""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional language code in BCP-47 (e.g., 'en-US'), or ISO-639-1 (e.g., 'en'), or multi languages
     with auto detection, (e.g., 'en,zh')."""
    custom_speech: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional configuration for custom speech models."""
    phrase_list: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional list of phrase hints to bias recognition."""

    @overload
    def __init__(
        self,
        *,
        model: Union[
            Literal["whisper-1"],
            Literal["gpt-4o-transcribe"],
            Literal["gpt-4o-mini-transcribe"],
            Literal["azure-speech"],
            str,
        ],
        language: Optional[str] = None,
        custom_speech: Optional[dict[str, str]] = None,
        phrase_list: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AudioNoiseReduction(_Model):
    """Configuration for input audio noise reduction.

    :ivar type: The type of noise reduction model. Required. Is one of the following types:
     Literal["azure_deep_noise_suppression"], Literal["near_field"], Literal["far_field"], str
    :vartype type: str
    """

    type: Union[Literal["azure_deep_noise_suppression"], Literal["near_field"], Literal["far_field"], str] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of noise reduction model. Required. Is one of the following types:
     Literal[\"azure_deep_noise_suppression\"], Literal[\"near_field\"], Literal[\"far_field\"], str"""

    @overload
    def __init__(
        self,
        *,
        type: Union[Literal["azure_deep_noise_suppression"], Literal["near_field"], Literal["far_field"], str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvatarConfig(_Model):
    """Configuration for avatar streaming and behavior during the session.

    :ivar type: Type of avatar to use. Known values are: "video-avatar" and "photo-avatar".
    :vartype type: str or ~azure.ai.voicelive.models.AvatarConfigTypes
    :ivar ice_servers: Optional list of ICE servers to use for WebRTC connection establishment.
    :vartype ice_servers: list[~azure.ai.voicelive.models.IceServer]
    :ivar character: The character name or ID used for the avatar. Required.
    :vartype character: str
    :ivar style: Optional avatar style, such as emotional tone or speaking style.
    :vartype style: str
    :ivar model: Base model to use for the avatar. Required for photo avatar. "vasa-1"
    :vartype model: str or ~azure.ai.voicelive.models.PhotoAvatarBaseModes
    :ivar customized: Indicates whether the avatar is customized or not. Required.
    :vartype customized: bool
    :ivar video: Optional video configuration including resolution, bitrate, and codec.
    :vartype video: ~azure.ai.voicelive.models.VideoParams
    :ivar scene: Configuration for the avatar's zoom level, position, rotation and movement
     amplitude in the video frame.
    :vartype scene: ~azure.ai.voicelive.models.Scene
    :ivar output_protocol: Output protocol for avatar streaming. Default is 'webrtc'. Known values
     are: "webrtc" and "websocket".
    :vartype output_protocol: str or ~azure.ai.voicelive.models.AvatarOutputProtocol
    :ivar output_audit_audio: When enabled, forwards audit audio via WebSocket for review/debugging
     purposes, even when avatar output is delivered via WebRTC.
    :vartype output_audit_audio: bool
    """

    type: Optional[Union[str, "_models.AvatarConfigTypes"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of avatar to use. Known values are: \"video-avatar\" and \"photo-avatar\"."""
    ice_servers: Optional[list["_models.IceServer"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional list of ICE servers to use for WebRTC connection establishment."""
    character: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The character name or ID used for the avatar. Required."""
    style: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional avatar style, such as emotional tone or speaking style."""
    model: Optional[Union[str, "_models.PhotoAvatarBaseModes"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Base model to use for the avatar. Required for photo avatar. \"vasa-1\""""
    customized: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates whether the avatar is customized or not. Required."""
    video: Optional["_models.VideoParams"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional video configuration including resolution, bitrate, and codec."""
    scene: Optional["_models.Scene"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Configuration for the avatar's zoom level, position, rotation and movement amplitude in the
     video frame."""
    output_protocol: Optional[Union[str, "_models.AvatarOutputProtocol"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Output protocol for avatar streaming. Default is 'webrtc'. Known values are: \"webrtc\" and
     \"websocket\"."""
    output_audit_audio: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """When enabled, forwards audit audio via WebSocket for review/debugging purposes, even when
     avatar output is delivered via WebRTC."""

    @overload
    def __init__(
        self,
        *,
        character: str,
        customized: bool,
        type: Optional[Union[str, "_models.AvatarConfigTypes"]] = None,
        ice_servers: Optional[list["_models.IceServer"]] = None,
        style: Optional[str] = None,
        model: Optional[Union[str, "_models.PhotoAvatarBaseModes"]] = None,
        video: Optional["_models.VideoParams"] = None,
        scene: Optional["_models.Scene"] = None,
        output_protocol: Optional[Union[str, "_models.AvatarOutputProtocol"]] = None,
        output_audit_audio: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureVoice(_Model):
    """Base for Azure voice configurations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureCustomVoice, AzurePersonalVoice, AzureStandardVoice

    :ivar type: The type of the Azure voice. Required. Known values are: "azure-custom",
     "azure-standard", and "azure-personal".
    :vartype type: str or ~azure.ai.voicelive.models.AzureVoiceType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of the Azure voice. Required. Known values are: \"azure-custom\", \"azure-standard\",
     and \"azure-personal\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureCustomVoice(AzureVoice, discriminator="azure-custom"):
    """Azure custom voice configuration.

    :ivar type: Required. Azure custom voice.
    :vartype type: str or ~azure.ai.voicelive.models.AZURE_CUSTOM
    :ivar name: Voice name cannot be empty. Required.
    :vartype name: str
    :ivar endpoint_id: Endpoint ID cannot be empty. Required.
    :vartype endpoint_id: str
    :ivar temperature: Temperature must be between 0.0 and 1.0.
    :vartype temperature: float
    :ivar custom_lexicon_url:
    :vartype custom_lexicon_url: str
    :ivar custom_text_normalization_url:
    :vartype custom_text_normalization_url: str
    :ivar prefer_locales:
    :vartype prefer_locales: list[str]
    :ivar locale:
    :vartype locale: str
    :ivar style:
    :vartype style: str
    :ivar pitch:
    :vartype pitch: str
    :ivar rate:
    :vartype rate: str
    :ivar volume:
    :vartype volume: str
    """

    type: Literal[AzureVoiceType.AZURE_CUSTOM] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Azure custom voice."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Voice name cannot be empty. Required."""
    endpoint_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Endpoint ID cannot be empty. Required."""
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Temperature must be between 0.0 and 1.0."""
    custom_lexicon_url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    custom_text_normalization_url: Optional[str] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    prefer_locales: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    locale: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    style: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    pitch: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    rate: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    volume: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        name: str,
        endpoint_id: str,
        temperature: Optional[float] = None,
        custom_lexicon_url: Optional[str] = None,
        custom_text_normalization_url: Optional[str] = None,
        prefer_locales: Optional[list[str]] = None,
        locale: Optional[str] = None,
        style: Optional[str] = None,
        pitch: Optional[str] = None,
        rate: Optional[str] = None,
        volume: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = AzureVoiceType.AZURE_CUSTOM  # type: ignore


class AzurePersonalVoice(AzureVoice, discriminator="azure-personal"):
    """Azure personal voice configuration.

    :ivar type: Required. Azure personal voice.
    :vartype type: str or ~azure.ai.voicelive.models.AZURE_PERSONAL
    :ivar name: Voice name cannot be empty. Required.
    :vartype name: str
    :ivar temperature: Temperature must be between 0.0 and 1.0.
    :vartype temperature: float
    :ivar model: Underlying neural model to use for personal voice. Required. Known values are:
     "DragonLatestNeural", "PhoenixLatestNeural", and "PhoenixV2Neural".
    :vartype model: str or ~azure.ai.voicelive.models.PersonalVoiceModels
    :ivar custom_lexicon_url:
    :vartype custom_lexicon_url: str
    :ivar custom_text_normalization_url:
    :vartype custom_text_normalization_url: str
    :ivar prefer_locales:
    :vartype prefer_locales: list[str]
    :ivar locale:
    :vartype locale: str
    :ivar style:
    :vartype style: str
    :ivar pitch:
    :vartype pitch: str
    :ivar rate:
    :vartype rate: str
    :ivar volume:
    :vartype volume: str
    """

    type: Literal[AzureVoiceType.AZURE_PERSONAL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Azure personal voice."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Voice name cannot be empty. Required."""
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Temperature must be between 0.0 and 1.0."""
    model: Union[str, "_models.PersonalVoiceModels"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Underlying neural model to use for personal voice. Required. Known values are:
     \"DragonLatestNeural\", \"PhoenixLatestNeural\", and \"PhoenixV2Neural\"."""
    custom_lexicon_url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    custom_text_normalization_url: Optional[str] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    prefer_locales: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    locale: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    style: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    pitch: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    rate: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    volume: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        name: str,
        model: Union[str, "_models.PersonalVoiceModels"],
        temperature: Optional[float] = None,
        custom_lexicon_url: Optional[str] = None,
        custom_text_normalization_url: Optional[str] = None,
        prefer_locales: Optional[list[str]] = None,
        locale: Optional[str] = None,
        style: Optional[str] = None,
        pitch: Optional[str] = None,
        rate: Optional[str] = None,
        volume: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = AzureVoiceType.AZURE_PERSONAL  # type: ignore


class EouDetection(_Model):
    """Top-level union for end-of-utterance (EOU) semantic detection configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureSemanticDetection, AzureSemanticDetectionEn, AzureSemanticDetectionMultilingual

    :ivar model: Required. Is one of the following types: Literal["semantic_detection_v1"],
     Literal["semantic_detection_v1_en"], Literal["semantic_detection_v1_multilingual"], str
    :vartype model: str
    """

    __mapping__: dict[str, _Model] = {}
    model: str = rest_discriminator(name="model", visibility=["read", "create", "update", "delete", "query"])
    """Required. Is one of the following types: Literal[\"semantic_detection_v1\"],
     Literal[\"semantic_detection_v1_en\"], Literal[\"semantic_detection_v1_multilingual\"], str"""

    @overload
    def __init__(
        self,
        *,
        model: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureSemanticDetection(EouDetection, discriminator="semantic_detection_v1"):
    """Azure semantic end-of-utterance detection (default).

    :ivar model: Required. Default value is "semantic_detection_v1".
    :vartype model: str
    :ivar threshold_level: Threshold level setting. Recommended instead of ``threshold``. One of
     ``low``, ``medium``, ``high``, or ``default``. Known values are: "low", "medium", "high", and
     "default".
    :vartype threshold_level: str or ~azure.ai.voicelive.models.EouThresholdLevel
    :ivar timeout_ms: Timeout in milliseconds. Recommended instead of ``timeout``.
    :vartype timeout_ms: int
    """

    model: Literal["semantic_detection_v1"] = rest_discriminator(name="model", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"semantic_detection_v1\"."""
    threshold_level: Optional[Union[str, "_models.EouThresholdLevel"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Threshold level setting. Recommended instead of ``threshold``. One of ``low``, ``medium``,
     ``high``, or ``default``. Known values are: \"low\", \"medium\", \"high\", and \"default\"."""
    timeout_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Timeout in milliseconds. Recommended instead of ``timeout``."""

    @overload
    def __init__(
        self,
        *,
        threshold_level: Optional[Union[str, "_models.EouThresholdLevel"]] = None,
        timeout_ms: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.model = "semantic_detection_v1"  # type: ignore


class AzureSemanticDetectionEn(EouDetection, discriminator="semantic_detection_v1_en"):
    """Azure semantic end-of-utterance detection (English-optimized).

    :ivar model: Required. Default value is "semantic_detection_v1_en".
    :vartype model: str
    :ivar threshold_level: Threshold level setting. Recommended instead of ``threshold``. One of
     ``low``, ``medium``, ``high``, or ``default``. Known values are: "low", "medium", "high", and
     "default".
    :vartype threshold_level: str or ~azure.ai.voicelive.models.EouThresholdLevel
    :ivar timeout_ms: Timeout in milliseconds. Recommended instead of ``timeout``.
    :vartype timeout_ms: int
    """

    model: Literal["semantic_detection_v1_en"] = rest_discriminator(name="model", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"semantic_detection_v1_en\"."""
    threshold_level: Optional[Union[str, "_models.EouThresholdLevel"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Threshold level setting. Recommended instead of ``threshold``. One of ``low``, ``medium``,
     ``high``, or ``default``. Known values are: \"low\", \"medium\", \"high\", and \"default\"."""
    timeout_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Timeout in milliseconds. Recommended instead of ``timeout``."""

    @overload
    def __init__(
        self,
        *,
        threshold_level: Optional[Union[str, "_models.EouThresholdLevel"]] = None,
        timeout_ms: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.model = "semantic_detection_v1_en"  # type: ignore


class AzureSemanticDetectionMultilingual(EouDetection, discriminator="semantic_detection_v1_multilingual"):
    """Azure semantic end-of-utterance detection (multilingual).

    :ivar model: Required. Default value is "semantic_detection_v1_multilingual".
    :vartype model: str
    :ivar threshold_level: Threshold level setting. Recommended instead of ``threshold``. One of
     ``low``, ``medium``, ``high``, or ``default``. Known values are: "low", "medium", "high", and
     "default".
    :vartype threshold_level: str or ~azure.ai.voicelive.models.EouThresholdLevel
    :ivar timeout_ms: Timeout in milliseconds. Recommended instead of ``timeout``.
    :vartype timeout_ms: int
    """

    model: Literal["semantic_detection_v1_multilingual"] = rest_discriminator(name="model", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"semantic_detection_v1_multilingual\"."""
    threshold_level: Optional[Union[str, "_models.EouThresholdLevel"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Threshold level setting. Recommended instead of ``threshold``. One of ``low``, ``medium``,
     ``high``, or ``default``. Known values are: \"low\", \"medium\", \"high\", and \"default\"."""
    timeout_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Timeout in milliseconds. Recommended instead of ``timeout``."""

    @overload
    def __init__(
        self,
        *,
        threshold_level: Optional[Union[str, "_models.EouThresholdLevel"]] = None,
        timeout_ms: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.model = "semantic_detection_v1_multilingual"  # type: ignore


class TurnDetection(_Model):
    """Top-level union for turn detection configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureSemanticVad, AzureSemanticVadEn, AzureSemanticVadMultilingual, ServerVad

    :ivar type: Required. Known values are: "server_vad", "azure_semantic_vad",
     "azure_semantic_vad_en", and "azure_semantic_vad_multilingual".
    :vartype type: str or ~azure.ai.voicelive.models.TurnDetectionType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"server_vad\", \"azure_semantic_vad\", \"azure_semantic_vad_en\",
     and \"azure_semantic_vad_multilingual\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureSemanticVad(TurnDetection, discriminator="azure_semantic_vad"):
    """Server Speech Detection (Azure semantic VAD, default variant).

    :ivar type: Required. AZURE_SEMANTIC_VAD.
    :vartype type: str or ~azure.ai.voicelive.models.AZURE_SEMANTIC_VAD
    :ivar threshold:
    :vartype threshold: float
    :ivar prefix_padding_ms:
    :vartype prefix_padding_ms: int
    :ivar silence_duration_ms:
    :vartype silence_duration_ms: int
    :ivar end_of_utterance_detection:
    :vartype end_of_utterance_detection: ~azure.ai.voicelive.models.EouDetection
    :ivar speech_duration_ms:
    :vartype speech_duration_ms: int
    :ivar remove_filler_words:
    :vartype remove_filler_words: bool
    :ivar languages:
    :vartype languages: list[str]
    :ivar auto_truncate:
    :vartype auto_truncate: bool
    :ivar create_response:
    :vartype create_response: bool
    :ivar interrupt_response:
    :vartype interrupt_response: bool
    """

    type: Literal[TurnDetectionType.AZURE_SEMANTIC_VAD] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. AZURE_SEMANTIC_VAD."""
    threshold: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    prefix_padding_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    silence_duration_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    end_of_utterance_detection: Optional["_models.EouDetection"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    speech_duration_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    remove_filler_words: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    languages: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    auto_truncate: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    create_response: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    interrupt_response: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        threshold: Optional[float] = None,
        prefix_padding_ms: Optional[int] = None,
        silence_duration_ms: Optional[int] = None,
        end_of_utterance_detection: Optional["_models.EouDetection"] = None,
        speech_duration_ms: Optional[int] = None,
        remove_filler_words: Optional[bool] = None,
        languages: Optional[list[str]] = None,
        auto_truncate: Optional[bool] = None,
        create_response: Optional[bool] = None,
        interrupt_response: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = TurnDetectionType.AZURE_SEMANTIC_VAD  # type: ignore


class AzureSemanticVadEn(TurnDetection, discriminator="azure_semantic_vad_en"):
    """Server Speech Detection (Azure semantic VAD, English-only).

    :ivar type: Required. AZURE_SEMANTIC_VAD_EN.
    :vartype type: str or ~azure.ai.voicelive.models.AZURE_SEMANTIC_VAD_EN
    :ivar threshold:
    :vartype threshold: float
    :ivar prefix_padding_ms:
    :vartype prefix_padding_ms: int
    :ivar silence_duration_ms:
    :vartype silence_duration_ms: int
    :ivar end_of_utterance_detection:
    :vartype end_of_utterance_detection: ~azure.ai.voicelive.models.EouDetection
    :ivar speech_duration_ms:
    :vartype speech_duration_ms: int
    :ivar remove_filler_words:
    :vartype remove_filler_words: bool
    :ivar auto_truncate:
    :vartype auto_truncate: bool
    :ivar create_response:
    :vartype create_response: bool
    :ivar interrupt_response:
    :vartype interrupt_response: bool
    """

    type: Literal[TurnDetectionType.AZURE_SEMANTIC_VAD_EN] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. AZURE_SEMANTIC_VAD_EN."""
    threshold: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    prefix_padding_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    silence_duration_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    end_of_utterance_detection: Optional["_models.EouDetection"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    speech_duration_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    remove_filler_words: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    auto_truncate: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    create_response: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    interrupt_response: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        threshold: Optional[float] = None,
        prefix_padding_ms: Optional[int] = None,
        silence_duration_ms: Optional[int] = None,
        end_of_utterance_detection: Optional["_models.EouDetection"] = None,
        speech_duration_ms: Optional[int] = None,
        remove_filler_words: Optional[bool] = None,
        auto_truncate: Optional[bool] = None,
        create_response: Optional[bool] = None,
        interrupt_response: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = TurnDetectionType.AZURE_SEMANTIC_VAD_EN  # type: ignore


class AzureSemanticVadMultilingual(TurnDetection, discriminator="azure_semantic_vad_multilingual"):
    """Server Speech Detection (Azure semantic VAD).

    :ivar type: Required. AZURE_SEMANTIC_VAD_MULTILINGUAL.
    :vartype type: str or ~azure.ai.voicelive.models.AZURE_SEMANTIC_VAD_MULTILINGUAL
    :ivar threshold:
    :vartype threshold: float
    :ivar prefix_padding_ms:
    :vartype prefix_padding_ms: int
    :ivar silence_duration_ms:
    :vartype silence_duration_ms: int
    :ivar end_of_utterance_detection:
    :vartype end_of_utterance_detection: ~azure.ai.voicelive.models.EouDetection
    :ivar speech_duration_ms:
    :vartype speech_duration_ms: int
    :ivar remove_filler_words:
    :vartype remove_filler_words: bool
    :ivar languages:
    :vartype languages: list[str]
    :ivar auto_truncate:
    :vartype auto_truncate: bool
    :ivar create_response:
    :vartype create_response: bool
    :ivar interrupt_response:
    :vartype interrupt_response: bool
    """

    type: Literal[TurnDetectionType.AZURE_SEMANTIC_VAD_MULTILINGUAL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. AZURE_SEMANTIC_VAD_MULTILINGUAL."""
    threshold: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    prefix_padding_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    silence_duration_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    end_of_utterance_detection: Optional["_models.EouDetection"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    speech_duration_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    remove_filler_words: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    languages: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    auto_truncate: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    create_response: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    interrupt_response: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        threshold: Optional[float] = None,
        prefix_padding_ms: Optional[int] = None,
        silence_duration_ms: Optional[int] = None,
        end_of_utterance_detection: Optional["_models.EouDetection"] = None,
        speech_duration_ms: Optional[int] = None,
        remove_filler_words: Optional[bool] = None,
        languages: Optional[list[str]] = None,
        auto_truncate: Optional[bool] = None,
        create_response: Optional[bool] = None,
        interrupt_response: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = TurnDetectionType.AZURE_SEMANTIC_VAD_MULTILINGUAL  # type: ignore


class AzureStandardVoice(AzureVoice, discriminator="azure-standard"):
    """Azure standard voice configuration.

    :ivar type: Required. Azure standard voice.
    :vartype type: str or ~azure.ai.voicelive.models.AZURE_STANDARD
    :ivar name: Voice name cannot be empty. Required.
    :vartype name: str
    :ivar temperature: Temperature must be between 0.0 and 1.0.
    :vartype temperature: float
    :ivar custom_lexicon_url:
    :vartype custom_lexicon_url: str
    :ivar custom_text_normalization_url:
    :vartype custom_text_normalization_url: str
    :ivar prefer_locales:
    :vartype prefer_locales: list[str]
    :ivar locale:
    :vartype locale: str
    :ivar style:
    :vartype style: str
    :ivar pitch:
    :vartype pitch: str
    :ivar rate:
    :vartype rate: str
    :ivar volume:
    :vartype volume: str
    """

    type: Literal[AzureVoiceType.AZURE_STANDARD] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Azure standard voice."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Voice name cannot be empty. Required."""
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Temperature must be between 0.0 and 1.0."""
    custom_lexicon_url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    custom_text_normalization_url: Optional[str] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    prefer_locales: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    locale: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    style: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    pitch: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    rate: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    volume: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        name: str,
        temperature: Optional[float] = None,
        custom_lexicon_url: Optional[str] = None,
        custom_text_normalization_url: Optional[str] = None,
        prefer_locales: Optional[list[str]] = None,
        locale: Optional[str] = None,
        style: Optional[str] = None,
        pitch: Optional[str] = None,
        rate: Optional[str] = None,
        volume: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = AzureVoiceType.AZURE_STANDARD  # type: ignore


class Background(_Model):
    """Defines a video background, either a solid color or an image URL (mutually exclusive).

    :ivar color: Background color in hex format (e.g., ``#00FF00FF``). Cannot be set if
     ``image_url`` is provided.
    :vartype color: str
    :ivar image_url: Background image URL. Cannot be set if ``color`` is provided.
    :vartype image_url: str
    """

    color: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Background color in hex format (e.g., ``#00FF00FF``). Cannot be set if ``image_url`` is
     provided."""
    image_url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Background image URL. Cannot be set if ``color`` is provided."""

    @overload
    def __init__(
        self,
        *,
        color: Optional[str] = None,
        image_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CachedTokenDetails(_Model):
    """Details of output token usage.

    :ivar text_tokens: Number of cached text tokens. Required.
    :vartype text_tokens: int
    :ivar audio_tokens: Number of cached audio tokens. Required.
    :vartype audio_tokens: int
    :ivar image_tokens: Number of cached image tokens. Required.
    :vartype image_tokens: int
    """

    text_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of cached text tokens. Required."""
    audio_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of cached audio tokens. Required."""
    image_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of cached image tokens. Required."""

    @overload
    def __init__(
        self,
        *,
        text_tokens: int,
        audio_tokens: int,
        image_tokens: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClientEvent(_Model):
    """A voicelive client event.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ClientEventConversationItemCreate, ClientEventConversationItemDelete,
    ClientEventConversationItemRetrieve, ClientEventConversationItemTruncate,
    ClientEventInputAudioClear, ClientEventInputAudioTurnAppend, ClientEventInputAudioTurnCancel,
    ClientEventInputAudioTurnEnd, ClientEventInputAudioTurnStart,
    ClientEventInputAudioBufferAppend, ClientEventInputAudioBufferClear,
    ClientEventInputAudioBufferCommit, ClientEventResponseCancel, ClientEventResponseCreate,
    ClientEventSessionAvatarConnect, ClientEventSessionUpdate

    :ivar type: The type of event. Required. Known values are: "session.update",
     "input_audio_buffer.append", "input_audio_buffer.commit", "input_audio_buffer.clear",
     "input_audio.turn.start", "input_audio.turn.append", "input_audio.turn.end",
     "input_audio.turn.cancel", "input_audio.clear", "conversation.item.create",
     "conversation.item.retrieve", "conversation.item.truncate", "conversation.item.delete",
     "response.create", "response.cancel", "session.avatar.connect", and "mcp_approval_response".
    :vartype type: str or ~azure.ai.voicelive.models.ClientEventType
    :ivar event_id:
    :vartype event_id: str
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of event. Required. Known values are: \"session.update\",
     \"input_audio_buffer.append\", \"input_audio_buffer.commit\", \"input_audio_buffer.clear\",
     \"input_audio.turn.start\", \"input_audio.turn.append\", \"input_audio.turn.end\",
     \"input_audio.turn.cancel\", \"input_audio.clear\", \"conversation.item.create\",
     \"conversation.item.retrieve\", \"conversation.item.truncate\", \"conversation.item.delete\",
     \"response.create\", \"response.cancel\", \"session.avatar.connect\", and
     \"mcp_approval_response\"."""
    event_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        type: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClientEventConversationItemCreate(ClientEvent, discriminator="conversation.item.create"):
    """Add a new Item to the Conversation's context, including messages, function calls, and function
    call responses. This event can be used both to populate a "history" of the conversation and to
    add new items mid-stream, but has the current limitation that it cannot populate assistant
    audio messages. If successful, the server will respond with a ``conversation.item.created``
    event, otherwise an ``error`` event will be sent.

    :ivar type: The event type, must be ``conversation.item.create``. Required.
     CONVERSATION_ITEM_CREATE.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_CREATE
    :ivar event_id: Optional client-generated ID used to identify this event.
    :vartype event_id: str
    :ivar previous_item_id: The ID of the preceding item after which the new item will be inserted.
     If not set, the new item will be appended to the end of the conversation. If set to ``root``,
     the new item will be added to the beginning of the conversation. If set to an existing ID, it
     allows an item to be inserted mid-conversation. If the ID cannot be found, an error will be
     returned and the item will not be added.
    :vartype previous_item_id: str
    :ivar item:
    :vartype item: ~azure.ai.voicelive.models.ConversationRequestItem
    """

    type: Literal[ClientEventType.CONVERSATION_ITEM_CREATE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.create``. Required. CONVERSATION_ITEM_CREATE."""
    previous_item_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the preceding item after which the new item will be inserted. If not set, the new
     item will be appended to the end of the conversation. If set to ``root``, the new item will be
     added to the beginning of the conversation. If set to an existing ID, it allows an item to be
     inserted mid-conversation. If the ID cannot be found, an error will be returned and the item
     will not be added."""
    item: Optional["_models.ConversationRequestItem"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
        previous_item_id: Optional[str] = None,
        item: Optional["_models.ConversationRequestItem"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.CONVERSATION_ITEM_CREATE  # type: ignore


class ClientEventConversationItemDelete(ClientEvent, discriminator="conversation.item.delete"):
    """Send this event when you want to remove any item from the conversation history. The server will
    respond with a ``conversation.item.deleted`` event, unless the item does not exist in the
    conversation history, in which case the server will respond with an error.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``conversation.item.delete``. Required.
     CONVERSATION_ITEM_DELETE.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_DELETE
    :ivar item_id: The ID of the item to delete. Required.
    :vartype item_id: str
    """

    type: Literal[ClientEventType.CONVERSATION_ITEM_DELETE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.delete``. Required. CONVERSATION_ITEM_DELETE."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item to delete. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.CONVERSATION_ITEM_DELETE  # type: ignore


class ClientEventConversationItemRetrieve(ClientEvent, discriminator="conversation.item.retrieve"):
    """Send this event when you want to retrieve the server's representation of a specific item in the
    conversation history. This is useful, for example, to inspect user audio after noise
    cancellation and VAD. The server will respond with a ``conversation.item.retrieved`` event,
    unless the item does not exist in the conversation history, in which case the server will
    respond with an error.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``conversation.item.retrieve``. Required.
     CONVERSATION_ITEM_RETRIEVE.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_RETRIEVE
    :ivar item_id: The ID of the item to retrieve. Required.
    :vartype item_id: str
    """

    type: Literal[ClientEventType.CONVERSATION_ITEM_RETRIEVE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.retrieve``. Required. CONVERSATION_ITEM_RETRIEVE."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item to retrieve. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.CONVERSATION_ITEM_RETRIEVE  # type: ignore


class ClientEventConversationItemTruncate(ClientEvent, discriminator="conversation.item.truncate"):
    """Send this event to truncate a previous assistant message’s audio. The server will produce audio
    faster than voicelive, so this event is useful when the user interrupts to truncate audio that
    has already been sent to the client but not yet played. This will synchronize the server's
    understanding of the audio with the client's playback. Truncating audio will delete the
    server-side text transcript to ensure there is not text in the context that hasn't been heard
    by the user. If successful, the server will respond with a ``conversation.item.truncated``
    event.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``conversation.item.truncate``. Required.
     CONVERSATION_ITEM_TRUNCATE.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_TRUNCATE
    :ivar item_id: The ID of the assistant message item to truncate. Only assistant message items
     can be truncated. Required.
    :vartype item_id: str
    :ivar content_index: The index of the content part to truncate. Set this to 0. Required.
    :vartype content_index: int
    :ivar audio_end_ms: Inclusive duration up to which audio is truncated, in milliseconds. If the
     audio_end_ms is greater than the actual audio duration, the server will respond with an error.
     Required.
    :vartype audio_end_ms: int
    """

    type: Literal[ClientEventType.CONVERSATION_ITEM_TRUNCATE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.truncate``. Required. CONVERSATION_ITEM_TRUNCATE."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the assistant message item to truncate. Only assistant message items can be
     truncated. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part to truncate. Set this to 0. Required."""
    audio_end_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Inclusive duration up to which audio is truncated, in milliseconds. If the audio_end_ms is
     greater than the actual audio duration, the server will respond with an error. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        content_index: int,
        audio_end_ms: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.CONVERSATION_ITEM_TRUNCATE  # type: ignore


class ClientEventInputAudioBufferAppend(ClientEvent, discriminator="input_audio_buffer.append"):
    """Send this event to append audio bytes to the input audio buffer. The audio
    buffer is temporary storage you can write to and later commit. In Server VAD
    mode, the audio buffer is used to detect speech and the server will decide
    when to commit. When Server VAD is disabled, you must commit the audio buffer
    manually.

    The client may choose how much audio to place in each event up to a maximum
    of 15 MiB, for example streaming smaller chunks from the client may allow the
    VAD to be more responsive. Unlike made other client events, the server will
    not send a confirmation response to this event.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``input_audio_buffer.append``. Required.
     INPUT_AUDIO_BUFFER_APPEND.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_BUFFER_APPEND
    :ivar audio: Base64-encoded audio. This must be in the format specified by the
     ``input_audio_format`` field in the session configuration. Required.
    :vartype audio: str
    """

    type: Literal[ClientEventType.INPUT_AUDIO_BUFFER_APPEND] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``input_audio_buffer.append``. Required. INPUT_AUDIO_BUFFER_APPEND."""
    audio: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Base64-encoded audio. This must be in the format specified by the ``input_audio_format`` field
     in the session configuration. Required."""

    @overload
    def __init__(
        self,
        *,
        audio: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.INPUT_AUDIO_BUFFER_APPEND  # type: ignore


class ClientEventInputAudioBufferClear(ClientEvent, discriminator="input_audio_buffer.clear"):
    """Send this event to clear the audio bytes in the buffer. The server will respond with an
    ``input_audio_buffer.cleared`` event.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``input_audio_buffer.clear``. Required.
     INPUT_AUDIO_BUFFER_CLEAR.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_BUFFER_CLEAR
    """

    type: Literal[ClientEventType.INPUT_AUDIO_BUFFER_CLEAR] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``input_audio_buffer.clear``. Required. INPUT_AUDIO_BUFFER_CLEAR."""

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.INPUT_AUDIO_BUFFER_CLEAR  # type: ignore


class ClientEventInputAudioBufferCommit(ClientEvent, discriminator="input_audio_buffer.commit"):
    """Send this event to commit the user input audio buffer, which will create a new user message
    item in the conversation. This event will produce an error if the input audio buffer is empty.
    When in Server VAD mode, the client does not need to send this event, the server will commit
    the audio buffer automatically. Committing the input audio buffer will trigger input audio
    transcription (if enabled in session configuration), but it will not create a response from the
    model. The server will respond with an ``input_audio_buffer.committed`` event.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``input_audio_buffer.commit``. Required.
     INPUT_AUDIO_BUFFER_COMMIT.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_BUFFER_COMMIT
    """

    type: Literal[ClientEventType.INPUT_AUDIO_BUFFER_COMMIT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``input_audio_buffer.commit``. Required. INPUT_AUDIO_BUFFER_COMMIT."""

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.INPUT_AUDIO_BUFFER_COMMIT  # type: ignore


class ClientEventInputAudioClear(ClientEvent, discriminator="input_audio.clear"):
    """Clears all input audio currently being streamed.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be 'input_audio.clear'. Required. INPUT_AUDIO_CLEAR.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_CLEAR
    """

    type: Literal[ClientEventType.INPUT_AUDIO_CLEAR] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be 'input_audio.clear'. Required. INPUT_AUDIO_CLEAR."""

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.INPUT_AUDIO_CLEAR  # type: ignore


class ClientEventInputAudioTurnAppend(ClientEvent, discriminator="input_audio.turn.append"):
    """Appends audio data to an ongoing input turn.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be 'input_audio.turn.append'. Required.
     INPUT_AUDIO_TURN_APPEND.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_TURN_APPEND
    :ivar turn_id: The ID of the turn this audio is part of. Required.
    :vartype turn_id: str
    :ivar audio: Base64-encoded audio chunk. Required.
    :vartype audio: str
    """

    type: Literal[ClientEventType.INPUT_AUDIO_TURN_APPEND] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be 'input_audio.turn.append'. Required. INPUT_AUDIO_TURN_APPEND."""
    turn_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the turn this audio is part of. Required."""
    audio: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Base64-encoded audio chunk. Required."""

    @overload
    def __init__(
        self,
        *,
        turn_id: str,
        audio: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.INPUT_AUDIO_TURN_APPEND  # type: ignore


class ClientEventInputAudioTurnCancel(ClientEvent, discriminator="input_audio.turn.cancel"):
    """Cancels an in-progress input audio turn.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be 'input_audio.turn.cancel'. Required.
     INPUT_AUDIO_TURN_CANCEL.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_TURN_CANCEL
    :ivar turn_id: The ID of the turn to cancel. Required.
    :vartype turn_id: str
    """

    type: Literal[ClientEventType.INPUT_AUDIO_TURN_CANCEL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be 'input_audio.turn.cancel'. Required. INPUT_AUDIO_TURN_CANCEL."""
    turn_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the turn to cancel. Required."""

    @overload
    def __init__(
        self,
        *,
        turn_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.INPUT_AUDIO_TURN_CANCEL  # type: ignore


class ClientEventInputAudioTurnEnd(ClientEvent, discriminator="input_audio.turn.end"):
    """Marks the end of an audio input turn.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be 'input_audio.turn.end'. Required. INPUT_AUDIO_TURN_END.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_TURN_END
    :ivar turn_id: The ID of the audio turn being ended. Required.
    :vartype turn_id: str
    """

    type: Literal[ClientEventType.INPUT_AUDIO_TURN_END] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be 'input_audio.turn.end'. Required. INPUT_AUDIO_TURN_END."""
    turn_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the audio turn being ended. Required."""

    @overload
    def __init__(
        self,
        *,
        turn_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.INPUT_AUDIO_TURN_END  # type: ignore


class ClientEventInputAudioTurnStart(ClientEvent, discriminator="input_audio.turn.start"):
    """Indicates the start of a new audio input turn.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be 'input_audio.turn.start'. Required. INPUT_AUDIO_TURN_START.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_TURN_START
    :ivar turn_id: Unique identifier for the input audio turn. Required.
    :vartype turn_id: str
    """

    type: Literal[ClientEventType.INPUT_AUDIO_TURN_START] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be 'input_audio.turn.start'. Required. INPUT_AUDIO_TURN_START."""
    turn_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the input audio turn. Required."""

    @overload
    def __init__(
        self,
        *,
        turn_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.INPUT_AUDIO_TURN_START  # type: ignore


class ClientEventResponseCancel(ClientEvent, discriminator="response.cancel"):
    """Send this event to cancel an in-progress response. The server will respond with a
    ``response.cancelled`` event or an error if there is no response to cancel.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.cancel``. Required. RESPONSE_CANCEL.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_CANCEL
    :ivar response_id: A specific response ID to cancel - if not provided, will cancel an
     in-progress response in the default conversation.
    :vartype response_id: str
    """

    type: Literal[ClientEventType.RESPONSE_CANCEL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.cancel``. Required. RESPONSE_CANCEL."""
    response_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A specific response ID to cancel - if not provided, will cancel an in-progress response in the
     default conversation."""

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
        response_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.RESPONSE_CANCEL  # type: ignore


class ClientEventResponseCreate(ClientEvent, discriminator="response.create"):
    """This event instructs the server to create a Response, which means triggering model inference.
    When in Server VAD mode, the server will create Responses automatically. A Response will
    include at least one Item, and may have two, in which case the second will be a function call.
    These Items will be appended to the conversation history. The server will respond with a
    ``response.created`` event, events for Items and content created, and finally a
    ``response.done`` event to indicate the Response is complete. The ``response.create`` event
    includes inference configuration like ``instructions``, and ``temperature``. These fields will
    override the Session's configuration for this Response only.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.create``. Required. RESPONSE_CREATE.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_CREATE
    :ivar response:
    :vartype response: ~azure.ai.voicelive.models.ResponseCreateParams
    :ivar additional_instructions: additional instructions (system prompt) appended to the default
     instructions of the session. Only affects this response only.
    :vartype additional_instructions: str
    """

    type: Literal[ClientEventType.RESPONSE_CREATE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.create``. Required. RESPONSE_CREATE."""
    response: Optional["_models.ResponseCreateParams"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    additional_instructions: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """additional instructions (system prompt) appended to the default instructions of the session.
     Only affects this response only."""

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
        response: Optional["_models.ResponseCreateParams"] = None,
        additional_instructions: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.RESPONSE_CREATE  # type: ignore


class ClientEventSessionAvatarConnect(ClientEvent, discriminator="session.avatar.connect"):
    """Sent when the client connects and provides its SDP (Session Description Protocol)

    for avatar-related media negotiation.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be 'session.avatar.connect'. Required. SESSION_AVATAR_CONNECT.
    :vartype type: str or ~azure.ai.voicelive.models.SESSION_AVATAR_CONNECT
    :ivar client_sdp: The client's SDP offer. Required.
    :vartype client_sdp: str
    """

    type: Literal[ClientEventType.SESSION_AVATAR_CONNECT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be 'session.avatar.connect'. Required. SESSION_AVATAR_CONNECT."""
    client_sdp: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The client's SDP offer. Required."""

    @overload
    def __init__(
        self,
        *,
        client_sdp: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.SESSION_AVATAR_CONNECT  # type: ignore


class ClientEventSessionUpdate(ClientEvent, discriminator="session.update"):
    """Send this event to update the session’s default configuration. The client may send this event
    at any time to update any field, except for ``voice``. However, note that once a session has
    been initialized with a particular ``model``, it can’t be changed to another model using
    ``session.update``. When the server receives a ``session.update``, it will respond with a
    ``session.updated`` event showing the full, effective configuration. Only the fields that are
    present are updated. To clear a field like ``instructions``, pass an empty string.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``session.update``. Required. SESSION_UPDATE.
    :vartype type: str or ~azure.ai.voicelive.models.SESSION_UPDATE
    :ivar session: Required.
    :vartype session: ~azure.ai.voicelive.models.RequestSession
    """

    type: Literal[ClientEventType.SESSION_UPDATE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``session.update``. Required. SESSION_UPDATE."""
    session: "_models.RequestSession" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        session: "_models.RequestSession",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ClientEventType.SESSION_UPDATE  # type: ignore


class ContentPart(_Model):
    """Base for any content part; discriminated by ``type``.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ResponseAudioContentPart, RequestAudioContentPart, RequestImageContentPart,
    RequestTextContentPart, ResponseTextContentPart

    :ivar type: Required. Known values are: "input_text", "input_audio", "input_image", "text", and
     "audio".
    :vartype type: str or ~azure.ai.voicelive.models.ContentPartType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"input_text\", \"input_audio\", \"input_image\", \"text\", and
     \"audio\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationItemBase(_Model):
    """The item to add to the conversation."""


class ErrorResponse(_Model):
    """Standard error response envelope.

    :ivar error: Error object returned in case of API failure. Required.
    :vartype error: ~azure.ai.voicelive.models.VoiceLiveErrorDetails
    """

    error: "_models.VoiceLiveErrorDetails" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error object returned in case of API failure. Required."""

    @overload
    def __init__(
        self,
        *,
        error: "_models.VoiceLiveErrorDetails",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FunctionCallItem(ConversationRequestItem, discriminator="function_call"):
    """A function call item within a conversation.

    :ivar id:
    :vartype id: str
    :ivar type: Required. FUNCTION_CALL.
    :vartype type: str or ~azure.ai.voicelive.models.FUNCTION_CALL
    :ivar name: Required.
    :vartype name: str
    :ivar call_id: Required.
    :vartype call_id: str
    :ivar arguments: Required.
    :vartype arguments: str
    :ivar status: Known values are: "completed" and "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ItemParamStatus
    """

    type: Literal[ItemType.FUNCTION_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. FUNCTION_CALL."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    arguments: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    status: Optional[Union[str, "_models.ItemParamStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"completed\" and \"incomplete\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        call_id: str,
        arguments: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        status: Optional[Union[str, "_models.ItemParamStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.FUNCTION_CALL  # type: ignore


class FunctionCallOutputItem(ConversationRequestItem, discriminator="function_call_output"):
    """A function call output item within a conversation.

    :ivar id:
    :vartype id: str
    :ivar type: Required. FUNCTION_CALL_OUTPUT.
    :vartype type: str or ~azure.ai.voicelive.models.FUNCTION_CALL_OUTPUT
    :ivar call_id: Required.
    :vartype call_id: str
    :ivar output: Required.
    :vartype output: str
    :ivar status: Known values are: "completed" and "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ItemParamStatus
    """

    type: Literal[ItemType.FUNCTION_CALL_OUTPUT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. FUNCTION_CALL_OUTPUT."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    status: Optional[Union[str, "_models.ItemParamStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"completed\" and \"incomplete\"."""

    @overload
    def __init__(
        self,
        *,
        call_id: str,
        output: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        status: Optional[Union[str, "_models.ItemParamStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.FUNCTION_CALL_OUTPUT  # type: ignore


class Tool(_Model):
    """The base representation of a voicelive tool definition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FunctionTool, MCPServer

    :ivar type: Required. Known values are: "function" and "mcp".
    :vartype type: str or ~azure.ai.voicelive.models.ToolType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"function\" and \"mcp\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FunctionTool(Tool, discriminator="function"):
    """The definition of a function tool as used by the voicelive endpoint.

    :ivar type: Required. FUNCTION.
    :vartype type: str or ~azure.ai.voicelive.models.FUNCTION
    :ivar name: Required.
    :vartype name: str
    :ivar description:
    :vartype description: str
    :ivar parameters:
    :vartype parameters: any
    """

    type: Literal[ToolType.FUNCTION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. FUNCTION."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    parameters: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        parameters: Optional[Any] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.FUNCTION  # type: ignore


class IceServer(_Model):
    """ICE server configuration for WebRTC connection negotiation.

    :ivar urls: List of ICE server URLs (e.g., TURN or STUN endpoints). Required.
    :vartype urls: list[str]
    :ivar username: Optional username used for authentication with the ICE server.
    :vartype username: str
    :ivar credential: Optional credential (e.g., password or token) used for authentication.
    :vartype credential: str
    """

    urls: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of ICE server URLs (e.g., TURN or STUN endpoints). Required."""
    username: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional username used for authentication with the ICE server."""
    credential: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional credential (e.g., password or token) used for authentication."""

    @overload
    def __init__(
        self,
        *,
        urls: list[str],
        username: Optional[str] = None,
        credential: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MessageContentPart(_Model):
    """Base for any message content part; discriminated by ``type``.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    InputAudioContentPart, InputTextContentPart, OutputTextContentPart

    :ivar type: The type of the content part. Required. Known values are: "input_text",
     "input_audio", "input_image", "text", and "audio".
    :vartype type: str or ~azure.ai.voicelive.models.ContentPartType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of the content part. Required. Known values are: \"input_text\", \"input_audio\",
     \"input_image\", \"text\", and \"audio\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InputAudioContentPart(MessageContentPart, discriminator="input_audio"):
    """Input audio content part.

    :ivar type: Required. INPUT_AUDIO.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO
    :ivar audio: Required.
    :vartype audio: str
    :ivar transcript:
    :vartype transcript: str
    """

    type: Literal[ContentPartType.INPUT_AUDIO] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. INPUT_AUDIO."""
    audio: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    transcript: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        audio: str,
        transcript: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ContentPartType.INPUT_AUDIO  # type: ignore


class InputTextContentPart(MessageContentPart, discriminator="input_text"):
    """Input text content part.

    :ivar type: Required. INPUT_TEXT.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_TEXT
    :ivar text: Required.
    :vartype text: str
    """

    type: Literal[ContentPartType.INPUT_TEXT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. INPUT_TEXT."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ContentPartType.INPUT_TEXT  # type: ignore


class InputTokenDetails(_Model):
    """Details of input token usage.

    :ivar cached_tokens: Number of cached tokens used in the input. Required.
    :vartype cached_tokens: int
    :ivar text_tokens: Number of text tokens used in the input. Required.
    :vartype text_tokens: int
    :ivar audio_tokens: Number of audio tokens used in the input. Required.
    :vartype audio_tokens: int
    :ivar image_tokens: Number of image tokens used in the input. Required.
    :vartype image_tokens: int
    :ivar cached_tokens_details: Details of cached token usage. Required.
    :vartype cached_tokens_details: ~azure.ai.voicelive.models.CachedTokenDetails
    """

    cached_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of cached tokens used in the input. Required."""
    text_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of text tokens used in the input. Required."""
    audio_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of audio tokens used in the input. Required."""
    image_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of image tokens used in the input. Required."""
    cached_tokens_details: "_models.CachedTokenDetails" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Details of cached token usage. Required."""

    @overload
    def __init__(
        self,
        *,
        cached_tokens: int,
        text_tokens: int,
        audio_tokens: int,
        image_tokens: int,
        cached_tokens_details: "_models.CachedTokenDetails",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InterimResponseConfigBase(_Model):
    """Base model for interim response configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    LlmInterimResponseConfig, StaticInterimResponseConfig

    :ivar type: The type of interim response configuration. Required. Known values are:
     "static_interim_response" and "llm_interim_response".
    :vartype type: str or ~azure.ai.voicelive.models.InterimResponseConfigType
    :ivar triggers: List of triggers that can fire the interim response. Any trigger can activate
     it (OR logic). Supported: 'latency', 'tool'.
    :vartype triggers: list[str or ~azure.ai.voicelive.models.InterimResponseTrigger]
    :ivar latency_threshold_ms: Latency threshold in milliseconds before triggering interim
     response. Default is 2000ms.
    :vartype latency_threshold_ms: int
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of interim response configuration. Required. Known values are:
     \"static_interim_response\" and \"llm_interim_response\"."""
    triggers: Optional[list[Union[str, "_models.InterimResponseTrigger"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of triggers that can fire the interim response. Any trigger can activate it (OR logic).
     Supported: 'latency', 'tool'."""
    latency_threshold_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Latency threshold in milliseconds before triggering interim response. Default is 2000ms."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        triggers: Optional[list[Union[str, "_models.InterimResponseTrigger"]]] = None,
        latency_threshold_ms: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LlmInterimResponseConfig(InterimResponseConfigBase, discriminator="llm_interim_response"):
    """Configuration for LLM-based interim response generation. Uses LLM to generate context-aware
    interim responses when any trigger condition is met.

    :ivar triggers: List of triggers that can fire the interim response. Any trigger can activate
     it (OR logic). Supported: 'latency', 'tool'.
    :vartype triggers: list[str or ~azure.ai.voicelive.models.InterimResponseTrigger]
    :ivar latency_threshold_ms: Latency threshold in milliseconds before triggering interim
     response. Default is 2000ms.
    :vartype latency_threshold_ms: int
    :ivar type: Required. LLM-based interim response configuration type.
    :vartype type: str or ~azure.ai.voicelive.models.LLM_INTERIM_RESPONSE
    :ivar model: The model to use for LLM-based interim response generation. Default is
     gpt-4.1-mini.
    :vartype model: str
    :ivar instructions: Custom instructions for generating interim responses. If not provided, a
     default prompt is used.
    :vartype instructions: str
    :ivar max_completion_tokens: Maximum number of tokens to generate for the interim response.
    :vartype max_completion_tokens: int
    """

    type: Literal[InterimResponseConfigType.LLM_INTERIM_RESPONSE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. LLM-based interim response configuration type."""
    model: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The model to use for LLM-based interim response generation. Default is gpt-4.1-mini."""
    instructions: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Custom instructions for generating interim responses. If not provided, a default prompt is
     used."""
    max_completion_tokens: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum number of tokens to generate for the interim response."""

    @overload
    def __init__(
        self,
        *,
        triggers: Optional[list[Union[str, "_models.InterimResponseTrigger"]]] = None,
        latency_threshold_ms: Optional[int] = None,
        model: Optional[str] = None,
        instructions: Optional[str] = None,
        max_completion_tokens: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = InterimResponseConfigType.LLM_INTERIM_RESPONSE  # type: ignore


class LogProbProperties(_Model):
    """A single log probability entry for a token.

    :ivar token: The token that was used to generate the log probability. Required.
    :vartype token: str
    :ivar logprob: The log probability of the token. Required.
    :vartype logprob: float
    :ivar bytes: The bytes that were used to generate the log probability. Required.
    :vartype bytes: list[int]
    """

    token: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The token that was used to generate the log probability. Required."""
    logprob: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The log probability of the token. Required."""
    bytes: list[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The bytes that were used to generate the log probability. Required."""

    @overload
    def __init__(
        self,
        *,
        token: str,
        logprob: float,
        bytes: list[int],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MCPApprovalResponseRequestItem(ConversationRequestItem, discriminator="mcp_approval_response"):
    """A request item that represents a response to an MCP approval request.

    :ivar id:
    :vartype id: str
    :ivar type: The type of the item. Required. MCP_APPROVAL_RESPONSE.
    :vartype type: str or ~azure.ai.voicelive.models.MCP_APPROVAL_RESPONSE
    :ivar approval_request_id: The ID of the approval request. Required.
    :vartype approval_request_id: str
    :ivar approve: Whether the tool call was approved. Required.
    :vartype approve: bool
    """

    type: Literal[ItemType.MCP_APPROVAL_RESPONSE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the item. Required. MCP_APPROVAL_RESPONSE."""
    approval_request_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the approval request. Required."""
    approve: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether the tool call was approved. Required."""

    @overload
    def __init__(
        self,
        *,
        approval_request_id: str,
        approve: bool,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MCP_APPROVAL_RESPONSE  # type: ignore


class MCPServer(Tool, discriminator="mcp"):
    """The definition of an MCP server as used by the voicelive endpoint.

    :ivar type: Required. MCP.
    :vartype type: str or ~azure.ai.voicelive.models.MCP
    :ivar server_label: Required.
    :vartype server_label: str
    :ivar server_url: Required.
    :vartype server_url: str
    :ivar authorization:
    :vartype authorization: str
    :ivar headers:
    :vartype headers: dict[str, str]
    :ivar allowed_tools:
    :vartype allowed_tools: list[str]
    :ivar require_approval: Is either a Union[str, "_models.MCPApprovalType"] type or a {str:
     [str]} type.
    :vartype require_approval: str or ~azure.ai.voicelive.models.MCPApprovalType or dict[str,
     list[str]]
    """

    type: Literal[ToolType.MCP] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. MCP."""
    server_label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    server_url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    authorization: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    headers: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    allowed_tools: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    require_approval: Optional[Union[str, "_models.MCPApprovalType", dict[str, list[str]]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Is either a Union[str, \"_models.MCPApprovalType\"] type or a {str: [str]} type."""

    @overload
    def __init__(
        self,
        *,
        server_label: str,
        server_url: str,
        authorization: Optional[str] = None,
        headers: Optional[dict[str, str]] = None,
        allowed_tools: Optional[list[str]] = None,
        require_approval: Optional[Union[str, "_models.MCPApprovalType", dict[str, list[str]]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.MCP  # type: ignore


class MCPTool(_Model):
    """Represents a mcp tool definition.

    :ivar name: The name of the tool. Required.
    :vartype name: str
    :ivar description: The description of the tool.
    :vartype description: str
    :ivar input_schema: The input schema for the tool. Required.
    :vartype input_schema: any
    :ivar annotations: The annotations for the tool.
    :vartype annotations: any
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the tool. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the tool."""
    input_schema: Any = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The input schema for the tool. Required."""
    annotations: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The annotations for the tool."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        input_schema: Any,
        description: Optional[str] = None,
        annotations: Optional[Any] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OpenAIVoice(_Model):
    """OpenAI voice configuration with explicit type field.

    This provides a unified interface for OpenAI voices, complementing the
    existing string-based OAIVoice for backward compatibility.

    :ivar type: The type of the voice. Required. Default value is "openai".
    :vartype type: str
    :ivar name: The name of the OpenAI voice. Required. Known values are: "alloy", "ash", "ballad",
     "coral", "echo", "sage", "shimmer", "verse", "marin", and "cedar".
    :vartype name: str or ~azure.ai.voicelive.models.OpenAIVoiceName
    """

    type: Literal["openai"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of the voice. Required. Default value is \"openai\"."""
    name: Union[str, "_models.OpenAIVoiceName"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the OpenAI voice. Required. Known values are: \"alloy\", \"ash\", \"ballad\",
     \"coral\", \"echo\", \"sage\", \"shimmer\", \"verse\", \"marin\", and \"cedar\"."""

    @overload
    def __init__(
        self,
        *,
        name: Union[str, "_models.OpenAIVoiceName"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["openai"] = "openai"


class OutputTextContentPart(MessageContentPart, discriminator="text"):
    """Output text content part.

    :ivar type: The type of the content part. Required. TEXT.
    :vartype type: str or ~azure.ai.voicelive.models.TEXT
    :ivar text: The text content. Required.
    :vartype text: str
    """

    type: Literal[ContentPartType.TEXT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the content part. Required. TEXT."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text content. Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ContentPartType.TEXT  # type: ignore


class OutputTokenDetails(_Model):
    """Details of output token usage.

    :ivar text_tokens: Number of text tokens generated in the output. Required.
    :vartype text_tokens: int
    :ivar audio_tokens: Number of audio tokens generated in the output. Required.
    :vartype audio_tokens: int
    """

    text_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of text tokens generated in the output. Required."""
    audio_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of audio tokens generated in the output. Required."""

    @overload
    def __init__(
        self,
        *,
        text_tokens: int,
        audio_tokens: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RequestAudioContentPart(ContentPart, discriminator="input_audio"):
    """An audio content part for a request. This is supported only by realtime models (e.g.,
    gpt-realtime). For text-based models, use ``input_text`` instead.

    :ivar type: Required. INPUT_AUDIO.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO
    :ivar audio: Base64-encoded audio bytes, these will be parsed as the format specified in the
     session input audio type configuration. This defaults to PCM 16-bit 24kHz mono if not
     specified. Required.
    :vartype audio: str
    :ivar transcript: Optional transcript of the audio content. This is not sent to the model, but
     will be attached to the message item for reference.
    :vartype transcript: str
    """

    type: Literal[ContentPartType.INPUT_AUDIO] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. INPUT_AUDIO."""
    audio: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Base64-encoded audio bytes, these will be parsed as the format specified in the session input
     audio type configuration. This defaults to PCM 16-bit 24kHz mono if not specified. Required."""
    transcript: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional transcript of the audio content. This is not sent to the model, but will be attached
     to the message item for reference."""

    @overload
    def __init__(
        self,
        *,
        audio: str,
        transcript: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ContentPartType.INPUT_AUDIO  # type: ignore


class RequestImageContentPart(ContentPart, discriminator="input_image"):
    """Input image content part.

    :ivar type: Required. INPUT_IMAGE.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_IMAGE
    :ivar url:
    :vartype url: str
    :ivar detail: Known values are: "auto", "low", and "high".
    :vartype detail: str or ~azure.ai.voicelive.models.RequestImageContentPartDetail
    """

    type: Literal[ContentPartType.INPUT_IMAGE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. INPUT_IMAGE."""
    url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    detail: Optional[Union[str, "_models.RequestImageContentPartDetail"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"auto\", \"low\", and \"high\"."""

    @overload
    def __init__(
        self,
        *,
        url: Optional[str] = None,
        detail: Optional[Union[str, "_models.RequestImageContentPartDetail"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ContentPartType.INPUT_IMAGE  # type: ignore


class RequestSession(_Model):
    """Base for session configuration shared between request and response.

    :ivar model: The model for the session.
    :vartype model: str
    :ivar modalities: The modalities to be used in the session.
    :vartype modalities: list[str or ~azure.ai.voicelive.models.Modality]
    :ivar animation: The animation configuration for the session.
    :vartype animation: ~azure.ai.voicelive.models.Animation
    :ivar voice: The voice configuration for the session. Is one of the following types: Union[str,
     "_models.OpenAIVoiceName"], OpenAIVoice, AzureVoice
    :vartype voice: str or ~azure.ai.voicelive.models.OpenAIVoiceName or
     ~azure.ai.voicelive.models.OpenAIVoice or ~azure.ai.voicelive.models.AzureVoice
    :ivar instructions: Optional instructions to guide the model's behavior throughout the session.
    :vartype instructions: str
    :ivar input_audio_sampling_rate: Input audio sampling rate in Hz. Available values:

     * For pcm16: 8000, 16000, 24000

     * For g711_alaw/g711_ulaw: 8000.
    :vartype input_audio_sampling_rate: int
    :ivar input_audio_format: Input audio format. Default is 'pcm16'. Known values are: "pcm16",
     "g711_ulaw", and "g711_alaw".
    :vartype input_audio_format: str or ~azure.ai.voicelive.models.InputAudioFormat
    :ivar output_audio_format: Output audio format. Default is 'pcm16'. Known values are: "pcm16",
     "pcm16_8000hz", "pcm16_16000hz", "g711_ulaw", and "g711_alaw".
    :vartype output_audio_format: str or ~azure.ai.voicelive.models.OutputAudioFormat
    :ivar turn_detection: Type of turn detection to use.
    :vartype turn_detection: ~azure.ai.voicelive.models.TurnDetection
    :ivar input_audio_noise_reduction: Configuration for input audio noise reduction.
    :vartype input_audio_noise_reduction: ~azure.ai.voicelive.models.AudioNoiseReduction
    :ivar input_audio_echo_cancellation: Configuration for echo cancellation during server-side
     audio processing.
    :vartype input_audio_echo_cancellation: ~azure.ai.voicelive.models.AudioEchoCancellation
    :ivar avatar: Configuration for avatar streaming and behavior during the session.
    :vartype avatar: ~azure.ai.voicelive.models.AvatarConfig
    :ivar input_audio_transcription: Configuration for input audio transcription.
    :vartype input_audio_transcription: ~azure.ai.voicelive.models.AudioInputTranscriptionOptions
    :ivar output_audio_timestamp_types: Types of timestamps to include in audio response content.
    :vartype output_audio_timestamp_types: list[str or
     ~azure.ai.voicelive.models.AudioTimestampType]
    :ivar tools: Configuration for tools to be used during the session, if applicable.
    :vartype tools: list[~azure.ai.voicelive.models.Tool]
    :ivar tool_choice: Specifies which tools the model is allowed to call during the session. Is
     either a Union[str, "_models.ToolChoiceLiteral"] type or a ToolChoiceSelection type.
    :vartype tool_choice: str or ~azure.ai.voicelive.models.ToolChoiceLiteral or
     ~azure.ai.voicelive.models.ToolChoiceSelection
    :ivar temperature: Controls the randomness of the model's output. Range: 0.0 to 1.0. Default is
     0.7.
    :vartype temperature: float
    :ivar max_response_output_tokens: Maximum number of tokens to generate in the response. Default
     is unlimited. Is either a int type or a Literal["inf"] type.
    :vartype max_response_output_tokens: int or str
    :ivar reasoning_effort: Constrains effort on reasoning for reasoning models. Check model
     documentation for supported values for each model. Reducing reasoning effort can result in
     faster responses and fewer tokens used on reasoning in a response. Known values are: "none",
     "minimal", "low", "medium", "high", and "xhigh".
    :vartype reasoning_effort: str or ~azure.ai.voicelive.models.ReasoningEffort
    :ivar interim_response: Configuration for interim response generation during latency or tool
     calls. Is either a StaticInterimResponseConfig type or a LlmInterimResponseConfig type.
    :vartype interim_response: ~azure.ai.voicelive.models.StaticInterimResponseConfig or
     ~azure.ai.voicelive.models.LlmInterimResponseConfig
    """

    model: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The model for the session."""
    modalities: Optional[list[Union[str, "_models.Modality"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The modalities to be used in the session."""
    animation: Optional["_models.Animation"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The animation configuration for the session."""
    voice: Optional["_types.Voice"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The voice configuration for the session. Is one of the following types: Union[str,
     \"_models.OpenAIVoiceName\"], OpenAIVoice, AzureVoice"""
    instructions: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional instructions to guide the model's behavior throughout the session."""
    input_audio_sampling_rate: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Input audio sampling rate in Hz. Available values:
 
      * For pcm16: 8000, 16000, 24000
 
      * For g711_alaw/g711_ulaw: 8000."""
    input_audio_format: Optional[Union[str, "_models.InputAudioFormat"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Input audio format. Default is 'pcm16'. Known values are: \"pcm16\", \"g711_ulaw\", and
     \"g711_alaw\"."""
    output_audio_format: Optional[Union[str, "_models.OutputAudioFormat"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Output audio format. Default is 'pcm16'. Known values are: \"pcm16\", \"pcm16_8000hz\",
     \"pcm16_16000hz\", \"g711_ulaw\", and \"g711_alaw\"."""
    turn_detection: Optional["_models.TurnDetection"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of turn detection to use."""
    input_audio_noise_reduction: Optional["_models.AudioNoiseReduction"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration for input audio noise reduction."""
    input_audio_echo_cancellation: Optional["_models.AudioEchoCancellation"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration for echo cancellation during server-side audio processing."""
    avatar: Optional["_models.AvatarConfig"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Configuration for avatar streaming and behavior during the session."""
    input_audio_transcription: Optional["_models.AudioInputTranscriptionOptions"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration for input audio transcription."""
    output_audio_timestamp_types: Optional[list[Union[str, "_models.AudioTimestampType"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Types of timestamps to include in audio response content."""
    tools: Optional[list["_models.Tool"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Configuration for tools to be used during the session, if applicable."""
    tool_choice: Optional["_types.ToolChoice"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies which tools the model is allowed to call during the session. Is either a Union[str,
     \"_models.ToolChoiceLiteral\"] type or a ToolChoiceSelection type."""
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Controls the randomness of the model's output. Range: 0.0 to 1.0. Default is 0.7."""
    max_response_output_tokens: Optional[Union[int, Literal["inf"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum number of tokens to generate in the response. Default is unlimited. Is either a int
     type or a Literal[\"inf\"] type."""
    reasoning_effort: Optional[Union[str, "_models.ReasoningEffort"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Constrains effort on reasoning for reasoning models. Check model documentation for supported
     values for each model. Reducing reasoning effort can result in faster responses and fewer
     tokens used on reasoning in a response. Known values are: \"none\", \"minimal\", \"low\",
     \"medium\", \"high\", and \"xhigh\"."""
    interim_response: Optional["_types.InterimResponseConfig"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration for interim response generation during latency or tool calls. Is either a
     StaticInterimResponseConfig type or a LlmInterimResponseConfig type."""

    @overload
    def __init__(
        self,
        *,
        model: Optional[str] = None,
        modalities: Optional[list[Union[str, "_models.Modality"]]] = None,
        animation: Optional["_models.Animation"] = None,
        voice: Optional["_types.Voice"] = None,
        instructions: Optional[str] = None,
        input_audio_sampling_rate: Optional[int] = None,
        input_audio_format: Optional[Union[str, "_models.InputAudioFormat"]] = None,
        output_audio_format: Optional[Union[str, "_models.OutputAudioFormat"]] = None,
        turn_detection: Optional["_models.TurnDetection"] = None,
        input_audio_noise_reduction: Optional["_models.AudioNoiseReduction"] = None,
        input_audio_echo_cancellation: Optional["_models.AudioEchoCancellation"] = None,
        avatar: Optional["_models.AvatarConfig"] = None,
        input_audio_transcription: Optional["_models.AudioInputTranscriptionOptions"] = None,
        output_audio_timestamp_types: Optional[list[Union[str, "_models.AudioTimestampType"]]] = None,
        tools: Optional[list["_models.Tool"]] = None,
        tool_choice: Optional["_types.ToolChoice"] = None,
        temperature: Optional[float] = None,
        max_response_output_tokens: Optional[Union[int, Literal["inf"]]] = None,
        reasoning_effort: Optional[Union[str, "_models.ReasoningEffort"]] = None,
        interim_response: Optional["_types.InterimResponseConfig"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RequestTextContentPart(ContentPart, discriminator="input_text"):
    """A text content part for a request.

    :ivar type: Required. INPUT_TEXT.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_TEXT
    :ivar text:
    :vartype text: str
    """

    type: Literal[ContentPartType.INPUT_TEXT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. INPUT_TEXT."""
    text: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        text: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ContentPartType.INPUT_TEXT  # type: ignore


class Response(_Model):
    """The response resource.

    :ivar id: The unique ID of the response.
    :vartype id: str
    :ivar object: The object type, must be ``realtime.response``. Default value is
     "realtime.response".
    :vartype object: str
    :ivar status: The final status of the response.

     One of: ``completed``, ``cancelled``, ``failed``, ``incomplete``, or ``in_progress``. Known
     values are: "completed", "cancelled", "failed", "incomplete", and "in_progress".
    :vartype status: str or ~azure.ai.voicelive.models.ResponseStatus
    :ivar status_details: Additional details about the status.
    :vartype status_details: ~azure.ai.voicelive.models.ResponseStatusDetails
    :ivar output: The list of output items generated by the response.
    :vartype output: list[~azure.ai.voicelive.models.ResponseItem]
    :ivar usage: Usage statistics for the Response, this will correspond to billing. A VoiceLive
     API session will maintain a conversation context and append new Items to the Conversation, thus
     output from previous turns (text and audio tokens) will become the input for later turns.
    :vartype usage: ~azure.ai.voicelive.models.TokenUsage
    :ivar conversation_id: Which conversation the response is added to, determined by the
     ``conversation`` field in the ``response.create`` event. If ``auto``, the response will be
     added to the default conversation and the value of ``conversation_id`` will be an id like
     ``conv_1234``. If ``none``, the response will not be added to any conversation and the value of
     ``conversation_id`` will be ``null``. If responses are being triggered by server VAD, the
     response will be added to the default conversation, thus the ``conversation_id`` will be an id
     like ``conv_1234``.
    :vartype conversation_id: str
    :ivar voice: supported voice identifiers and configurations. Is one of the following types:
     Union[str, "_models.OpenAIVoiceName"], OpenAIVoice, AzureVoice
    :vartype voice: str or ~azure.ai.voicelive.models.OpenAIVoiceName or
     ~azure.ai.voicelive.models.OpenAIVoice or ~azure.ai.voicelive.models.AzureVoice
    :ivar modalities: The set of modalities the model used to respond. If there are multiple
     modalities, the model will pick one, for example if ``modalities`` is ``["text", "audio"]``,
     the model could be responding in either text or audio.
    :vartype modalities: list[str or ~azure.ai.voicelive.models.Modality]
    :ivar output_audio_format: The format of output audio. Options are ``pcm16``, ``g711_ulaw``, or
     ``g711_alaw``. Known values are: "pcm16", "pcm16_8000hz", "pcm16_16000hz", "g711_ulaw", and
     "g711_alaw".
    :vartype output_audio_format: str or ~azure.ai.voicelive.models.OutputAudioFormat
    :ivar temperature: Sampling temperature for the model, limited to [0.6, 1.2]. Defaults to 0.8.
    :vartype temperature: float
    :ivar max_output_tokens: Maximum number of output tokens for a single assistant response,
     inclusive of tool calls, that was used in this response. Is either a int type or a
     Literal["inf"] type.
    :vartype max_output_tokens: int or str
    :ivar metadata: Set of up to 16 key-value pairs that can be attached to an object. This can be
     useful for storing additional information about the object in a structured format. Keys can be
     a maximum of 64 characters long and values can be a maximum of 512 characters long.
    :vartype metadata: dict[str, str]
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the response."""
    object: Optional[Literal["realtime.response"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The object type, must be ``realtime.response``. Default value is \"realtime.response\"."""
    status: Optional[Union[str, "_models.ResponseStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The final status of the response.
     
     One of: ``completed``, ``cancelled``, ``failed``, ``incomplete``, or ``in_progress``. Known
     values are: \"completed\", \"cancelled\", \"failed\", \"incomplete\", and \"in_progress\"."""
    status_details: Optional["_models.ResponseStatusDetails"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional details about the status."""
    output: Optional[list["_models.ResponseItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of output items generated by the response."""
    usage: Optional["_models.TokenUsage"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Usage statistics for the Response, this will correspond to billing. A VoiceLive API session
     will maintain a conversation context and append new Items to the Conversation, thus output from
     previous turns (text and audio tokens) will become the input for later turns."""
    conversation_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Which conversation the response is added to, determined by the ``conversation`` field in the
     ``response.create`` event. If ``auto``, the response will be added to the default conversation
     and the value of ``conversation_id`` will be an id like ``conv_1234``. If ``none``, the
     response will not be added to any conversation and the value of ``conversation_id`` will be
     ``null``. If responses are being triggered by server VAD, the response will be added to the
     default conversation, thus the ``conversation_id`` will be an id like ``conv_1234``."""
    voice: Optional["_types.Voice"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """supported voice identifiers and configurations. Is one of the following types: Union[str,
     \"_models.OpenAIVoiceName\"], OpenAIVoice, AzureVoice"""
    modalities: Optional[list[Union[str, "_models.Modality"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The set of modalities the model used to respond. If there are multiple modalities, the model
     will pick one, for example if ``modalities`` is ``[\"text\", \"audio\"]``, the model could be
     responding in either text or audio."""
    output_audio_format: Optional[Union[str, "_models.OutputAudioFormat"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The format of output audio. Options are ``pcm16``, ``g711_ulaw``, or ``g711_alaw``. Known
     values are: \"pcm16\", \"pcm16_8000hz\", \"pcm16_16000hz\", \"g711_ulaw\", and \"g711_alaw\"."""
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sampling temperature for the model, limited to [0.6, 1.2]. Defaults to 0.8."""
    max_output_tokens: Optional[Union[int, Literal["inf"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum number of output tokens for a single assistant response, inclusive of tool calls, that
     was used in this response. Is either a int type or a Literal[\"inf\"] type."""
    metadata: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Set of up to 16 key-value pairs that can be attached to an object. This can be useful for
     storing additional information about the object in a structured format. Keys can be a maximum
     of 64 characters long and values can be a maximum of 512 characters long."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        object: Optional[Literal["realtime.response"]] = None,
        status: Optional[Union[str, "_models.ResponseStatus"]] = None,
        status_details: Optional["_models.ResponseStatusDetails"] = None,
        output: Optional[list["_models.ResponseItem"]] = None,
        usage: Optional["_models.TokenUsage"] = None,
        conversation_id: Optional[str] = None,
        voice: Optional["_types.Voice"] = None,
        modalities: Optional[list[Union[str, "_models.Modality"]]] = None,
        output_audio_format: Optional[Union[str, "_models.OutputAudioFormat"]] = None,
        temperature: Optional[float] = None,
        max_output_tokens: Optional[Union[int, Literal["inf"]]] = None,
        metadata: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseAudioContentPart(ContentPart, discriminator="audio"):
    """An audio content part for a response.

    :ivar type: Required. AUDIO.
    :vartype type: str or ~azure.ai.voicelive.models.AUDIO
    :ivar transcript:
    :vartype transcript: str
    """

    type: Literal[ContentPartType.AUDIO] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. AUDIO."""
    transcript: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        transcript: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ContentPartType.AUDIO  # type: ignore


class ResponseStatusDetails(_Model):
    """Base for all non-success response details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ResponseCancelledDetails, ResponseFailedDetails, ResponseIncompleteDetails

    :ivar type: Required. Known values are: "completed", "cancelled", "failed", "incomplete", and
     "in_progress".
    :vartype type: str or ~azure.ai.voicelive.models.ResponseStatus
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"completed\", \"cancelled\", \"failed\", \"incomplete\", and
     \"in_progress\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseCancelledDetails(ResponseStatusDetails, discriminator="cancelled"):
    """Details for a cancelled response.

    :ivar type: Required. CANCELLED.
    :vartype type: str or ~azure.ai.voicelive.models.CANCELLED
    :ivar reason: Required. Is one of the following types: Literal["turn_detected"],
     Literal["client_cancelled"], str
    :vartype reason: str
    """

    type: Literal[ResponseStatus.CANCELLED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. CANCELLED."""
    reason: Union[Literal["turn_detected"], Literal["client_cancelled"], str] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Is one of the following types: Literal[\"turn_detected\"],
     Literal[\"client_cancelled\"], str"""

    @overload
    def __init__(
        self,
        *,
        reason: Union[Literal["turn_detected"], Literal["client_cancelled"], str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStatus.CANCELLED  # type: ignore


class ResponseCreateParams(_Model):
    """Create a new VoiceLive response with these parameters.

    :ivar commit: Whether to commit the response to the conversation. Defaults to true.
    :vartype commit: bool
    :ivar cancel_previous: Whether to cancel any ongoing generation before starting this one.
     Defaults to true.
    :vartype cancel_previous: bool
    :ivar append_input_items: Input items to append to the conversation context before generating a
     response.
    :vartype append_input_items: list[~azure.ai.voicelive.models.ConversationRequestItem]
    :ivar input_items: Input items to be used as the context for this response. An empty array
     clears previous context.
    :vartype input_items: list[~azure.ai.voicelive.models.ConversationRequestItem]
    :ivar modalities: The set of modalities the model can respond with. To disable audio, set this
     to ["text"].
    :vartype modalities: list[str or ~azure.ai.voicelive.models.Modality]
    :ivar instructions: The default system instructions (i.e. system message) prepended to model
     calls. This field allows the client to guide the model on desired
     responses. The model can be instructed on response content and format,
     (e.g. "be extremely succinct", "act friendly", "here are examples of good
     responses") and on audio behavior (e.g. "talk quickly", "inject emotion
     into your voice", "laugh frequently"). The instructions are not guaranteed
     to be followed by the model, but they provide guidance to the model on the
     desired behavior.

     Note that the server sets default instructions which will be used if this
     field is not set and are visible in the ``session.created`` event at the
     start of the session.
    :vartype instructions: str
    :ivar voice: supported voice identifiers and configurations. Is one of the following types:
     Union[str, "_models.OpenAIVoiceName"], OpenAIVoice, AzureVoice
    :vartype voice: str or ~azure.ai.voicelive.models.OpenAIVoiceName or
     ~azure.ai.voicelive.models.OpenAIVoice or ~azure.ai.voicelive.models.AzureVoice
    :ivar output_audio_format: The format of output audio. Options are ``pcm16``, ``g711_ulaw``, or
     ``g711_alaw``. Known values are: "pcm16", "pcm16_8000hz", "pcm16_16000hz", "g711_ulaw", and
     "g711_alaw".
    :vartype output_audio_format: str or ~azure.ai.voicelive.models.OutputAudioFormat
    :ivar tools: Tools (functions) available to the model.
    :vartype tools: list[~azure.ai.voicelive.models.Tool]
    :ivar tool_choice: How the model chooses tools. Options are ``auto``, ``none``, ``required``,
     or specify a function, like ``{"type": "function", "function": {"name": "my_function"}}``.
    :vartype tool_choice: str
    :ivar temperature: Sampling temperature for the model, limited to [0.6, 1.2]. Defaults to 0.8.
    :vartype temperature: float
    :ivar max_output_tokens: Maximum number of output tokens for a single assistant response,
     inclusive of tool calls. Provide an integer between 1 and 4096 to limit output tokens, or
     ``inf`` for the maximum available tokens for a given model. Defaults to ``inf``. Is either a
     int type or a Literal["inf"] type.
    :vartype max_output_tokens: int or str
    :ivar pre_generated_assistant_message: Create the response with pre-generated assistant
     message. The message item would be added into the conversation history and returned with
     synthesized audio output in the created response.
    :vartype pre_generated_assistant_message: ~azure.ai.voicelive.models.AssistantMessageItem
    :ivar reasoning_effort: Constrains effort on reasoning for reasoning models. Check model
     documentation for supported values for each model. Reducing reasoning effort can result in
     faster responses and fewer tokens used on reasoning in a response. Known values are: "none",
     "minimal", "low", "medium", "high", and "xhigh".
    :vartype reasoning_effort: str or ~azure.ai.voicelive.models.ReasoningEffort
    :ivar metadata: Set of up to 16 key-value pairs that can be attached to an object. This can be
     useful for storing additional information about the object in a structured format. Keys can be
     a maximum of 64 characters long and values can be a maximum of 512 characters long.
    :vartype metadata: dict[str, str]
    """

    commit: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether to commit the response to the conversation. Defaults to true."""
    cancel_previous: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether to cancel any ongoing generation before starting this one. Defaults to true."""
    append_input_items: Optional[list["_models.ConversationRequestItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Input items to append to the conversation context before generating a response."""
    input_items: Optional[list["_models.ConversationRequestItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Input items to be used as the context for this response. An empty array clears previous
     context."""
    modalities: Optional[list[Union[str, "_models.Modality"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The set of modalities the model can respond with. To disable audio, set this to [\"text\"]."""
    instructions: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The default system instructions (i.e. system message) prepended to model
     calls. This field allows the client to guide the model on desired
     responses. The model can be instructed on response content and format,
     (e.g. \"be extremely succinct\", \"act friendly\", \"here are examples of good
     responses\") and on audio behavior (e.g. \"talk quickly\", \"inject emotion
     into your voice\", \"laugh frequently\"). The instructions are not guaranteed
     to be followed by the model, but they provide guidance to the model on the
     desired behavior.
     
     Note that the server sets default instructions which will be used if this
     field is not set and are visible in the ``session.created`` event at the
     start of the session."""
    voice: Optional["_types.Voice"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """supported voice identifiers and configurations. Is one of the following types: Union[str,
     \"_models.OpenAIVoiceName\"], OpenAIVoice, AzureVoice"""
    output_audio_format: Optional[Union[str, "_models.OutputAudioFormat"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The format of output audio. Options are ``pcm16``, ``g711_ulaw``, or ``g711_alaw``. Known
     values are: \"pcm16\", \"pcm16_8000hz\", \"pcm16_16000hz\", \"g711_ulaw\", and \"g711_alaw\"."""
    tools: Optional[list["_models.Tool"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Tools (functions) available to the model."""
    tool_choice: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """How the model chooses tools. Options are ``auto``, ``none``, ``required``, or specify a
     function, like ``{\"type\": \"function\", \"function\": {\"name\": \"my_function\"}}``."""
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sampling temperature for the model, limited to [0.6, 1.2]. Defaults to 0.8."""
    max_output_tokens: Optional[Union[int, Literal["inf"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum number of output tokens for a single assistant response, inclusive of tool calls.
     Provide an integer between 1 and 4096 to limit output tokens, or ``inf`` for the maximum
     available tokens for a given model. Defaults to ``inf``. Is either a int type or a
     Literal[\"inf\"] type."""
    pre_generated_assistant_message: Optional["_models.AssistantMessageItem"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Create the response with pre-generated assistant message. The message item would be added into
     the conversation history and returned with synthesized audio output in the created response."""
    reasoning_effort: Optional[Union[str, "_models.ReasoningEffort"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Constrains effort on reasoning for reasoning models. Check model documentation for supported
     values for each model. Reducing reasoning effort can result in faster responses and fewer
     tokens used on reasoning in a response. Known values are: \"none\", \"minimal\", \"low\",
     \"medium\", \"high\", and \"xhigh\"."""
    metadata: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Set of up to 16 key-value pairs that can be attached to an object. This can be useful for
     storing additional information about the object in a structured format. Keys can be a maximum
     of 64 characters long and values can be a maximum of 512 characters long."""

    @overload
    def __init__(
        self,
        *,
        commit: Optional[bool] = None,
        cancel_previous: Optional[bool] = None,
        append_input_items: Optional[list["_models.ConversationRequestItem"]] = None,
        input_items: Optional[list["_models.ConversationRequestItem"]] = None,
        modalities: Optional[list[Union[str, "_models.Modality"]]] = None,
        instructions: Optional[str] = None,
        voice: Optional["_types.Voice"] = None,
        output_audio_format: Optional[Union[str, "_models.OutputAudioFormat"]] = None,
        tools: Optional[list["_models.Tool"]] = None,
        tool_choice: Optional[str] = None,
        temperature: Optional[float] = None,
        max_output_tokens: Optional[Union[int, Literal["inf"]]] = None,
        pre_generated_assistant_message: Optional["_models.AssistantMessageItem"] = None,
        reasoning_effort: Optional[Union[str, "_models.ReasoningEffort"]] = None,
        metadata: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseFailedDetails(ResponseStatusDetails, discriminator="failed"):
    """Details for a failed response.

    :ivar type: Required. FAILED.
    :vartype type: str or ~azure.ai.voicelive.models.FAILED
    :ivar error: Required.
    :vartype error: any
    """

    type: Literal[ResponseStatus.FAILED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. FAILED."""
    error: Any = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        error: Any,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStatus.FAILED  # type: ignore


class ResponseItem(_Model):
    """Base for any response item; discriminated by ``type``.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ResponseFunctionCallItem, ResponseFunctionCallOutputItem, ResponseMCPApprovalRequestItem,
    ResponseMCPApprovalResponseItem, ResponseMCPCallItem, ResponseMCPListToolItem,
    ResponseMessageItem

    :ivar type: Required. Known values are: "message", "function_call", "function_call_output",
     "mcp_list_tools", "mcp_call", "mcp_approval_request", and "mcp_approval_response".
    :vartype type: str or ~azure.ai.voicelive.models.ItemType
    :ivar id:
    :vartype id: str
    :ivar object: Default value is "realtime.item".
    :vartype object: str
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"message\", \"function_call\", \"function_call_output\",
     \"mcp_list_tools\", \"mcp_call\", \"mcp_approval_request\", and \"mcp_approval_response\"."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    object: Optional[Literal["realtime.item"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Default value is \"realtime.item\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        object: Optional[Literal["realtime.item"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseFunctionCallItem(ResponseItem, discriminator="function_call"):
    """A function call item within a conversation.

    :ivar id:
    :vartype id: str
    :ivar object: Default value is "realtime.item".
    :vartype object: str
    :ivar type: Required. FUNCTION_CALL.
    :vartype type: str or ~azure.ai.voicelive.models.FUNCTION_CALL
    :ivar name: Required.
    :vartype name: str
    :ivar call_id: Required.
    :vartype call_id: str
    :ivar arguments: Required.
    :vartype arguments: str
    :ivar status: Required. Known values are: "in_progress", "completed", and "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ResponseItemStatus
    """

    type: Literal[ItemType.FUNCTION_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. FUNCTION_CALL."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    arguments: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    status: Union[str, "_models.ResponseItemStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Known values are: \"in_progress\", \"completed\", and \"incomplete\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        call_id: str,
        arguments: str,
        status: Union[str, "_models.ResponseItemStatus"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        object: Optional[Literal["realtime.item"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.FUNCTION_CALL  # type: ignore


class ResponseFunctionCallOutputItem(ResponseItem, discriminator="function_call_output"):
    """A function call output item within a conversation.

    :ivar id:
    :vartype id: str
    :ivar object: Default value is "realtime.item".
    :vartype object: str
    :ivar type: Required. FUNCTION_CALL_OUTPUT.
    :vartype type: str or ~azure.ai.voicelive.models.FUNCTION_CALL_OUTPUT
    :ivar call_id: Required.
    :vartype call_id: str
    :ivar output: Required.
    :vartype output: str
    """

    type: Literal[ItemType.FUNCTION_CALL_OUTPUT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. FUNCTION_CALL_OUTPUT."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        call_id: str,
        output: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        object: Optional[Literal["realtime.item"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.FUNCTION_CALL_OUTPUT  # type: ignore


class ResponseIncompleteDetails(ResponseStatusDetails, discriminator="incomplete"):
    """Details for an incomplete response.

    :ivar type: Required. INCOMPLETE.
    :vartype type: str or ~azure.ai.voicelive.models.INCOMPLETE
    :ivar reason: Required. Is one of the following types: Literal["max_output_tokens"],
     Literal["content_filter"], str
    :vartype reason: str
    """

    type: Literal[ResponseStatus.INCOMPLETE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. INCOMPLETE."""
    reason: Union[Literal["max_output_tokens"], Literal["content_filter"], str] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Is one of the following types: Literal[\"max_output_tokens\"],
     Literal[\"content_filter\"], str"""

    @overload
    def __init__(
        self,
        *,
        reason: Union[Literal["max_output_tokens"], Literal["content_filter"], str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStatus.INCOMPLETE  # type: ignore


class ResponseMCPApprovalRequestItem(ResponseItem, discriminator="mcp_approval_request"):
    """A response item that represents a request for approval to call an MCP tool.

    :ivar id:
    :vartype id: str
    :ivar object: Default value is "realtime.item".
    :vartype object: str
    :ivar type: The type of the item. Required. MCP_APPROVAL_REQUEST.
    :vartype type: str or ~azure.ai.voicelive.models.MCP_APPROVAL_REQUEST
    :ivar arguments: The arguments for the tool call.
    :vartype arguments: str
    :ivar name: The name of the tool to call. Required.
    :vartype name: str
    :ivar server_label: The label of the server that provides the tool. Required.
    :vartype server_label: str
    """

    type: Literal[ItemType.MCP_APPROVAL_REQUEST] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the item. Required. MCP_APPROVAL_REQUEST."""
    arguments: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The arguments for the tool call."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the tool to call. Required."""
    server_label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The label of the server that provides the tool. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        server_label: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        object: Optional[Literal["realtime.item"]] = None,
        arguments: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MCP_APPROVAL_REQUEST  # type: ignore


class ResponseMCPApprovalResponseItem(ResponseItem, discriminator="mcp_approval_response"):
    """A response item that represents a response to an MCP approval request.

    :ivar id:
    :vartype id: str
    :ivar object: Default value is "realtime.item".
    :vartype object: str
    :ivar type: The type of the item. Required. MCP_APPROVAL_RESPONSE.
    :vartype type: str or ~azure.ai.voicelive.models.MCP_APPROVAL_RESPONSE
    :ivar approval_request_id: The ID of the approval request. Required.
    :vartype approval_request_id: str
    :ivar approve: Whether the tool call was approved. Required.
    :vartype approve: bool
    :ivar reason: The reason for the approval decision.
    :vartype reason: str
    """

    type: Literal[ItemType.MCP_APPROVAL_RESPONSE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the item. Required. MCP_APPROVAL_RESPONSE."""
    approval_request_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the approval request. Required."""
    approve: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether the tool call was approved. Required."""
    reason: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The reason for the approval decision."""

    @overload
    def __init__(
        self,
        *,
        approval_request_id: str,
        approve: bool,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        object: Optional[Literal["realtime.item"]] = None,
        reason: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MCP_APPROVAL_RESPONSE  # type: ignore


class ResponseMCPCallItem(ResponseItem, discriminator="mcp_call"):
    """A response item that represents a call to an MCP tool.

    :ivar id:
    :vartype id: str
    :ivar object: Default value is "realtime.item".
    :vartype object: str
    :ivar type: The type of the item. Required. MCP_CALL.
    :vartype type: str or ~azure.ai.voicelive.models.MCP_CALL
    :ivar approval_request_id: The ID of the approval request, if any.
    :vartype approval_request_id: str
    :ivar arguments: The arguments for the tool call. Required.
    :vartype arguments: str
    :ivar server_label: The label of the server that provides the tool. Required.
    :vartype server_label: str
    :ivar name: The name of the tool to call. Required.
    :vartype name: str
    :ivar output: The output of the tool call.
    :vartype output: str
    :ivar error: The error, if any, from the tool call.
    :vartype error: any
    """

    type: Literal[ItemType.MCP_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the item. Required. MCP_CALL."""
    approval_request_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the approval request, if any."""
    arguments: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The arguments for the tool call. Required."""
    server_label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The label of the server that provides the tool. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the tool to call. Required."""
    output: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The output of the tool call."""
    error: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error, if any, from the tool call."""

    @overload
    def __init__(
        self,
        *,
        arguments: str,
        server_label: str,
        name: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        object: Optional[Literal["realtime.item"]] = None,
        approval_request_id: Optional[str] = None,
        output: Optional[str] = None,
        error: Optional[Any] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MCP_CALL  # type: ignore


class ResponseMCPListToolItem(ResponseItem, discriminator="mcp_list_tools"):
    """A response item that lists the tools available on an MCP server.

    :ivar id:
    :vartype id: str
    :ivar object: Default value is "realtime.item".
    :vartype object: str
    :ivar type: The type of the item. Required. MCP_LIST_TOOLS.
    :vartype type: str or ~azure.ai.voicelive.models.MCP_LIST_TOOLS
    :ivar tools: The tools available on the server. Required.
    :vartype tools: list[~azure.ai.voicelive.models.MCPTool]
    :ivar server_label: The label of the server that provides the tools. Required.
    :vartype server_label: str
    """

    type: Literal[ItemType.MCP_LIST_TOOLS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the item. Required. MCP_LIST_TOOLS."""
    tools: list["_models.MCPTool"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tools available on the server. Required."""
    server_label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The label of the server that provides the tools. Required."""

    @overload
    def __init__(
        self,
        *,
        tools: list["_models.MCPTool"],
        server_label: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        object: Optional[Literal["realtime.item"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MCP_LIST_TOOLS  # type: ignore


class ResponseMessageItem(ResponseItem, discriminator="message"):
    """Base type for message item within a conversation.

    :ivar id:
    :vartype id: str
    :ivar object: Default value is "realtime.item".
    :vartype object: str
    :ivar type: Required. MESSAGE.
    :vartype type: str or ~azure.ai.voicelive.models.MESSAGE
    :ivar role: Required. Known values are: "system", "user", and "assistant".
    :vartype role: str or ~azure.ai.voicelive.models.MessageRole
    :ivar content: Required.
    :vartype content: list[~azure.ai.voicelive.models.ContentPart]
    :ivar status: Required. Known values are: "in_progress", "completed", and "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ResponseItemStatus
    """

    type: Literal[ItemType.MESSAGE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. MESSAGE."""
    role: Union[str, "_models.MessageRole"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"system\", \"user\", and \"assistant\"."""
    content: list["_models.ContentPart"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    status: Union[str, "_models.ResponseItemStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Known values are: \"in_progress\", \"completed\", and \"incomplete\"."""

    @overload
    def __init__(
        self,
        *,
        role: Union[str, "_models.MessageRole"],
        content: list["_models.ContentPart"],
        status: Union[str, "_models.ResponseItemStatus"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        object: Optional[Literal["realtime.item"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MESSAGE  # type: ignore


class ResponseSession(_Model):
    """Base for session configuration in the response.

    :ivar model: The model for the session.
    :vartype model: str
    :ivar modalities: The modalities to be used in the session.
    :vartype modalities: list[str or ~azure.ai.voicelive.models.Modality]
    :ivar animation: The animation configuration for the session.
    :vartype animation: ~azure.ai.voicelive.models.Animation
    :ivar voice: The voice configuration for the session. Is one of the following types: Union[str,
     "_models.OpenAIVoiceName"], OpenAIVoice, AzureVoice
    :vartype voice: str or ~azure.ai.voicelive.models.OpenAIVoiceName or
     ~azure.ai.voicelive.models.OpenAIVoice or ~azure.ai.voicelive.models.AzureVoice
    :ivar instructions: Optional instructions to guide the model's behavior throughout the session.
    :vartype instructions: str
    :ivar input_audio_sampling_rate: Input audio sampling rate in Hz. Available values:

     * For pcm16: 8000, 16000, 24000

     * For g711_alaw/g711_ulaw: 8000.
    :vartype input_audio_sampling_rate: int
    :ivar input_audio_format: Input audio format. Default is 'pcm16'. Known values are: "pcm16",
     "g711_ulaw", and "g711_alaw".
    :vartype input_audio_format: str or ~azure.ai.voicelive.models.InputAudioFormat
    :ivar output_audio_format: Output audio format. Default is 'pcm16'. Known values are: "pcm16",
     "pcm16_8000hz", "pcm16_16000hz", "g711_ulaw", and "g711_alaw".
    :vartype output_audio_format: str or ~azure.ai.voicelive.models.OutputAudioFormat
    :ivar turn_detection: Type of turn detection to use.
    :vartype turn_detection: ~azure.ai.voicelive.models.TurnDetection
    :ivar input_audio_noise_reduction: Configuration for input audio noise reduction.
    :vartype input_audio_noise_reduction: ~azure.ai.voicelive.models.AudioNoiseReduction
    :ivar input_audio_echo_cancellation: Configuration for echo cancellation during server-side
     audio processing.
    :vartype input_audio_echo_cancellation: ~azure.ai.voicelive.models.AudioEchoCancellation
    :ivar avatar: Configuration for avatar streaming and behavior during the session.
    :vartype avatar: ~azure.ai.voicelive.models.AvatarConfig
    :ivar input_audio_transcription: Configuration for input audio transcription.
    :vartype input_audio_transcription: ~azure.ai.voicelive.models.AudioInputTranscriptionOptions
    :ivar output_audio_timestamp_types: Types of timestamps to include in audio response content.
    :vartype output_audio_timestamp_types: list[str or
     ~azure.ai.voicelive.models.AudioTimestampType]
    :ivar tools: Configuration for tools to be used during the session, if applicable.
    :vartype tools: list[~azure.ai.voicelive.models.Tool]
    :ivar tool_choice: Specifies which tools the model is allowed to call during the session. Is
     either a Union[str, "_models.ToolChoiceLiteral"] type or a ToolChoiceSelection type.
    :vartype tool_choice: str or ~azure.ai.voicelive.models.ToolChoiceLiteral or
     ~azure.ai.voicelive.models.ToolChoiceSelection
    :ivar temperature: Controls the randomness of the model's output. Range: 0.0 to 1.0. Default is
     0.7.
    :vartype temperature: float
    :ivar max_response_output_tokens: Maximum number of tokens to generate in the response. Default
     is unlimited. Is either a int type or a Literal["inf"] type.
    :vartype max_response_output_tokens: int or str
    :ivar reasoning_effort: Constrains effort on reasoning for reasoning models. Check model
     documentation for supported values for each model. Reducing reasoning effort can result in
     faster responses and fewer tokens used on reasoning in a response. Known values are: "none",
     "minimal", "low", "medium", "high", and "xhigh".
    :vartype reasoning_effort: str or ~azure.ai.voicelive.models.ReasoningEffort
    :ivar interim_response: Configuration for interim response generation during latency or tool
     calls. Is either a StaticInterimResponseConfig type or a LlmInterimResponseConfig type.
    :vartype interim_response: ~azure.ai.voicelive.models.StaticInterimResponseConfig or
     ~azure.ai.voicelive.models.LlmInterimResponseConfig
    :ivar agent: The agent configuration for the session, if applicable.
    :vartype agent: ~azure.ai.voicelive.models.AgentConfig
    :ivar id: The unique identifier for the session.
    :vartype id: str
    """

    model: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The model for the session."""
    modalities: Optional[list[Union[str, "_models.Modality"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The modalities to be used in the session."""
    animation: Optional["_models.Animation"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The animation configuration for the session."""
    voice: Optional["_types.Voice"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The voice configuration for the session. Is one of the following types: Union[str,
     \"_models.OpenAIVoiceName\"], OpenAIVoice, AzureVoice"""
    instructions: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional instructions to guide the model's behavior throughout the session."""
    input_audio_sampling_rate: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Input audio sampling rate in Hz. Available values:
 
      * For pcm16: 8000, 16000, 24000
 
      * For g711_alaw/g711_ulaw: 8000."""
    input_audio_format: Optional[Union[str, "_models.InputAudioFormat"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Input audio format. Default is 'pcm16'. Known values are: \"pcm16\", \"g711_ulaw\", and
     \"g711_alaw\"."""
    output_audio_format: Optional[Union[str, "_models.OutputAudioFormat"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Output audio format. Default is 'pcm16'. Known values are: \"pcm16\", \"pcm16_8000hz\",
     \"pcm16_16000hz\", \"g711_ulaw\", and \"g711_alaw\"."""
    turn_detection: Optional["_models.TurnDetection"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of turn detection to use."""
    input_audio_noise_reduction: Optional["_models.AudioNoiseReduction"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration for input audio noise reduction."""
    input_audio_echo_cancellation: Optional["_models.AudioEchoCancellation"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration for echo cancellation during server-side audio processing."""
    avatar: Optional["_models.AvatarConfig"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Configuration for avatar streaming and behavior during the session."""
    input_audio_transcription: Optional["_models.AudioInputTranscriptionOptions"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration for input audio transcription."""
    output_audio_timestamp_types: Optional[list[Union[str, "_models.AudioTimestampType"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Types of timestamps to include in audio response content."""
    tools: Optional[list["_models.Tool"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Configuration for tools to be used during the session, if applicable."""
    tool_choice: Optional["_types.ToolChoice"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies which tools the model is allowed to call during the session. Is either a Union[str,
     \"_models.ToolChoiceLiteral\"] type or a ToolChoiceSelection type."""
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Controls the randomness of the model's output. Range: 0.0 to 1.0. Default is 0.7."""
    max_response_output_tokens: Optional[Union[int, Literal["inf"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum number of tokens to generate in the response. Default is unlimited. Is either a int
     type or a Literal[\"inf\"] type."""
    reasoning_effort: Optional[Union[str, "_models.ReasoningEffort"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Constrains effort on reasoning for reasoning models. Check model documentation for supported
     values for each model. Reducing reasoning effort can result in faster responses and fewer
     tokens used on reasoning in a response. Known values are: \"none\", \"minimal\", \"low\",
     \"medium\", \"high\", and \"xhigh\"."""
    interim_response: Optional["_types.InterimResponseConfig"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration for interim response generation during latency or tool calls. Is either a
     StaticInterimResponseConfig type or a LlmInterimResponseConfig type."""
    agent: Optional["_models.AgentConfig"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The agent configuration for the session, if applicable."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier for the session."""

    @overload
    def __init__(
        self,
        *,
        model: Optional[str] = None,
        modalities: Optional[list[Union[str, "_models.Modality"]]] = None,
        animation: Optional["_models.Animation"] = None,
        voice: Optional["_types.Voice"] = None,
        instructions: Optional[str] = None,
        input_audio_sampling_rate: Optional[int] = None,
        input_audio_format: Optional[Union[str, "_models.InputAudioFormat"]] = None,
        output_audio_format: Optional[Union[str, "_models.OutputAudioFormat"]] = None,
        turn_detection: Optional["_models.TurnDetection"] = None,
        input_audio_noise_reduction: Optional["_models.AudioNoiseReduction"] = None,
        input_audio_echo_cancellation: Optional["_models.AudioEchoCancellation"] = None,
        avatar: Optional["_models.AvatarConfig"] = None,
        input_audio_transcription: Optional["_models.AudioInputTranscriptionOptions"] = None,
        output_audio_timestamp_types: Optional[list[Union[str, "_models.AudioTimestampType"]]] = None,
        tools: Optional[list["_models.Tool"]] = None,
        tool_choice: Optional["_types.ToolChoice"] = None,
        temperature: Optional[float] = None,
        max_response_output_tokens: Optional[Union[int, Literal["inf"]]] = None,
        reasoning_effort: Optional[Union[str, "_models.ReasoningEffort"]] = None,
        interim_response: Optional["_types.InterimResponseConfig"] = None,
        agent: Optional["_models.AgentConfig"] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseTextContentPart(ContentPart, discriminator="text"):
    """A text content part for a response.

    :ivar type: Required. TEXT.
    :vartype type: str or ~azure.ai.voicelive.models.TEXT
    :ivar text:
    :vartype text: str
    """

    type: Literal[ContentPartType.TEXT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. TEXT."""
    text: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        text: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ContentPartType.TEXT  # type: ignore


class Scene(_Model):
    """Configuration for avatar's zoom level, position, rotation and movement amplitude in the video
    frame.

    :ivar zoom: Zoom level of the avatar. Range is (0, +∞). Values less than 1 zoom out, values
     greater than 1 zoom in.
    :vartype zoom: float
    :ivar position_x: Horizontal position of the avatar. Range is [-1, 1], as a proportion of frame
     width. Negative values move left, positive values move right.
    :vartype position_x: float
    :ivar position_y: Vertical position of the avatar. Range is [-1, 1], as a proportion of frame
     height. Negative values move up, positive values move down.
    :vartype position_y: float
    :ivar rotation_x: Rotation around the X-axis (pitch). Range is [-π, π] in radians. Negative
     values rotate up, positive values rotate down.
    :vartype rotation_x: float
    :ivar rotation_y: Rotation around the Y-axis (yaw). Range is [-π, π] in radians. Negative
     values rotate left, positive values rotate right.
    :vartype rotation_y: float
    :ivar rotation_z: Rotation around the Z-axis (roll). Range is [-π, π] in radians. Negative
     values rotate anticlockwise, positive values rotate clockwise.
    :vartype rotation_z: float
    :ivar amplitude: Amplitude of the avatar movement. Range is (0, 1]. Values in (0, 1) mean
     reduced amplitude, 1 means full amplitude.
    :vartype amplitude: float
    """

    zoom: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Zoom level of the avatar. Range is (0, +∞). Values less than 1 zoom out, values greater than 1
     zoom in."""
    position_x: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Horizontal position of the avatar. Range is [-1, 1], as a proportion of frame width. Negative
     values move left, positive values move right."""
    position_y: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Vertical position of the avatar. Range is [-1, 1], as a proportion of frame height. Negative
     values move up, positive values move down."""
    rotation_x: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Rotation around the X-axis (pitch). Range is [-π, π] in radians. Negative values rotate up,
     positive values rotate down."""
    rotation_y: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Rotation around the Y-axis (yaw). Range is [-π, π] in radians. Negative values rotate left,
     positive values rotate right."""
    rotation_z: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Rotation around the Z-axis (roll). Range is [-π, π] in radians. Negative values rotate
     anticlockwise, positive values rotate clockwise."""
    amplitude: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Amplitude of the avatar movement. Range is (0, 1]. Values in (0, 1) mean reduced amplitude, 1
     means full amplitude."""

    @overload
    def __init__(
        self,
        *,
        zoom: Optional[float] = None,
        position_x: Optional[float] = None,
        position_y: Optional[float] = None,
        rotation_x: Optional[float] = None,
        rotation_y: Optional[float] = None,
        rotation_z: Optional[float] = None,
        amplitude: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServerEvent(_Model):
    """A voicelive server event.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ServerEventConversationItemCreated, ServerEventConversationItemDeleted,
    ServerEventConversationItemInputAudioTranscriptionCompleted,
    ServerEventConversationItemInputAudioTranscriptionDelta,
    ServerEventConversationItemInputAudioTranscriptionFailed, ServerEventConversationItemRetrieved,
    ServerEventConversationItemTruncated, ServerEventError, ServerEventInputAudioBufferCleared,
    ServerEventInputAudioBufferCommitted, ServerEventInputAudioBufferSpeechStarted,
    ServerEventInputAudioBufferSpeechStopped, ServerEventMcpListToolsCompleted,
    ServerEventMcpListToolsFailed, ServerEventMcpListToolsInProgress,
    ServerEventResponseAnimationBlendshapeDelta, ServerEventResponseAnimationBlendshapeDone,
    ServerEventResponseAnimationVisemeDelta, ServerEventResponseAnimationVisemeDone,
    ServerEventResponseAudioDelta, ServerEventResponseAudioDone,
    ServerEventResponseAudioTimestampDelta, ServerEventResponseAudioTimestampDone,
    ServerEventResponseAudioTranscriptDelta, ServerEventResponseAudioTranscriptDone,
    ServerEventResponseContentPartAdded, ServerEventResponseContentPartDone,
    ServerEventResponseCreated, ServerEventResponseDone,
    ServerEventResponseFunctionCallArgumentsDelta, ServerEventResponseFunctionCallArgumentsDone,
    ServerEventResponseMcpCallCompleted, ServerEventResponseMcpCallFailed,
    ServerEventResponseMcpCallInProgress, ServerEventResponseMcpCallArgumentsDelta,
    ServerEventResponseMcpCallArgumentsDone, ServerEventResponseOutputItemAdded,
    ServerEventResponseOutputItemDone, ServerEventResponseTextDelta, ServerEventResponseTextDone,
    ServerEventSessionAvatarConnecting, ServerEventSessionCreated, ServerEventSessionUpdated,
    ServerEventWarning

    :ivar type: The type of event. Required. Known values are: "error", "warning",
     "session.avatar.connecting", "session.created", "session.updated",
     "conversation.item.input_audio_transcription.completed",
     "conversation.item.input_audio_transcription.delta",
     "conversation.item.input_audio_transcription.failed", "conversation.item.created",
     "conversation.item.retrieved", "conversation.item.truncated", "conversation.item.deleted",
     "input_audio_buffer.committed", "input_audio_buffer.cleared",
     "input_audio_buffer.speech_started", "input_audio_buffer.speech_stopped", "response.created",
     "response.done", "response.output_item.added", "response.output_item.done",
     "response.content_part.added", "response.content_part.done", "response.text.delta",
     "response.text.done", "response.audio_transcript.delta", "response.audio_transcript.done",
     "response.audio.delta", "response.audio.done", "response.animation_blendshapes.delta",
     "response.animation_blendshapes.done", "response.audio_timestamp.delta",
     "response.audio_timestamp.done", "response.animation_viseme.delta",
     "response.animation_viseme.done", "response.function_call_arguments.delta",
     "response.function_call_arguments.done", "mcp_list_tools.in_progress",
     "mcp_list_tools.completed", "mcp_list_tools.failed", "response.mcp_call_arguments.delta",
     "response.mcp_call_arguments.done", "response.mcp_call.in_progress",
     "response.mcp_call.completed", and "response.mcp_call.failed".
    :vartype type: str or ~azure.ai.voicelive.models.ServerEventType
    :ivar event_id:
    :vartype event_id: str
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of event. Required. Known values are: \"error\", \"warning\",
     \"session.avatar.connecting\", \"session.created\", \"session.updated\",
     \"conversation.item.input_audio_transcription.completed\",
     \"conversation.item.input_audio_transcription.delta\",
     \"conversation.item.input_audio_transcription.failed\", \"conversation.item.created\",
     \"conversation.item.retrieved\", \"conversation.item.truncated\",
     \"conversation.item.deleted\", \"input_audio_buffer.committed\",
     \"input_audio_buffer.cleared\", \"input_audio_buffer.speech_started\",
     \"input_audio_buffer.speech_stopped\", \"response.created\", \"response.done\",
     \"response.output_item.added\", \"response.output_item.done\", \"response.content_part.added\",
     \"response.content_part.done\", \"response.text.delta\", \"response.text.done\",
     \"response.audio_transcript.delta\", \"response.audio_transcript.done\",
     \"response.audio.delta\", \"response.audio.done\", \"response.animation_blendshapes.delta\",
     \"response.animation_blendshapes.done\", \"response.audio_timestamp.delta\",
     \"response.audio_timestamp.done\", \"response.animation_viseme.delta\",
     \"response.animation_viseme.done\", \"response.function_call_arguments.delta\",
     \"response.function_call_arguments.done\", \"mcp_list_tools.in_progress\",
     \"mcp_list_tools.completed\", \"mcp_list_tools.failed\", \"response.mcp_call_arguments.delta\",
     \"response.mcp_call_arguments.done\", \"response.mcp_call.in_progress\",
     \"response.mcp_call.completed\", and \"response.mcp_call.failed\"."""
    event_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        type: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)

    @classmethod
    def deserialize(cls, payload: dict[str, Any]) -> "ServerEvent":
        # public, linter-friendly entrypoint
        # pylint: disable-next=protected-access
        return cls._deserialize(payload, [])

class ServerEventConversationItemCreated(ServerEvent, discriminator="conversation.item.created"):
    """Returned when a conversation item is created. There are several scenarios that produce this
    event:

    The server is generating a Response, which if successful will produce
    either one or two Items, which will be of type `message`
    (role `assistant`) or type `function_call`.
    The input audio buffer has been committed, either by the client or the
    server (in `server_vad` mode). The server will take the content of the
    input audio buffer and add it to a new user message Item.
    The client has sent a `conversation.item.create` event to add a new Item
    to the Conversation.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``conversation.item.created``. Required.
     CONVERSATION_ITEM_CREATED.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_CREATED
    :ivar previous_item_id: The ID of the preceding item in the Conversation context, allows the
     client to understand the order of the conversation.
    :vartype previous_item_id: str
    :ivar item:
    :vartype item: ~azure.ai.voicelive.models.ResponseItem
    """

    type: Literal[ServerEventType.CONVERSATION_ITEM_CREATED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.created``. Required. CONVERSATION_ITEM_CREATED."""
    previous_item_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the preceding item in the Conversation context, allows the client to understand the
     order of the conversation."""
    item: Optional["_models.ResponseItem"] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
        previous_item_id: Optional[str] = None,
        item: Optional["_models.ResponseItem"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.CONVERSATION_ITEM_CREATED  # type: ignore


class ServerEventConversationItemDeleted(ServerEvent, discriminator="conversation.item.deleted"):
    """Returned when an item in the conversation is deleted by the client with a
    ``conversation.item.delete`` event. This event is used to synchronize the server's
    understanding of the conversation history with the client's view.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``conversation.item.deleted``. Required.
     CONVERSATION_ITEM_DELETED.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_DELETED
    :ivar item_id: The ID of the item that was deleted. Required.
    :vartype item_id: str
    """

    type: Literal[ServerEventType.CONVERSATION_ITEM_DELETED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.deleted``. Required. CONVERSATION_ITEM_DELETED."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item that was deleted. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.CONVERSATION_ITEM_DELETED  # type: ignore


class ServerEventConversationItemInputAudioTranscriptionCompleted(
    ServerEvent, discriminator="conversation.item.input_audio_transcription.completed"
):  # pylint: disable=name-too-long
    """This event is the output of audio transcription for user audio written to the user audio
    buffer. Transcription begins when the input audio buffer is committed by the client or server
    (in ``server_vad`` mode). Transcription runs asynchronously with Response creation, so this
    event may come before or after the Response events. VoiceLive API models accept audio natively,
    and thus input transcription is a separate process run on a separate ASR (Automatic Speech
    Recognition) model. The transcript may diverge somewhat from the model's interpretation, and
    should be treated as a rough guide.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``conversation.item.input_audio_transcription.completed``.
     Required. CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_COMPLETED.
    :vartype type: str or
     ~azure.ai.voicelive.models.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_COMPLETED
    :ivar item_id: The ID of the user message item containing the audio. Required.
    :vartype item_id: str
    :ivar content_index: The index of the content part containing the audio. Required.
    :vartype content_index: int
    :ivar transcript: The transcribed text. Required.
    :vartype transcript: str
    """

    type: Literal[ServerEventType.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_COMPLETED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.input_audio_transcription.completed``. Required.
     CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_COMPLETED."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the user message item containing the audio. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part containing the audio. Required."""
    transcript: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The transcribed text. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        content_index: int,
        transcript: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_COMPLETED  # type: ignore


class ServerEventConversationItemInputAudioTranscriptionDelta(
    ServerEvent, discriminator="conversation.item.input_audio_transcription.delta"
):  # pylint: disable=name-too-long
    """Returned when the text value of an input audio transcription content part is updated.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``conversation.item.input_audio_transcription.delta``.
     Required. CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_DELTA.
    :vartype type: str or
     ~azure.ai.voicelive.models.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_DELTA
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar content_index: The index of the content part in the item's content array.
    :vartype content_index: int
    :ivar delta: The text delta.
    :vartype delta: str
    :ivar logprobs: The log probabilities of the transcription.
    :vartype logprobs: list[~azure.ai.voicelive.models.LogProbProperties]
    """

    type: Literal[ServerEventType.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.input_audio_transcription.delta``. Required.
     CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_DELTA."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    content_index: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array."""
    delta: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text delta."""
    logprobs: Optional[list["_models.LogProbProperties"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The log probabilities of the transcription."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        event_id: Optional[str] = None,
        content_index: Optional[int] = None,
        delta: Optional[str] = None,
        logprobs: Optional[list["_models.LogProbProperties"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_DELTA  # type: ignore


class ServerEventConversationItemInputAudioTranscriptionFailed(
    ServerEvent, discriminator="conversation.item.input_audio_transcription.failed"
):  # pylint: disable=name-too-long
    """Returned when input audio transcription is configured, and a transcription request for a user
    message failed. These events are separate from other ``error`` events so that the client can
    identify the related Item.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``conversation.item.input_audio_transcription.failed``.
     Required. CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_FAILED.
    :vartype type: str or
     ~azure.ai.voicelive.models.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_FAILED
    :ivar item_id: The ID of the user message item. Required.
    :vartype item_id: str
    :ivar content_index: The index of the content part containing the audio. Required.
    :vartype content_index: int
    :ivar error: Details of the transcription error. Required.
    :vartype error: ~azure.ai.voicelive.models.VoiceLiveErrorDetails
    """

    type: Literal[ServerEventType.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_FAILED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.input_audio_transcription.failed``. Required.
     CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_FAILED."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the user message item. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part containing the audio. Required."""
    error: "_models.VoiceLiveErrorDetails" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Details of the transcription error. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        content_index: int,
        error: "_models.VoiceLiveErrorDetails",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_FAILED  # type: ignore


class ServerEventConversationItemRetrieved(ServerEvent, discriminator="conversation.item.retrieved"):
    """Returned when a conversation item is retrieved with ``conversation.item.retrieve``.

    :ivar type: The event type, must be ``conversation.item.retrieved``. Required.
     CONVERSATION_ITEM_RETRIEVED.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_RETRIEVED
    :ivar item:
    :vartype item: ~azure.ai.voicelive.models.ResponseItem
    :ivar event_id:
    :vartype event_id: str
    """

    type: Literal[ServerEventType.CONVERSATION_ITEM_RETRIEVED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.retrieved``. Required. CONVERSATION_ITEM_RETRIEVED."""
    item: Optional["_models.ResponseItem"] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        item: Optional["_models.ResponseItem"] = None,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.CONVERSATION_ITEM_RETRIEVED  # type: ignore


class ServerEventConversationItemTruncated(ServerEvent, discriminator="conversation.item.truncated"):
    """Returned when an earlier assistant audio message item is truncated by the client with a
    ``conversation.item.truncate`` event. This event is used to synchronize the server's
    understanding of the audio with the client's playback. This action will truncate the audio and
    remove the server-side text transcript to ensure there is no text in the context that hasn't
    been heard by the user.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``conversation.item.truncated``. Required.
     CONVERSATION_ITEM_TRUNCATED.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_TRUNCATED
    :ivar item_id: The ID of the assistant message item that was truncated. Required.
    :vartype item_id: str
    :ivar content_index: The index of the content part that was truncated. Required.
    :vartype content_index: int
    :ivar audio_end_ms: The duration up to which the audio was truncated, in milliseconds.
     Required.
    :vartype audio_end_ms: int
    """

    type: Literal[ServerEventType.CONVERSATION_ITEM_TRUNCATED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.truncated``. Required. CONVERSATION_ITEM_TRUNCATED."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the assistant message item that was truncated. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part that was truncated. Required."""
    audio_end_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The duration up to which the audio was truncated, in milliseconds. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        content_index: int,
        audio_end_ms: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.CONVERSATION_ITEM_TRUNCATED  # type: ignore


class ServerEventError(ServerEvent, discriminator="error"):
    """Returned when an error occurs, which could be a client problem or a server problem. Most errors
    are recoverable and the session will stay open, we recommend to implementors to monitor and log
    error messages by default.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``error``. Required. ERROR.
    :vartype type: str or ~azure.ai.voicelive.models.ERROR
    :ivar error: Details of the error. Required.
    :vartype error: ~azure.ai.voicelive.models.ServerEventErrorDetails
    """

    type: Literal[ServerEventType.ERROR] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``error``. Required. ERROR."""
    error: "_models.ServerEventErrorDetails" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Details of the error. Required."""

    @overload
    def __init__(
        self,
        *,
        error: "_models.ServerEventErrorDetails",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.ERROR  # type: ignore


class ServerEventErrorDetails(_Model):
    """Details of the error.

    :ivar type: The type of error (e.g., "invalid_request_error", "server_error"). Required.
    :vartype type: str
    :ivar code: Error code, if any.
    :vartype code: str
    :ivar message: A human-readable error message. Required.
    :vartype message: str
    :ivar param: Parameter related to the error, if any.
    :vartype param: str
    :ivar event_id: The event_id of the client event that caused the error, if applicable.
    :vartype event_id: str
    """

    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of error (e.g., \"invalid_request_error\", \"server_error\"). Required."""
    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error code, if any."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A human-readable error message. Required."""
    param: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Parameter related to the error, if any."""
    event_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The event_id of the client event that caused the error, if applicable."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        message: str,
        code: Optional[str] = None,
        param: Optional[str] = None,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServerEventInputAudioBufferCleared(ServerEvent, discriminator="input_audio_buffer.cleared"):
    """Returned when the input audio buffer is cleared by the client with a
    ``input_audio_buffer.clear`` event.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``input_audio_buffer.cleared``. Required.
     INPUT_AUDIO_BUFFER_CLEARED.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_BUFFER_CLEARED
    """

    type: Literal[ServerEventType.INPUT_AUDIO_BUFFER_CLEARED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``input_audio_buffer.cleared``. Required. INPUT_AUDIO_BUFFER_CLEARED."""

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.INPUT_AUDIO_BUFFER_CLEARED  # type: ignore


class ServerEventInputAudioBufferCommitted(ServerEvent, discriminator="input_audio_buffer.committed"):
    """Returned when an input audio buffer is committed, either by the client or automatically in
    server VAD mode. The ``item_id`` property is the ID of the user message item that will be
    created, thus a ``conversation.item.created`` event will also be sent to the client.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``input_audio_buffer.committed``. Required.
     INPUT_AUDIO_BUFFER_COMMITTED.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_BUFFER_COMMITTED
    :ivar previous_item_id: The ID of the preceding item after which the new item will be inserted.
    :vartype previous_item_id: str
    :ivar item_id: The ID of the user message item that will be created. Required.
    :vartype item_id: str
    """

    type: Literal[ServerEventType.INPUT_AUDIO_BUFFER_COMMITTED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``input_audio_buffer.committed``. Required.
     INPUT_AUDIO_BUFFER_COMMITTED."""
    previous_item_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the preceding item after which the new item will be inserted."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the user message item that will be created. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        event_id: Optional[str] = None,
        previous_item_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.INPUT_AUDIO_BUFFER_COMMITTED  # type: ignore


class ServerEventInputAudioBufferSpeechStarted(ServerEvent, discriminator="input_audio_buffer.speech_started"):
    """Sent by the server when in ``server_vad`` mode to indicate that speech has been detected in the
    audio buffer. This can happen any time audio is added to the buffer (unless speech is already
    detected). The client may want to use this event to interrupt audio playback or provide visual
    feedback to the user. The client should expect to receive a
    ``input_audio_buffer.speech_stopped`` event when speech stops. The ``item_id`` property is the
    ID of the user message item that will be created when speech stops and will also be included in
    the ``input_audio_buffer.speech_stopped`` event (unless the client manually commits the audio
    buffer during VAD activation).

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``input_audio_buffer.speech_started``. Required.
     INPUT_AUDIO_BUFFER_SPEECH_STARTED.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_BUFFER_SPEECH_STARTED
    :ivar audio_start_ms: Milliseconds from the start of all audio written to the buffer during the
     session when speech was first detected. This will correspond to the beginning of audio sent to
     the model, and thus includes the ``prefix_padding_ms`` configured in the Session. Required.
    :vartype audio_start_ms: int
    :ivar item_id: The ID of the user message item that will be created when speech stops.
     Required.
    :vartype item_id: str
    """

    type: Literal[ServerEventType.INPUT_AUDIO_BUFFER_SPEECH_STARTED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``input_audio_buffer.speech_started``. Required.
     INPUT_AUDIO_BUFFER_SPEECH_STARTED."""
    audio_start_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Milliseconds from the start of all audio written to the buffer during the session when speech
     was first detected. This will correspond to the beginning of audio sent to the model, and thus
     includes the ``prefix_padding_ms`` configured in the Session. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the user message item that will be created when speech stops. Required."""

    @overload
    def __init__(
        self,
        *,
        audio_start_ms: int,
        item_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.INPUT_AUDIO_BUFFER_SPEECH_STARTED  # type: ignore


class ServerEventInputAudioBufferSpeechStopped(ServerEvent, discriminator="input_audio_buffer.speech_stopped"):
    """Returned in ``server_vad`` mode when the server detects the end of speech in the audio buffer.
    The server will also send an ``conversation.item.created`` event with the user message item
    that is created from the audio buffer.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``input_audio_buffer.speech_stopped``. Required.
     INPUT_AUDIO_BUFFER_SPEECH_STOPPED.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_BUFFER_SPEECH_STOPPED
    :ivar audio_end_ms: Milliseconds since the session started when speech stopped. This will
     correspond to the end of audio sent to the model, and thus includes the
     ``min_silence_duration_ms`` configured in the Session. Required.
    :vartype audio_end_ms: int
    :ivar item_id: The ID of the user message item that will be created. Required.
    :vartype item_id: str
    """

    type: Literal[ServerEventType.INPUT_AUDIO_BUFFER_SPEECH_STOPPED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``input_audio_buffer.speech_stopped``. Required.
     INPUT_AUDIO_BUFFER_SPEECH_STOPPED."""
    audio_end_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Milliseconds since the session started when speech stopped. This will correspond to the end of
     audio sent to the model, and thus includes the ``min_silence_duration_ms`` configured in the
     Session. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the user message item that will be created. Required."""

    @overload
    def __init__(
        self,
        *,
        audio_end_ms: int,
        item_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.INPUT_AUDIO_BUFFER_SPEECH_STOPPED  # type: ignore


class ServerEventMcpListToolsCompleted(ServerEvent, discriminator="mcp_list_tools.completed"):
    """MCP list tools completed message.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required. MCP_LIST_TOOLS_COMPLETED.
    :vartype type: str or ~azure.ai.voicelive.models.MCP_LIST_TOOLS_COMPLETED
    :ivar item_id: The item ID. Required.
    :vartype item_id: str
    """

    type: Literal[ServerEventType.MCP_LIST_TOOLS_COMPLETED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. MCP_LIST_TOOLS_COMPLETED."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The item ID. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.MCP_LIST_TOOLS_COMPLETED  # type: ignore


class ServerEventMcpListToolsFailed(ServerEvent, discriminator="mcp_list_tools.failed"):
    """MCP list tools failed message.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required. MCP_LIST_TOOLS_FAILED.
    :vartype type: str or ~azure.ai.voicelive.models.MCP_LIST_TOOLS_FAILED
    :ivar item_id: The item ID. Required.
    :vartype item_id: str
    """

    type: Literal[ServerEventType.MCP_LIST_TOOLS_FAILED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. MCP_LIST_TOOLS_FAILED."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The item ID. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.MCP_LIST_TOOLS_FAILED  # type: ignore


class ServerEventMcpListToolsInProgress(ServerEvent, discriminator="mcp_list_tools.in_progress"):
    """MCP list tools in progress message.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required. MCP_LIST_TOOLS_IN_PROGRESS.
    :vartype type: str or ~azure.ai.voicelive.models.MCP_LIST_TOOLS_IN_PROGRESS
    :ivar item_id: The item ID. Required.
    :vartype item_id: str
    """

    type: Literal[ServerEventType.MCP_LIST_TOOLS_IN_PROGRESS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. MCP_LIST_TOOLS_IN_PROGRESS."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The item ID. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.MCP_LIST_TOOLS_IN_PROGRESS  # type: ignore


class ServerEventResponseAnimationBlendshapeDelta(
    ServerEvent, discriminator="response.animation_blendshapes.delta"
):  # pylint: disable=name-too-long
    """Represents a delta update of blendshape animation frames for a specific output of a response.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required. RESPONSE_ANIMATION_BLENDSHAPES_DELTA.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_ANIMATION_BLENDSHAPES_DELTA
    :ivar response_id: Required.
    :vartype response_id: str
    :ivar item_id: Required.
    :vartype item_id: str
    :ivar output_index: Required.
    :vartype output_index: int
    :ivar content_index: Required.
    :vartype content_index: int
    :ivar frames: Required. Is either a [[float]] type or a str type.
    :vartype frames: list[list[float]] or str
    :ivar frame_index: Required.
    :vartype frame_index: int
    """

    type: Literal[ServerEventType.RESPONSE_ANIMATION_BLENDSHAPES_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. RESPONSE_ANIMATION_BLENDSHAPES_DELTA."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    frames: Union[list[list[float]], str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required. Is either a [[float]] type or a str type."""
    frame_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        frames: Union[list[list[float]], str],
        frame_index: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_ANIMATION_BLENDSHAPES_DELTA  # type: ignore


class ServerEventResponseAnimationBlendshapeDone(
    ServerEvent, discriminator="response.animation_blendshapes.done"
):  # pylint: disable=name-too-long
    """Indicates the completion of blendshape animation processing for a specific output of a
    response.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required. RESPONSE_ANIMATION_BLENDSHAPES_DONE.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_ANIMATION_BLENDSHAPES_DONE
    :ivar response_id: Required.
    :vartype response_id: str
    :ivar item_id: Required.
    :vartype item_id: str
    :ivar output_index: Required.
    :vartype output_index: int
    """

    type: Literal[ServerEventType.RESPONSE_ANIMATION_BLENDSHAPES_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. RESPONSE_ANIMATION_BLENDSHAPES_DONE."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_ANIMATION_BLENDSHAPES_DONE  # type: ignore


class ServerEventResponseAnimationVisemeDelta(ServerEvent, discriminator="response.animation_viseme.delta"):
    """Represents a viseme ID delta update for animation based on audio.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required. RESPONSE_ANIMATION_VISEME_DELTA.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_ANIMATION_VISEME_DELTA
    :ivar response_id: Required.
    :vartype response_id: str
    :ivar item_id: Required.
    :vartype item_id: str
    :ivar output_index: Required.
    :vartype output_index: int
    :ivar content_index: Required.
    :vartype content_index: int
    :ivar audio_offset_ms: Required.
    :vartype audio_offset_ms: int
    :ivar viseme_id: Required.
    :vartype viseme_id: int
    """

    type: Literal[ServerEventType.RESPONSE_ANIMATION_VISEME_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. RESPONSE_ANIMATION_VISEME_DELTA."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    audio_offset_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    viseme_id: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        audio_offset_ms: int,
        viseme_id: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_ANIMATION_VISEME_DELTA  # type: ignore


class ServerEventResponseAnimationVisemeDone(ServerEvent, discriminator="response.animation_viseme.done"):
    """Indicates completion of viseme animation delivery for a response.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required. RESPONSE_ANIMATION_VISEME_DONE.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_ANIMATION_VISEME_DONE
    :ivar response_id: Required.
    :vartype response_id: str
    :ivar item_id: Required.
    :vartype item_id: str
    :ivar output_index: Required.
    :vartype output_index: int
    :ivar content_index: Required.
    :vartype content_index: int
    """

    type: Literal[ServerEventType.RESPONSE_ANIMATION_VISEME_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. RESPONSE_ANIMATION_VISEME_DONE."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_ANIMATION_VISEME_DONE  # type: ignore


class ServerEventResponseAudioDelta(ServerEvent, discriminator="response.audio.delta"):
    """Returned when the model-generated audio is updated.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.audio.delta``. Required. RESPONSE_AUDIO_DELTA.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_AUDIO_DELTA
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    :ivar delta: Base64-encoded audio data delta. Required.
    :vartype delta: bytes
    """

    type: Literal[ServerEventType.RESPONSE_AUDIO_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.audio.delta``. Required. RESPONSE_AUDIO_DELTA."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""
    delta: bytes = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64")
    """Base64-encoded audio data delta. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        delta: bytes,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_AUDIO_DELTA  # type: ignore


class ServerEventResponseAudioDone(ServerEvent, discriminator="response.audio.done"):
    """Returned when the model-generated audio is done. Also emitted when a Response is interrupted,
    incomplete, or cancelled.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.audio.done``. Required. RESPONSE_AUDIO_DONE.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_AUDIO_DONE
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    """

    type: Literal[ServerEventType.RESPONSE_AUDIO_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.audio.done``. Required. RESPONSE_AUDIO_DONE."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_AUDIO_DONE  # type: ignore


class ServerEventResponseAudioTimestampDelta(ServerEvent, discriminator="response.audio_timestamp.delta"):
    """Represents a word-level audio timestamp delta for a response.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required. RESPONSE_AUDIO_TIMESTAMP_DELTA.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_AUDIO_TIMESTAMP_DELTA
    :ivar response_id: Required.
    :vartype response_id: str
    :ivar item_id: Required.
    :vartype item_id: str
    :ivar output_index: Required.
    :vartype output_index: int
    :ivar content_index: Required.
    :vartype content_index: int
    :ivar audio_offset_ms: Required.
    :vartype audio_offset_ms: int
    :ivar audio_duration_ms: Required.
    :vartype audio_duration_ms: int
    :ivar text: Required.
    :vartype text: str
    :ivar timestamp_type: Required. Default value is "word".
    :vartype timestamp_type: str
    """

    type: Literal[ServerEventType.RESPONSE_AUDIO_TIMESTAMP_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. RESPONSE_AUDIO_TIMESTAMP_DELTA."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    audio_offset_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    audio_duration_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    timestamp_type: Literal["word"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is \"word\"."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        audio_offset_ms: int,
        audio_duration_ms: int,
        text: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_AUDIO_TIMESTAMP_DELTA  # type: ignore
        self.timestamp_type: Literal["word"] = "word"


class ServerEventResponseAudioTimestampDone(ServerEvent, discriminator="response.audio_timestamp.done"):
    """Indicates completion of audio timestamp delivery for a response.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required. RESPONSE_AUDIO_TIMESTAMP_DONE.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_AUDIO_TIMESTAMP_DONE
    :ivar response_id: Required.
    :vartype response_id: str
    :ivar item_id: Required.
    :vartype item_id: str
    :ivar output_index: Required.
    :vartype output_index: int
    :ivar content_index: Required.
    :vartype content_index: int
    """

    type: Literal[ServerEventType.RESPONSE_AUDIO_TIMESTAMP_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. RESPONSE_AUDIO_TIMESTAMP_DONE."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_AUDIO_TIMESTAMP_DONE  # type: ignore


class ServerEventResponseAudioTranscriptDelta(ServerEvent, discriminator="response.audio_transcript.delta"):
    """Returned when the model-generated transcription of audio output is updated.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.audio_transcript.delta``. Required.
     RESPONSE_AUDIO_TRANSCRIPT_DELTA.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_AUDIO_TRANSCRIPT_DELTA
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    :ivar delta: The transcript delta. Required.
    :vartype delta: str
    """

    type: Literal[ServerEventType.RESPONSE_AUDIO_TRANSCRIPT_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.audio_transcript.delta``. Required.
     RESPONSE_AUDIO_TRANSCRIPT_DELTA."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""
    delta: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The transcript delta. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        delta: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_AUDIO_TRANSCRIPT_DELTA  # type: ignore


class ServerEventResponseAudioTranscriptDone(ServerEvent, discriminator="response.audio_transcript.done"):
    """Returned when the model-generated transcription of audio output is done streaming. Also emitted
    when a Response is interrupted, incomplete, or cancelled.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.audio_transcript.done``. Required.
     RESPONSE_AUDIO_TRANSCRIPT_DONE.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_AUDIO_TRANSCRIPT_DONE
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    :ivar transcript: The final transcript of the audio. Required.
    :vartype transcript: str
    """

    type: Literal[ServerEventType.RESPONSE_AUDIO_TRANSCRIPT_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.audio_transcript.done``. Required.
     RESPONSE_AUDIO_TRANSCRIPT_DONE."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""
    transcript: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The final transcript of the audio. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        transcript: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_AUDIO_TRANSCRIPT_DONE  # type: ignore


class ServerEventResponseContentPartAdded(ServerEvent, discriminator="response.content_part.added"):
    """Returned when a new content part is added to an assistant message item during response
    generation.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.content_part.added``. Required.
     RESPONSE_CONTENT_PART_ADDED.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_CONTENT_PART_ADDED
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item to which the content part was added. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    :ivar part: The content part that was added. Required.
    :vartype part: ~azure.ai.voicelive.models.ContentPart
    """

    type: Literal[ServerEventType.RESPONSE_CONTENT_PART_ADDED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.content_part.added``. Required. RESPONSE_CONTENT_PART_ADDED."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item to which the content part was added. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""
    part: "_models.ContentPart" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content part that was added. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        part: "_models.ContentPart",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_CONTENT_PART_ADDED  # type: ignore


class ServerEventResponseContentPartDone(ServerEvent, discriminator="response.content_part.done"):
    """Returned when a content part is done streaming in an assistant message item. Also emitted when
    a Response is interrupted, incomplete, or cancelled.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.content_part.done``. Required.
     RESPONSE_CONTENT_PART_DONE.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_CONTENT_PART_DONE
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    :ivar part: The content part that is done. Required.
    :vartype part: ~azure.ai.voicelive.models.ContentPart
    """

    type: Literal[ServerEventType.RESPONSE_CONTENT_PART_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.content_part.done``. Required. RESPONSE_CONTENT_PART_DONE."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""
    part: "_models.ContentPart" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content part that is done. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        part: "_models.ContentPart",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_CONTENT_PART_DONE  # type: ignore


class ServerEventResponseCreated(ServerEvent, discriminator="response.created"):
    """Returned when a new Response is created. The first event of response creation, where the
    response is in an initial state of ``in_progress``.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.created``. Required. RESPONSE_CREATED.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_CREATED
    :ivar response: Required.
    :vartype response: ~azure.ai.voicelive.models.Response
    """

    type: Literal[ServerEventType.RESPONSE_CREATED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.created``. Required. RESPONSE_CREATED."""
    response: "_models.Response" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        response: "_models.Response",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_CREATED  # type: ignore


class ServerEventResponseDone(ServerEvent, discriminator="response.done"):
    """Returned when a Response is done streaming. Always emitted, no matter the final state. The
    Response object included in the ``response.done`` event will include all output Items in the
    Response but will omit the raw audio data.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.done``. Required. RESPONSE_DONE.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_DONE
    :ivar response: Required.
    :vartype response: ~azure.ai.voicelive.models.Response
    """

    type: Literal[ServerEventType.RESPONSE_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.done``. Required. RESPONSE_DONE."""
    response: "_models.Response" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        response: "_models.Response",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_DONE  # type: ignore


class ServerEventResponseFunctionCallArgumentsDelta(
    ServerEvent, discriminator="response.function_call_arguments.delta"
):  # pylint: disable=name-too-long
    """Returned when the model-generated function call arguments are updated.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.function_call_arguments.delta``. Required.
     RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the function call item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar call_id: The ID of the function call. Required.
    :vartype call_id: str
    :ivar delta: The arguments delta as a JSON string. Required.
    :vartype delta: str
    """

    type: Literal[ServerEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.function_call_arguments.delta``. Required.
     RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the function call item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the function call. Required."""
    delta: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The arguments delta as a JSON string. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        call_id: str,
        delta: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA  # type: ignore


class ServerEventResponseFunctionCallArgumentsDone(
    ServerEvent, discriminator="response.function_call_arguments.done"
):  # pylint: disable=name-too-long
    """Returned when the model-generated function call arguments are done streaming. Also emitted when
    a Response is interrupted, incomplete, or cancelled.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.function_call_arguments.done``. Required.
     RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the function call item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar call_id: The ID of the function call. Required.
    :vartype call_id: str
    :ivar arguments: The final arguments as a JSON string. Required.
    :vartype arguments: str
    :ivar name: The name of the function call. Required.
    :vartype name: str
    """

    type: Literal[ServerEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.function_call_arguments.done``. Required.
     RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the function call item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the function call. Required."""
    arguments: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The final arguments as a JSON string. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the function call. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        call_id: str,
        arguments: str,
        name: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE  # type: ignore


class ServerEventResponseMcpCallArgumentsDelta(ServerEvent, discriminator="response.mcp_call_arguments.delta"):
    """Represents a delta update of the arguments for an MCP tool call.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required. RESPONSE_MCP_CALL_ARGUMENTS_DELTA.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_MCP_CALL_ARGUMENTS_DELTA
    :ivar delta: The delta of the arguments. Required.
    :vartype delta: str
    :ivar item_id: The ID of the item associated with the event. Required.
    :vartype item_id: str
    :ivar response_id: The ID of the response associated with the event. Required.
    :vartype response_id: str
    :ivar output_index: The index of the output associated with the event. Required.
    :vartype output_index: int
    :ivar obfuscation: The obfuscation of the arguments.
    :vartype obfuscation: str
    """

    type: Literal[ServerEventType.RESPONSE_MCP_CALL_ARGUMENTS_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. RESPONSE_MCP_CALL_ARGUMENTS_DELTA."""
    delta: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The delta of the arguments. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item associated with the event. Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response associated with the event. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output associated with the event. Required."""
    obfuscation: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The obfuscation of the arguments."""

    @overload
    def __init__(
        self,
        *,
        delta: str,
        item_id: str,
        response_id: str,
        output_index: int,
        event_id: Optional[str] = None,
        obfuscation: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_MCP_CALL_ARGUMENTS_DELTA  # type: ignore


class ServerEventResponseMcpCallArgumentsDone(ServerEvent, discriminator="response.mcp_call_arguments.done"):
    """Indicates the completion of the arguments for an MCP tool call.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required. RESPONSE_MCP_CALL_ARGUMENTS_DONE.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_MCP_CALL_ARGUMENTS_DONE
    :ivar item_id: The ID of the item associated with the event. Required.
    :vartype item_id: str
    :ivar response_id: The ID of the response associated with the event. Required.
    :vartype response_id: str
    :ivar output_index: The index of the output associated with the event. Required.
    :vartype output_index: int
    :ivar arguments: The full arguments for the tool call.
    :vartype arguments: str
    """

    type: Literal[ServerEventType.RESPONSE_MCP_CALL_ARGUMENTS_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. RESPONSE_MCP_CALL_ARGUMENTS_DONE."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item associated with the event. Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response associated with the event. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output associated with the event. Required."""
    arguments: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The full arguments for the tool call."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        response_id: str,
        output_index: int,
        event_id: Optional[str] = None,
        arguments: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_MCP_CALL_ARGUMENTS_DONE  # type: ignore


class ServerEventResponseMcpCallCompleted(ServerEvent, discriminator="response.mcp_call.completed"):
    """Indicates the MCP call has completed.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required. RESPONSE_MCP_CALL_COMPLETED.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_MCP_CALL_COMPLETED
    :ivar item_id: The ID of the item associated with the event. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output associated with the event. Required.
    :vartype output_index: int
    """

    type: Literal[ServerEventType.RESPONSE_MCP_CALL_COMPLETED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. RESPONSE_MCP_CALL_COMPLETED."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item associated with the event. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output associated with the event. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        output_index: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_MCP_CALL_COMPLETED  # type: ignore


class ServerEventResponseMcpCallFailed(ServerEvent, discriminator="response.mcp_call.failed"):
    """Indicates the MCP call has failed.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required. RESPONSE_MCP_CALL_FAILED.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_MCP_CALL_FAILED
    :ivar item_id: The ID of the item associated with the event. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output associated with the event. Required.
    :vartype output_index: int
    """

    type: Literal[ServerEventType.RESPONSE_MCP_CALL_FAILED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. RESPONSE_MCP_CALL_FAILED."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item associated with the event. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output associated with the event. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        output_index: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_MCP_CALL_FAILED  # type: ignore


class ServerEventResponseMcpCallInProgress(ServerEvent, discriminator="response.mcp_call.in_progress"):
    """Indicates the MCP call running.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required. RESPONSE_MCP_CALL_IN_PROGRESS.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_MCP_CALL_IN_PROGRESS
    :ivar item_id: The ID of the item associated with the event. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output associated with the event. Required.
    :vartype output_index: int
    """

    type: Literal[ServerEventType.RESPONSE_MCP_CALL_IN_PROGRESS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. RESPONSE_MCP_CALL_IN_PROGRESS."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item associated with the event. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output associated with the event. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        output_index: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_MCP_CALL_IN_PROGRESS  # type: ignore


class ServerEventResponseOutputItemAdded(ServerEvent, discriminator="response.output_item.added"):
    """Returned when a new Item is created during Response generation.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.output_item.added``. Required.
     RESPONSE_OUTPUT_ITEM_ADDED.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_OUTPUT_ITEM_ADDED
    :ivar response_id: The ID of the Response to which the item belongs. Required.
    :vartype response_id: str
    :ivar output_index: The index of the output item in the Response. Required.
    :vartype output_index: int
    :ivar item:
    :vartype item: ~azure.ai.voicelive.models.ResponseItem
    """

    type: Literal[ServerEventType.RESPONSE_OUTPUT_ITEM_ADDED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.output_item.added``. Required. RESPONSE_OUTPUT_ITEM_ADDED."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Response to which the item belongs. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the Response. Required."""
    item: Optional["_models.ResponseItem"] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        output_index: int,
        event_id: Optional[str] = None,
        item: Optional["_models.ResponseItem"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_OUTPUT_ITEM_ADDED  # type: ignore


class ServerEventResponseOutputItemDone(ServerEvent, discriminator="response.output_item.done"):
    """Returned when an Item is done streaming. Also emitted when a Response is interrupted,
    incomplete, or cancelled.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.output_item.done``. Required.
     RESPONSE_OUTPUT_ITEM_DONE.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_OUTPUT_ITEM_DONE
    :ivar response_id: The ID of the Response to which the item belongs. Required.
    :vartype response_id: str
    :ivar output_index: The index of the output item in the Response. Required.
    :vartype output_index: int
    :ivar item:
    :vartype item: ~azure.ai.voicelive.models.ResponseItem
    """

    type: Literal[ServerEventType.RESPONSE_OUTPUT_ITEM_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.output_item.done``. Required. RESPONSE_OUTPUT_ITEM_DONE."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Response to which the item belongs. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the Response. Required."""
    item: Optional["_models.ResponseItem"] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        output_index: int,
        event_id: Optional[str] = None,
        item: Optional["_models.ResponseItem"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_OUTPUT_ITEM_DONE  # type: ignore


class ServerEventResponseTextDelta(ServerEvent, discriminator="response.text.delta"):
    """Returned when the text value of a "text" content part is updated.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.text.delta``. Required. RESPONSE_TEXT_DELTA.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_TEXT_DELTA
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    :ivar delta: The text delta. Required.
    :vartype delta: str
    """

    type: Literal[ServerEventType.RESPONSE_TEXT_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.text.delta``. Required. RESPONSE_TEXT_DELTA."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""
    delta: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text delta. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        delta: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_TEXT_DELTA  # type: ignore


class ServerEventResponseTextDone(ServerEvent, discriminator="response.text.done"):
    """Returned when the text value of a "text" content part is done streaming. Also emitted when a
    Response is interrupted, incomplete, or cancelled.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.text.done``. Required. RESPONSE_TEXT_DONE.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_TEXT_DONE
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    :ivar text: The final text content. Required.
    :vartype text: str
    """

    type: Literal[ServerEventType.RESPONSE_TEXT_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.text.done``. Required. RESPONSE_TEXT_DONE."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The final text content. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        text: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.RESPONSE_TEXT_DONE  # type: ignore


class ServerEventSessionAvatarConnecting(ServerEvent, discriminator="session.avatar.connecting"):
    """Sent when the server is in the process of establishing an avatar media connection and provides
    its SDP answer.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be 'session.avatar.connecting'. Required.
     SESSION_AVATAR_CONNECTING.
    :vartype type: str or ~azure.ai.voicelive.models.SESSION_AVATAR_CONNECTING
    :ivar server_sdp: The server's SDP answer for the avatar connection. Required.
    :vartype server_sdp: str
    """

    type: Literal[ServerEventType.SESSION_AVATAR_CONNECTING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be 'session.avatar.connecting'. Required. SESSION_AVATAR_CONNECTING."""
    server_sdp: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The server's SDP answer for the avatar connection. Required."""

    @overload
    def __init__(
        self,
        *,
        server_sdp: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.SESSION_AVATAR_CONNECTING  # type: ignore


class ServerEventSessionCreated(ServerEvent, discriminator="session.created"):
    """Returned when a Session is created. Emitted automatically when a new connection is established
    as the first server event. This event will contain the default Session configuration.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``session.created``. Required. SESSION_CREATED.
    :vartype type: str or ~azure.ai.voicelive.models.SESSION_CREATED
    :ivar session: Required.
    :vartype session: ~azure.ai.voicelive.models.ResponseSession
    """

    type: Literal[ServerEventType.SESSION_CREATED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``session.created``. Required. SESSION_CREATED."""
    session: "_models.ResponseSession" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        session: "_models.ResponseSession",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.SESSION_CREATED  # type: ignore


class ServerEventSessionUpdated(ServerEvent, discriminator="session.updated"):
    """Returned when a session is updated with a ``session.update`` event, unless there is an error.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``session.updated``. Required. SESSION_UPDATED.
    :vartype type: str or ~azure.ai.voicelive.models.SESSION_UPDATED
    :ivar session: Required.
    :vartype session: ~azure.ai.voicelive.models.ResponseSession
    """

    type: Literal[ServerEventType.SESSION_UPDATED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``session.updated``. Required. SESSION_UPDATED."""
    session: "_models.ResponseSession" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        session: "_models.ResponseSession",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.SESSION_UPDATED  # type: ignore


class ServerEventWarning(ServerEvent, discriminator="warning"):
    """Returned when a warning occurs that does not interrupt the conversation flow. Warnings are
    informational and the session will continue normally.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``warning``. Required. WARNING.
    :vartype type: str or ~azure.ai.voicelive.models.WARNING
    :ivar warning: Details of the warning. Required.
    :vartype warning: ~azure.ai.voicelive.models.ServerEventWarningDetails
    """

    type: Literal[ServerEventType.WARNING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``warning``. Required. WARNING."""
    warning: "_models.ServerEventWarningDetails" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Details of the warning. Required."""

    @overload
    def __init__(
        self,
        *,
        warning: "_models.ServerEventWarningDetails",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServerEventType.WARNING  # type: ignore


class ServerEventWarningDetails(_Model):
    """Details of the warning.

    :ivar message: A human-readable warning message. Required.
    :vartype message: str
    :ivar code: Warning code, if any.
    :vartype code: str
    :ivar param: Parameter related to the warning, if any.
    :vartype param: str
    """

    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A human-readable warning message. Required."""
    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warning code, if any."""
    param: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Parameter related to the warning, if any."""

    @overload
    def __init__(
        self,
        *,
        message: str,
        code: Optional[str] = None,
        param: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServerVad(TurnDetection, discriminator="server_vad"):
    """Base model for VAD-based turn detection.

    :ivar type: Required. SERVER_VAD.
    :vartype type: str or ~azure.ai.voicelive.models.SERVER_VAD
    :ivar threshold:
    :vartype threshold: float
    :ivar prefix_padding_ms:
    :vartype prefix_padding_ms: int
    :ivar silence_duration_ms:
    :vartype silence_duration_ms: int
    :ivar end_of_utterance_detection:
    :vartype end_of_utterance_detection: ~azure.ai.voicelive.models.EouDetection
    :ivar auto_truncate:
    :vartype auto_truncate: bool
    :ivar create_response:
    :vartype create_response: bool
    :ivar interrupt_response:
    :vartype interrupt_response: bool
    """

    type: Literal[TurnDetectionType.SERVER_VAD] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. SERVER_VAD."""
    threshold: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    prefix_padding_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    silence_duration_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    end_of_utterance_detection: Optional["_models.EouDetection"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    auto_truncate: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    create_response: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    interrupt_response: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        threshold: Optional[float] = None,
        prefix_padding_ms: Optional[int] = None,
        silence_duration_ms: Optional[int] = None,
        end_of_utterance_detection: Optional["_models.EouDetection"] = None,
        auto_truncate: Optional[bool] = None,
        create_response: Optional[bool] = None,
        interrupt_response: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = TurnDetectionType.SERVER_VAD  # type: ignore


class SessionBase(_Model):
    """VoiceLive session object configuration."""


class StaticInterimResponseConfig(InterimResponseConfigBase, discriminator="static_interim_response"):
    """Configuration for static interim response generation. Randomly selects from configured texts
    when any trigger condition is met.

    :ivar triggers: List of triggers that can fire the interim response. Any trigger can activate
     it (OR logic). Supported: 'latency', 'tool'.
    :vartype triggers: list[str or ~azure.ai.voicelive.models.InterimResponseTrigger]
    :ivar latency_threshold_ms: Latency threshold in milliseconds before triggering interim
     response. Default is 2000ms.
    :vartype latency_threshold_ms: int
    :ivar type: Required. Static interim response configuration type.
    :vartype type: str or ~azure.ai.voicelive.models.STATIC_INTERIM_RESPONSE
    :ivar texts: List of interim response text options to randomly select from.
    :vartype texts: list[str]
    """

    type: Literal[InterimResponseConfigType.STATIC_INTERIM_RESPONSE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Static interim response configuration type."""
    texts: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of interim response text options to randomly select from."""

    @overload
    def __init__(
        self,
        *,
        triggers: Optional[list[Union[str, "_models.InterimResponseTrigger"]]] = None,
        latency_threshold_ms: Optional[int] = None,
        texts: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = InterimResponseConfigType.STATIC_INTERIM_RESPONSE  # type: ignore


class SystemMessageItem(MessageItem, discriminator="system"):
    """A system message item within a conversation.

    :ivar id:
    :vartype id: str
    :ivar type: The type of the item; must be 'message' for message items. Required. MESSAGE.
    :vartype type: str or ~azure.ai.voicelive.models.MESSAGE
    :ivar content: The content parts of the message. Required.
    :vartype content: list[~azure.ai.voicelive.models.MessageContentPart]
    :ivar status: Processing status of the message item. Known values are: "completed" and
     "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ItemParamStatus
    :ivar role: Required. SYSTEM.
    :vartype role: str or ~azure.ai.voicelive.models.SYSTEM
    """

    __mapping__: dict[str, _Model] = {}
    role: Literal[MessageRole.SYSTEM] = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. SYSTEM."""

    @overload
    def __init__(
        self,
        *,
        content: list["_models.MessageContentPart"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        status: Optional[Union[str, "_models.ItemParamStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.role = MessageRole.SYSTEM  # type: ignore


class TokenUsage(_Model):
    """Overall usage statistics for a response.

    :ivar total_tokens: Total number of tokens (input + output). Required.
    :vartype total_tokens: int
    :ivar input_tokens: Number of input tokens. Required.
    :vartype input_tokens: int
    :ivar output_tokens: Number of output tokens. Required.
    :vartype output_tokens: int
    :ivar input_token_details: Detailed breakdown of input tokens. Required.
    :vartype input_token_details: ~azure.ai.voicelive.models.InputTokenDetails
    :ivar output_token_details: Detailed breakdown of output tokens. Required.
    :vartype output_token_details: ~azure.ai.voicelive.models.OutputTokenDetails
    """

    total_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Total number of tokens (input + output). Required."""
    input_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of input tokens. Required."""
    output_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of output tokens. Required."""
    input_token_details: "_models.InputTokenDetails" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Detailed breakdown of input tokens. Required."""
    output_token_details: "_models.OutputTokenDetails" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Detailed breakdown of output tokens. Required."""

    @overload
    def __init__(
        self,
        *,
        total_tokens: int,
        input_tokens: int,
        output_tokens: int,
        input_token_details: "_models.InputTokenDetails",
        output_token_details: "_models.OutputTokenDetails",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ToolChoiceSelection(_Model):
    """A base representation for a voicelive tool_choice selecting a named tool.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ToolChoiceFunctionSelection

    :ivar type: Required. Known values are: "function" and "mcp".
    :vartype type: str or ~azure.ai.voicelive.models.ToolType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"function\" and \"mcp\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ToolChoiceFunctionSelection(ToolChoiceSelection, discriminator="function"):
    """The representation of a voicelive tool_choice selecting a named function tool.

    :ivar type: Required. FUNCTION.
    :vartype type: str or ~azure.ai.voicelive.models.FUNCTION
    :ivar name: Required.
    :vartype name: str
    """

    type: Literal[ToolType.FUNCTION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. FUNCTION."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.FUNCTION  # type: ignore


class UserMessageItem(MessageItem, discriminator="user"):
    """A user message item within a conversation.

    :ivar id:
    :vartype id: str
    :ivar type: The type of the item; must be 'message' for message items. Required. MESSAGE.
    :vartype type: str or ~azure.ai.voicelive.models.MESSAGE
    :ivar content: The content parts of the message. Required.
    :vartype content: list[~azure.ai.voicelive.models.MessageContentPart]
    :ivar status: Processing status of the message item. Known values are: "completed" and
     "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ItemParamStatus
    :ivar role: Required. USER.
    :vartype role: str or ~azure.ai.voicelive.models.USER
    """

    __mapping__: dict[str, _Model] = {}
    role: Literal[MessageRole.USER] = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. USER."""

    @overload
    def __init__(
        self,
        *,
        content: list["_models.MessageContentPart"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        status: Optional[Union[str, "_models.ItemParamStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.role = MessageRole.USER  # type: ignore


class VideoCrop(_Model):
    """Defines a video crop rectangle using top-left and bottom-right coordinates.

    :ivar top_left: Top-left corner of the crop region. Array of [x, y], must be non-negative
     integers. Required.
    :vartype top_left: list[int]
    :ivar bottom_right: Bottom-right corner of the crop region. Array of [x, y], must be
     non-negative integers. Required.
    :vartype bottom_right: list[int]
    """

    top_left: list[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Top-left corner of the crop region. Array of [x, y], must be non-negative integers. Required."""
    bottom_right: list[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Bottom-right corner of the crop region. Array of [x, y], must be non-negative integers.
     Required."""

    @overload
    def __init__(
        self,
        *,
        top_left: list[int],
        bottom_right: list[int],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VideoParams(_Model):
    """Video streaming parameters for avatar.

    :ivar bitrate: Bitrate in bits per second (e.g., 2000000 for 2 Mbps).
    :vartype bitrate: int
    :ivar codec: Codec to use for encoding. Currently only 'h264' is supported. Default value is
     "h264".
    :vartype codec: str
    :ivar crop: Optional cropping settings for the video stream.
    :vartype crop: ~azure.ai.voicelive.models.VideoCrop
    :ivar resolution: Optional resolution settings for the video stream.
    :vartype resolution: ~azure.ai.voicelive.models.VideoResolution
    :ivar background: Optional background settings for the video. Allows specifying either a solid
     color or an image URL.
    :vartype background: ~azure.ai.voicelive.models.Background
    :ivar gop_size: Group of Pictures (GOP) size for video encoding. Controls the interval between
     keyframes, affecting compression efficiency and seeking performance.
    :vartype gop_size: int
    """

    bitrate: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Bitrate in bits per second (e.g., 2000000 for 2 Mbps)."""
    codec: Optional[Literal["h264"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Codec to use for encoding. Currently only 'h264' is supported. Default value is \"h264\"."""
    crop: Optional["_models.VideoCrop"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional cropping settings for the video stream."""
    resolution: Optional["_models.VideoResolution"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional resolution settings for the video stream."""
    background: Optional["_models.Background"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional background settings for the video. Allows specifying either a solid color or an image
     URL."""
    gop_size: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Group of Pictures (GOP) size for video encoding. Controls the interval between keyframes,
     affecting compression efficiency and seeking performance."""

    @overload
    def __init__(
        self,
        *,
        bitrate: Optional[int] = None,
        codec: Optional[Literal["h264"]] = None,
        crop: Optional["_models.VideoCrop"] = None,
        resolution: Optional["_models.VideoResolution"] = None,
        background: Optional["_models.Background"] = None,
        gop_size: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VideoResolution(_Model):
    """Resolution of the video feed in pixels.

    :ivar width: Width of the video in pixels. Must be greater than 0. Required.
    :vartype width: int
    :ivar height: Height of the video in pixels. Must be greater than 0. Required.
    :vartype height: int
    """

    width: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Width of the video in pixels. Must be greater than 0. Required."""
    height: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Height of the video in pixels. Must be greater than 0. Required."""

    @overload
    def __init__(
        self,
        *,
        width: int,
        height: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VoiceLiveErrorDetails(_Model):
    """Error object returned in case of API failure.

    :ivar code: Error code, or null if unspecified.
    :vartype code: str
    :ivar message: Human-readable error message. Required.
    :vartype message: str
    :ivar param: Parameter name related to the error, if applicable.
    :vartype param: str
    :ivar type: Type or category of the error.
    :vartype type: str
    :ivar event_id: Event id of the error.
    :vartype event_id: str
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error code, or null if unspecified."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Human-readable error message. Required."""
    param: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Parameter name related to the error, if applicable."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Type or category of the error."""
    event_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Event id of the error."""

    @overload
    def __init__(
        self,
        *,
        message: str,
        code: Optional[str] = None,
        param: Optional[str] = None,
        type: Optional[str] = None,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
