# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource.deploymentstacks.aio import DeploymentStacksClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDeploymentStacksDeploymentStacksOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DeploymentStacksClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_get_at_resource_group(self, resource_group):
        response = await self.client.deployment_stacks.get_at_resource_group(
            resource_group_name=resource_group.name,
            deployment_stack_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_list_at_resource_group(self, resource_group):
        response = self.client.deployment_stacks.list_at_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_begin_validate_stack_at_resource_group(self, resource_group):
        response = await (
            await self.client.deployment_stacks.begin_validate_stack_at_resource_group(
                resource_group_name=resource_group.name,
                deployment_stack_name="str",
                deployment_stack={
                    "id": "str",
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "actionOnUnmanage": {
                            "resources": "str",
                            "managementGroups": "str",
                            "resourceGroups": "str",
                            "resourcesWithoutDeleteSupport": "str",
                        },
                        "denySettings": {
                            "mode": "str",
                            "applyToChildScopes": bool,
                            "excludedActions": ["str"],
                            "excludedPrincipals": ["str"],
                        },
                        "bypassStackOutOfSyncError": bool,
                        "correlationId": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "deletedResources": [
                            {
                                "apiVersion": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "deploymentExtensions": [{"name": "str", "version": "str", "config": {}, "configId": "str"}],
                        "deploymentId": "str",
                        "deploymentScope": "str",
                        "description": "str",
                        "detachedResources": [
                            {
                                "apiVersion": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "duration": "str",
                        "error": {
                            "additionalInfo": [{"info": {}, "type": "str"}],
                            "code": "str",
                            "details": [...],
                            "message": "str",
                            "target": "str",
                        },
                        "extensionConfigs": {"str": {}},
                        "externalInputDefinitions": {"str": {"kind": "str", "config": {}}},
                        "externalInputs": {"str": {"value": {}}},
                        "failedResources": [
                            {
                                "apiVersion": "str",
                                "error": {
                                    "additionalInfo": [{"info": {}, "type": "str"}],
                                    "code": "str",
                                    "details": [...],
                                    "message": "str",
                                    "target": "str",
                                },
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "outputs": {"str": {}},
                        "parameters": {
                            "str": {
                                "expression": "str",
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "type": "str",
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "provisioningState": "str",
                        "resources": [
                            {
                                "apiVersion": "str",
                                "denyStatus": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "status": "str",
                                "type": "str",
                            }
                        ],
                        "template": {"str": {}},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                        "validationLevel": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_begin_create_or_update_at_resource_group(self, resource_group):
        response = await (
            await self.client.deployment_stacks.begin_create_or_update_at_resource_group(
                resource_group_name=resource_group.name,
                deployment_stack_name="str",
                deployment_stack={
                    "id": "str",
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "actionOnUnmanage": {
                            "resources": "str",
                            "managementGroups": "str",
                            "resourceGroups": "str",
                            "resourcesWithoutDeleteSupport": "str",
                        },
                        "denySettings": {
                            "mode": "str",
                            "applyToChildScopes": bool,
                            "excludedActions": ["str"],
                            "excludedPrincipals": ["str"],
                        },
                        "bypassStackOutOfSyncError": bool,
                        "correlationId": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "deletedResources": [
                            {
                                "apiVersion": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "deploymentExtensions": [{"name": "str", "version": "str", "config": {}, "configId": "str"}],
                        "deploymentId": "str",
                        "deploymentScope": "str",
                        "description": "str",
                        "detachedResources": [
                            {
                                "apiVersion": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "duration": "str",
                        "error": {
                            "additionalInfo": [{"info": {}, "type": "str"}],
                            "code": "str",
                            "details": [...],
                            "message": "str",
                            "target": "str",
                        },
                        "extensionConfigs": {"str": {}},
                        "externalInputDefinitions": {"str": {"kind": "str", "config": {}}},
                        "externalInputs": {"str": {"value": {}}},
                        "failedResources": [
                            {
                                "apiVersion": "str",
                                "error": {
                                    "additionalInfo": [{"info": {}, "type": "str"}],
                                    "code": "str",
                                    "details": [...],
                                    "message": "str",
                                    "target": "str",
                                },
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "outputs": {"str": {}},
                        "parameters": {
                            "str": {
                                "expression": "str",
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "type": "str",
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "provisioningState": "str",
                        "resources": [
                            {
                                "apiVersion": "str",
                                "denyStatus": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "status": "str",
                                "type": "str",
                            }
                        ],
                        "template": {"str": {}},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                        "validationLevel": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_begin_delete_at_resource_group(self, resource_group):
        response = await (
            await self.client.deployment_stacks.begin_delete_at_resource_group(
                resource_group_name=resource_group.name,
                deployment_stack_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_export_template_at_resource_group(self, resource_group):
        response = await self.client.deployment_stacks.export_template_at_resource_group(
            resource_group_name=resource_group.name,
            deployment_stack_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_get_at_subscription(self, resource_group):
        response = await self.client.deployment_stacks.get_at_subscription(
            deployment_stack_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_list_at_subscription(self, resource_group):
        response = self.client.deployment_stacks.list_at_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_begin_validate_stack_at_subscription(self, resource_group):
        response = await (
            await self.client.deployment_stacks.begin_validate_stack_at_subscription(
                deployment_stack_name="str",
                deployment_stack={
                    "id": "str",
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "actionOnUnmanage": {
                            "resources": "str",
                            "managementGroups": "str",
                            "resourceGroups": "str",
                            "resourcesWithoutDeleteSupport": "str",
                        },
                        "denySettings": {
                            "mode": "str",
                            "applyToChildScopes": bool,
                            "excludedActions": ["str"],
                            "excludedPrincipals": ["str"],
                        },
                        "bypassStackOutOfSyncError": bool,
                        "correlationId": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "deletedResources": [
                            {
                                "apiVersion": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "deploymentExtensions": [{"name": "str", "version": "str", "config": {}, "configId": "str"}],
                        "deploymentId": "str",
                        "deploymentScope": "str",
                        "description": "str",
                        "detachedResources": [
                            {
                                "apiVersion": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "duration": "str",
                        "error": {
                            "additionalInfo": [{"info": {}, "type": "str"}],
                            "code": "str",
                            "details": [...],
                            "message": "str",
                            "target": "str",
                        },
                        "extensionConfigs": {"str": {}},
                        "externalInputDefinitions": {"str": {"kind": "str", "config": {}}},
                        "externalInputs": {"str": {"value": {}}},
                        "failedResources": [
                            {
                                "apiVersion": "str",
                                "error": {
                                    "additionalInfo": [{"info": {}, "type": "str"}],
                                    "code": "str",
                                    "details": [...],
                                    "message": "str",
                                    "target": "str",
                                },
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "outputs": {"str": {}},
                        "parameters": {
                            "str": {
                                "expression": "str",
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "type": "str",
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "provisioningState": "str",
                        "resources": [
                            {
                                "apiVersion": "str",
                                "denyStatus": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "status": "str",
                                "type": "str",
                            }
                        ],
                        "template": {"str": {}},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                        "validationLevel": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_begin_create_or_update_at_subscription(self, resource_group):
        response = await (
            await self.client.deployment_stacks.begin_create_or_update_at_subscription(
                deployment_stack_name="str",
                deployment_stack={
                    "id": "str",
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "actionOnUnmanage": {
                            "resources": "str",
                            "managementGroups": "str",
                            "resourceGroups": "str",
                            "resourcesWithoutDeleteSupport": "str",
                        },
                        "denySettings": {
                            "mode": "str",
                            "applyToChildScopes": bool,
                            "excludedActions": ["str"],
                            "excludedPrincipals": ["str"],
                        },
                        "bypassStackOutOfSyncError": bool,
                        "correlationId": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "deletedResources": [
                            {
                                "apiVersion": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "deploymentExtensions": [{"name": "str", "version": "str", "config": {}, "configId": "str"}],
                        "deploymentId": "str",
                        "deploymentScope": "str",
                        "description": "str",
                        "detachedResources": [
                            {
                                "apiVersion": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "duration": "str",
                        "error": {
                            "additionalInfo": [{"info": {}, "type": "str"}],
                            "code": "str",
                            "details": [...],
                            "message": "str",
                            "target": "str",
                        },
                        "extensionConfigs": {"str": {}},
                        "externalInputDefinitions": {"str": {"kind": "str", "config": {}}},
                        "externalInputs": {"str": {"value": {}}},
                        "failedResources": [
                            {
                                "apiVersion": "str",
                                "error": {
                                    "additionalInfo": [{"info": {}, "type": "str"}],
                                    "code": "str",
                                    "details": [...],
                                    "message": "str",
                                    "target": "str",
                                },
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "outputs": {"str": {}},
                        "parameters": {
                            "str": {
                                "expression": "str",
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "type": "str",
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "provisioningState": "str",
                        "resources": [
                            {
                                "apiVersion": "str",
                                "denyStatus": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "status": "str",
                                "type": "str",
                            }
                        ],
                        "template": {"str": {}},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                        "validationLevel": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_begin_delete_at_subscription(self, resource_group):
        response = await (
            await self.client.deployment_stacks.begin_delete_at_subscription(
                deployment_stack_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_export_template_at_subscription(self, resource_group):
        response = await self.client.deployment_stacks.export_template_at_subscription(
            deployment_stack_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_get_at_management_group(self, resource_group):
        response = await self.client.deployment_stacks.get_at_management_group(
            management_group_id="str",
            deployment_stack_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_list_at_management_group(self, resource_group):
        response = self.client.deployment_stacks.list_at_management_group(
            management_group_id="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_begin_validate_stack_at_management_group(self, resource_group):
        response = await (
            await self.client.deployment_stacks.begin_validate_stack_at_management_group(
                management_group_id="str",
                deployment_stack_name="str",
                deployment_stack={
                    "id": "str",
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "actionOnUnmanage": {
                            "resources": "str",
                            "managementGroups": "str",
                            "resourceGroups": "str",
                            "resourcesWithoutDeleteSupport": "str",
                        },
                        "denySettings": {
                            "mode": "str",
                            "applyToChildScopes": bool,
                            "excludedActions": ["str"],
                            "excludedPrincipals": ["str"],
                        },
                        "bypassStackOutOfSyncError": bool,
                        "correlationId": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "deletedResources": [
                            {
                                "apiVersion": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "deploymentExtensions": [{"name": "str", "version": "str", "config": {}, "configId": "str"}],
                        "deploymentId": "str",
                        "deploymentScope": "str",
                        "description": "str",
                        "detachedResources": [
                            {
                                "apiVersion": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "duration": "str",
                        "error": {
                            "additionalInfo": [{"info": {}, "type": "str"}],
                            "code": "str",
                            "details": [...],
                            "message": "str",
                            "target": "str",
                        },
                        "extensionConfigs": {"str": {}},
                        "externalInputDefinitions": {"str": {"kind": "str", "config": {}}},
                        "externalInputs": {"str": {"value": {}}},
                        "failedResources": [
                            {
                                "apiVersion": "str",
                                "error": {
                                    "additionalInfo": [{"info": {}, "type": "str"}],
                                    "code": "str",
                                    "details": [...],
                                    "message": "str",
                                    "target": "str",
                                },
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "outputs": {"str": {}},
                        "parameters": {
                            "str": {
                                "expression": "str",
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "type": "str",
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "provisioningState": "str",
                        "resources": [
                            {
                                "apiVersion": "str",
                                "denyStatus": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "status": "str",
                                "type": "str",
                            }
                        ],
                        "template": {"str": {}},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                        "validationLevel": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_begin_create_or_update_at_management_group(self, resource_group):
        response = await (
            await self.client.deployment_stacks.begin_create_or_update_at_management_group(
                management_group_id="str",
                deployment_stack_name="str",
                deployment_stack={
                    "id": "str",
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "actionOnUnmanage": {
                            "resources": "str",
                            "managementGroups": "str",
                            "resourceGroups": "str",
                            "resourcesWithoutDeleteSupport": "str",
                        },
                        "denySettings": {
                            "mode": "str",
                            "applyToChildScopes": bool,
                            "excludedActions": ["str"],
                            "excludedPrincipals": ["str"],
                        },
                        "bypassStackOutOfSyncError": bool,
                        "correlationId": "str",
                        "debugSetting": {"detailLevel": "str"},
                        "deletedResources": [
                            {
                                "apiVersion": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "deploymentExtensions": [{"name": "str", "version": "str", "config": {}, "configId": "str"}],
                        "deploymentId": "str",
                        "deploymentScope": "str",
                        "description": "str",
                        "detachedResources": [
                            {
                                "apiVersion": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "duration": "str",
                        "error": {
                            "additionalInfo": [{"info": {}, "type": "str"}],
                            "code": "str",
                            "details": [...],
                            "message": "str",
                            "target": "str",
                        },
                        "extensionConfigs": {"str": {}},
                        "externalInputDefinitions": {"str": {"kind": "str", "config": {}}},
                        "externalInputs": {"str": {"value": {}}},
                        "failedResources": [
                            {
                                "apiVersion": "str",
                                "error": {
                                    "additionalInfo": [{"info": {}, "type": "str"}],
                                    "code": "str",
                                    "details": [...],
                                    "message": "str",
                                    "target": "str",
                                },
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "type": "str",
                            }
                        ],
                        "outputs": {"str": {}},
                        "parameters": {
                            "str": {
                                "expression": "str",
                                "reference": {"keyVault": {"id": "str"}, "secretName": "str", "secretVersion": "str"},
                                "type": "str",
                                "value": {},
                            }
                        },
                        "parametersLink": {"uri": "str", "contentVersion": "str"},
                        "provisioningState": "str",
                        "resources": [
                            {
                                "apiVersion": "str",
                                "denyStatus": "str",
                                "extension": {"name": "str", "version": "str", "config": {}, "configId": "str"},
                                "id": "str",
                                "identifiers": {"str": {}},
                                "status": "str",
                                "type": "str",
                            }
                        ],
                        "template": {"str": {}},
                        "templateLink": {
                            "contentVersion": "str",
                            "id": "str",
                            "queryString": "str",
                            "relativePath": "str",
                            "uri": "str",
                        },
                        "validationLevel": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_begin_delete_at_management_group(self, resource_group):
        response = await (
            await self.client.deployment_stacks.begin_delete_at_management_group(
                management_group_id="str",
                deployment_stack_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_deployment_stacks_export_template_at_management_group(self, resource_group):
        response = await self.client.deployment_stacks.export_template_at_management_group(
            management_group_id="str",
            deployment_stack_name="str",
        )

        # please add some check logic here by yourself
        # ...
