# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class AnalysisCreate(_serialization.Model):
    """The request body for creating an analysis for an NGINX configuration.

    :ivar root_file: The root file of the NGINX config file(s). It must match one of the files'
     filepath.
    :vartype root_file: str
    :ivar files:
    :vartype files: list[~azure.mgmt.nginx.models.NginxConfigurationFile]
    :ivar protected_files:
    :vartype protected_files: list[~azure.mgmt.nginx.models.NginxConfigurationProtectedFileRequest]
    :ivar package: Nginx Configuration Package.
    :vartype package: ~azure.mgmt.nginx.models.NginxConfigurationPackage
    """

    _attribute_map = {
        "root_file": {"key": "config.rootFile", "type": "str"},
        "files": {"key": "config.files", "type": "[NginxConfigurationFile]"},
        "protected_files": {"key": "config.protectedFiles", "type": "[NginxConfigurationProtectedFileRequest]"},
        "package": {"key": "config.package", "type": "NginxConfigurationPackage"},
    }

    def __init__(
        self,
        *,
        root_file: Optional[str] = None,
        files: Optional[list["_models.NginxConfigurationFile"]] = None,
        protected_files: Optional[list["_models.NginxConfigurationProtectedFileRequest"]] = None,
        package: Optional["_models.NginxConfigurationPackage"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword root_file: The root file of the NGINX config file(s). It must match one of the files'
         filepath.
        :paramtype root_file: str
        :keyword files:
        :paramtype files: list[~azure.mgmt.nginx.models.NginxConfigurationFile]
        :keyword protected_files:
        :paramtype protected_files:
         list[~azure.mgmt.nginx.models.NginxConfigurationProtectedFileRequest]
        :keyword package: Nginx Configuration Package.
        :paramtype package: ~azure.mgmt.nginx.models.NginxConfigurationPackage
        """
        super().__init__(**kwargs)
        self.root_file = root_file
        self.files = files
        self.protected_files = protected_files
        self.package = package


class AnalysisDiagnostic(_serialization.Model):
    """An error object found during the analysis of an NGINX configuration.

    All required parameters must be populated in order to send to server.

    :ivar id: Unique identifier for the error.
    :vartype id: str
    :ivar directive: Required.
    :vartype directive: str
    :ivar description: Required.
    :vartype description: str
    :ivar file: the filepath of the most relevant config file. Required.
    :vartype file: str
    :ivar line: Required.
    :vartype line: float
    :ivar message: Required.
    :vartype message: str
    :ivar rule: Required.
    :vartype rule: str
    """

    _validation = {
        "directive": {"required": True},
        "description": {"required": True},
        "file": {"required": True},
        "line": {"required": True},
        "message": {"required": True},
        "rule": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "directive": {"key": "directive", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "file": {"key": "file", "type": "str"},
        "line": {"key": "line", "type": "float"},
        "message": {"key": "message", "type": "str"},
        "rule": {"key": "rule", "type": "str"},
    }

    def __init__(
        self,
        *,
        directive: str,
        description: str,
        file: str,
        line: float,
        message: str,
        rule: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Unique identifier for the error.
        :paramtype id: str
        :keyword directive: Required.
        :paramtype directive: str
        :keyword description: Required.
        :paramtype description: str
        :keyword file: the filepath of the most relevant config file. Required.
        :paramtype file: str
        :keyword line: Required.
        :paramtype line: float
        :keyword message: Required.
        :paramtype message: str
        :keyword rule: Required.
        :paramtype rule: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.directive = directive
        self.description = description
        self.file = file
        self.line = line
        self.message = message
        self.rule = rule


class AnalysisResult(_serialization.Model):
    """The response body for an analysis request. Contains the status of the analysis and any errors.

    All required parameters must be populated in order to send to server.

    :ivar status: The status of the analysis. Required.
    :vartype status: str
    :ivar errors:
    :vartype errors: list[~azure.mgmt.nginx.models.AnalysisDiagnostic]
    :ivar diagnostics:
    :vartype diagnostics: list[~azure.mgmt.nginx.models.DiagnosticItem]
    """

    _validation = {
        "status": {"required": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "errors": {"key": "data.errors", "type": "[AnalysisDiagnostic]"},
        "diagnostics": {"key": "data.diagnostics", "type": "[DiagnosticItem]"},
    }

    def __init__(
        self,
        *,
        status: str,
        errors: Optional[list["_models.AnalysisDiagnostic"]] = None,
        diagnostics: Optional[list["_models.DiagnosticItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The status of the analysis. Required.
        :paramtype status: str
        :keyword errors:
        :paramtype errors: list[~azure.mgmt.nginx.models.AnalysisDiagnostic]
        :keyword diagnostics:
        :paramtype diagnostics: list[~azure.mgmt.nginx.models.DiagnosticItem]
        """
        super().__init__(**kwargs)
        self.status = status
        self.errors = errors
        self.diagnostics = diagnostics


class AutoUpgradeProfile(_serialization.Model):
    """Autoupgrade settings of a deployment.

    All required parameters must be populated in order to send to server.

    :ivar upgrade_channel: Channel used for autoupgrade. Required.
    :vartype upgrade_channel: str
    """

    _validation = {
        "upgrade_channel": {"required": True},
    }

    _attribute_map = {
        "upgrade_channel": {"key": "upgradeChannel", "type": "str"},
    }

    def __init__(self, *, upgrade_channel: str, **kwargs: Any) -> None:
        """
        :keyword upgrade_channel: Channel used for autoupgrade. Required.
        :paramtype upgrade_channel: str
        """
        super().__init__(**kwargs)
        self.upgrade_channel = upgrade_channel


class DiagnosticItem(_serialization.Model):
    """A diagnostic is a message associated with an NGINX config. The Analyzer returns diagnostics
    with a level indicating the importance of the diagnostic with optional category.

    All required parameters must be populated in order to send to server.

    :ivar id: Unique identifier for the diagnostic.
    :vartype id: str
    :ivar directive: Required.
    :vartype directive: str
    :ivar description: Required.
    :vartype description: str
    :ivar file: The filepath of the most relevant config file. Required.
    :vartype file: str
    :ivar line: Required.
    :vartype line: float
    :ivar message: Required.
    :vartype message: str
    :ivar rule: Required.
    :vartype rule: str
    :ivar level: Warning or Info. Required. Known values are: "Info" and "Warning".
    :vartype level: str or ~azure.mgmt.nginx.models.Level
    :ivar category: Category of warning like Best-practices, Recommendation, Security etc.
    :vartype category: str
    """

    _validation = {
        "directive": {"required": True},
        "description": {"required": True},
        "file": {"required": True},
        "line": {"required": True},
        "message": {"required": True},
        "rule": {"required": True},
        "level": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "directive": {"key": "directive", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "file": {"key": "file", "type": "str"},
        "line": {"key": "line", "type": "float"},
        "message": {"key": "message", "type": "str"},
        "rule": {"key": "rule", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "category": {"key": "category", "type": "str"},
    }

    def __init__(
        self,
        *,
        directive: str,
        description: str,
        file: str,
        line: float,
        message: str,
        rule: str,
        level: Union[str, "_models.Level"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        category: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Unique identifier for the diagnostic.
        :paramtype id: str
        :keyword directive: Required.
        :paramtype directive: str
        :keyword description: Required.
        :paramtype description: str
        :keyword file: The filepath of the most relevant config file. Required.
        :paramtype file: str
        :keyword line: Required.
        :paramtype line: float
        :keyword message: Required.
        :paramtype message: str
        :keyword rule: Required.
        :paramtype rule: str
        :keyword level: Warning or Info. Required. Known values are: "Info" and "Warning".
        :paramtype level: str or ~azure.mgmt.nginx.models.Level
        :keyword category: Category of warning like Best-practices, Recommendation, Security etc.
        :paramtype category: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.directive = directive
        self.description = description
        self.file = file
        self.line = line
        self.message = message
        self.rule = rule
        self.level = level
        self.category = category


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.nginx.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.nginx.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[list["_models.ErrorDetail"]] = None
        self.additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.nginx.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.nginx.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class IdentityProperties(_serialization.Model):
    """Identity Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id:
    :vartype principal_id: str
    :ivar tenant_id:
    :vartype tenant_id: str
    :ivar type: Identity Type. Known values are: "SystemAssigned", "UserAssigned", "SystemAssigned,
     UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.nginx.models.IdentityType
    :ivar user_assigned_identities: Dictionary of :code:`<UserIdentityProperties>`.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.nginx.models.UserIdentityProperties]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserIdentityProperties}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.IdentityType"]] = None,
        user_assigned_identities: Optional[dict[str, "_models.UserIdentityProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Identity Type. Known values are: "SystemAssigned", "UserAssigned",
         "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.nginx.models.IdentityType
        :keyword user_assigned_identities: Dictionary of :code:`<UserIdentityProperties>`.
        :paramtype user_assigned_identities: dict[str, ~azure.mgmt.nginx.models.UserIdentityProperties]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    """


class NginxCertificate(ProxyResource):
    """Nginx Certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    :ivar properties: Nginx Certificate Properties.
    :vartype properties: ~azure.mgmt.nginx.models.NginxCertificateProperties
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "NginxCertificateProperties"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.NginxCertificateProperties"] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Nginx Certificate Properties.
        :paramtype properties: ~azure.mgmt.nginx.models.NginxCertificateProperties
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.location = location


class NginxCertificateErrorResponseBody(_serialization.Model):
    """Nginx Certificate Error Response Body.

    :ivar code:
    :vartype code: str
    :ivar message:
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code:
        :paramtype code: str
        :keyword message:
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class NginxCertificateListResponse(_serialization.Model):
    """Nginx Certificate List Response.

    All required parameters must be populated in order to send to server.

    :ivar value: The NginxCertificate items on this page. Required.
    :vartype value: list[~azure.mgmt.nginx.models.NginxCertificate]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NginxCertificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.NginxCertificate"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The NginxCertificate items on this page. Required.
        :paramtype value: list[~azure.mgmt.nginx.models.NginxCertificate]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NginxCertificateProperties(_serialization.Model):
    """Nginx Certificate Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning State. Known values are: "Accepted", "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.nginx.models.ProvisioningState
    :ivar key_virtual_path:
    :vartype key_virtual_path: str
    :ivar certificate_virtual_path:
    :vartype certificate_virtual_path: str
    :ivar key_vault_secret_id:
    :vartype key_vault_secret_id: str
    :ivar sha1_thumbprint:
    :vartype sha1_thumbprint: str
    :ivar key_vault_secret_version:
    :vartype key_vault_secret_version: str
    :ivar key_vault_secret_created:
    :vartype key_vault_secret_created: ~datetime.datetime
    :ivar certificate_error: Nginx Certificate Error Response Body.
    :vartype certificate_error: ~azure.mgmt.nginx.models.NginxCertificateErrorResponseBody
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "sha1_thumbprint": {"readonly": True},
        "key_vault_secret_version": {"readonly": True},
        "key_vault_secret_created": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "key_virtual_path": {"key": "keyVirtualPath", "type": "str"},
        "certificate_virtual_path": {"key": "certificateVirtualPath", "type": "str"},
        "key_vault_secret_id": {"key": "keyVaultSecretId", "type": "str"},
        "sha1_thumbprint": {"key": "sha1Thumbprint", "type": "str"},
        "key_vault_secret_version": {"key": "keyVaultSecretVersion", "type": "str"},
        "key_vault_secret_created": {"key": "keyVaultSecretCreated", "type": "iso-8601"},
        "certificate_error": {"key": "certificateError", "type": "NginxCertificateErrorResponseBody"},
    }

    def __init__(
        self,
        *,
        key_virtual_path: Optional[str] = None,
        certificate_virtual_path: Optional[str] = None,
        key_vault_secret_id: Optional[str] = None,
        certificate_error: Optional["_models.NginxCertificateErrorResponseBody"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_virtual_path:
        :paramtype key_virtual_path: str
        :keyword certificate_virtual_path:
        :paramtype certificate_virtual_path: str
        :keyword key_vault_secret_id:
        :paramtype key_vault_secret_id: str
        :keyword certificate_error: Nginx Certificate Error Response Body.
        :paramtype certificate_error: ~azure.mgmt.nginx.models.NginxCertificateErrorResponseBody
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.key_virtual_path = key_virtual_path
        self.certificate_virtual_path = certificate_virtual_path
        self.key_vault_secret_id = key_vault_secret_id
        self.sha1_thumbprint: Optional[str] = None
        self.key_vault_secret_version: Optional[str] = None
        self.key_vault_secret_created: Optional[datetime.datetime] = None
        self.certificate_error = certificate_error


class NginxConfigurationFile(_serialization.Model):
    """Nginx Configuration File.

    :ivar content:
    :vartype content: str
    :ivar virtual_path:
    :vartype virtual_path: str
    """

    _attribute_map = {
        "content": {"key": "content", "type": "str"},
        "virtual_path": {"key": "virtualPath", "type": "str"},
    }

    def __init__(self, *, content: Optional[str] = None, virtual_path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword content:
        :paramtype content: str
        :keyword virtual_path:
        :paramtype virtual_path: str
        """
        super().__init__(**kwargs)
        self.content = content
        self.virtual_path = virtual_path


class NginxConfigurationListResponse(_serialization.Model):
    """Response of a list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The NginxConfigurationResponse items on this page. Required.
    :vartype value: list[~azure.mgmt.nginx.models.NginxConfigurationResponse]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NginxConfigurationResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.NginxConfigurationResponse"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The NginxConfigurationResponse items on this page. Required.
        :paramtype value: list[~azure.mgmt.nginx.models.NginxConfigurationResponse]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NginxConfigurationPackage(_serialization.Model):
    """Nginx Configuration Package.

    :ivar data:
    :vartype data: str
    :ivar protected_files:
    :vartype protected_files: list[str]
    """

    _attribute_map = {
        "data": {"key": "data", "type": "str"},
        "protected_files": {"key": "protectedFiles", "type": "[str]"},
    }

    def __init__(
        self, *, data: Optional[str] = None, protected_files: Optional[list[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword data:
        :paramtype data: str
        :keyword protected_files:
        :paramtype protected_files: list[str]
        """
        super().__init__(**kwargs)
        self.data = data
        self.protected_files = protected_files


class NginxConfigurationProtectedFileRequest(_serialization.Model):
    """Nginx Configuration Protected File Request.

    :ivar content: The content of the protected file. This value is a PUT only value. If you
     perform a GET request on this value, it will be empty because it is a protected file.
    :vartype content: str
    :ivar virtual_path: The virtual path of the protected file.
    :vartype virtual_path: str
    :ivar content_hash: The hash of the content of the file. This value is used to determine if the
     file has changed.
    :vartype content_hash: str
    """

    _attribute_map = {
        "content": {"key": "content", "type": "str"},
        "virtual_path": {"key": "virtualPath", "type": "str"},
        "content_hash": {"key": "contentHash", "type": "str"},
    }

    def __init__(
        self,
        *,
        content: Optional[str] = None,
        virtual_path: Optional[str] = None,
        content_hash: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword content: The content of the protected file. This value is a PUT only value. If you
         perform a GET request on this value, it will be empty because it is a protected file.
        :paramtype content: str
        :keyword virtual_path: The virtual path of the protected file.
        :paramtype virtual_path: str
        :keyword content_hash: The hash of the content of the file. This value is used to determine if
         the file has changed.
        :paramtype content_hash: str
        """
        super().__init__(**kwargs)
        self.content = content
        self.virtual_path = virtual_path
        self.content_hash = content_hash


class NginxConfigurationProtectedFileResponse(_serialization.Model):
    """Nginx Configuration Protected File Response.

    :ivar virtual_path: The virtual path of the protected file.
    :vartype virtual_path: str
    :ivar content_hash: The hash of the content of the file. This value is used to determine if the
     file has changed.
    :vartype content_hash: str
    """

    _attribute_map = {
        "virtual_path": {"key": "virtualPath", "type": "str"},
        "content_hash": {"key": "contentHash", "type": "str"},
    }

    def __init__(
        self, *, virtual_path: Optional[str] = None, content_hash: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword virtual_path: The virtual path of the protected file.
        :paramtype virtual_path: str
        :keyword content_hash: The hash of the content of the file. This value is used to determine if
         the file has changed.
        :paramtype content_hash: str
        """
        super().__init__(**kwargs)
        self.virtual_path = virtual_path
        self.content_hash = content_hash


class NginxConfigurationRequest(_serialization.Model):
    """Nginx Configuration Request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar properties: Nginx Configuration Request Properties.
    :vartype properties: ~azure.mgmt.nginx.models.NginxConfigurationRequestProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "NginxConfigurationRequestProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self, *, properties: Optional["_models.NginxConfigurationRequestProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Nginx Configuration Request Properties.
        :paramtype properties: ~azure.mgmt.nginx.models.NginxConfigurationRequestProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.properties = properties
        self.system_data: Optional["_models.SystemData"] = None


class NginxConfigurationRequestProperties(_serialization.Model):
    """Nginx Configuration Request Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning State. Known values are: "Accepted", "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.nginx.models.ProvisioningState
    :ivar files:
    :vartype files: list[~azure.mgmt.nginx.models.NginxConfigurationFile]
    :ivar protected_files:
    :vartype protected_files: list[~azure.mgmt.nginx.models.NginxConfigurationProtectedFileRequest]
    :ivar package: Nginx Configuration Package.
    :vartype package: ~azure.mgmt.nginx.models.NginxConfigurationPackage
    :ivar root_file:
    :vartype root_file: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "files": {"key": "files", "type": "[NginxConfigurationFile]"},
        "protected_files": {"key": "protectedFiles", "type": "[NginxConfigurationProtectedFileRequest]"},
        "package": {"key": "package", "type": "NginxConfigurationPackage"},
        "root_file": {"key": "rootFile", "type": "str"},
    }

    def __init__(
        self,
        *,
        files: Optional[list["_models.NginxConfigurationFile"]] = None,
        protected_files: Optional[list["_models.NginxConfigurationProtectedFileRequest"]] = None,
        package: Optional["_models.NginxConfigurationPackage"] = None,
        root_file: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword files:
        :paramtype files: list[~azure.mgmt.nginx.models.NginxConfigurationFile]
        :keyword protected_files:
        :paramtype protected_files:
         list[~azure.mgmt.nginx.models.NginxConfigurationProtectedFileRequest]
        :keyword package: Nginx Configuration Package.
        :paramtype package: ~azure.mgmt.nginx.models.NginxConfigurationPackage
        :keyword root_file:
        :paramtype root_file: str
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.files = files
        self.protected_files = protected_files
        self.package = package
        self.root_file = root_file


class NginxConfigurationResponse(ProxyResource):
    """Nginx Configuration Response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    :ivar properties: Nginx Configuration Response Properties.
    :vartype properties: ~azure.mgmt.nginx.models.NginxConfigurationResponseProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "NginxConfigurationResponseProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.NginxConfigurationResponseProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Nginx Configuration Response Properties.
        :paramtype properties: ~azure.mgmt.nginx.models.NginxConfigurationResponseProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class NginxConfigurationResponseProperties(_serialization.Model):
    """Nginx Configuration Response Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning State. Known values are: "Accepted", "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.nginx.models.ProvisioningState
    :ivar files:
    :vartype files: list[~azure.mgmt.nginx.models.NginxConfigurationFile]
    :ivar protected_files:
    :vartype protected_files:
     list[~azure.mgmt.nginx.models.NginxConfigurationProtectedFileResponse]
    :ivar package: Nginx Configuration Package.
    :vartype package: ~azure.mgmt.nginx.models.NginxConfigurationPackage
    :ivar root_file:
    :vartype root_file: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "files": {"key": "files", "type": "[NginxConfigurationFile]"},
        "protected_files": {"key": "protectedFiles", "type": "[NginxConfigurationProtectedFileResponse]"},
        "package": {"key": "package", "type": "NginxConfigurationPackage"},
        "root_file": {"key": "rootFile", "type": "str"},
    }

    def __init__(
        self,
        *,
        files: Optional[list["_models.NginxConfigurationFile"]] = None,
        protected_files: Optional[list["_models.NginxConfigurationProtectedFileResponse"]] = None,
        package: Optional["_models.NginxConfigurationPackage"] = None,
        root_file: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword files:
        :paramtype files: list[~azure.mgmt.nginx.models.NginxConfigurationFile]
        :keyword protected_files:
        :paramtype protected_files:
         list[~azure.mgmt.nginx.models.NginxConfigurationProtectedFileResponse]
        :keyword package: Nginx Configuration Package.
        :paramtype package: ~azure.mgmt.nginx.models.NginxConfigurationPackage
        :keyword root_file:
        :paramtype root_file: str
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.files = files
        self.protected_files = protected_files
        self.package = package
        self.root_file = root_file


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class NginxDeployment(TrackedResource):
    """Nginx Deployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Nginx Deployment Properties.
    :vartype properties: ~azure.mgmt.nginx.models.NginxDeploymentProperties
    :ivar identity: Identity Properties.
    :vartype identity: ~azure.mgmt.nginx.models.IdentityProperties
    :ivar sku: Resource Sku.
    :vartype sku: ~azure.mgmt.nginx.models.ResourceSku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "NginxDeploymentProperties"},
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "sku": {"key": "sku", "type": "ResourceSku"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.NginxDeploymentProperties"] = None,
        identity: Optional["_models.IdentityProperties"] = None,
        sku: Optional["_models.ResourceSku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Nginx Deployment Properties.
        :paramtype properties: ~azure.mgmt.nginx.models.NginxDeploymentProperties
        :keyword identity: Identity Properties.
        :paramtype identity: ~azure.mgmt.nginx.models.IdentityProperties
        :keyword sku: Resource Sku.
        :paramtype sku: ~azure.mgmt.nginx.models.ResourceSku
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.identity = identity
        self.sku = sku


class NginxDeploymentApiKeyListResponse(_serialization.Model):
    """Nginx Deployment Api Key List Response.

    All required parameters must be populated in order to send to server.

    :ivar value: The NginxDeploymentApiKeyResponse items on this page. Required.
    :vartype value: list[~azure.mgmt.nginx.models.NginxDeploymentApiKeyResponse]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NginxDeploymentApiKeyResponse]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.NginxDeploymentApiKeyResponse"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The NginxDeploymentApiKeyResponse items on this page. Required.
        :paramtype value: list[~azure.mgmt.nginx.models.NginxDeploymentApiKeyResponse]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NginxDeploymentApiKeyRequest(_serialization.Model):
    """Nginx Deployment Api Key Request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar properties: Nginx Deployment Api Key Request Properties.
    :vartype properties: ~azure.mgmt.nginx.models.NginxDeploymentApiKeyRequestProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "NginxDeploymentApiKeyRequestProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self, *, properties: Optional["_models.NginxDeploymentApiKeyRequestProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Nginx Deployment Api Key Request Properties.
        :paramtype properties: ~azure.mgmt.nginx.models.NginxDeploymentApiKeyRequestProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.properties = properties
        self.system_data: Optional["_models.SystemData"] = None


class NginxDeploymentApiKeyRequestProperties(_serialization.Model):
    """Nginx Deployment Api Key Request Properties.

    :ivar secret_text: Secret text to be used as a Dataplane API Key. This is a write only property
     that can never be read back, but the first three characters will be returned in the 'hint'
     property.
    :vartype secret_text: str
    :ivar end_date_time: The time after which this Dataplane API Key is no longer valid.
    :vartype end_date_time: ~datetime.datetime
    """

    _attribute_map = {
        "secret_text": {"key": "secretText", "type": "str"},
        "end_date_time": {"key": "endDateTime", "type": "iso-8601"},
    }

    def __init__(
        self, *, secret_text: Optional[str] = None, end_date_time: Optional[datetime.datetime] = None, **kwargs: Any
    ) -> None:
        """
        :keyword secret_text: Secret text to be used as a Dataplane API Key. This is a write only
         property that can never be read back, but the first three characters will be returned in the
         'hint' property.
        :paramtype secret_text: str
        :keyword end_date_time: The time after which this Dataplane API Key is no longer valid.
        :paramtype end_date_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.secret_text = secret_text
        self.end_date_time = end_date_time


class NginxDeploymentApiKeyResponse(ProxyResource):
    """Nginx Deployment Api Key Response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    :ivar properties: Nginx Deployment Api Key Response Properties.
    :vartype properties: ~azure.mgmt.nginx.models.NginxDeploymentApiKeyResponseProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "NginxDeploymentApiKeyResponseProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.NginxDeploymentApiKeyResponseProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Nginx Deployment Api Key Response Properties.
        :paramtype properties: ~azure.mgmt.nginx.models.NginxDeploymentApiKeyResponseProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class NginxDeploymentApiKeyResponseProperties(_serialization.Model):
    """Nginx Deployment Api Key Response Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hint: The first three characters of the secret text to help identify it in use. This
     property is read-only.
    :vartype hint: str
    :ivar end_date_time: The time after which this Dataplane API Key is no longer valid.
    :vartype end_date_time: ~datetime.datetime
    """

    _validation = {
        "hint": {"readonly": True},
    }

    _attribute_map = {
        "hint": {"key": "hint", "type": "str"},
        "end_date_time": {"key": "endDateTime", "type": "iso-8601"},
    }

    def __init__(self, *, end_date_time: Optional[datetime.datetime] = None, **kwargs: Any) -> None:
        """
        :keyword end_date_time: The time after which this Dataplane API Key is no longer valid.
        :paramtype end_date_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.hint: Optional[str] = None
        self.end_date_time = end_date_time


class NginxDeploymentDefaultWafPolicyListResponse(_serialization.Model):  # pylint: disable=name-too-long
    """Nginx Deployment Default Waf Policy List Response.

    :ivar value:
    :vartype value: list[~azure.mgmt.nginx.models.NginxDeploymentDefaultWafPolicyProperties]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NginxDeploymentDefaultWafPolicyProperties]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[list["_models.NginxDeploymentDefaultWafPolicyProperties"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.nginx.models.NginxDeploymentDefaultWafPolicyProperties]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NginxDeploymentDefaultWafPolicyProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Nginx Deployment Default Waf Policy Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar content:
    :vartype content: bytes
    :ivar filepath:
    :vartype filepath: str
    """

    _validation = {
        "content": {"readonly": True},
        "filepath": {"readonly": True},
    }

    _attribute_map = {
        "content": {"key": "content", "type": "bytearray"},
        "filepath": {"key": "filepath", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.content: Optional[bytes] = None
        self.filepath: Optional[str] = None


class NginxDeploymentListResponse(_serialization.Model):
    """Nginx Deployment List Response.

    All required parameters must be populated in order to send to server.

    :ivar value: The NginxDeployment items on this page. Required.
    :vartype value: list[~azure.mgmt.nginx.models.NginxDeployment]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NginxDeployment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.NginxDeployment"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The NginxDeployment items on this page. Required.
        :paramtype value: list[~azure.mgmt.nginx.models.NginxDeployment]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NginxDeploymentProperties(_serialization.Model):
    """Nginx Deployment Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning State. Known values are: "Accepted", "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.nginx.models.ProvisioningState
    :ivar nginx_version:
    :vartype nginx_version: str
    :ivar network_profile: Nginx Network Profile.
    :vartype network_profile: ~azure.mgmt.nginx.models.NginxNetworkProfile
    :ivar ip_address: The IP address of the deployment.
    :vartype ip_address: str
    :ivar enable_diagnostics_support:
    :vartype enable_diagnostics_support: bool
    :ivar logging: Nginx Logging.
    :vartype logging: ~azure.mgmt.nginx.models.NginxLogging
    :ivar scaling_properties: Information on how the deployment will be scaled.
    :vartype scaling_properties: ~azure.mgmt.nginx.models.NginxDeploymentScalingProperties
    :ivar auto_upgrade_profile: Autoupgrade settings of a deployment.
    :vartype auto_upgrade_profile: ~azure.mgmt.nginx.models.AutoUpgradeProfile
    :ivar user_profile: Nginx Deployment User Profile.
    :vartype user_profile: ~azure.mgmt.nginx.models.NginxDeploymentUserProfile
    :ivar dataplane_api_endpoint: Dataplane API endpoint for the caller to update the NGINX state
     of the deployment.
    :vartype dataplane_api_endpoint: str
    :ivar web_application_firewall_settings: Settings for the NGINX App Protect Web Application
     Firewall (WAF).
    :vartype web_application_firewall_settings:
     ~azure.mgmt.nginx.models.WebApplicationFirewallSettings
    :ivar web_application_firewall_status: The status of the NGINX App Protect Web Application
     Firewall.
    :vartype web_application_firewall_status: ~azure.mgmt.nginx.models.WebApplicationFirewallStatus
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "nginx_version": {"readonly": True},
        "ip_address": {"readonly": True},
        "dataplane_api_endpoint": {"readonly": True},
        "web_application_firewall_status": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "nginx_version": {"key": "nginxVersion", "type": "str"},
        "network_profile": {"key": "networkProfile", "type": "NginxNetworkProfile"},
        "ip_address": {"key": "ipAddress", "type": "str"},
        "enable_diagnostics_support": {"key": "enableDiagnosticsSupport", "type": "bool"},
        "logging": {"key": "logging", "type": "NginxLogging"},
        "scaling_properties": {"key": "scalingProperties", "type": "NginxDeploymentScalingProperties"},
        "auto_upgrade_profile": {"key": "autoUpgradeProfile", "type": "AutoUpgradeProfile"},
        "user_profile": {"key": "userProfile", "type": "NginxDeploymentUserProfile"},
        "dataplane_api_endpoint": {"key": "dataplaneApiEndpoint", "type": "str"},
        "web_application_firewall_settings": {
            "key": "nginxAppProtect.webApplicationFirewallSettings",
            "type": "WebApplicationFirewallSettings",
        },
        "web_application_firewall_status": {
            "key": "nginxAppProtect.webApplicationFirewallStatus",
            "type": "WebApplicationFirewallStatus",
        },
    }

    def __init__(
        self,
        *,
        network_profile: Optional["_models.NginxNetworkProfile"] = None,
        enable_diagnostics_support: Optional[bool] = None,
        logging: Optional["_models.NginxLogging"] = None,
        scaling_properties: Optional["_models.NginxDeploymentScalingProperties"] = None,
        auto_upgrade_profile: Optional["_models.AutoUpgradeProfile"] = None,
        user_profile: Optional["_models.NginxDeploymentUserProfile"] = None,
        web_application_firewall_settings: Optional["_models.WebApplicationFirewallSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_profile: Nginx Network Profile.
        :paramtype network_profile: ~azure.mgmt.nginx.models.NginxNetworkProfile
        :keyword enable_diagnostics_support:
        :paramtype enable_diagnostics_support: bool
        :keyword logging: Nginx Logging.
        :paramtype logging: ~azure.mgmt.nginx.models.NginxLogging
        :keyword scaling_properties: Information on how the deployment will be scaled.
        :paramtype scaling_properties: ~azure.mgmt.nginx.models.NginxDeploymentScalingProperties
        :keyword auto_upgrade_profile: Autoupgrade settings of a deployment.
        :paramtype auto_upgrade_profile: ~azure.mgmt.nginx.models.AutoUpgradeProfile
        :keyword user_profile: Nginx Deployment User Profile.
        :paramtype user_profile: ~azure.mgmt.nginx.models.NginxDeploymentUserProfile
        :keyword web_application_firewall_settings: Settings for the NGINX App Protect Web Application
         Firewall (WAF).
        :paramtype web_application_firewall_settings:
         ~azure.mgmt.nginx.models.WebApplicationFirewallSettings
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.nginx_version: Optional[str] = None
        self.network_profile = network_profile
        self.ip_address: Optional[str] = None
        self.enable_diagnostics_support = enable_diagnostics_support
        self.logging = logging
        self.scaling_properties = scaling_properties
        self.auto_upgrade_profile = auto_upgrade_profile
        self.user_profile = user_profile
        self.dataplane_api_endpoint: Optional[str] = None
        self.web_application_firewall_settings = web_application_firewall_settings
        self.web_application_firewall_status: Optional["_models.WebApplicationFirewallStatus"] = None


class NginxDeploymentScalingProperties(_serialization.Model):
    """Information on how the deployment will be scaled.

    :ivar capacity:
    :vartype capacity: int
    :ivar profiles:
    :vartype profiles: list[~azure.mgmt.nginx.models.ScaleProfile]
    """

    _attribute_map = {
        "capacity": {"key": "capacity", "type": "int"},
        "profiles": {"key": "autoScaleSettings.profiles", "type": "[ScaleProfile]"},
    }

    def __init__(
        self, *, capacity: Optional[int] = None, profiles: Optional[list["_models.ScaleProfile"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword capacity:
        :paramtype capacity: int
        :keyword profiles:
        :paramtype profiles: list[~azure.mgmt.nginx.models.ScaleProfile]
        """
        super().__init__(**kwargs)
        self.capacity = capacity
        self.profiles = profiles


class NginxDeploymentUpdateParameters(_serialization.Model):
    """Nginx Deployment Update Parameters.

    :ivar identity: Identity Properties.
    :vartype identity: ~azure.mgmt.nginx.models.IdentityProperties
    :ivar tags: Dictionary of :code:`<string>`.
    :vartype tags: dict[str, str]
    :ivar sku: Resource Sku.
    :vartype sku: ~azure.mgmt.nginx.models.ResourceSku
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    :ivar properties: Nginx Deployment Update Properties.
    :vartype properties: ~azure.mgmt.nginx.models.NginxDeploymentUpdateProperties
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "IdentityProperties"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "ResourceSku"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "NginxDeploymentUpdateProperties"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.IdentityProperties"] = None,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.ResourceSku"] = None,
        location: Optional[str] = None,
        properties: Optional["_models.NginxDeploymentUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Identity Properties.
        :paramtype identity: ~azure.mgmt.nginx.models.IdentityProperties
        :keyword tags: Dictionary of :code:`<string>`.
        :paramtype tags: dict[str, str]
        :keyword sku: Resource Sku.
        :paramtype sku: ~azure.mgmt.nginx.models.ResourceSku
        :keyword location: The geo-location where the resource lives.
        :paramtype location: str
        :keyword properties: Nginx Deployment Update Properties.
        :paramtype properties: ~azure.mgmt.nginx.models.NginxDeploymentUpdateProperties
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.sku = sku
        self.location = location
        self.properties = properties


class NginxDeploymentUpdateProperties(_serialization.Model):
    """Nginx Deployment Update Properties.

    :ivar enable_diagnostics_support:
    :vartype enable_diagnostics_support: bool
    :ivar logging: Nginx Logging.
    :vartype logging: ~azure.mgmt.nginx.models.NginxLogging
    :ivar scaling_properties: Information on how the deployment will be scaled.
    :vartype scaling_properties: ~azure.mgmt.nginx.models.NginxDeploymentScalingProperties
    :ivar user_profile: Nginx Deployment User Profile.
    :vartype user_profile: ~azure.mgmt.nginx.models.NginxDeploymentUserProfile
    :ivar network_profile: Nginx Network Profile.
    :vartype network_profile: ~azure.mgmt.nginx.models.NginxNetworkProfile
    :ivar auto_upgrade_profile: Autoupgrade settings of a deployment.
    :vartype auto_upgrade_profile: ~azure.mgmt.nginx.models.AutoUpgradeProfile
    :ivar web_application_firewall_settings: Settings for the NGINX App Protect Web Application
     Firewall (WAF).
    :vartype web_application_firewall_settings:
     ~azure.mgmt.nginx.models.WebApplicationFirewallSettings
    """

    _attribute_map = {
        "enable_diagnostics_support": {"key": "enableDiagnosticsSupport", "type": "bool"},
        "logging": {"key": "logging", "type": "NginxLogging"},
        "scaling_properties": {"key": "scalingProperties", "type": "NginxDeploymentScalingProperties"},
        "user_profile": {"key": "userProfile", "type": "NginxDeploymentUserProfile"},
        "network_profile": {"key": "networkProfile", "type": "NginxNetworkProfile"},
        "auto_upgrade_profile": {"key": "autoUpgradeProfile", "type": "AutoUpgradeProfile"},
        "web_application_firewall_settings": {
            "key": "nginxAppProtect.webApplicationFirewallSettings",
            "type": "WebApplicationFirewallSettings",
        },
    }

    def __init__(
        self,
        *,
        enable_diagnostics_support: Optional[bool] = None,
        logging: Optional["_models.NginxLogging"] = None,
        scaling_properties: Optional["_models.NginxDeploymentScalingProperties"] = None,
        user_profile: Optional["_models.NginxDeploymentUserProfile"] = None,
        network_profile: Optional["_models.NginxNetworkProfile"] = None,
        auto_upgrade_profile: Optional["_models.AutoUpgradeProfile"] = None,
        web_application_firewall_settings: Optional["_models.WebApplicationFirewallSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_diagnostics_support:
        :paramtype enable_diagnostics_support: bool
        :keyword logging: Nginx Logging.
        :paramtype logging: ~azure.mgmt.nginx.models.NginxLogging
        :keyword scaling_properties: Information on how the deployment will be scaled.
        :paramtype scaling_properties: ~azure.mgmt.nginx.models.NginxDeploymentScalingProperties
        :keyword user_profile: Nginx Deployment User Profile.
        :paramtype user_profile: ~azure.mgmt.nginx.models.NginxDeploymentUserProfile
        :keyword network_profile: Nginx Network Profile.
        :paramtype network_profile: ~azure.mgmt.nginx.models.NginxNetworkProfile
        :keyword auto_upgrade_profile: Autoupgrade settings of a deployment.
        :paramtype auto_upgrade_profile: ~azure.mgmt.nginx.models.AutoUpgradeProfile
        :keyword web_application_firewall_settings: Settings for the NGINX App Protect Web Application
         Firewall (WAF).
        :paramtype web_application_firewall_settings:
         ~azure.mgmt.nginx.models.WebApplicationFirewallSettings
        """
        super().__init__(**kwargs)
        self.enable_diagnostics_support = enable_diagnostics_support
        self.logging = logging
        self.scaling_properties = scaling_properties
        self.user_profile = user_profile
        self.network_profile = network_profile
        self.auto_upgrade_profile = auto_upgrade_profile
        self.web_application_firewall_settings = web_application_firewall_settings


class NginxDeploymentUserProfile(_serialization.Model):
    """Nginx Deployment User Profile.

    :ivar preferred_email: The preferred support contact email address of the user used for sending
     alerts and notification. Can be an empty string or a valid email address.
    :vartype preferred_email: str
    """

    _validation = {
        "preferred_email": {"pattern": r"^$|^[A-Za-z0-9._%+-]+@(?:[A-Za-z0-9-]+\.)+[A-Za-z]{2,}$"},
    }

    _attribute_map = {
        "preferred_email": {"key": "preferredEmail", "type": "str"},
    }

    def __init__(self, *, preferred_email: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword preferred_email: The preferred support contact email address of the user used for
         sending alerts and notification. Can be an empty string or a valid email address.
        :paramtype preferred_email: str
        """
        super().__init__(**kwargs)
        self.preferred_email = preferred_email


class NginxDeploymentWafPolicy(ProxyResource):
    """Nginx Deployment Waf Policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    :ivar properties: Nginx Deployment Waf Policy Properties.
    :vartype properties: ~azure.mgmt.nginx.models.NginxDeploymentWafPolicyProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "NginxDeploymentWafPolicyProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.NginxDeploymentWafPolicyProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Nginx Deployment Waf Policy Properties.
        :paramtype properties: ~azure.mgmt.nginx.models.NginxDeploymentWafPolicyProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class NginxDeploymentWafPolicyApplyingStatus(_serialization.Model):
    """Nginx Deployment Waf Policy Applying Status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Machine readable code indicating the applying status code of a WAF Policy. Known
     values are: "NotApplied", "Applying", "Succeeded", "Failed", and "Removing".
    :vartype code: str or ~azure.mgmt.nginx.models.NginxDeploymentWafPolicyApplyingStatusCode
    :ivar display_status: A readable string of the current status, and sometimes have the reason
     for the current state.
    :vartype display_status: str
    :ivar time: The date and time in UTC the current applying status was set.
    :vartype time: str
    """

    _validation = {
        "code": {"readonly": True},
        "display_status": {"readonly": True},
        "time": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "time": {"key": "time", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[Union[str, "_models.NginxDeploymentWafPolicyApplyingStatusCode"]] = None
        self.display_status: Optional[str] = None
        self.time: Optional[str] = None


class NginxDeploymentWafPolicyCompilingStatus(_serialization.Model):
    """Nginx Deployment Waf Policy Compiling Status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Machine readable code indicating the compilation status of a WAF Policy. Known
     values are: "NotStarted", "InProgress", "Succeeded", and "Failed".
    :vartype code: str or ~azure.mgmt.nginx.models.NginxDeploymentWafPolicyCompilingStatusCode
    :ivar display_status: A readable string of the current status, and sometimes have the reason
     for the current state. If the CompilingStatus is Failed the Display Status will be The waf
     Policy failed to compile.
    :vartype display_status: str
    :ivar time: The date and time the policy was compiled in UTC.
    :vartype time: str
    """

    _validation = {
        "code": {"readonly": True},
        "display_status": {"readonly": True},
        "time": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "time": {"key": "time", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[Union[str, "_models.NginxDeploymentWafPolicyCompilingStatusCode"]] = None
        self.display_status: Optional[str] = None
        self.time: Optional[str] = None


class NginxDeploymentWafPolicyListResponse(_serialization.Model):
    """Nginx Deployment Waf Policy List Response.

    All required parameters must be populated in order to send to server.

    :ivar value: The NginxDeploymentWafPolicyMetadata items on this page. Required.
    :vartype value: list[~azure.mgmt.nginx.models.NginxDeploymentWafPolicyMetadata]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NginxDeploymentWafPolicyMetadata]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: list["_models.NginxDeploymentWafPolicyMetadata"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The NginxDeploymentWafPolicyMetadata items on this page. Required.
        :paramtype value: list[~azure.mgmt.nginx.models.NginxDeploymentWafPolicyMetadata]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NginxDeploymentWafPolicyMetadata(_serialization.Model):
    """Nginx Deployment Waf Policy Metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id:
    :vartype id: str
    :ivar name:
    :vartype name: str
    :ivar type:
    :vartype type: str
    :ivar properties: Nginx Deployment Waf Policy Metadata Properties.
    :vartype properties: ~azure.mgmt.nginx.models.NginxDeploymentWafPolicyMetadataProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.nginx.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "NginxDeploymentWafPolicyMetadataProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self, *, properties: Optional["_models.NginxDeploymentWafPolicyMetadataProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Nginx Deployment Waf Policy Metadata Properties.
        :paramtype properties: ~azure.mgmt.nginx.models.NginxDeploymentWafPolicyMetadataProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.properties = properties
        self.system_data: Optional["_models.SystemData"] = None


class NginxDeploymentWafPolicyMetadataProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Nginx Deployment Waf Policy Metadata Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar filepath:
    :vartype filepath: str
    :ivar provisioning_state: Provisioning State. Known values are: "Accepted", "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.nginx.models.ProvisioningState
    :ivar compiling_state: Nginx Deployment Waf Policy Compiling Status.
    :vartype compiling_state: ~azure.mgmt.nginx.models.NginxDeploymentWafPolicyCompilingStatus
    :ivar applying_state: Nginx Deployment Waf Policy Applying Status.
    :vartype applying_state: ~azure.mgmt.nginx.models.NginxDeploymentWafPolicyApplyingStatus
    """

    _validation = {
        "filepath": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "compiling_state": {"readonly": True},
        "applying_state": {"readonly": True},
    }

    _attribute_map = {
        "filepath": {"key": "filepath", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "compiling_state": {"key": "compilingState", "type": "NginxDeploymentWafPolicyCompilingStatus"},
        "applying_state": {"key": "applyingState", "type": "NginxDeploymentWafPolicyApplyingStatus"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.filepath: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.compiling_state: Optional["_models.NginxDeploymentWafPolicyCompilingStatus"] = None
        self.applying_state: Optional["_models.NginxDeploymentWafPolicyApplyingStatus"] = None


class NginxDeploymentWafPolicyProperties(_serialization.Model):
    """Nginx Deployment Waf Policy Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning State. Known values are: "Accepted", "Creating",
     "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.nginx.models.ProvisioningState
    :ivar content: The byte content of the Policy.
    :vartype content: bytes
    :ivar filepath: The file path where the Policy is to be saved.
    :vartype filepath: str
    :ivar compiling_state: Nginx Deployment Waf Policy Compiling Status.
    :vartype compiling_state: ~azure.mgmt.nginx.models.NginxDeploymentWafPolicyCompilingStatus
    :ivar applying_state: Nginx Deployment Waf Policy Applying Status.
    :vartype applying_state: ~azure.mgmt.nginx.models.NginxDeploymentWafPolicyApplyingStatus
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "compiling_state": {"readonly": True},
        "applying_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "content": {"key": "content", "type": "bytearray"},
        "filepath": {"key": "filepath", "type": "str"},
        "compiling_state": {"key": "compilingState", "type": "NginxDeploymentWafPolicyCompilingStatus"},
        "applying_state": {"key": "applyingState", "type": "NginxDeploymentWafPolicyApplyingStatus"},
    }

    def __init__(self, *, content: Optional[bytes] = None, filepath: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword content: The byte content of the Policy.
        :paramtype content: bytes
        :keyword filepath: The file path where the Policy is to be saved.
        :paramtype filepath: str
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.content = content
        self.filepath = filepath
        self.compiling_state: Optional["_models.NginxDeploymentWafPolicyCompilingStatus"] = None
        self.applying_state: Optional["_models.NginxDeploymentWafPolicyApplyingStatus"] = None


class NginxFrontendIPConfiguration(_serialization.Model):
    """Nginx Frontend IP Configuration.

    :ivar public_ip_addresses:
    :vartype public_ip_addresses: list[~azure.mgmt.nginx.models.NginxPublicIPAddress]
    :ivar private_ip_addresses:
    :vartype private_ip_addresses: list[~azure.mgmt.nginx.models.NginxPrivateIPAddress]
    """

    _attribute_map = {
        "public_ip_addresses": {"key": "publicIPAddresses", "type": "[NginxPublicIPAddress]"},
        "private_ip_addresses": {"key": "privateIPAddresses", "type": "[NginxPrivateIPAddress]"},
    }

    def __init__(
        self,
        *,
        public_ip_addresses: Optional[list["_models.NginxPublicIPAddress"]] = None,
        private_ip_addresses: Optional[list["_models.NginxPrivateIPAddress"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword public_ip_addresses:
        :paramtype public_ip_addresses: list[~azure.mgmt.nginx.models.NginxPublicIPAddress]
        :keyword private_ip_addresses:
        :paramtype private_ip_addresses: list[~azure.mgmt.nginx.models.NginxPrivateIPAddress]
        """
        super().__init__(**kwargs)
        self.public_ip_addresses = public_ip_addresses
        self.private_ip_addresses = private_ip_addresses


class NginxLogging(_serialization.Model):
    """Nginx Logging.

    :ivar storage_account: Nginx Storage Account.
    :vartype storage_account: ~azure.mgmt.nginx.models.NginxStorageAccount
    """

    _attribute_map = {
        "storage_account": {"key": "storageAccount", "type": "NginxStorageAccount"},
    }

    def __init__(self, *, storage_account: Optional["_models.NginxStorageAccount"] = None, **kwargs: Any) -> None:
        """
        :keyword storage_account: Nginx Storage Account.
        :paramtype storage_account: ~azure.mgmt.nginx.models.NginxStorageAccount
        """
        super().__init__(**kwargs)
        self.storage_account = storage_account


class NginxNetworkInterfaceConfiguration(_serialization.Model):
    """Nginx Network Interface Configuration.

    :ivar subnet_id:
    :vartype subnet_id: str
    """

    _attribute_map = {
        "subnet_id": {"key": "subnetId", "type": "str"},
    }

    def __init__(self, *, subnet_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword subnet_id:
        :paramtype subnet_id: str
        """
        super().__init__(**kwargs)
        self.subnet_id = subnet_id


class NginxNetworkProfile(_serialization.Model):
    """Nginx Network Profile.

    :ivar front_end_ip_configuration: Nginx Frontend IP Configuration.
    :vartype front_end_ip_configuration: ~azure.mgmt.nginx.models.NginxFrontendIPConfiguration
    :ivar network_interface_configuration: Nginx Network Interface Configuration.
    :vartype network_interface_configuration:
     ~azure.mgmt.nginx.models.NginxNetworkInterfaceConfiguration
    """

    _attribute_map = {
        "front_end_ip_configuration": {"key": "frontEndIPConfiguration", "type": "NginxFrontendIPConfiguration"},
        "network_interface_configuration": {
            "key": "networkInterfaceConfiguration",
            "type": "NginxNetworkInterfaceConfiguration",
        },
    }

    def __init__(
        self,
        *,
        front_end_ip_configuration: Optional["_models.NginxFrontendIPConfiguration"] = None,
        network_interface_configuration: Optional["_models.NginxNetworkInterfaceConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword front_end_ip_configuration: Nginx Frontend IP Configuration.
        :paramtype front_end_ip_configuration: ~azure.mgmt.nginx.models.NginxFrontendIPConfiguration
        :keyword network_interface_configuration: Nginx Network Interface Configuration.
        :paramtype network_interface_configuration:
         ~azure.mgmt.nginx.models.NginxNetworkInterfaceConfiguration
        """
        super().__init__(**kwargs)
        self.front_end_ip_configuration = front_end_ip_configuration
        self.network_interface_configuration = network_interface_configuration


class NginxPrivateIPAddress(_serialization.Model):
    """Nginx Private IP Address.

    :ivar private_ip_address:
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: Nginx Private IP Allocation Method. Known values are:
     "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.nginx.models.NginxPrivateIPAllocationMethod
    :ivar subnet_id:
    :vartype subnet_id: str
    """

    _attribute_map = {
        "private_ip_address": {"key": "privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "privateIPAllocationMethod", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.NginxPrivateIPAllocationMethod"]] = None,
        subnet_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_ip_address:
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: Nginx Private IP Allocation Method. Known values are:
         "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.nginx.models.NginxPrivateIPAllocationMethod
        :keyword subnet_id:
        :paramtype subnet_id: str
        """
        super().__init__(**kwargs)
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet_id = subnet_id


class NginxPublicIPAddress(_serialization.Model):
    """Nginx Public IP Address.

    :ivar id:
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id:
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class NginxStorageAccount(_serialization.Model):
    """Nginx Storage Account.

    :ivar account_name:
    :vartype account_name: str
    :ivar container_name:
    :vartype container_name: str
    """

    _attribute_map = {
        "account_name": {"key": "accountName", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
    }

    def __init__(
        self, *, account_name: Optional[str] = None, container_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword account_name:
        :paramtype account_name: str
        :keyword container_name:
        :paramtype container_name: str
        """
        super().__init__(**kwargs)
        self.account_name = account_name
        self.container_name = container_name


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.nginx.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.nginx.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.nginx.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.nginx.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.is_data_action: Optional[bool] = None
        self.display = display
        self.origin: Optional[Union[str, "_models.Origin"]] = None
        self.action_type: Optional[Union[str, "_models.ActionType"]] = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider: Optional[str] = None
        self.resource: Optional[str] = None
        self.operation: Optional[str] = None
        self.description: Optional[str] = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.nginx.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[list["_models.Operation"]] = None
        self.next_link: Optional[str] = None


class ResourceSku(_serialization.Model):
    """Resource Sku.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the SKU. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Name of the SKU. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class ScaleProfile(_serialization.Model):
    """The autoscale profile.

    All required parameters must be populated in order to send to server.

    :ivar name: Required.
    :vartype name: str
    :ivar min: The minimum number of NCUs the deployment can be autoscaled to. Required.
    :vartype min: int
    :ivar max: The maximum number of NCUs the deployment can be autoscaled to. Required.
    :vartype max: int
    """

    _validation = {
        "name": {"required": True},
        "min": {"required": True},
        "max": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "min": {"key": "capacity.min", "type": "int"},
        "max": {"key": "capacity.max", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        min: int,  # pylint: disable=redefined-builtin
        max: int,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Required.
        :paramtype name: str
        :keyword min: The minimum number of NCUs the deployment can be autoscaled to. Required.
        :paramtype min: int
        :keyword max: The maximum number of NCUs the deployment can be autoscaled to. Required.
        :paramtype max: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.min = min
        self.max = max


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.nginx.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.nginx.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.nginx.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.nginx.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserIdentityProperties(_serialization.Model):
    """User Identity Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id:
    :vartype principal_id: str
    :ivar client_id:
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class WebApplicationFirewallComponentVersions(_serialization.Model):
    """Versions of the NGINX App Protect Web Application Firewall (WAF) components.

    All required parameters must be populated in order to send to server.

    :ivar waf_engine_version: The version of the NGINX App Protect Web Application Firewall (WAF)
     engine. Required.
    :vartype waf_engine_version: str
    :ivar waf_nginx_version: The version of the NGINX App Protect Web Application Firewall (WAF)
     module for NGINX. Required.
    :vartype waf_nginx_version: str
    """

    _validation = {
        "waf_engine_version": {"required": True},
        "waf_nginx_version": {"required": True},
    }

    _attribute_map = {
        "waf_engine_version": {"key": "wafEngineVersion", "type": "str"},
        "waf_nginx_version": {"key": "wafNginxVersion", "type": "str"},
    }

    def __init__(self, *, waf_engine_version: str, waf_nginx_version: str, **kwargs: Any) -> None:
        """
        :keyword waf_engine_version: The version of the NGINX App Protect Web Application Firewall
         (WAF) engine. Required.
        :paramtype waf_engine_version: str
        :keyword waf_nginx_version: The version of the NGINX App Protect Web Application Firewall (WAF)
         module for NGINX. Required.
        :paramtype waf_nginx_version: str
        """
        super().__init__(**kwargs)
        self.waf_engine_version = waf_engine_version
        self.waf_nginx_version = waf_nginx_version


class WebApplicationFirewallPackage(_serialization.Model):
    """NGINX App Protect Web Application Firewall (WAF) Package. Contains the version and revision
    date of the package.

    All required parameters must be populated in order to send to server.

    :ivar version: The version of the NGINX App Protect Web Application Firewall (WAF) package.
     Required.
    :vartype version: str
    :ivar revision_datetime: The date and time of the package revision. Required.
    :vartype revision_datetime: ~datetime.datetime
    """

    _validation = {
        "version": {"required": True},
        "revision_datetime": {"required": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
        "revision_datetime": {"key": "revisionDatetime", "type": "iso-8601"},
    }

    def __init__(self, *, version: str, revision_datetime: datetime.datetime, **kwargs: Any) -> None:
        """
        :keyword version: The version of the NGINX App Protect Web Application Firewall (WAF) package.
         Required.
        :paramtype version: str
        :keyword revision_datetime: The date and time of the package revision. Required.
        :paramtype revision_datetime: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.version = version
        self.revision_datetime = revision_datetime


class WebApplicationFirewallSettings(_serialization.Model):
    """Settings for the NGINX App Protect Web Application Firewall (WAF).

    :ivar activation_state: The activation state of the WAF. Use 'Enabled' to enable the WAF and
     'Disabled' to disable it. Known values are: "Enabled" and "Disabled".
    :vartype activation_state: str or ~azure.mgmt.nginx.models.ActivationState
    """

    _attribute_map = {
        "activation_state": {"key": "activationState", "type": "str"},
    }

    def __init__(
        self, *, activation_state: Optional[Union[str, "_models.ActivationState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword activation_state: The activation state of the WAF. Use 'Enabled' to enable the WAF and
         'Disabled' to disable it. Known values are: "Enabled" and "Disabled".
        :paramtype activation_state: str or ~azure.mgmt.nginx.models.ActivationState
        """
        super().__init__(**kwargs)
        self.activation_state = activation_state


class WebApplicationFirewallStatus(_serialization.Model):
    """The status of the NGINX App Protect Web Application Firewall.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar waf_release: NGINX App Protect WAF release version.
    :vartype waf_release: str
    :ivar attack_signatures_package: Package containing attack signatures for the NGINX App Protect
     Web Application Firewall (WAF).
    :vartype attack_signatures_package: ~azure.mgmt.nginx.models.WebApplicationFirewallPackage
    :ivar bot_signatures_package: Package containing bot signatures for the NGINX App Protect Web
     Application Firewall (WAF).
    :vartype bot_signatures_package: ~azure.mgmt.nginx.models.WebApplicationFirewallPackage
    :ivar threat_campaigns_package: Package containing threat campaigns for the NGINX App Protect
     Web Application Firewall (WAF).
    :vartype threat_campaigns_package: ~azure.mgmt.nginx.models.WebApplicationFirewallPackage
    :ivar component_versions: Versions of the NGINX App Protect Web Application Firewall (WAF)
     components.
    :vartype component_versions: ~azure.mgmt.nginx.models.WebApplicationFirewallComponentVersions
    """

    _validation = {
        "attack_signatures_package": {"readonly": True},
        "bot_signatures_package": {"readonly": True},
        "threat_campaigns_package": {"readonly": True},
        "component_versions": {"readonly": True},
    }

    _attribute_map = {
        "waf_release": {"key": "wafRelease", "type": "str"},
        "attack_signatures_package": {"key": "attackSignaturesPackage", "type": "WebApplicationFirewallPackage"},
        "bot_signatures_package": {"key": "botSignaturesPackage", "type": "WebApplicationFirewallPackage"},
        "threat_campaigns_package": {"key": "threatCampaignsPackage", "type": "WebApplicationFirewallPackage"},
        "component_versions": {"key": "componentVersions", "type": "WebApplicationFirewallComponentVersions"},
    }

    def __init__(self, *, waf_release: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword waf_release: NGINX App Protect WAF release version.
        :paramtype waf_release: str
        """
        super().__init__(**kwargs)
        self.waf_release = waf_release
        self.attack_signatures_package: Optional["_models.WebApplicationFirewallPackage"] = None
        self.bot_signatures_package: Optional["_models.WebApplicationFirewallPackage"] = None
        self.threat_campaigns_package: Optional["_models.WebApplicationFirewallPackage"] = None
        self.component_versions: Optional["_models.WebApplicationFirewallComponentVersions"] = None
