# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementNetworkSecurityPerimeterAccessRulesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_security_perimeter_access_rules_get(self, resource_group):
        response = self.client.network_security_perimeter_access_rules.get(
            resource_group_name=resource_group.name,
            network_security_perimeter_name="str",
            profile_name="str",
            access_rule_name="str",
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_security_perimeter_access_rules_create_or_update(self, resource_group):
        response = self.client.network_security_perimeter_access_rules.create_or_update(
            resource_group_name=resource_group.name,
            network_security_perimeter_name="str",
            profile_name="str",
            access_rule_name="str",
            parameters={
                "addressPrefixes": ["str"],
                "direction": "str",
                "emailAddresses": ["str"],
                "fullyQualifiedDomainNames": ["str"],
                "id": "str",
                "name": "str",
                "networkSecurityPerimeters": [{"id": "str", "location": "str", "perimeterGuid": "str"}],
                "phoneNumbers": ["str"],
                "provisioningState": "str",
                "serviceTags": ["str"],
                "subscriptions": [{"id": "str"}],
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_security_perimeter_access_rules_delete(self, resource_group):
        response = self.client.network_security_perimeter_access_rules.delete(
            resource_group_name=resource_group.name,
            network_security_perimeter_name="str",
            profile_name="str",
            access_rule_name="str",
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_security_perimeter_access_rules_list(self, resource_group):
        response = self.client.network_security_perimeter_access_rules.list(
            resource_group_name=resource_group.name,
            network_security_perimeter_name="str",
            profile_name="str",
            api_version="2025-05-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_network_security_perimeter_access_rules_reconcile(self, resource_group):
        response = self.client.network_security_perimeter_access_rules.reconcile(
            resource_group_name=resource_group.name,
            network_security_perimeter_name="str",
            profile_name="str",
            access_rule_name="str",
            parameters={},
            api_version="2025-05-01",
        )

        # please add some check logic here by yourself
        # ...
