# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.edgeactions.aio import EdgeActionsMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEdgeActionsMgmtEdgeActionVersionsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EdgeActionsMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_edge_action_versions_get(self, resource_group):
        response = await self.client.edge_action_versions.get(
            resource_group_name=resource_group.name,
            edge_action_name="str",
            version="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_edge_action_versions_begin_create(self, resource_group):
        response = await (
            await self.client.edge_action_versions.begin_create(
                resource_group_name=resource_group.name,
                edge_action_name="str",
                version="str",
                resource={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "deploymentType": "str",
                        "isDefaultVersion": "str",
                        "lastPackageUpdateTime": "2020-02-20 00:00:00",
                        "provisioningState": "str",
                        "validationStatus": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_edge_action_versions_begin_update(self, resource_group):
        response = await (
            await self.client.edge_action_versions.begin_update(
                resource_group_name=resource_group.name,
                edge_action_name="str",
                version="str",
                properties={"properties": {"deploymentType": "str", "isDefaultVersion": "str"}, "tags": {"str": "str"}},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_edge_action_versions_begin_delete(self, resource_group):
        response = await (
            await self.client.edge_action_versions.begin_delete(
                resource_group_name=resource_group.name,
                edge_action_name="str",
                version="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_edge_action_versions_list_by_edge_action(self, resource_group):
        response = self.client.edge_action_versions.list_by_edge_action(
            resource_group_name=resource_group.name,
            edge_action_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_edge_action_versions_begin_deploy_version_code(self, resource_group):
        response = await (
            await self.client.edge_action_versions.begin_deploy_version_code(
                resource_group_name=resource_group.name,
                edge_action_name="str",
                version="str",
                body={"content": "str", "name": "str"},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_edge_action_versions_begin_get_version_code(self, resource_group):
        response = await (
            await self.client.edge_action_versions.begin_get_version_code(
                resource_group_name=resource_group.name,
                edge_action_name="str",
                version="str",
                content_type="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_edge_action_versions_begin_swap_default(self, resource_group):
        response = await (
            await self.client.edge_action_versions.begin_swap_default(
                resource_group_name=resource_group.name,
                edge_action_name="str",
                version="str",
                content_type="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
