# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, AsyncIterator, Callable, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from ..._utils.serialization import Deserializer, Serializer
from ...operations._operations import (
    build_bulk_actions_cancel_request,
    build_bulk_actions_create_or_update_request,
    build_bulk_actions_delete_request,
    build_bulk_actions_get_operation_status_request,
    build_bulk_actions_get_request,
    build_bulk_actions_list_by_resource_group_request,
    build_bulk_actions_list_by_subscription_request,
    build_bulk_actions_list_virtual_machines_request,
    build_bulk_actions_virtual_machines_cancel_operations_request,
    build_bulk_actions_virtual_machines_execute_create_request,
    build_bulk_actions_virtual_machines_execute_deallocate_request,
    build_bulk_actions_virtual_machines_execute_delete_request,
    build_bulk_actions_virtual_machines_execute_hibernate_request,
    build_bulk_actions_virtual_machines_execute_start_request,
    build_bulk_actions_virtual_machines_get_operation_status_request,
    build_operations_list_request,
)
from .._configuration import ComputeBulkActionsMgmtClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, dict[str, Any]], Any]]
JSON = MutableMapping[str, Any]
List = list


class Operations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.computebulkactions.aio.ComputeBulkActionsMgmtClient`'s
        :attr:`operations` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: ComputeBulkActionsMgmtClientConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncItemPaged["_models.Operation"]:
        """List the operations for the provider.

        :return: An iterator like instance of Operation
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.computebulkactions.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Operation]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_operations_list_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Operation], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.ErrorResponse,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class BulkActionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.computebulkactions.aio.ComputeBulkActionsMgmtClient`'s
        :attr:`bulk_actions` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: ComputeBulkActionsMgmtClientConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, resource_group_name: str, location: str, name: str, **kwargs: Any
    ) -> _models.LocationBasedLaunchBulkInstancesOperation:
        """Gets an instance of LaunchBulkInstancesOperations.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param location: The location name. Required.
        :type location: str
        :param name: The name of the LaunchBulkInstancesOperation. Required.
        :type name: str
        :return: LocationBasedLaunchBulkInstancesOperation. The
         LocationBasedLaunchBulkInstancesOperation is compatible with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.LocationBasedLaunchBulkInstancesOperation
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LocationBasedLaunchBulkInstancesOperation] = kwargs.pop("cls", None)

        _request = build_bulk_actions_get_request(
            resource_group_name=resource_group_name,
            location=location,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LocationBasedLaunchBulkInstancesOperation, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_operation_status(self, location: str, id: str, **kwargs: Any) -> _models.OperationStatusResult:
        """Get the status of a LaunchBulkInstancesOperation.

        :param location: The location name. Required.
        :type location: str
        :param id: The async operation id. Required.
        :type id: str
        :return: OperationStatusResult. The OperationStatusResult is compatible with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.OperationStatusResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.OperationStatusResult] = kwargs.pop("cls", None)

        _request = build_bulk_actions_get_operation_status_request(
            location=location,
            id=id,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.OperationStatusResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self,
        resource_group_name: str,
        location: str,
        name: str,
        resource: Union[_models.LocationBasedLaunchBulkInstancesOperation, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_bulk_actions_create_or_update_request(
            resource_group_name=resource_group_name,
            location=location,
            name=name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 201:
            response_headers["Azure-AsyncOperation"] = self._deserialize(
                "str", response.headers.get("Azure-AsyncOperation")
            )
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        location: str,
        name: str,
        resource: _models.LocationBasedLaunchBulkInstancesOperation,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LocationBasedLaunchBulkInstancesOperation]:
        """Creates or updates LaunchBulkInstancesOperations.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param location: The location name. Required.
        :type location: str
        :param name: The name of the LaunchBulkInstancesOperation. Required.
        :type name: str
        :param resource: Resource create parameters. Required.
        :type resource: ~azure.mgmt.computebulkactions.models.LocationBasedLaunchBulkInstancesOperation
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns LocationBasedLaunchBulkInstancesOperation.
         The LocationBasedLaunchBulkInstancesOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.computebulkactions.models.LocationBasedLaunchBulkInstancesOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        location: str,
        name: str,
        resource: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LocationBasedLaunchBulkInstancesOperation]:
        """Creates or updates LaunchBulkInstancesOperations.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param location: The location name. Required.
        :type location: str
        :param name: The name of the LaunchBulkInstancesOperation. Required.
        :type name: str
        :param resource: Resource create parameters. Required.
        :type resource: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns LocationBasedLaunchBulkInstancesOperation.
         The LocationBasedLaunchBulkInstancesOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.computebulkactions.models.LocationBasedLaunchBulkInstancesOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        location: str,
        name: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LocationBasedLaunchBulkInstancesOperation]:
        """Creates or updates LaunchBulkInstancesOperations.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param location: The location name. Required.
        :type location: str
        :param name: The name of the LaunchBulkInstancesOperation. Required.
        :type name: str
        :param resource: Resource create parameters. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns LocationBasedLaunchBulkInstancesOperation.
         The LocationBasedLaunchBulkInstancesOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.computebulkactions.models.LocationBasedLaunchBulkInstancesOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        location: str,
        name: str,
        resource: Union[_models.LocationBasedLaunchBulkInstancesOperation, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.LocationBasedLaunchBulkInstancesOperation]:
        """Creates or updates LaunchBulkInstancesOperations.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param location: The location name. Required.
        :type location: str
        :param name: The name of the LaunchBulkInstancesOperation. Required.
        :type name: str
        :param resource: Resource create parameters. Is one of the following types:
         LocationBasedLaunchBulkInstancesOperation, JSON, IO[bytes] Required.
        :type resource: ~azure.mgmt.computebulkactions.models.LocationBasedLaunchBulkInstancesOperation
         or JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns LocationBasedLaunchBulkInstancesOperation.
         The LocationBasedLaunchBulkInstancesOperation is compatible with MutableMapping
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.computebulkactions.models.LocationBasedLaunchBulkInstancesOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.LocationBasedLaunchBulkInstancesOperation] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                location=location,
                name=name,
                resource=resource,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.LocationBasedLaunchBulkInstancesOperation, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.LocationBasedLaunchBulkInstancesOperation].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.LocationBasedLaunchBulkInstancesOperation](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _delete_initial(
        self,
        resource_group_name: str,
        location: str,
        name: str,
        *,
        delete_instances: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_bulk_actions_delete_request(
            resource_group_name=resource_group_name,
            location=location,
            name=name,
            subscription_id=self._config.subscription_id,
            delete_instances=delete_instances,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete(
        self,
        resource_group_name: str,
        location: str,
        name: str,
        *,
        delete_instances: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Deletes LaunchBulkInstancesOperations.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param location: The location name. Required.
        :type location: str
        :param name: The name of the LaunchBulkInstancesOperation. Required.
        :type name: str
        :keyword delete_instances: When true, deletes all virtual machines created by this BulkAction
         Operation. Default value is None.
        :paramtype delete_instances: bool
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(
                resource_group_name=resource_group_name,
                location=location,
                name=name,
                delete_instances=delete_instances,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _cancel_initial(
        self, resource_group_name: str, location: str, name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_bulk_actions_cancel_request(
            resource_group_name=resource_group_name,
            location=location,
            name=name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
        response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_cancel(
        self, resource_group_name: str, location: str, name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Cancels LaunchBulkInstancesOperation instances that have not yet launched.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param location: The location name. Required.
        :type location: str
        :param name: The name of the LaunchBulkInstancesOperation. Required.
        :type name: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._cancel_initial(
                resource_group_name=resource_group_name,
                location=location,
                name=name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_by_resource_group(
        self, resource_group_name: str, location: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.LocationBasedLaunchBulkInstancesOperation"]:
        """List LaunchBulkInstancesOperation resources by resource group.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param location: The location name. Required.
        :type location: str
        :return: An iterator like instance of LocationBasedLaunchBulkInstancesOperation
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.computebulkactions.models.LocationBasedLaunchBulkInstancesOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LocationBasedLaunchBulkInstancesOperation]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_bulk_actions_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    location=location,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(
                List[_models.LocationBasedLaunchBulkInstancesOperation], deserialized.get("value", [])
            )
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.ErrorResponse,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_by_subscription(
        self, location: str, **kwargs: Any
    ) -> AsyncItemPaged["_models.LocationBasedLaunchBulkInstancesOperation"]:
        """List LaunchBulkInstancesOperation resources by subscriptionId.

        :param location: The location name. Required.
        :type location: str
        :return: An iterator like instance of LocationBasedLaunchBulkInstancesOperation
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.computebulkactions.models.LocationBasedLaunchBulkInstancesOperation]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LocationBasedLaunchBulkInstancesOperation]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_bulk_actions_list_by_subscription_request(
                    location=location,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(
                List[_models.LocationBasedLaunchBulkInstancesOperation], deserialized.get("value", [])
            )
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.ErrorResponse,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_virtual_machines(
        self,
        resource_group_name: str,
        location: str,
        name: str,
        *,
        filter: Optional[str] = None,
        skiptoken: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncItemPaged["_models.VirtualMachine"]:
        """List VirtualMachine resources of a LaunchBulkInstancesOperation.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param location: The location name. Required.
        :type location: str
        :param name: The name of the LaunchBulkInstancesOperation. Required.
        :type name: str
        :keyword filter: Filter expression to filter the virtual machines. Default value is None.
        :paramtype filter: str
        :keyword skiptoken: Skip token for pagination. Uses the token from a previous response to fetch
         the next page of results. Default value is None.
        :paramtype skiptoken: str
        :return: An iterator like instance of VirtualMachine
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.computebulkactions.models.VirtualMachine]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.VirtualMachine]] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_bulk_actions_list_virtual_machines_request(
                    resource_group_name=resource_group_name,
                    location=location,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    filter=filter,
                    skiptoken=skiptoken,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.base_url", self._config.base_url, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.VirtualMachine], deserialized.get("value", []))
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _failsafe_deserialize(
                    _models.ErrorResponse,
                    response,
                )
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def virtual_machines_execute_deallocate(
        self,
        location: str,
        request_body: _models.ExecuteDeallocateRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DeallocateResourceOperationResponse:
        """VirtualMachinesExecuteDeallocate: Execute deallocate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computebulkactions.models.ExecuteDeallocateRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DeallocateResourceOperationResponse. The DeallocateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.DeallocateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_deallocate(
        self, location: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.DeallocateResourceOperationResponse:
        """VirtualMachinesExecuteDeallocate: Execute deallocate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DeallocateResourceOperationResponse. The DeallocateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.DeallocateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_deallocate(
        self, location: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.DeallocateResourceOperationResponse:
        """VirtualMachinesExecuteDeallocate: Execute deallocate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DeallocateResourceOperationResponse. The DeallocateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.DeallocateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_execute_deallocate(
        self, location: str, request_body: Union[_models.ExecuteDeallocateRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.DeallocateResourceOperationResponse:
        """VirtualMachinesExecuteDeallocate: Execute deallocate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Is one of the following types: ExecuteDeallocateRequest,
         JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computebulkactions.models.ExecuteDeallocateRequest or JSON or
         IO[bytes]
        :return: DeallocateResourceOperationResponse. The DeallocateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.DeallocateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DeallocateResourceOperationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_bulk_actions_virtual_machines_execute_deallocate_request(
            location=location,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.DeallocateResourceOperationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def virtual_machines_execute_hibernate(
        self,
        location: str,
        request_body: _models.ExecuteHibernateRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.HibernateResourceOperationResponse:
        """VirtualMachinesExecuteHibernate: Execute hibernate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computebulkactions.models.ExecuteHibernateRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HibernateResourceOperationResponse. The HibernateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.HibernateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_hibernate(
        self, location: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.HibernateResourceOperationResponse:
        """VirtualMachinesExecuteHibernate: Execute hibernate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HibernateResourceOperationResponse. The HibernateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.HibernateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_hibernate(
        self, location: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.HibernateResourceOperationResponse:
        """VirtualMachinesExecuteHibernate: Execute hibernate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: HibernateResourceOperationResponse. The HibernateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.HibernateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_execute_hibernate(
        self, location: str, request_body: Union[_models.ExecuteHibernateRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.HibernateResourceOperationResponse:
        """VirtualMachinesExecuteHibernate: Execute hibernate operation for a batch of virtual machines,
        this operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Is one of the following types: ExecuteHibernateRequest,
         JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computebulkactions.models.ExecuteHibernateRequest or JSON or
         IO[bytes]
        :return: HibernateResourceOperationResponse. The HibernateResourceOperationResponse is
         compatible with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.HibernateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.HibernateResourceOperationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_bulk_actions_virtual_machines_execute_hibernate_request(
            location=location,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.HibernateResourceOperationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def virtual_machines_execute_start(
        self,
        location: str,
        request_body: _models.ExecuteStartRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.StartResourceOperationResponse:
        """VirtualMachinesExecuteStart: Execute start operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computebulkactions.models.ExecuteStartRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StartResourceOperationResponse. The StartResourceOperationResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.StartResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_start(
        self, location: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.StartResourceOperationResponse:
        """VirtualMachinesExecuteStart: Execute start operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StartResourceOperationResponse. The StartResourceOperationResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.StartResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_start(
        self, location: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.StartResourceOperationResponse:
        """VirtualMachinesExecuteStart: Execute start operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: StartResourceOperationResponse. The StartResourceOperationResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.StartResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_execute_start(
        self, location: str, request_body: Union[_models.ExecuteStartRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.StartResourceOperationResponse:
        """VirtualMachinesExecuteStart: Execute start operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Is one of the following types: ExecuteStartRequest,
         JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computebulkactions.models.ExecuteStartRequest or JSON or
         IO[bytes]
        :return: StartResourceOperationResponse. The StartResourceOperationResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.StartResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.StartResourceOperationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_bulk_actions_virtual_machines_execute_start_request(
            location=location,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.StartResourceOperationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def virtual_machines_execute_create(
        self,
        location: str,
        request_body: _models.ExecuteCreateRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CreateResourceOperationResponse:
        """VirtualMachinesExecuteCreate: Execute create operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computebulkactions.models.ExecuteCreateRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreateResourceOperationResponse. The CreateResourceOperationResponse is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.CreateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_create(
        self, location: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateResourceOperationResponse:
        """VirtualMachinesExecuteCreate: Execute create operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreateResourceOperationResponse. The CreateResourceOperationResponse is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.CreateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_create(
        self, location: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateResourceOperationResponse:
        """VirtualMachinesExecuteCreate: Execute create operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreateResourceOperationResponse. The CreateResourceOperationResponse is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.CreateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_execute_create(
        self, location: str, request_body: Union[_models.ExecuteCreateRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.CreateResourceOperationResponse:
        """VirtualMachinesExecuteCreate: Execute create operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Is one of the following types: ExecuteCreateRequest,
         JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computebulkactions.models.ExecuteCreateRequest or JSON or
         IO[bytes]
        :return: CreateResourceOperationResponse. The CreateResourceOperationResponse is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.CreateResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CreateResourceOperationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_bulk_actions_virtual_machines_execute_create_request(
            location=location,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CreateResourceOperationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def virtual_machines_execute_delete(
        self,
        location: str,
        request_body: _models.ExecuteDeleteRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.DeleteResourceOperationResponse:
        """VirtualMachinesExecuteDelete: Execute delete operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computebulkactions.models.ExecuteDeleteRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DeleteResourceOperationResponse. The DeleteResourceOperationResponse is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.DeleteResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_delete(
        self, location: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.DeleteResourceOperationResponse:
        """VirtualMachinesExecuteDelete: Execute delete operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DeleteResourceOperationResponse. The DeleteResourceOperationResponse is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.DeleteResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_execute_delete(
        self, location: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.DeleteResourceOperationResponse:
        """VirtualMachinesExecuteDelete: Execute delete operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: DeleteResourceOperationResponse. The DeleteResourceOperationResponse is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.DeleteResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_execute_delete(
        self, location: str, request_body: Union[_models.ExecuteDeleteRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.DeleteResourceOperationResponse:
        """VirtualMachinesExecuteDelete: Execute delete operation for a batch of virtual machines, this
        operation is triggered as soon as Computeschedule receives it.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Is one of the following types: ExecuteDeleteRequest,
         JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computebulkactions.models.ExecuteDeleteRequest or JSON or
         IO[bytes]
        :return: DeleteResourceOperationResponse. The DeleteResourceOperationResponse is compatible
         with MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.DeleteResourceOperationResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DeleteResourceOperationResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_bulk_actions_virtual_machines_execute_delete_request(
            location=location,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.DeleteResourceOperationResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def virtual_machines_get_operation_status(
        self,
        location: str,
        request_body: _models.GetOperationStatusRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.GetOperationStatusResponse:
        """VirtualMachinesGetOperationStatus: Polling endpoint to read status of operations performed on
        virtual machines.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computebulkactions.models.GetOperationStatusRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GetOperationStatusResponse. The GetOperationStatusResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.GetOperationStatusResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_get_operation_status(
        self, location: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.GetOperationStatusResponse:
        """VirtualMachinesGetOperationStatus: Polling endpoint to read status of operations performed on
        virtual machines.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GetOperationStatusResponse. The GetOperationStatusResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.GetOperationStatusResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_get_operation_status(
        self, location: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.GetOperationStatusResponse:
        """VirtualMachinesGetOperationStatus: Polling endpoint to read status of operations performed on
        virtual machines.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GetOperationStatusResponse. The GetOperationStatusResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.GetOperationStatusResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_get_operation_status(
        self, location: str, request_body: Union[_models.GetOperationStatusRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.GetOperationStatusResponse:
        """VirtualMachinesGetOperationStatus: Polling endpoint to read status of operations performed on
        virtual machines.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Is one of the following types:
         GetOperationStatusRequest, JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computebulkactions.models.GetOperationStatusRequest or JSON or
         IO[bytes]
        :return: GetOperationStatusResponse. The GetOperationStatusResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.GetOperationStatusResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.GetOperationStatusResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_bulk_actions_virtual_machines_get_operation_status_request(
            location=location,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.GetOperationStatusResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def virtual_machines_cancel_operations(
        self,
        location: str,
        request_body: _models.CancelOperationsRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CancelOperationsResponse:
        """VirtualMachinesCancelOperations: Cancel a previously submitted (start/deallocate/hibernate)
        request.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: ~azure.mgmt.computebulkactions.models.CancelOperationsRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CancelOperationsResponse. The CancelOperationsResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.CancelOperationsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_cancel_operations(
        self, location: str, request_body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CancelOperationsResponse:
        """VirtualMachinesCancelOperations: Cancel a previously submitted (start/deallocate/hibernate)
        request.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CancelOperationsResponse. The CancelOperationsResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.CancelOperationsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def virtual_machines_cancel_operations(
        self, location: str, request_body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CancelOperationsResponse:
        """VirtualMachinesCancelOperations: Cancel a previously submitted (start/deallocate/hibernate)
        request.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Required.
        :type request_body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CancelOperationsResponse. The CancelOperationsResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.CancelOperationsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def virtual_machines_cancel_operations(
        self, location: str, request_body: Union[_models.CancelOperationsRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.CancelOperationsResponse:
        """VirtualMachinesCancelOperations: Cancel a previously submitted (start/deallocate/hibernate)
        request.

        :param location: The location name. Required.
        :type location: str
        :param request_body: The request body. Is one of the following types: CancelOperationsRequest,
         JSON, IO[bytes] Required.
        :type request_body: ~azure.mgmt.computebulkactions.models.CancelOperationsRequest or JSON or
         IO[bytes]
        :return: CancelOperationsResponse. The CancelOperationsResponse is compatible with
         MutableMapping
        :rtype: ~azure.mgmt.computebulkactions.models.CancelOperationsResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CancelOperationsResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(request_body, (IOBase, bytes)):
            _content = request_body
        else:
            _content = json.dumps(request_body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_bulk_actions_virtual_machines_cancel_operations_request(
            location=location,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(
                _models.ErrorResponse,
                response,
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CancelOperationsResponse, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
