# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.artifactsigning import ArtifactSigningMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-artifactsigning
# USAGE
    python certificate_profiles_get.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ArtifactSigningMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.certificate_profiles.get(
        resource_group_name="MyResourceGroup",
        account_name="MyAccount",
        profile_name="profileA",
    )
    print(response)


# x-ms-original-file: 2025-10-13/CertificateProfiles_Get.json
if __name__ == "__main__":
    main()
