# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.agricultureplatform import AgriculturePlatformMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAgriculturePlatformMgmtAgriServiceOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AgriculturePlatformMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_agri_service_get(self, resource_group):
        response = self.client.agri_service.get(
            resource_group_name=resource_group.name,
            agri_service_resource_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_agri_service_begin_create_or_update(self, resource_group):
        response = self.client.agri_service.begin_create_or_update(
            resource_group_name=resource_group.name,
            agri_service_resource_name="str",
            resource={
                "location": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "properties": {
                    "config": {
                        "appServiceResourceId": "str",
                        "cosmosDbResourceId": "str",
                        "instanceUri": "str",
                        "keyVaultResourceId": "str",
                        "redisCacheResourceId": "str",
                        "storageAccountResourceId": "str",
                        "version": "str",
                    },
                    "dataConnectorCredentials": [
                        {
                            "key": "str",
                            "value": {
                                "clientId": "str",
                                "keyName": "str",
                                "keyVaultUri": "str",
                                "keyVersion": "str",
                                "kind": "str",
                            },
                        }
                    ],
                    "installedSolutions": [
                        {
                            "key": "str",
                            "value": {
                                "applicationName": "str",
                                "marketPlacePublisherId": "str",
                                "partnerId": "str",
                                "planId": "str",
                                "saasSubscriptionId": "str",
                                "saasSubscriptionName": "str",
                            },
                        }
                    ],
                    "managedOnBehalfOfConfiguration": {"moboBrokerResources": [{"id": "str"}]},
                    "provisioningState": "str",
                },
                "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_agri_service_begin_update(self, resource_group):
        response = self.client.agri_service.begin_update(
            resource_group_name=resource_group.name,
            agri_service_resource_name="str",
            properties={
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "properties": {
                    "config": {
                        "appServiceResourceId": "str",
                        "cosmosDbResourceId": "str",
                        "instanceUri": "str",
                        "keyVaultResourceId": "str",
                        "redisCacheResourceId": "str",
                        "storageAccountResourceId": "str",
                        "version": "str",
                    },
                    "dataConnectorCredentials": [
                        {
                            "key": "str",
                            "value": {
                                "clientId": "str",
                                "keyName": "str",
                                "keyVaultUri": "str",
                                "keyVersion": "str",
                                "kind": "str",
                            },
                        }
                    ],
                    "installedSolutions": [
                        {
                            "key": "str",
                            "value": {
                                "applicationName": "str",
                                "marketPlacePublisherId": "str",
                                "partnerId": "str",
                                "planId": "str",
                                "saasSubscriptionId": "str",
                                "saasSubscriptionName": "str",
                            },
                        }
                    ],
                },
                "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_agri_service_begin_delete(self, resource_group):
        response = self.client.agri_service.begin_delete(
            resource_group_name=resource_group.name,
            agri_service_resource_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_agri_service_list_by_resource_group(self, resource_group):
        response = self.client.agri_service.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_agri_service_list_by_subscription(self, resource_group):
        response = self.client.agri_service.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_agri_service_list_available_solutions(self, resource_group):
        response = self.client.agri_service.list_available_solutions(
            resource_group_name=resource_group.name,
            agri_service_resource_name="str",
        )

        # please add some check logic here by yourself
        # ...
