# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.kubernetesconfiguration import SourceControlConfigurationClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-kubernetesconfiguration
# USAGE
    python create_flux_configuration.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SourceControlConfigurationClient(
        credential=DefaultAzureCredential(),
        subscription_id="subId1",
    )

    response = client.flux_configurations.begin_create_or_update(
        resource_group_name="rg1",
        cluster_rp="Microsoft.Kubernetes",
        cluster_resource_name="connectedClusters",
        cluster_name="clusterName1",
        flux_configuration_name="srs-fluxconfig",
        flux_configuration={
            "properties": {
                "gitRepository": {
                    "httpsCACert": "ZXhhbXBsZWNlcnRpZmljYXRl",
                    "repositoryRef": {"branch": "master"},
                    "syncIntervalInSeconds": 600,
                    "timeoutInSeconds": 600,
                    "url": "https://github.com/Azure/arc-k8s-demo",
                },
                "kustomizations": {
                    "srs-kustomization1": {
                        "dependsOn": [],
                        "path": "./test/path",
                        "postBuild": {
                            "substitute": {"cluster_env": "prod", "replica_count": "2"},
                            "substituteFrom": [{"kind": "ConfigMap", "name": "cluster-test", "optional": True}],
                        },
                        "syncIntervalInSeconds": 600,
                        "timeoutInSeconds": 600,
                        "wait": True,
                    },
                    "srs-kustomization2": {
                        "dependsOn": ["srs-kustomization1"],
                        "path": "./other/test/path",
                        "postBuild": {
                            "substituteFrom": [
                                {"kind": "ConfigMap", "name": "cluster-values", "optional": True},
                                {"kind": "Secret", "name": "secret-name", "optional": False},
                            ]
                        },
                        "prune": False,
                        "retryIntervalInSeconds": 600,
                        "syncIntervalInSeconds": 600,
                        "timeoutInSeconds": 600,
                        "wait": False,
                    },
                },
                "namespace": "srs-namespace",
                "reconciliationWaitDuration": "PT30M",
                "scope": "cluster",
                "sourceKind": "GitRepository",
                "suspend": False,
                "waitForReconciliation": True,
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/kubernetesconfiguration/resource-manager/Microsoft.KubernetesConfiguration/stable/2023-05-01/examples/CreateFluxConfiguration.json
if __name__ == "__main__":
    main()
