# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class Resource(_serialization.Model):
    """Resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags


class GenericResource(Resource):
    """Resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar managed_by: ID of the resource that manages this resource.
    :vartype managed_by: str
    :ivar sku: The SKU of the resource.
    :vartype sku: ~azure.mgmt.resource.managedapplications.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        managed_by: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword managed_by: ID of the resource that manages this resource.
        :paramtype managed_by: str
        :keyword sku: The SKU of the resource.
        :paramtype sku: ~azure.mgmt.resource.managedapplications.models.Sku
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.managed_by = managed_by
        self.sku = sku


class Application(GenericResource):
    """Information about managed application.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar managed_by: ID of the resource that manages this resource.
    :vartype managed_by: str
    :ivar sku: The SKU of the resource.
    :vartype sku: ~azure.mgmt.resource.managedapplications.models.Sku
    :ivar plan: The plan information.
    :vartype plan: ~azure.mgmt.resource.managedapplications.models.Plan
    :ivar kind: The kind of the managed application. Allowed values are MarketPlace and
     ServiceCatalog. Required.
    :vartype kind: str
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.resource.managedapplications.models.Identity
    :ivar managed_resource_group_id: The managed resource group Id.
    :vartype managed_resource_group_id: str
    :ivar application_definition_id: The fully qualified path of managed application definition Id.
    :vartype application_definition_id: str
    :ivar parameters: Name and value pairs that define the managed application parameters. It can
     be a JObject or a well formed JSON string.
    :vartype parameters: JSON
    :ivar outputs: Name and value pairs that define the managed application outputs.
    :vartype outputs: JSON
    :ivar provisioning_state: The managed application provisioning state. Known values are:
     "NotSpecified", "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted",
     "Canceled", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.resource.managedapplications.models.ProvisioningState
    :ivar billing_details: The managed application billing details.
    :vartype billing_details:
     ~azure.mgmt.resource.managedapplications.models.ApplicationBillingDetailsDefinition
    :ivar jit_access_policy: The managed application Jit access policy.
    :vartype jit_access_policy:
     ~azure.mgmt.resource.managedapplications.models.ApplicationJitAccessPolicy
    :ivar publisher_tenant_id: The publisher tenant Id.
    :vartype publisher_tenant_id: str
    :ivar authorizations: The  read-only authorizations property that is retrieved from the
     application package.
    :vartype authorizations:
     list[~azure.mgmt.resource.managedapplications.models.ApplicationAuthorization]
    :ivar management_mode: The managed application management mode. Known values are:
     "NotSpecified", "Unmanaged", and "Managed".
    :vartype management_mode: str or
     ~azure.mgmt.resource.managedapplications.models.ApplicationManagementMode
    :ivar customer_support: The read-only customer support property that is retrieved from the
     application package.
    :vartype customer_support:
     ~azure.mgmt.resource.managedapplications.models.ApplicationPackageContact
    :ivar support_urls: The read-only support URLs property that is retrieved from the application
     package.
    :vartype support_urls:
     ~azure.mgmt.resource.managedapplications.models.ApplicationPackageSupportUrls
    :ivar artifacts: The collection of managed application artifacts.
    :vartype artifacts: list[~azure.mgmt.resource.managedapplications.models.ApplicationArtifact]
    :ivar created_by: The client entity that created the JIT request.
    :vartype created_by: ~azure.mgmt.resource.managedapplications.models.ApplicationClientDetails
    :ivar updated_by: The client entity that last updated the JIT request.
    :vartype updated_by: ~azure.mgmt.resource.managedapplications.models.ApplicationClientDetails
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True, "pattern": r"^[-\w\._,\(\)]+$"},
        "outputs": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "billing_details": {"readonly": True},
        "publisher_tenant_id": {"readonly": True},
        "authorizations": {"readonly": True},
        "management_mode": {"readonly": True},
        "customer_support": {"readonly": True},
        "support_urls": {"readonly": True},
        "artifacts": {"readonly": True},
        "created_by": {"readonly": True},
        "updated_by": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "plan": {"key": "plan", "type": "Plan"},
        "kind": {"key": "kind", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "managed_resource_group_id": {"key": "properties.managedResourceGroupId", "type": "str"},
        "application_definition_id": {"key": "properties.applicationDefinitionId", "type": "str"},
        "parameters": {"key": "properties.parameters", "type": "object"},
        "outputs": {"key": "properties.outputs", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "billing_details": {"key": "properties.billingDetails", "type": "ApplicationBillingDetailsDefinition"},
        "jit_access_policy": {"key": "properties.jitAccessPolicy", "type": "ApplicationJitAccessPolicy"},
        "publisher_tenant_id": {"key": "properties.publisherTenantId", "type": "str"},
        "authorizations": {"key": "properties.authorizations", "type": "[ApplicationAuthorization]"},
        "management_mode": {"key": "properties.managementMode", "type": "str"},
        "customer_support": {"key": "properties.customerSupport", "type": "ApplicationPackageContact"},
        "support_urls": {"key": "properties.supportUrls", "type": "ApplicationPackageSupportUrls"},
        "artifacts": {"key": "properties.artifacts", "type": "[ApplicationArtifact]"},
        "created_by": {"key": "properties.createdBy", "type": "ApplicationClientDetails"},
        "updated_by": {"key": "properties.updatedBy", "type": "ApplicationClientDetails"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        kind: str,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        managed_by: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        plan: Optional["_models.Plan"] = None,
        identity: Optional["_models.Identity"] = None,
        managed_resource_group_id: Optional[str] = None,
        application_definition_id: Optional[str] = None,
        parameters: Optional[JSON] = None,
        jit_access_policy: Optional["_models.ApplicationJitAccessPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword managed_by: ID of the resource that manages this resource.
        :paramtype managed_by: str
        :keyword sku: The SKU of the resource.
        :paramtype sku: ~azure.mgmt.resource.managedapplications.models.Sku
        :keyword plan: The plan information.
        :paramtype plan: ~azure.mgmt.resource.managedapplications.models.Plan
        :keyword kind: The kind of the managed application. Allowed values are MarketPlace and
         ServiceCatalog. Required.
        :paramtype kind: str
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.resource.managedapplications.models.Identity
        :keyword managed_resource_group_id: The managed resource group Id.
        :paramtype managed_resource_group_id: str
        :keyword application_definition_id: The fully qualified path of managed application definition
         Id.
        :paramtype application_definition_id: str
        :keyword parameters: Name and value pairs that define the managed application parameters. It
         can be a JObject or a well formed JSON string.
        :paramtype parameters: JSON
        :keyword jit_access_policy: The managed application Jit access policy.
        :paramtype jit_access_policy:
         ~azure.mgmt.resource.managedapplications.models.ApplicationJitAccessPolicy
        """
        super().__init__(location=location, tags=tags, managed_by=managed_by, sku=sku, **kwargs)
        self.plan = plan
        self.kind = kind
        self.identity = identity
        self.managed_resource_group_id = managed_resource_group_id
        self.application_definition_id = application_definition_id
        self.parameters = parameters
        self.outputs: Optional[JSON] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.billing_details: Optional["_models.ApplicationBillingDetailsDefinition"] = None
        self.jit_access_policy = jit_access_policy
        self.publisher_tenant_id: Optional[str] = None
        self.authorizations: Optional[List["_models.ApplicationAuthorization"]] = None
        self.management_mode: Optional[Union[str, "_models.ApplicationManagementMode"]] = None
        self.customer_support: Optional["_models.ApplicationPackageContact"] = None
        self.support_urls: Optional["_models.ApplicationPackageSupportUrls"] = None
        self.artifacts: Optional[List["_models.ApplicationArtifact"]] = None
        self.created_by: Optional["_models.ApplicationClientDetails"] = None
        self.updated_by: Optional["_models.ApplicationClientDetails"] = None


class ApplicationArtifact(_serialization.Model):
    """Managed application artifact.

    All required parameters must be populated in order to send to server.

    :ivar name: The managed application artifact name. Required. Known values are: "NotSpecified",
     "ViewDefinition", "Authorizations", and "CustomRoleDefinition".
    :vartype name: str or ~azure.mgmt.resource.managedapplications.models.ApplicationArtifactName
    :ivar uri: The managed application artifact blob uri. Required.
    :vartype uri: str
    :ivar type: The managed application artifact type. Required. Known values are: "NotSpecified",
     "Template", and "Custom".
    :vartype type: str or ~azure.mgmt.resource.managedapplications.models.ApplicationArtifactType
    """

    _validation = {
        "name": {"required": True},
        "uri": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Union[str, "_models.ApplicationArtifactName"],
        uri: str,
        type: Union[str, "_models.ApplicationArtifactType"],
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The managed application artifact name. Required. Known values are:
         "NotSpecified", "ViewDefinition", "Authorizations", and "CustomRoleDefinition".
        :paramtype name: str or ~azure.mgmt.resource.managedapplications.models.ApplicationArtifactName
        :keyword uri: The managed application artifact blob uri. Required.
        :paramtype uri: str
        :keyword type: The managed application artifact type. Required. Known values are:
         "NotSpecified", "Template", and "Custom".
        :paramtype type: str or ~azure.mgmt.resource.managedapplications.models.ApplicationArtifactType
        """
        super().__init__(**kwargs)
        self.name = name
        self.uri = uri
        self.type = type


class ApplicationAuthorization(_serialization.Model):
    """The managed application provider authorization.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The provider's principal identifier. This is the identity that the provider
     will use to call ARM to manage the managed application resources. Required.
    :vartype principal_id: str
    :ivar role_definition_id: The provider's role definition identifier. This role will define all
     the permissions that the provider must have on the managed application's container resource
     group. This role definition cannot have permission to delete the resource group. Required.
    :vartype role_definition_id: str
    """

    _validation = {
        "principal_id": {"required": True},
        "role_definition_id": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
    }

    def __init__(self, *, principal_id: str, role_definition_id: str, **kwargs: Any) -> None:
        """
        :keyword principal_id: The provider's principal identifier. This is the identity that the
         provider will use to call ARM to manage the managed application resources. Required.
        :paramtype principal_id: str
        :keyword role_definition_id: The provider's role definition identifier. This role will define
         all the permissions that the provider must have on the managed application's container resource
         group. This role definition cannot have permission to delete the resource group. Required.
        :paramtype role_definition_id: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id


class ApplicationBillingDetailsDefinition(_serialization.Model):
    """Managed application billing details definition.

    :ivar resource_usage_id: The managed application resource usage Id.
    :vartype resource_usage_id: str
    """

    _attribute_map = {
        "resource_usage_id": {"key": "resourceUsageId", "type": "str"},
    }

    def __init__(self, *, resource_usage_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_usage_id: The managed application resource usage Id.
        :paramtype resource_usage_id: str
        """
        super().__init__(**kwargs)
        self.resource_usage_id = resource_usage_id


class ApplicationClientDetails(_serialization.Model):
    """The application client details to track the entity creating/updating the managed app resource.

    :ivar oid: The client Oid.
    :vartype oid: str
    :ivar puid: The client Puid.
    :vartype puid: str
    :ivar application_id: The client application Id.
    :vartype application_id: str
    """

    _attribute_map = {
        "oid": {"key": "oid", "type": "str"},
        "puid": {"key": "puid", "type": "str"},
        "application_id": {"key": "applicationId", "type": "str"},
    }

    def __init__(
        self,
        *,
        oid: Optional[str] = None,
        puid: Optional[str] = None,
        application_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword oid: The client Oid.
        :paramtype oid: str
        :keyword puid: The client Puid.
        :paramtype puid: str
        :keyword application_id: The client application Id.
        :paramtype application_id: str
        """
        super().__init__(**kwargs)
        self.oid = oid
        self.puid = puid
        self.application_id = application_id


class ApplicationDefinition(GenericResource):
    """Information about managed application definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar managed_by: ID of the resource that manages this resource.
    :vartype managed_by: str
    :ivar sku: The SKU of the resource.
    :vartype sku: ~azure.mgmt.resource.managedapplications.models.Sku
    :ivar lock_level: The managed application lock level. Required. Known values are:
     "CanNotDelete", "ReadOnly", and "None".
    :vartype lock_level: str or
     ~azure.mgmt.resource.managedapplications.models.ApplicationLockLevel
    :ivar display_name: The managed application definition display name.
    :vartype display_name: str
    :ivar is_enabled: A value indicating whether the package is enabled or not.
    :vartype is_enabled: bool
    :ivar authorizations: The managed application provider authorizations.
    :vartype authorizations:
     list[~azure.mgmt.resource.managedapplications.models.ApplicationAuthorization]
    :ivar artifacts: The collection of managed application artifacts. The portal will use the files
     specified as artifacts to construct the user experience of creating a managed application from
     a managed application definition.
    :vartype artifacts:
     list[~azure.mgmt.resource.managedapplications.models.ApplicationDefinitionArtifact]
    :ivar description: The managed application definition description.
    :vartype description: str
    :ivar package_file_uri: The managed application definition package file Uri. Use this element.
    :vartype package_file_uri: str
    :ivar main_template: The inline main template json which has resources to be provisioned. It
     can be a JObject or well-formed JSON string.
    :vartype main_template: JSON
    :ivar create_ui_definition: The createUiDefinition json for the backing template with
     Microsoft.Solutions/applications resource. It can be a JObject or well-formed JSON string.
    :vartype create_ui_definition: JSON
    :ivar notification_policy: The managed application notification policy.
    :vartype notification_policy:
     ~azure.mgmt.resource.managedapplications.models.ApplicationNotificationPolicy
    :ivar locking_policy: The managed application locking policy.
    :vartype locking_policy:
     ~azure.mgmt.resource.managedapplications.models.ApplicationPackageLockingPolicyDefinition
    :ivar deployment_policy: The managed application deployment policy.
    :vartype deployment_policy:
     ~azure.mgmt.resource.managedapplications.models.ApplicationDeploymentPolicy
    :ivar management_policy: The managed application management policy that determines publisher's
     access to the managed resource group.
    :vartype management_policy:
     ~azure.mgmt.resource.managedapplications.models.ApplicationManagementPolicy
    :ivar policies: The managed application provider policies.
    :vartype policies: list[~azure.mgmt.resource.managedapplications.models.ApplicationPolicy]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "lock_level": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "lock_level": {"key": "properties.lockLevel", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
        "authorizations": {"key": "properties.authorizations", "type": "[ApplicationAuthorization]"},
        "artifacts": {"key": "properties.artifacts", "type": "[ApplicationDefinitionArtifact]"},
        "description": {"key": "properties.description", "type": "str"},
        "package_file_uri": {"key": "properties.packageFileUri", "type": "str"},
        "main_template": {"key": "properties.mainTemplate", "type": "object"},
        "create_ui_definition": {"key": "properties.createUiDefinition", "type": "object"},
        "notification_policy": {"key": "properties.notificationPolicy", "type": "ApplicationNotificationPolicy"},
        "locking_policy": {"key": "properties.lockingPolicy", "type": "ApplicationPackageLockingPolicyDefinition"},
        "deployment_policy": {"key": "properties.deploymentPolicy", "type": "ApplicationDeploymentPolicy"},
        "management_policy": {"key": "properties.managementPolicy", "type": "ApplicationManagementPolicy"},
        "policies": {"key": "properties.policies", "type": "[ApplicationPolicy]"},
    }

    def __init__(
        self,
        *,
        lock_level: Union[str, "_models.ApplicationLockLevel"],
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        managed_by: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        display_name: Optional[str] = None,
        is_enabled: Optional[bool] = None,
        authorizations: Optional[List["_models.ApplicationAuthorization"]] = None,
        artifacts: Optional[List["_models.ApplicationDefinitionArtifact"]] = None,
        description: Optional[str] = None,
        package_file_uri: Optional[str] = None,
        main_template: Optional[JSON] = None,
        create_ui_definition: Optional[JSON] = None,
        notification_policy: Optional["_models.ApplicationNotificationPolicy"] = None,
        locking_policy: Optional["_models.ApplicationPackageLockingPolicyDefinition"] = None,
        deployment_policy: Optional["_models.ApplicationDeploymentPolicy"] = None,
        management_policy: Optional["_models.ApplicationManagementPolicy"] = None,
        policies: Optional[List["_models.ApplicationPolicy"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword managed_by: ID of the resource that manages this resource.
        :paramtype managed_by: str
        :keyword sku: The SKU of the resource.
        :paramtype sku: ~azure.mgmt.resource.managedapplications.models.Sku
        :keyword lock_level: The managed application lock level. Required. Known values are:
         "CanNotDelete", "ReadOnly", and "None".
        :paramtype lock_level: str or
         ~azure.mgmt.resource.managedapplications.models.ApplicationLockLevel
        :keyword display_name: The managed application definition display name.
        :paramtype display_name: str
        :keyword is_enabled: A value indicating whether the package is enabled or not.
        :paramtype is_enabled: bool
        :keyword authorizations: The managed application provider authorizations.
        :paramtype authorizations:
         list[~azure.mgmt.resource.managedapplications.models.ApplicationAuthorization]
        :keyword artifacts: The collection of managed application artifacts. The portal will use the
         files specified as artifacts to construct the user experience of creating a managed application
         from a managed application definition.
        :paramtype artifacts:
         list[~azure.mgmt.resource.managedapplications.models.ApplicationDefinitionArtifact]
        :keyword description: The managed application definition description.
        :paramtype description: str
        :keyword package_file_uri: The managed application definition package file Uri. Use this
         element.
        :paramtype package_file_uri: str
        :keyword main_template: The inline main template json which has resources to be provisioned. It
         can be a JObject or well-formed JSON string.
        :paramtype main_template: JSON
        :keyword create_ui_definition: The createUiDefinition json for the backing template with
         Microsoft.Solutions/applications resource. It can be a JObject or well-formed JSON string.
        :paramtype create_ui_definition: JSON
        :keyword notification_policy: The managed application notification policy.
        :paramtype notification_policy:
         ~azure.mgmt.resource.managedapplications.models.ApplicationNotificationPolicy
        :keyword locking_policy: The managed application locking policy.
        :paramtype locking_policy:
         ~azure.mgmt.resource.managedapplications.models.ApplicationPackageLockingPolicyDefinition
        :keyword deployment_policy: The managed application deployment policy.
        :paramtype deployment_policy:
         ~azure.mgmt.resource.managedapplications.models.ApplicationDeploymentPolicy
        :keyword management_policy: The managed application management policy that determines
         publisher's access to the managed resource group.
        :paramtype management_policy:
         ~azure.mgmt.resource.managedapplications.models.ApplicationManagementPolicy
        :keyword policies: The managed application provider policies.
        :paramtype policies: list[~azure.mgmt.resource.managedapplications.models.ApplicationPolicy]
        """
        super().__init__(location=location, tags=tags, managed_by=managed_by, sku=sku, **kwargs)
        self.lock_level = lock_level
        self.display_name = display_name
        self.is_enabled = is_enabled
        self.authorizations = authorizations
        self.artifacts = artifacts
        self.description = description
        self.package_file_uri = package_file_uri
        self.main_template = main_template
        self.create_ui_definition = create_ui_definition
        self.notification_policy = notification_policy
        self.locking_policy = locking_policy
        self.deployment_policy = deployment_policy
        self.management_policy = management_policy
        self.policies = policies


class ApplicationDefinitionArtifact(_serialization.Model):
    """Application definition artifact.

    All required parameters must be populated in order to send to server.

    :ivar name: The managed application definition artifact name. Required. Known values are:
     "NotSpecified", "ApplicationResourceTemplate", "CreateUiDefinition", and
     "MainTemplateParameters".
    :vartype name: str or
     ~azure.mgmt.resource.managedapplications.models.ApplicationDefinitionArtifactName
    :ivar uri: The managed application definition artifact blob uri. Required.
    :vartype uri: str
    :ivar type: The managed application definition artifact type. Required. Known values are:
     "NotSpecified", "Template", and "Custom".
    :vartype type: str or ~azure.mgmt.resource.managedapplications.models.ApplicationArtifactType
    """

    _validation = {
        "name": {"required": True},
        "uri": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Union[str, "_models.ApplicationDefinitionArtifactName"],
        uri: str,
        type: Union[str, "_models.ApplicationArtifactType"],
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The managed application definition artifact name. Required. Known values are:
         "NotSpecified", "ApplicationResourceTemplate", "CreateUiDefinition", and
         "MainTemplateParameters".
        :paramtype name: str or
         ~azure.mgmt.resource.managedapplications.models.ApplicationDefinitionArtifactName
        :keyword uri: The managed application definition artifact blob uri. Required.
        :paramtype uri: str
        :keyword type: The managed application definition artifact type. Required. Known values are:
         "NotSpecified", "Template", and "Custom".
        :paramtype type: str or ~azure.mgmt.resource.managedapplications.models.ApplicationArtifactType
        """
        super().__init__(**kwargs)
        self.name = name
        self.uri = uri
        self.type = type


class ApplicationDefinitionListResult(_serialization.Model):
    """List of managed application definitions.

    :ivar value: The array of managed application definitions.
    :vartype value: list[~azure.mgmt.resource.managedapplications.models.ApplicationDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ApplicationDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The array of managed application definitions.
        :paramtype value: list[~azure.mgmt.resource.managedapplications.models.ApplicationDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationDeploymentPolicy(_serialization.Model):
    """Managed application deployment policy.

    All required parameters must be populated in order to send to server.

    :ivar deployment_mode: The managed application deployment mode. Required. Known values are:
     "NotSpecified", "Incremental", and "Complete".
    :vartype deployment_mode: str or ~azure.mgmt.resource.managedapplications.models.DeploymentMode
    """

    _validation = {
        "deployment_mode": {"required": True},
    }

    _attribute_map = {
        "deployment_mode": {"key": "deploymentMode", "type": "str"},
    }

    def __init__(self, *, deployment_mode: Union[str, "_models.DeploymentMode"], **kwargs: Any) -> None:
        """
        :keyword deployment_mode: The managed application deployment mode. Required. Known values are:
         "NotSpecified", "Incremental", and "Complete".
        :paramtype deployment_mode: str or
         ~azure.mgmt.resource.managedapplications.models.DeploymentMode
        """
        super().__init__(**kwargs)
        self.deployment_mode = deployment_mode


class ApplicationJitAccessPolicy(_serialization.Model):
    """Managed application Jit access policy.

    All required parameters must be populated in order to send to server.

    :ivar jit_access_enabled: Whether the JIT access is enabled. Required.
    :vartype jit_access_enabled: bool
    :ivar jit_approval_mode: JIT approval mode. Known values are: "NotSpecified", "AutoApprove",
     and "ManualApprove".
    :vartype jit_approval_mode: str or
     ~azure.mgmt.resource.managedapplications.models.JitApprovalMode
    :ivar jit_approvers: The JIT approvers.
    :vartype jit_approvers:
     list[~azure.mgmt.resource.managedapplications.models.JitApproverDefinition]
    :ivar maximum_jit_access_duration: The maximum duration JIT access is granted. This is an
     ISO8601 time period value.
    :vartype maximum_jit_access_duration: str
    """

    _validation = {
        "jit_access_enabled": {"required": True},
    }

    _attribute_map = {
        "jit_access_enabled": {"key": "jitAccessEnabled", "type": "bool"},
        "jit_approval_mode": {"key": "jitApprovalMode", "type": "str"},
        "jit_approvers": {"key": "jitApprovers", "type": "[JitApproverDefinition]"},
        "maximum_jit_access_duration": {"key": "maximumJitAccessDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        jit_access_enabled: bool,
        jit_approval_mode: Optional[Union[str, "_models.JitApprovalMode"]] = None,
        jit_approvers: Optional[List["_models.JitApproverDefinition"]] = None,
        maximum_jit_access_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword jit_access_enabled: Whether the JIT access is enabled. Required.
        :paramtype jit_access_enabled: bool
        :keyword jit_approval_mode: JIT approval mode. Known values are: "NotSpecified", "AutoApprove",
         and "ManualApprove".
        :paramtype jit_approval_mode: str or
         ~azure.mgmt.resource.managedapplications.models.JitApprovalMode
        :keyword jit_approvers: The JIT approvers.
        :paramtype jit_approvers:
         list[~azure.mgmt.resource.managedapplications.models.JitApproverDefinition]
        :keyword maximum_jit_access_duration: The maximum duration JIT access is granted. This is an
         ISO8601 time period value.
        :paramtype maximum_jit_access_duration: str
        """
        super().__init__(**kwargs)
        self.jit_access_enabled = jit_access_enabled
        self.jit_approval_mode = jit_approval_mode
        self.jit_approvers = jit_approvers
        self.maximum_jit_access_duration = maximum_jit_access_duration


class ApplicationListResult(_serialization.Model):
    """List of managed applications.

    :ivar value: The array of managed applications.
    :vartype value: list[~azure.mgmt.resource.managedapplications.models.Application]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Application]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Application"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The array of managed applications.
        :paramtype value: list[~azure.mgmt.resource.managedapplications.models.Application]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationManagementPolicy(_serialization.Model):
    """Managed application management policy.

    :ivar mode: The managed application management mode. Known values are: "NotSpecified",
     "Unmanaged", and "Managed".
    :vartype mode: str or ~azure.mgmt.resource.managedapplications.models.ApplicationManagementMode
    """

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
    }

    def __init__(
        self, *, mode: Optional[Union[str, "_models.ApplicationManagementMode"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword mode: The managed application management mode. Known values are: "NotSpecified",
         "Unmanaged", and "Managed".
        :paramtype mode: str or
         ~azure.mgmt.resource.managedapplications.models.ApplicationManagementMode
        """
        super().__init__(**kwargs)
        self.mode = mode


class ApplicationNotificationEndpoint(_serialization.Model):
    """Managed application notification endpoint.

    All required parameters must be populated in order to send to server.

    :ivar uri: The managed application notification endpoint uri. Required.
    :vartype uri: str
    """

    _validation = {
        "uri": {"required": True},
    }

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
    }

    def __init__(self, *, uri: str, **kwargs: Any) -> None:
        """
        :keyword uri: The managed application notification endpoint uri. Required.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.uri = uri


class ApplicationNotificationPolicy(_serialization.Model):
    """Managed application notification policy.

    All required parameters must be populated in order to send to server.

    :ivar notification_endpoints: The managed application notification endpoint. Required.
    :vartype notification_endpoints:
     list[~azure.mgmt.resource.managedapplications.models.ApplicationNotificationEndpoint]
    """

    _validation = {
        "notification_endpoints": {"required": True},
    }

    _attribute_map = {
        "notification_endpoints": {"key": "notificationEndpoints", "type": "[ApplicationNotificationEndpoint]"},
    }

    def __init__(
        self, *, notification_endpoints: List["_models.ApplicationNotificationEndpoint"], **kwargs: Any
    ) -> None:
        """
        :keyword notification_endpoints: The managed application notification endpoint. Required.
        :paramtype notification_endpoints:
         list[~azure.mgmt.resource.managedapplications.models.ApplicationNotificationEndpoint]
        """
        super().__init__(**kwargs)
        self.notification_endpoints = notification_endpoints


class ApplicationPackageContact(_serialization.Model):
    """The application package contact information.

    All required parameters must be populated in order to send to server.

    :ivar contact_name: The contact name.
    :vartype contact_name: str
    :ivar email: The contact email. Required.
    :vartype email: str
    :ivar phone: The contact phone number. Required.
    :vartype phone: str
    """

    _validation = {
        "email": {"required": True},
        "phone": {"required": True},
    }

    _attribute_map = {
        "contact_name": {"key": "contactName", "type": "str"},
        "email": {"key": "email", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
    }

    def __init__(self, *, email: str, phone: str, contact_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword contact_name: The contact name.
        :paramtype contact_name: str
        :keyword email: The contact email. Required.
        :paramtype email: str
        :keyword phone: The contact phone number. Required.
        :paramtype phone: str
        """
        super().__init__(**kwargs)
        self.contact_name = contact_name
        self.email = email
        self.phone = phone


class ApplicationPackageLockingPolicyDefinition(_serialization.Model):  # pylint: disable=name-too-long
    """Managed application locking policy.

    :ivar allowed_actions: The deny assignment excluded actions.
    :vartype allowed_actions: list[str]
    :ivar allowed_data_actions: The deny assignment excluded data actions.
    :vartype allowed_data_actions: list[str]
    """

    _attribute_map = {
        "allowed_actions": {"key": "allowedActions", "type": "[str]"},
        "allowed_data_actions": {"key": "allowedDataActions", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        allowed_actions: Optional[List[str]] = None,
        allowed_data_actions: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allowed_actions: The deny assignment excluded actions.
        :paramtype allowed_actions: list[str]
        :keyword allowed_data_actions: The deny assignment excluded data actions.
        :paramtype allowed_data_actions: list[str]
        """
        super().__init__(**kwargs)
        self.allowed_actions = allowed_actions
        self.allowed_data_actions = allowed_data_actions


class ApplicationPackageSupportUrls(_serialization.Model):
    """The appliance package support URLs.

    :ivar public_azure: The public azure support URL.
    :vartype public_azure: str
    :ivar government_cloud: The government cloud support URL.
    :vartype government_cloud: str
    """

    _attribute_map = {
        "public_azure": {"key": "publicAzure", "type": "str"},
        "government_cloud": {"key": "governmentCloud", "type": "str"},
    }

    def __init__(
        self, *, public_azure: Optional[str] = None, government_cloud: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword public_azure: The public azure support URL.
        :paramtype public_azure: str
        :keyword government_cloud: The government cloud support URL.
        :paramtype government_cloud: str
        """
        super().__init__(**kwargs)
        self.public_azure = public_azure
        self.government_cloud = government_cloud


class ApplicationPatchable(GenericResource):
    """Information about managed application.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar managed_by: ID of the resource that manages this resource.
    :vartype managed_by: str
    :ivar sku: The SKU of the resource.
    :vartype sku: ~azure.mgmt.resource.managedapplications.models.Sku
    :ivar plan: The plan information.
    :vartype plan: ~azure.mgmt.resource.managedapplications.models.PlanPatchable
    :ivar kind: The kind of the managed application. Allowed values are MarketPlace and
     ServiceCatalog.
    :vartype kind: str
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.resource.managedapplications.models.Identity
    :ivar managed_resource_group_id: The managed resource group Id.
    :vartype managed_resource_group_id: str
    :ivar application_definition_id: The fully qualified path of managed application definition Id.
    :vartype application_definition_id: str
    :ivar parameters: Name and value pairs that define the managed application parameters. It can
     be a JObject or a well formed JSON string.
    :vartype parameters: JSON
    :ivar outputs: Name and value pairs that define the managed application outputs.
    :vartype outputs: JSON
    :ivar provisioning_state: The managed application provisioning state. Known values are:
     "NotSpecified", "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted",
     "Canceled", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.resource.managedapplications.models.ProvisioningState
    :ivar billing_details: The managed application billing details.
    :vartype billing_details:
     ~azure.mgmt.resource.managedapplications.models.ApplicationBillingDetailsDefinition
    :ivar jit_access_policy: The managed application Jit access policy.
    :vartype jit_access_policy:
     ~azure.mgmt.resource.managedapplications.models.ApplicationJitAccessPolicy
    :ivar publisher_tenant_id: The publisher tenant Id.
    :vartype publisher_tenant_id: str
    :ivar authorizations: The  read-only authorizations property that is retrieved from the
     application package.
    :vartype authorizations:
     list[~azure.mgmt.resource.managedapplications.models.ApplicationAuthorization]
    :ivar management_mode: The managed application management mode. Known values are:
     "NotSpecified", "Unmanaged", and "Managed".
    :vartype management_mode: str or
     ~azure.mgmt.resource.managedapplications.models.ApplicationManagementMode
    :ivar customer_support: The read-only customer support property that is retrieved from the
     application package.
    :vartype customer_support:
     ~azure.mgmt.resource.managedapplications.models.ApplicationPackageContact
    :ivar support_urls: The read-only support URLs property that is retrieved from the application
     package.
    :vartype support_urls:
     ~azure.mgmt.resource.managedapplications.models.ApplicationPackageSupportUrls
    :ivar artifacts: The collection of managed application artifacts.
    :vartype artifacts: list[~azure.mgmt.resource.managedapplications.models.ApplicationArtifact]
    :ivar created_by: The client entity that created the JIT request.
    :vartype created_by: ~azure.mgmt.resource.managedapplications.models.ApplicationClientDetails
    :ivar updated_by: The client entity that last updated the JIT request.
    :vartype updated_by: ~azure.mgmt.resource.managedapplications.models.ApplicationClientDetails
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"pattern": r"^[-\w\._,\(\)]+$"},
        "outputs": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "billing_details": {"readonly": True},
        "publisher_tenant_id": {"readonly": True},
        "authorizations": {"readonly": True},
        "management_mode": {"readonly": True},
        "customer_support": {"readonly": True},
        "support_urls": {"readonly": True},
        "artifacts": {"readonly": True},
        "created_by": {"readonly": True},
        "updated_by": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "plan": {"key": "plan", "type": "PlanPatchable"},
        "kind": {"key": "kind", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "managed_resource_group_id": {"key": "properties.managedResourceGroupId", "type": "str"},
        "application_definition_id": {"key": "properties.applicationDefinitionId", "type": "str"},
        "parameters": {"key": "properties.parameters", "type": "object"},
        "outputs": {"key": "properties.outputs", "type": "object"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "billing_details": {"key": "properties.billingDetails", "type": "ApplicationBillingDetailsDefinition"},
        "jit_access_policy": {"key": "properties.jitAccessPolicy", "type": "ApplicationJitAccessPolicy"},
        "publisher_tenant_id": {"key": "properties.publisherTenantId", "type": "str"},
        "authorizations": {"key": "properties.authorizations", "type": "[ApplicationAuthorization]"},
        "management_mode": {"key": "properties.managementMode", "type": "str"},
        "customer_support": {"key": "properties.customerSupport", "type": "ApplicationPackageContact"},
        "support_urls": {"key": "properties.supportUrls", "type": "ApplicationPackageSupportUrls"},
        "artifacts": {"key": "properties.artifacts", "type": "[ApplicationArtifact]"},
        "created_by": {"key": "properties.createdBy", "type": "ApplicationClientDetails"},
        "updated_by": {"key": "properties.updatedBy", "type": "ApplicationClientDetails"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        managed_by: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        plan: Optional["_models.PlanPatchable"] = None,
        kind: Optional[str] = None,
        identity: Optional["_models.Identity"] = None,
        managed_resource_group_id: Optional[str] = None,
        application_definition_id: Optional[str] = None,
        parameters: Optional[JSON] = None,
        jit_access_policy: Optional["_models.ApplicationJitAccessPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword managed_by: ID of the resource that manages this resource.
        :paramtype managed_by: str
        :keyword sku: The SKU of the resource.
        :paramtype sku: ~azure.mgmt.resource.managedapplications.models.Sku
        :keyword plan: The plan information.
        :paramtype plan: ~azure.mgmt.resource.managedapplications.models.PlanPatchable
        :keyword kind: The kind of the managed application. Allowed values are MarketPlace and
         ServiceCatalog.
        :paramtype kind: str
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.resource.managedapplications.models.Identity
        :keyword managed_resource_group_id: The managed resource group Id.
        :paramtype managed_resource_group_id: str
        :keyword application_definition_id: The fully qualified path of managed application definition
         Id.
        :paramtype application_definition_id: str
        :keyword parameters: Name and value pairs that define the managed application parameters. It
         can be a JObject or a well formed JSON string.
        :paramtype parameters: JSON
        :keyword jit_access_policy: The managed application Jit access policy.
        :paramtype jit_access_policy:
         ~azure.mgmt.resource.managedapplications.models.ApplicationJitAccessPolicy
        """
        super().__init__(location=location, tags=tags, managed_by=managed_by, sku=sku, **kwargs)
        self.plan = plan
        self.kind = kind
        self.identity = identity
        self.managed_resource_group_id = managed_resource_group_id
        self.application_definition_id = application_definition_id
        self.parameters = parameters
        self.outputs: Optional[JSON] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.billing_details: Optional["_models.ApplicationBillingDetailsDefinition"] = None
        self.jit_access_policy = jit_access_policy
        self.publisher_tenant_id: Optional[str] = None
        self.authorizations: Optional[List["_models.ApplicationAuthorization"]] = None
        self.management_mode: Optional[Union[str, "_models.ApplicationManagementMode"]] = None
        self.customer_support: Optional["_models.ApplicationPackageContact"] = None
        self.support_urls: Optional["_models.ApplicationPackageSupportUrls"] = None
        self.artifacts: Optional[List["_models.ApplicationArtifact"]] = None
        self.created_by: Optional["_models.ApplicationClientDetails"] = None
        self.updated_by: Optional["_models.ApplicationClientDetails"] = None


class ApplicationPolicy(_serialization.Model):
    """Managed application policy.

    :ivar name: The policy name.
    :vartype name: str
    :ivar policy_definition_id: The policy definition Id.
    :vartype policy_definition_id: str
    :ivar parameters: The policy parameters.
    :vartype parameters: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "parameters": {"key": "parameters", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        policy_definition_id: Optional[str] = None,
        parameters: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The policy name.
        :paramtype name: str
        :keyword policy_definition_id: The policy definition Id.
        :paramtype policy_definition_id: str
        :keyword parameters: The policy parameters.
        :paramtype parameters: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.policy_definition_id = policy_definition_id
        self.parameters = parameters


class ApplicationPropertiesPatchable(_serialization.Model):
    """The managed application properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar managed_resource_group_id: The managed resource group Id.
    :vartype managed_resource_group_id: str
    :ivar application_definition_id: The fully qualified path of managed application definition Id.
    :vartype application_definition_id: str
    :ivar parameters: Name and value pairs that define the managed application parameters. It can
     be a JObject or a well formed JSON string.
    :vartype parameters: JSON
    :ivar outputs: Name and value pairs that define the managed application outputs.
    :vartype outputs: JSON
    :ivar provisioning_state: The managed application provisioning state. Known values are:
     "NotSpecified", "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted",
     "Canceled", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.resource.managedapplications.models.ProvisioningState
    """

    _validation = {
        "outputs": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "managed_resource_group_id": {"key": "managedResourceGroupId", "type": "str"},
        "application_definition_id": {"key": "applicationDefinitionId", "type": "str"},
        "parameters": {"key": "parameters", "type": "object"},
        "outputs": {"key": "outputs", "type": "object"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        managed_resource_group_id: Optional[str] = None,
        application_definition_id: Optional[str] = None,
        parameters: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_resource_group_id: The managed resource group Id.
        :paramtype managed_resource_group_id: str
        :keyword application_definition_id: The fully qualified path of managed application definition
         Id.
        :paramtype application_definition_id: str
        :keyword parameters: Name and value pairs that define the managed application parameters. It
         can be a JObject or a well formed JSON string.
        :paramtype parameters: JSON
        """
        super().__init__(**kwargs)
        self.managed_resource_group_id = managed_resource_group_id
        self.application_definition_id = application_definition_id
        self.parameters = parameters
        self.outputs: Optional[JSON] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.managedapplications.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.resource.managedapplications.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetail"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.resource.managedapplications.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.resource.managedapplications.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Known values are: "SystemAssigned", "UserAssigned",
     "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.resource.managedapplications.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.resource.managedapplications.models.UserAssignedResourceIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedResourceIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedResourceIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The identity type. Known values are: "SystemAssigned", "UserAssigned",
         "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.resource.managedapplications.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity dictionary key references will be resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.resource.managedapplications.models.UserAssignedResourceIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class JitApproverDefinition(_serialization.Model):
    """JIT approver definition.

    All required parameters must be populated in order to send to server.

    :ivar id: The approver service principal Id. Required.
    :vartype id: str
    :ivar type: The approver type. Known values are: "user" and "group".
    :vartype type: str or ~azure.mgmt.resource.managedapplications.models.JitApproverType
    :ivar display_name: The approver display name.
    :vartype display_name: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        type: Optional[Union[str, "_models.JitApproverType"]] = None,
        display_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The approver service principal Id. Required.
        :paramtype id: str
        :keyword type: The approver type. Known values are: "user" and "group".
        :paramtype type: str or ~azure.mgmt.resource.managedapplications.models.JitApproverType
        :keyword display_name: The approver display name.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type
        self.display_name = display_name


class JitAuthorizationPolicies(_serialization.Model):
    """The JIT authorization policies.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The the principal id that will be granted JIT access. Required.
    :vartype principal_id: str
    :ivar role_definition_id: The role definition id that will be granted to the Principal.
     Required.
    :vartype role_definition_id: str
    """

    _validation = {
        "principal_id": {"required": True},
        "role_definition_id": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "role_definition_id": {"key": "roleDefinitionId", "type": "str"},
    }

    def __init__(self, *, principal_id: str, role_definition_id: str, **kwargs: Any) -> None:
        """
        :keyword principal_id: The the principal id that will be granted JIT access. Required.
        :paramtype principal_id: str
        :keyword role_definition_id: The role definition id that will be granted to the Principal.
         Required.
        :paramtype role_definition_id: str
        """
        super().__init__(**kwargs)
        self.principal_id = principal_id
        self.role_definition_id = role_definition_id


class JitRequestDefinition(Resource):
    """Information about JIT request definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar application_resource_id: The parent application id.
    :vartype application_resource_id: str
    :ivar publisher_tenant_id: The publisher tenant id.
    :vartype publisher_tenant_id: str
    :ivar jit_authorization_policies: The JIT authorization policies.
    :vartype jit_authorization_policies:
     list[~azure.mgmt.resource.managedapplications.models.JitAuthorizationPolicies]
    :ivar jit_scheduling_policy: The JIT request properties.
    :vartype jit_scheduling_policy:
     ~azure.mgmt.resource.managedapplications.models.JitSchedulingPolicy
    :ivar provisioning_state: The JIT request provisioning state. Known values are: "NotSpecified",
     "Accepted", "Running", "Ready", "Creating", "Created", "Deleting", "Deleted", "Canceled",
     "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.resource.managedapplications.models.ProvisioningState
    :ivar jit_request_state: The JIT request state. Known values are: "NotSpecified", "Pending",
     "Approved", "Denied", "Failed", "Canceled", "Expired", and "Timeout".
    :vartype jit_request_state: str or
     ~azure.mgmt.resource.managedapplications.models.JitRequestState
    :ivar created_by: The client entity that created the JIT request.
    :vartype created_by: ~azure.mgmt.resource.managedapplications.models.ApplicationClientDetails
    :ivar updated_by: The client entity that last updated the JIT request.
    :vartype updated_by: ~azure.mgmt.resource.managedapplications.models.ApplicationClientDetails
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "publisher_tenant_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "jit_request_state": {"readonly": True},
        "created_by": {"readonly": True},
        "updated_by": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "application_resource_id": {"key": "properties.applicationResourceId", "type": "str"},
        "publisher_tenant_id": {"key": "properties.publisherTenantId", "type": "str"},
        "jit_authorization_policies": {
            "key": "properties.jitAuthorizationPolicies",
            "type": "[JitAuthorizationPolicies]",
        },
        "jit_scheduling_policy": {"key": "properties.jitSchedulingPolicy", "type": "JitSchedulingPolicy"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "jit_request_state": {"key": "properties.jitRequestState", "type": "str"},
        "created_by": {"key": "properties.createdBy", "type": "ApplicationClientDetails"},
        "updated_by": {"key": "properties.updatedBy", "type": "ApplicationClientDetails"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        application_resource_id: Optional[str] = None,
        jit_authorization_policies: Optional[List["_models.JitAuthorizationPolicies"]] = None,
        jit_scheduling_policy: Optional["_models.JitSchedulingPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword application_resource_id: The parent application id.
        :paramtype application_resource_id: str
        :keyword jit_authorization_policies: The JIT authorization policies.
        :paramtype jit_authorization_policies:
         list[~azure.mgmt.resource.managedapplications.models.JitAuthorizationPolicies]
        :keyword jit_scheduling_policy: The JIT request properties.
        :paramtype jit_scheduling_policy:
         ~azure.mgmt.resource.managedapplications.models.JitSchedulingPolicy
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.application_resource_id = application_resource_id
        self.publisher_tenant_id: Optional[str] = None
        self.jit_authorization_policies = jit_authorization_policies
        self.jit_scheduling_policy = jit_scheduling_policy
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.jit_request_state: Optional[Union[str, "_models.JitRequestState"]] = None
        self.created_by: Optional["_models.ApplicationClientDetails"] = None
        self.updated_by: Optional["_models.ApplicationClientDetails"] = None


class JitRequestDefinitionListResult(_serialization.Model):
    """List of JIT requests.

    :ivar value: The array of Jit request definition.
    :vartype value: list[~azure.mgmt.resource.managedapplications.models.JitRequestDefinition]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[JitRequestDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.JitRequestDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The array of Jit request definition.
        :paramtype value: list[~azure.mgmt.resource.managedapplications.models.JitRequestDefinition]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class JitRequestPatchable(_serialization.Model):
    """Information about JIT request.

    :ivar tags: Jit request tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Jit request tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class JitSchedulingPolicy(_serialization.Model):
    """The JIT scheduling policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of JIT schedule. Required. Known values are: "NotSpecified", "Once", and
     "Recurring".
    :vartype type: str or ~azure.mgmt.resource.managedapplications.models.JitSchedulingType
    :ivar duration: The required duration of the JIT request. Required.
    :vartype duration: ~datetime.timedelta
    :ivar start_time: The start time of the request. Required.
    :vartype start_time: ~datetime.datetime
    """

    _validation = {
        "type": {"required": True, "readonly": True},
        "duration": {"required": True},
        "start_time": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
    }

    def __init__(self, *, duration: datetime.timedelta, start_time: datetime.datetime, **kwargs: Any) -> None:
        """
        :keyword duration: The required duration of the JIT request. Required.
        :paramtype duration: ~datetime.timedelta
        :keyword start_time: The start time of the request. Required.
        :paramtype start_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.type: Optional[Union[str, "_models.JitSchedulingType"]] = None
        self.duration = duration
        self.start_time = start_time


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.resource.managedapplications.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.resource.managedapplications.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.resource.managedapplications.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.resource.managedapplications.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.is_data_action: Optional[bool] = None
        self.display = display
        self.origin: Optional[Union[str, "_models.Origin"]] = None
        self.action_type: Optional[Union[str, "_models.ActionType"]] = None


class OperationAutoGenerated(_serialization.Model):
    """Microsoft.Solutions operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.resource.managedapplications.models.OperationDisplayAutoGenerated
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplayAutoGenerated"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplayAutoGenerated"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display:
         ~azure.mgmt.resource.managedapplications.models.OperationDisplayAutoGenerated
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider: Optional[str] = None
        self.resource: Optional[str] = None
        self.operation: Optional[str] = None
        self.description: Optional[str] = None


class OperationDisplayAutoGenerated(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.Solutions.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Application, JitRequest, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft.Solutions.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Application, JitRequest, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.resource.managedapplications.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Operation"]] = None
        self.next_link: Optional[str] = None


class Plan(_serialization.Model):
    """Plan for the managed application.

    All required parameters must be populated in order to send to server.

    :ivar name: The plan name. Required.
    :vartype name: str
    :ivar publisher: The publisher ID. Required.
    :vartype publisher: str
    :ivar product: The product code. Required.
    :vartype product: str
    :ivar promotion_code: The promotion code.
    :vartype promotion_code: str
    :ivar version: The plan's version. Required.
    :vartype version: str
    """

    _validation = {
        "name": {"required": True},
        "publisher": {"required": True},
        "product": {"required": True},
        "version": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        product: str,
        version: str,
        promotion_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The plan name. Required.
        :paramtype name: str
        :keyword publisher: The publisher ID. Required.
        :paramtype publisher: str
        :keyword product: The product code. Required.
        :paramtype product: str
        :keyword promotion_code: The promotion code.
        :paramtype promotion_code: str
        :keyword version: The plan's version. Required.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code
        self.version = version


class PlanPatchable(_serialization.Model):
    """Plan for the managed application.

    :ivar name: The plan name.
    :vartype name: str
    :ivar publisher: The publisher ID.
    :vartype publisher: str
    :ivar product: The product code.
    :vartype product: str
    :ivar promotion_code: The promotion code.
    :vartype promotion_code: str
    :ivar version: The plan's version.
    :vartype version: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The plan name.
        :paramtype name: str
        :keyword publisher: The publisher ID.
        :paramtype publisher: str
        :keyword product: The product code.
        :paramtype product: str
        :keyword promotion_code: The promotion code.
        :paramtype promotion_code: str
        :keyword version: The plan's version.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code
        self.version = version


class Sku(_serialization.Model):
    """SKU for the resource.

    All required parameters must be populated in order to send to server.

    :ivar name: The SKU name. Required.
    :vartype name: str
    :ivar tier: The SKU tier.
    :vartype tier: str
    :ivar size: The SKU size.
    :vartype size: str
    :ivar family: The SKU family.
    :vartype family: str
    :ivar model: The SKU model.
    :vartype model: str
    :ivar capacity: The SKU capacity.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "model": {"key": "model", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        model: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The SKU name. Required.
        :paramtype name: str
        :keyword tier: The SKU tier.
        :paramtype tier: str
        :keyword size: The SKU size.
        :paramtype size: str
        :keyword family: The SKU family.
        :paramtype family: str
        :keyword model: The SKU model.
        :paramtype model: str
        :keyword capacity: The SKU capacity.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.model = model
        self.capacity = capacity


class UserAssignedResourceIdentity(_serialization.Model):
    """Represents the user assigned identity that is contained within the UserAssignedIdentities
    dictionary on ResourceIdentity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of user assigned identity.
    :vartype tenant_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
