# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerregistry import ContainerRegistryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerRegistryManagementAgentPoolsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerRegistryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_agent_pools_get(self, resource_group):
        response = self.client.agent_pools.get(
            resource_group_name=resource_group.name,
            registry_name="str",
            agent_pool_name="str",
            api_version="2025-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_agent_pools_begin_create(self, resource_group):
        response = self.client.agent_pools.begin_create(
            resource_group_name=resource_group.name,
            registry_name="str",
            agent_pool_name="str",
            agent_pool={
                "location": "str",
                "count": 0,
                "id": "str",
                "name": "str",
                "os": "str",
                "provisioningState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "tier": "str",
                "type": "str",
                "virtualNetworkSubnetResourceId": "str",
            },
            api_version="2025-03-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_agent_pools_begin_delete(self, resource_group):
        response = self.client.agent_pools.begin_delete(
            resource_group_name=resource_group.name,
            registry_name="str",
            agent_pool_name="str",
            api_version="2025-03-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_agent_pools_begin_update(self, resource_group):
        response = self.client.agent_pools.begin_update(
            resource_group_name=resource_group.name,
            registry_name="str",
            agent_pool_name="str",
            update_parameters={"count": 0, "tags": {"str": "str"}},
            api_version="2025-03-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_agent_pools_list(self, resource_group):
        response = self.client.agent_pools.list(
            resource_group_name=resource_group.name,
            registry_name="str",
            api_version="2025-03-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_agent_pools_get_queue_status(self, resource_group):
        response = self.client.agent_pools.get_queue_status(
            resource_group_name=resource_group.name,
            registry_name="str",
            agent_pool_name="str",
            api_version="2025-03-01-preview",
        )

        # please add some check logic here by yourself
        # ...
