; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc %s -o - -mtriple=thumbv8m.base | FileCheck %s

declare i32 @g(...)

declare i32 @h0(i32, i32, i32, i32)
define hidden i32 @f0() {
; CHECK-LABEL: f0:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    bl g
; CHECK-NEXT:    movs r1, #1
; CHECK-NEXT:    movs r2, #2
; CHECK-NEXT:    movs r3, #3
; CHECK-NEXT:    ldr r7, [sp, #4]
; CHECK-NEXT:    mov lr, r7
; CHECK-NEXT:    pop {r7}
; CHECK-NEXT:    add sp, #4
; CHECK-NEXT:    b h0
  %1 = tail call i32 @g()
  %2 = tail call i32 @h0(i32 %1, i32 1, i32 2, i32 3)
  ret i32 %2
}

declare i32 @h1(i32)
define hidden i32 @f1() {
; CHECK-LABEL: f1:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    bl g
; CHECK-NEXT:    pop {r7}
; CHECK-NEXT:    pop {r1}
; CHECK-NEXT:    mov lr, r1
; CHECK-NEXT:    b h1
  %1 = tail call i32 @g()
  %2 = tail call i32 @h1(i32 %1)
  ret i32 %2
}

declare i32 @h2(i32, i32, i32, i32, i32)
define hidden i32 @f2(i32, i32, i32, i32, i32) {
; CHECK-LABEL: f2:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r5, r6, r7, lr}
; CHECK-NEXT:    sub sp, #4
; CHECK-NEXT:    mov r4, r3
; CHECK-NEXT:    mov r5, r2
; CHECK-NEXT:    mov r6, r1
; CHECK-NEXT:    ldr r7, [sp, #24]
; CHECK-NEXT:    bl g
; CHECK-NEXT:    cbz r0, .LBB2_2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:    str r7, [sp, #24]
; CHECK-NEXT:    mov r1, r6
; CHECK-NEXT:    mov r2, r5
; CHECK-NEXT:    mov r3, r4
; CHECK-NEXT:    add sp, #4
; CHECK-NEXT:    ldr r4, [sp, #16]
; CHECK-NEXT:    mov lr, r4
; CHECK-NEXT:    pop {r4, r5, r6, r7}
; CHECK-NEXT:    add sp, #4
; CHECK-NEXT:    b h2
; CHECK-NEXT:  .LBB2_2:
; CHECK-NEXT:    movs r0, #0
; CHECK-NEXT:    mvns r0, r0
; CHECK-NEXT:    add sp, #4
; CHECK-NEXT:    pop {r4, r5, r6, r7, pc}
  %6 = tail call i32 @g()
  %7 = icmp eq i32 %6, 0
  br i1 %7, label %10, label %8

  %9 = tail call i32 @h2(i32 %6, i32 %1, i32 %2, i32 %3, i32 %4)
  br label %10

  %11 = phi i32 [ %9, %8 ], [ -1, %5 ]
  ret i32 %11
}

; Make sure that tail calls to function pointers that require r0-r3 for argument
; passing do not break the compiler.
@fnptr = global ptr null
define i32 @test3() {
; CHECK-LABEL: test3:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    movw r0, :lower16:fnptr
; CHECK-NEXT:    movt r0, :upper16:fnptr
; CHECK-NEXT:    ldr r4, [r0]
; CHECK-NEXT:    movs r0, #1
; CHECK-NEXT:    movs r1, #2
; CHECK-NEXT:    movs r2, #3
; CHECK-NEXT:    movs r3, #4
; CHECK-NEXT:    blx r4
; CHECK-NEXT:    pop {r4, pc}
  %1 = load ptr, ptr @fnptr
  %2 = tail call i32 %1(i32 1, i32 2, i32 3, i32 4)
  ret i32 %2
}

@fnptr2 = global ptr null
define i32 @test4() {
; CHECK-LABEL: test4:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    movw r0, :lower16:fnptr2
; CHECK-NEXT:    movt r0, :upper16:fnptr2
; CHECK-NEXT:    ldr r4, [r0]
; CHECK-NEXT:    movs r0, #1
; CHECK-NEXT:    movs r1, #2
; CHECK-NEXT:    movs r2, #3
; CHECK-NEXT:    movs r3, #0
; CHECK-NEXT:    blx r4
; CHECK-NEXT:    pop {r4, pc}
  %1 = load ptr, ptr @fnptr2
  %2 = tail call i32 %1(i32 1, i32 2, i64 3)
  ret i32 %2
}

; Check that tail calls to function pointers where not all of r0-r3 are used for
; parameter passing are tail-call optimized.
; test5: params in r0, r1. r2 & r3 are free.
@fnptr3 = global ptr null
define i32 @test5() {
; CHECK-LABEL: test5:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    movw r0, :lower16:fnptr3
; CHECK-NEXT:    movt r0, :upper16:fnptr3
; CHECK-NEXT:    ldr r2, [r0]
; CHECK-NEXT:    movs r0, #1
; CHECK-NEXT:    movs r1, #2
; CHECK-NEXT:    bx r2
  %1 = load ptr, ptr @fnptr3
  %2 = tail call i32 %1(i32 1, i32 2)
  ret i32 %2
}

; test6: params in r0 and r2-r3. r1 is free.
@fnptr4 = global ptr null
define i32 @test6() {
; CHECK-LABEL: test6:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    movw r0, :lower16:fnptr4
; CHECK-NEXT:    movt r0, :upper16:fnptr4
; CHECK-NEXT:    ldr r1, [r0]
; CHECK-NEXT:    movs r0, #1
; CHECK-NEXT:    movs r2, #2
; CHECK-NEXT:    movs r3, #0
; CHECK-NEXT:    bx r1
  %1 = load ptr, ptr @fnptr4
  %2 = tail call i32 %1(i32 1, i64 2)
  ret i32 %2
}

; Check that tail calls to functions other than function pointers are
; tail-call optimized.
define i32 @test7() {
; CHECK-LABEL: test7:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    movs r0, #1
; CHECK-NEXT:    movs r1, #2
; CHECK-NEXT:    movs r2, #3
; CHECK-NEXT:    movs r3, #4
; CHECK-NEXT:    b bar
  %tail = tail call i32 @bar(i32 1, i32 2, i32 3, i32 4)
  ret i32 %tail
}

declare i32 @bar(i32, i32, i32, i32)

; Regression test for failure to load indirect branch target (class tcGPR) from
; a stack slot.
%struct.S = type { i32 }

define void @test8(ptr nocapture %fn, i32 %x) local_unnamed_addr {
; CHECK-LABEL: test8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    push {r4, r5, r6, r7, lr}
; CHECK-NEXT:    sub sp, #4
; CHECK-NEXT:    mov r4, r1
; CHECK-NEXT:    str r0, [sp] @ 4-byte Spill
; CHECK-NEXT:    bl test8_u
; CHECK-NEXT:    mov r5, r0
; CHECK-NEXT:    ldr r6, [r0]
; CHECK-NEXT:    movs r7, #0
; CHECK-NEXT:    mov r0, r7
; CHECK-NEXT:    bl test8_h
; CHECK-NEXT:    mov r1, r0
; CHECK-NEXT:    mov r0, r6
; CHECK-NEXT:    mov r2, r7
; CHECK-NEXT:    bl test8_g
; CHECK-NEXT:    str r4, [r5]
; CHECK-NEXT:    movs r0, #1
; CHECK-NEXT:    movs r1, #2
; CHECK-NEXT:    movs r2, #3
; CHECK-NEXT:    ldr r3, [sp] @ 4-byte Reload
; CHECK-NEXT:    add sp, #4
; CHECK-NEXT:    ldr r4, [sp, #16]
; CHECK-NEXT:    mov lr, r4
; CHECK-NEXT:    pop {r4, r5, r6, r7}
; CHECK-NEXT:    add sp, #4
; CHECK-NEXT:    bx r3
entry:
  %call = tail call ptr @test8_u()
  %0 = load i32, ptr %call, align 4
  %call1 = tail call i32 @test8_h(i32 0)
  %call2 = tail call i32 @test8_g(i32 %0, i32 %call1, i32 0)
  store i32 %x, ptr %call, align 4
  %call4 = tail call i32 %fn(i32 1, i32 2, i32 3)
  ret void
}

declare ptr @test8_u(...)

declare i32 @test8_g(i32, i32, i32)

declare i32 @test8_h(i32)

; Check that we don't introduce an unnecessary spill of lr.
declare i32 @h9(i32, i32, i32, i32)
define i32 @test9(ptr %x, ptr %y, ptr %z, ptr %a) {
; CHECK-LABEL: test9:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    push {r4, r7}
; CHECK-NEXT:    ldr r4, [r3]
; CHECK-NEXT:    ldr r3, [r3, #4]
; CHECK-NEXT:    adds r3, r4, r3
; CHECK-NEXT:    ldr r1, [r1]
; CHECK-NEXT:    ldr r0, [r0]
; CHECK-NEXT:    ldr r2, [r2]
; CHECK-NEXT:    pop {r4, r7}
; CHECK-NEXT:    b h9
  %zz = load i32, ptr %z
  %xx = load i32, ptr %x
  %yy = load i32, ptr %y
  %aa1 = load i32, ptr %a
  %a2 = getelementptr i32, ptr %a, i32 1
  %aa2 = load i32, ptr %a2
  %aa = add i32 %aa1, %aa2
  %r = tail call i32 @h9(i32 %xx, i32 %yy, i32 %zz, i32 %aa)
  ret i32 %r
}
