#![warn(clippy::unit_hash)]
#![allow(clippy::let_unit_value)]

use std::collections::hash_map::DefaultHasher;
use std::hash::Hash;

enum Foo {
    Empty,
    WithValue(u8),
}

fn do_nothing() {}

fn main() {
    let mut state = DefaultHasher::new();
    let my_enum = Foo::Empty;

    match my_enum {
        Foo::Empty => ().hash(&mut state),
        //~^ ERROR: this call to `hash` on the unit type will do nothing
        //~| NOTE: the implementation of `Hash` for `()` is a no-op
        Foo::WithValue(x) => x.hash(&mut state),
    }

    let res = ();
    res.hash(&mut state);
    //~^ ERROR: this call to `hash` on the unit type will do nothing
    //~| NOTE: the implementation of `Hash` for `()` is a no-op

    #[allow(clippy::unit_arg)]
    do_nothing().hash(&mut state);
    //~^ ERROR: this call to `hash` on the unit type will do nothing
    //~| NOTE: the implementation of `Hash` for `()` is a no-op
}
