# GENERATED FILE, DO NOT EDIT DIRECTLY

# This file is automatically generated using https://codeberg.org/slidge/legacy-module-template/
# Its source is at:
# https://codeberg.org/slidge/legacy-module-template/src/branch/main/docs/source/conf/py.jinja
# Open a pull request for this repository instead, to benefit the documentation of all slidge-based gateways.

import os
from datetime import datetime
from pathlib import Path

from slidge import __version__ as slidge_version

project = "matridge"
copyright = f"{datetime.today().year}, the {project} contributors"
author = f"the {project} contributors"
branch = os.getenv("CI_COMMIT_BRANCH", "main")

extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.extlinks",
    "sphinx.ext.viewcode",
    "sphinx.ext.autodoc.typehints",
    "slidge_sphinx_extensions.doap",
    "slidge_sphinx_extensions.config_obj",
    "sphinx_mdinclude",
]

autodoc_typehints = "description"

# Include __init__ docstrings
autoclass_content = "both"

extlinks = {"xep": ("https://xmpp.org/extensions/xep-%s.html", "XEP-%s")}

html_theme = "furo"
html_theme_options = {
    "source_edit_link": f"https://codeberg.org/slidge/{project}/_edit/{branch}/docs/source/{{filename}}",
    "source_view_link": f"https://codeberg.org/slidge/{project}/src/branch/{branch}/docs/source/{{filename}}",
    "footer_icons": [
        {
            "name": "Codeberg",
            "url": f"https://codeberg.org/slidge/{project}",
            "html": Path("codeberg.svg").read_text(),
        },
    ],
}


rst_epilog = f"""
.. |slidge_version| replace:: {slidge_version}
"""
