# Project Steering Committee (PSC)

## Introduction

The Project Steering Committee (PSC) for the SFCGAL project plays a crucial role in guiding the development and strategic direction of the project. The PSC ensures that SFCGAL remains a high-quality and reliable spatial computational geometry library.

## Role and Responsibilities

The PSC is responsible for:
- **Strategic Direction**: Setting the long-term goals and vision for the project.
- **Development Oversight**: Reviewing and approving major changes and ensuring the project adheres to its objectives.
- **Community Engagement**: Encouraging community participation and managing contributions from various developers.
- **Release Management**: Overseeing the release process to ensure timely and stable releases.
- **Quality Assurance**: Maintaining high standards of code quality and documentation.

## PSC Members

The PSC consists of experienced contributors who have demonstrated a strong commitment to the SFCGAL project. Members are typically invited based on their contributions and involvement.

### Current Members

- **Loïc Bartoletti** (Chair)
- **Raphaël Delhome**
- **Jean Felder**

## Decision-Making Process

The PSC operates on a consensus-based model. Major decisions are discussed openly, and all members are encouraged to participate. If consensus cannot be reached, a majority vote will be used to make the final decision.

## Becoming a PSC Member

Potential PSC members are identified based on their contributions and engagement with the project. If you are interested in joining the PSC, you can express your interest by reaching out to any current member or participating actively in project discussions and contributions.

## Communication

The PSC communicates primarily through the project's mailing list and issue tracker. Regular meetings may be held to discuss important matters, and meeting minutes will be made available to the community.

## Contact

For any questions or to get in touch with the PSC, please use the following contact methods:
- **Infos**: [infos@sfcgal.org](mailto:infos@sfcgal.org)
- **Issue Tracker**: [SFCGAL Issues](https://gitlab.com/sfcgal/SFCGAL/-/issues)

Thank you for your interest in the SFCGAL project and for considering contributing to its development and governance.

## Additional Resources

- [SFCGAL Documentation](https://sfcgal.gitlab.io/SFCGAL/)
- [SFCGAL Source Code](https://gitlab.com/sfcgal/SFCGAL)
