# 2025-06-09 Triage Log

Mostly positive week, with a lot of improvements in the type system, especially in new solver and one big win in caching code. Regressions come from new warnings, with outsized impact on one benchmark with a lot of generated code.

Triage done by **@panstromek**.
Revision range: [2fc3deed..c31cccb7](https://perf.rust-lang.org/?start=2fc3deed9fcb8762ad57191e0195f06f7543e4a5&end=c31cccb7b5cc098b1a8c1794ed38d7fdbec0ccb0&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.1%  | [0.3%, 8.5%]    | 22    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 0.9%]    | 3     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-3.4%, -0.2%]  | 151   |
| Improvements ✅ <br /> (secondary) | -3.5% | [-66.5%, -0.2%] | 146   |
| All ❌✅ (primary)                 | -0.4% | [-3.4%, 8.5%]   | 173   |


3 Regressions, 6 Improvements, 5 Mixed; 2 of them in rollups
45 artifact comparisons made in total

#### Regressions

Use ccache for stage0 tool builds [#136942](https://github.com/rust-lang/rust/pull/136942) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2f176126aaf3fd316fc5ced3d9a111a48797b52c&end=aae43c4532690153af7465227816c93036bb1604&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.9% | [2.9%, 2.9%] | 1     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 2.9% | [2.9%, 2.9%] | 1     |

The regression is spurious, the affected benchmark is bi-modal.

Move placeholder handling to a proper preprocessing step [#140466](https://github.com/rust-lang/rust/pull/140466) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=81a964c23ea4fe9ab52b4449bb166bf280035797&end=425e142686242c7e73f5e32c79071ae266f0f355&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.1% | [0.1%, 0.1%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.2% | [0.2%, 0.3%] | 8     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.1% | [0.1%, 0.1%] | 1     |


These regressions look real. One tiny regression in Cargo and two secondary benchmarks - `coercions` and `ucd`, which are both based on giant static tables and are somewhat artificial.

According to a [comment by author](https://github.com/rust-lang/rust/pull/140466#issuecomment-2955437404), this PR doesn't change runtime behavour, so those are probably just spurious. Most of the benchmarks improved since then and some of them are a bit noisy at times.

This is a piece of larger important work (Polonius) and the regressions are pretty limited. [#130227](https://github.com/rust-lang/rust/pull/130227) (which this PR is part of) does have a bit different perf results, so I guess it will also make more sense asses the perf impact of this work when more pieces of it lands.

Add a new `mismatched-lifetime-syntaxes` lint [#138677](https://github.com/rust-lang/rust/pull/138677) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=076ec59ff1dcf538b9d3a0b8e0d7f4edd0559959&end=ccf3198de316b488ee17441935182e9d5292b4d3&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.6%  | [0.2%, 9.7%]   | 72    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.5%]   | 11    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 1     |
| All ❌✅ (primary)                 | 1.6%  | [0.2%, 9.7%]   | 72    |

Large regression on many benchmarks, most notably on `stm32f4`. Mostly caused by emitting more warnings. Author justified the regression in [an comment on the PR](https://github.com/rust-lang/rust/pull/138677#issuecomment-2940461051). Results and next steps are discussed in [dedicated zulip channel](https://rust-lang.zulipchat.com/#narrow/stream/131828-t-compiler/topic/Perf.20regression.20for.20warn-by-default.20lint).

#### Improvements

Change per-module naked fn checks to happen during typeck instead [#141774](https://github.com/rust-lang/rust/pull/141774) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9f0e5d963d05ebcf7ae1ca1f4bda3668c702acda&end=44f415c1d617ebc7b931a243b7b321ef8a6ca47c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.1%, -0.1%] | 11    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.2%] | 11    |
| All ❌✅ (primary)                 | -0.1% | [-0.1%, -0.1%] | 11    |


Rollup of 11 pull requests [#142133](https://github.com/rust-lang/rust/pull/142133) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=868bf2da31d1c6ead7016d5ee52eacfd2e2fd158&end=775e0c8aeb8f63192854b27156f8b05a06b51814&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.2%] | 8     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 4     |


Clear nested candidates in select if certainty is yes [#141927](https://github.com/rust-lang/rust/pull/141927) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5e0bdaa9dde845b8e44fd93bf0c09d21ca60daa1&end=2f2c8c3512e82e4315db83bbb53eb79e2c566270&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -     | -               | 0     |
| Improvements ✅ <br /> (secondary) | -3.5% | [-20.7%, -0.4%] | 11    |
| All ❌✅ (primary)                 | -     | -               | 0     |


Remove CollectItemTypesVisitor [#142074](https://github.com/rust-lang/rust/pull/142074) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a5584a8fe16037dc01782064fa41424a6dbe9987&end=0b65d0db5f77c44bf37b4a25489562d68c14aecf&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.1%, -0.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.4%, -0.1%] | 8     |
| All ❌✅ (primary)                 | -0.1% | [-0.1%, -0.1%] | 1     |


Filter out universals and lifetimes from `stalled_vars` [#142088](https://github.com/rust-lang/rust/pull/142088) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8072811356a178dbdf8ca09b1635cfafd4661971&end=244bbfc60ee8593db96892468eee876240cb7ba1&stat=instructions:u)

| (instructions:u)                   | mean   | range           | count |
|:----------------------------------:|:------:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -      | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -      | -               | 0     |
| Improvements ✅ <br /> (primary)   | -      | -               | 0     |
| Improvements ✅ <br /> (secondary) | -10.2% | [-29.8%, -0.1%] | 15    |
| All ❌✅ (primary)                 | -      | -               | 0     |


Simplify and optimize `VecCache`'s `SlotIndex::from_index` [#142095](https://github.com/rust-lang/rust/pull/142095) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=244bbfc60ee8593db96892468eee876240cb7ba1&end=fb644e6a1a7d34c6bbb5ecfe5c185f8c977d6bb3&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 4     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-3.4%, -0.2%] | 184   |
| Improvements ✅ <br /> (secondary) | -1.0% | [-4.8%, -0.2%] | 112   |
| All ❌✅ (primary)                 | -0.8% | [-3.4%, -0.2%] | 184   |


#### Mixed

Merge coroutine obligation checking into borrowck parallel loop [#141773](https://github.com/rust-lang/rust/pull/141773) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2fc3deed9fcb8762ad57191e0195f06f7543e4a5&end=91fad92585b2dafc52a074e502b2a6c1f093ca35&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.5%]   | 2     |
| Improvements ✅ <br /> (primary)   | -2.9% | [-2.9%, -2.9%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -2.9% | [-2.9%, -2.9%] | 1     |

Looks like noise, the affected benchmarks keep following similar pattern (`clap-derive` is bimodal, the other two secondary benchmarks are noisy).

Rollup of 8 pull requests [#141944](https://github.com/rust-lang/rust/pull/141944) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b17dba45186c454576d0fc8fb93ecc65eb1a763a&end=c68032fd4c442d275f4daa571ba19c076106b490&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.3%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.1%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.6% | [-1.1%, -0.2%] | 3     |

Few regressions in unused-warnings. This looks like noise to me for the most part - check and opt builds don't agree on whether frontend times regressed or not and the benchmark since returned to previous state (partly in another rollup).

I would suspect #141741 to be the cause, because it touched use statements and unused-warnings is a large list of use statements, but that one had different pre-merge results. I don't think this is worth digging into, though.

Rework `collect_and_apply` to not rely on size hint for optimization [#141652](https://github.com/rust-lang/rust/pull/141652) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=792fc2b033aea7ea7b766e38bdc40f7d6bdce8c3&end=d9a739363878a06633eb912e44f02a3c5d6ba08c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.4%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.4%, -0.1%] | 9     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.0%, -0.2%] | 49    |
| All ❌✅ (primary)                 | -0.2% | [-0.4%, -0.1%] | 9     |

Improvements outweigh regressions. Regressions are limited to `wg-grammar`. Also justified by [review comment](https://github.com/rust-lang/rust/pull/141652#issuecomment-2936239135).

Fast path for stalled obligations on self ty [#141681](https://github.com/rust-lang/rust/pull/141681) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f315e6145802e091ff9fceab6db627a4b4ec2b86&end=9f0e5d963d05ebcf7ae1ca1f4bda3668c702acda&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]    | 1     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.1%, 1.3%]    | 14    |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.1%]  | 25    |
| Improvements ✅ <br /> (secondary) | -4.3% | [-50.3%, -0.0%] | 43    |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, 0.2%]   | 26    |

Improvements outweigh regressions, those are mostly on stress tests. Some regressions also don't seem to be related, they just return back to state before [#141652](https://github.com/rust-lang/rust/pull/141652).

Don't walk into `Certainty::Yes` goals [#142085](https://github.com/rust-lang/rust/pull/142085) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0b65d0db5f77c44bf37b4a25489562d68c14aecf&end=8072811356a178dbdf8ca09b1635cfafd4661971&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.4%  | [1.4%, 1.4%]    | 1     |
| Regressions ❌ <br /> (secondary)  | 1.4%  | [1.4%, 1.4%]    | 1     |
| Improvements ✅ <br /> (primary)   | -     | -               | 0     |
| Improvements ✅ <br /> (secondary) | -8.7% | [-17.9%, -0.8%] | 6     |
| All ❌✅ (primary)                 | 1.4%  | [1.4%, 1.4%]    | 1     |

Syn regression is spurious, it's just returning to the default state in bimodal pattern.

Secondary regression is limited to new solver benchmark. New solver is not enabled by default, yet.
