--
-- Copyright 2025 The Android Open Source Project
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     https://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.

-- Device specific device curves with 2D dependency (i.e. curve characteristics
-- are dependent on another CPU policy). See go/wattson for more info.
CREATE PERFETTO TABLE _tg5_2d_lut_2 AS
WITH
  data(device, policy, freq_khz, dep_policy, dep_freq, static, active, idle0, idle1) AS (
    SELECT
      *
    FROM (VALUES
      ("Tensor G5", 7, 266000, 5, 177000, 0, 51.2, 27.72, 0),
      ("Tensor G5", 7, 266000, 5, 266000, 0, 51.82, 27.24, 0),
      ("Tensor G5", 7, 266000, 5, 400000, 0, 53.14, 26.99, 0),
      ("Tensor G5", 7, 266000, 5, 533000, 0, 55.57, 28.61, 0),
      ("Tensor G5", 7, 266000, 5, 652000, 0, 57.43, 29.59, 0),
      ("Tensor G5", 7, 266000, 5, 729000, 0, 59.68, 30.27, 0),
      ("Tensor G5", 7, 266000, 5, 921000, 0, 65.59, 32.64, 0),
      ("Tensor G5", 7, 266000, 5, 1075000, 0, 70.69, 34.8, 0),
      ("Tensor G5", 7, 266000, 5, 1267000, 0, 75.38, 37.14, 0),
      ("Tensor G5", 7, 266000, 5, 1401000, 0, 80.24, 38.8, 0),
      ("Tensor G5", 7, 266000, 5, 1536000, 0, 84.57, 40.91, 0),
      ("Tensor G5", 7, 266000, 5, 1670000, 0, 88.29, 42.95, 0),
      ("Tensor G5", 7, 266000, 5, 1785000, 0, 91.91, 44.21, 0),
      ("Tensor G5", 7, 266000, 5, 1862000, 0, 98.54, 46.74, 0),
      ("Tensor G5", 7, 266000, 5, 1939000, 0, 102.98, 48.88, 0),
      ("Tensor G5", 7, 266000, 5, 2092000, 0, 114.11, 53.39, 0),
      ("Tensor G5", 7, 266000, 5, 2188000, 0, 118.33, 55.88, 0),
      ("Tensor G5", 7, 266000, 5, 2284000, 0, 123.94, 58.88, 0),
      ("Tensor G5", 7, 266000, 5, 2400000, 0, 131.05, 61.73, 0),
      ("Tensor G5", 7, 266000, 5, 2534000, 0, 145.65, 68.25, 0),
      ("Tensor G5", 7, 266000, 5, 2688000, 0, 161.28, 75.26, 0),
      ("Tensor G5", 7, 266000, 5, 2841000, 0, 191.51, 91.92, 0),
      ("Tensor G5", 7, 266000, 5, 2937000, 0, 213.0, 105.41, 0),
      ("Tensor G5", 7, 266000, 5, 3052000, 0, 243.69, 122.72, 0),
      ("Tensor G5", 7, 400000, 5, 177000, 0, 70.99, 26.46, 0),
      ("Tensor G5", 7, 400000, 5, 266000, 0, 71.18, 26.37, 0),
      ("Tensor G5", 7, 400000, 5, 400000, 0, 71.93, 26.32, 0),
      ("Tensor G5", 7, 400000, 5, 533000, 0, 75.41, 27.69, 0),
      ("Tensor G5", 7, 400000, 5, 652000, 0, 78.97, 28.95, 0),
      ("Tensor G5", 7, 400000, 5, 729000, 0, 80.65, 29.36, 0),
      ("Tensor G5", 7, 400000, 5, 921000, 0, 87.34, 31.9, 0),
      ("Tensor G5", 7, 400000, 5, 1075000, 0, 93.52, 34.09, 0),
      ("Tensor G5", 7, 400000, 5, 1267000, 0, 100.36, 36.44, 0),
      ("Tensor G5", 7, 400000, 5, 1401000, 0, 105.24, 38.08, 0),
      ("Tensor G5", 7, 400000, 5, 1536000, 0, 111.59, 39.78, 0),
      ("Tensor G5", 7, 400000, 5, 1670000, 0, 116.74, 41.83, 0),
      ("Tensor G5", 7, 400000, 5, 1785000, 0, 120.48, 43.63, 0),
      ("Tensor G5", 7, 400000, 5, 1862000, 0, 128.02, 46.01, 0),
      ("Tensor G5", 7, 400000, 5, 1939000, 0, 135.7, 47.44, 0),
      ("Tensor G5", 7, 400000, 5, 2092000, 0, 146.73, 52.88, 0),
      ("Tensor G5", 7, 400000, 5, 2188000, 0, 154.09, 55.12, 0),
      ("Tensor G5", 7, 400000, 5, 2284000, 0, 162.8, 57.99, 0),
      ("Tensor G5", 7, 400000, 5, 2400000, 0, 171.08, 60.54, 0),
      ("Tensor G5", 7, 400000, 5, 2534000, 0, 188.77, 67.58, 0),
      ("Tensor G5", 7, 400000, 5, 2688000, 0, 206.36, 74.52, 0),
      ("Tensor G5", 7, 400000, 5, 2841000, 0, 243.85, 90.6, 0),
      ("Tensor G5", 7, 400000, 5, 2937000, 0, 273.68, 104.56, 0),
      ("Tensor G5", 7, 400000, 5, 3052000, 0, 306.47, 121.9, 0),
      ("Tensor G5", 7, 533000, 5, 177000, 0, 86.84, 25.15, 0),
      ("Tensor G5", 7, 533000, 5, 266000, 0, 85.92, 26.0, 0),
      ("Tensor G5", 7, 533000, 5, 400000, 0, 86.85, 25.82, 0),
      ("Tensor G5", 7, 533000, 5, 533000, 0, 90.02, 27.16, 0),
      ("Tensor G5", 7, 533000, 5, 652000, 0, 94.57, 28.54, 0),
      ("Tensor G5", 7, 533000, 5, 729000, 0, 98.27, 28.19, 0),
      ("Tensor G5", 7, 533000, 5, 921000, 0, 107.03, 30.71, 0),
      ("Tensor G5", 7, 533000, 5, 1075000, 0, 113.27, 33.64, 0),
      ("Tensor G5", 7, 533000, 5, 1267000, 0, 123.63, 35.61, 0),
      ("Tensor G5", 7, 533000, 5, 1401000, 0, 130.18, 37.15, 0),
      ("Tensor G5", 7, 533000, 5, 1536000, 0, 134.83, 39.69, 0),
      ("Tensor G5", 7, 533000, 5, 1670000, 0, 139.28, 41.59, 0),
      ("Tensor G5", 7, 533000, 5, 1785000, 0, 146.0, 42.48, 0),
      ("Tensor G5", 7, 533000, 5, 1862000, 0, 154.85, 44.04, 0),
      ("Tensor G5", 7, 533000, 5, 1939000, 0, 165.86, 47.62, 0),
      ("Tensor G5", 7, 533000, 5, 2092000, 0, 178.72, 51.53, 0),
      ("Tensor G5", 7, 533000, 5, 2188000, 0, 186.42, 54.72, 0),
      ("Tensor G5", 7, 533000, 5, 2284000, 0, 0, 55.44, 0),
      ("Tensor G5", 7, 533000, 5, 2400000, 0, 0, 59.69, 0),
      ("Tensor G5", 7, 533000, 5, 2534000, 0, 0, 67.13, 0),
      ("Tensor G5", 7, 533000, 5, 2688000, 0, 0, 75.87, 0),
      ("Tensor G5", 7, 533000, 5, 2841000, 0, 0, 87.65, 0),
      ("Tensor G5", 7, 533000, 5, 2937000, 0, 0, 103.52, 0),
      ("Tensor G5", 7, 533000, 5, 3052000, 0, 366.64, 121.1, 0),
      ("Tensor G5", 7, 800000, 5, 177000, 0, 120.54, 26.07, 0),
      ("Tensor G5", 7, 800000, 5, 266000, 0, 122.76, 26.14, 0),
      ("Tensor G5", 7, 800000, 5, 400000, 0, 119.64, 27.09, 0),
      ("Tensor G5", 7, 800000, 5, 533000, 0, 115.66, 27.44, 0),
      ("Tensor G5", 7, 800000, 5, 652000, 0, 126.53, 27.29, 0),
      ("Tensor G5", 7, 800000, 5, 729000, 0, 124.87, 28.67, 0),
      ("Tensor G5", 7, 800000, 5, 921000, 0, 141.11, 30.2, 0),
      ("Tensor G5", 7, 800000, 5, 1075000, 0, 143.08, 33.64, 0),
      ("Tensor G5", 7, 800000, 5, 1267000, 0, 159.6, 34.7, 0),
      ("Tensor G5", 7, 800000, 5, 1401000, 0, 165.37, 36.34, 0),
      ("Tensor G5", 7, 800000, 5, 1536000, 0, 177.27, 38.16, 0),
      ("Tensor G5", 7, 800000, 5, 1670000, 0, 181.43, 40.1, 0),
      ("Tensor G5", 7, 800000, 5, 1785000, 0, 191.72, 41.4, 0),
      ("Tensor G5", 7, 800000, 5, 1862000, 0, 195.83, 45.68, 0),
      ("Tensor G5", 7, 800000, 5, 1939000, 0, 206.23, 47.97, 0),
      ("Tensor G5", 7, 800000, 5, 2092000, 0, 224.12, 52.21, 0),
      ("Tensor G5", 7, 800000, 5, 2188000, 0, 235.98, 55.1, 0),
      ("Tensor G5", 7, 800000, 5, 2284000, 0, 248.66, 55.23, 0),
      ("Tensor G5", 7, 800000, 5, 2400000, 0, 266.57, 58.03, 0),
      ("Tensor G5", 7, 800000, 5, 2534000, 0, 283.36, 67.23, 0),
      ("Tensor G5", 7, 800000, 5, 2688000, 0, 319.95, 74.48, 0),
      ("Tensor G5", 7, 800000, 5, 2841000, 0, 366.67, 90.46, 0),
      ("Tensor G5", 7, 800000, 5, 2937000, 0, 414.14, 104.4, 0),
      ("Tensor G5", 7, 800000, 5, 3052000, 0, 449.36, 126.56, 0),
      ("Tensor G5", 7, 883000, 5, 177000, 0, 132.5, 28.31, 0),
      ("Tensor G5", 7, 883000, 5, 266000, 0, 130.58, 27.14, 0),
      ("Tensor G5", 7, 883000, 5, 400000, 0, 129.8, 28.05, 0),
      ("Tensor G5", 7, 883000, 5, 533000, 0, 131.0, 27.2, 0),
      ("Tensor G5", 7, 883000, 5, 652000, 0, 130.17, 28.56, 0),
      ("Tensor G5", 7, 883000, 5, 729000, 0, 131.98, 29.04, 0),
      ("Tensor G5", 7, 883000, 5, 921000, 0, 151.36, 30.46, 0),
      ("Tensor G5", 7, 883000, 5, 1075000, 0, 151.45, 33.93, 0),
      ("Tensor G5", 7, 883000, 5, 1267000, 0, 170.65, 35.53, 0),
      ("Tensor G5", 7, 883000, 5, 1401000, 0, 173.46, 36.5, 0),
      ("Tensor G5", 7, 883000, 5, 1536000, 0, 185.58, 38.36, 0),
      ("Tensor G5", 7, 883000, 5, 1670000, 0, 189.47, 42.62, 0),
      ("Tensor G5", 7, 883000, 5, 1785000, 0, 198.91, 43.46, 0),
      ("Tensor G5", 7, 883000, 5, 1862000, 0, 211.99, 45.53, 0),
      ("Tensor G5", 7, 883000, 5, 1939000, 0, 232.41, 46.95, 0),
      ("Tensor G5", 7, 883000, 5, 2092000, 0, 244.78, 50.67, 0),
      ("Tensor G5", 7, 883000, 5, 2188000, 0, 250.05, 55.52, 0),
      ("Tensor G5", 7, 883000, 5, 2284000, 0, 263.23, 58.16, 0),
      ("Tensor G5", 7, 883000, 5, 2400000, 0, 284.7, 59.03, 0),
      ("Tensor G5", 7, 883000, 5, 2534000, 0, 306.12, 68.03, 0),
      ("Tensor G5", 7, 883000, 5, 2688000, 0, 344.19, 72.35, 0),
      ("Tensor G5", 7, 883000, 5, 2841000, 0, 388.8, 91.62, 0),
      ("Tensor G5", 7, 883000, 5, 2937000, 0, 444.06, 104.42, 0),
      ("Tensor G5", 7, 883000, 5, 3052000, 0, 493.66, 118.55, 0),
      ("Tensor G5", 7, 1036000, 5, 177000, 0, 156.84, 28.63, 0),
      ("Tensor G5", 7, 1036000, 5, 266000, 0, 151.54, 28.51, 0),
      ("Tensor G5", 7, 1036000, 5, 400000, 0, 152.76, 29.33, 0),
      ("Tensor G5", 7, 1036000, 5, 533000, 0, 150.44, 29.75, 0),
      ("Tensor G5", 7, 1036000, 5, 652000, 0, 157.3, 28.65, 0),
      ("Tensor G5", 7, 1036000, 5, 729000, 0, 148.58, 30.31, 0),
      ("Tensor G5", 7, 1036000, 5, 921000, 0, 165.9, 30.75, 0),
      ("Tensor G5", 7, 1036000, 5, 1075000, 0, 171.34, 32.88, 0),
      ("Tensor G5", 7, 1036000, 5, 1267000, 0, 186.69, 36.36, 0),
      ("Tensor G5", 7, 1036000, 5, 1401000, 0, 191.25, 36.71, 0),
      ("Tensor G5", 7, 1036000, 5, 1536000, 0, 202.16, 40.46, 0),
      ("Tensor G5", 7, 1036000, 5, 1670000, 0, 210.98, 40.96, 0),
      ("Tensor G5", 7, 1036000, 5, 1785000, 0, 220.45, 41.96, 0),
      ("Tensor G5", 7, 1036000, 5, 1862000, 0, 233.13, 44.8, 0),
      ("Tensor G5", 7, 1036000, 5, 1939000, 0, 246.73, 48.6, 0),
      ("Tensor G5", 7, 1036000, 5, 2092000, 0, 269.18, 50.99, 0),
      ("Tensor G5", 7, 1036000, 5, 2188000, 0, 290.94, 53.55, 0),
      ("Tensor G5", 7, 1036000, 5, 2284000, 0, 289.32, 58.66, 0),
      ("Tensor G5", 7, 1036000, 5, 2400000, 0, 309.73, 60.92, 0),
      ("Tensor G5", 7, 1036000, 5, 2534000, 0, 355.28, 65.54, 0),
      ("Tensor G5", 7, 1036000, 5, 2688000, 0, 374.11, 75.3, 0),
      ("Tensor G5", 7, 1036000, 5, 2841000, 0, 447.49, 92.03, 0),
      ("Tensor G5", 7, 1036000, 5, 2937000, 0, 486.93, 105.22, 0),
      ("Tensor G5", 7, 1036000, 5, 3052000, 0, 546.53, 120.64, 0),
      ("Tensor G5", 7, 1152000, 5, 177000, 0, 178.12, 29.74, 0),
      ("Tensor G5", 7, 1152000, 5, 266000, 0, 175.1, 30.0, 0),
      ("Tensor G5", 7, 1152000, 5, 400000, 0, 176.01, 29.75, 0),
      ("Tensor G5", 7, 1152000, 5, 533000, 0, 176.65, 29.7, 0),
      ("Tensor G5", 7, 1152000, 5, 652000, 0, 172.76, 30.59, 0),
      ("Tensor G5", 7, 1152000, 5, 729000, 0, 176.23, 30.34, 0),
      ("Tensor G5", 7, 1152000, 5, 921000, 0, 174.95, 30.77, 0),
      ("Tensor G5", 7, 1152000, 5, 1075000, 0, 185.11, 33.86, 0),
      ("Tensor G5", 7, 1152000, 5, 1267000, 0, 202.11, 35.39, 0),
      ("Tensor G5", 7, 1152000, 5, 1401000, 0, 212.87, 36.64, 0),
      ("Tensor G5", 7, 1152000, 5, 1536000, 0, 217.35, 38.45, 0),
      ("Tensor G5", 7, 1152000, 5, 1670000, 0, 235.37, 40.55, 0),
      ("Tensor G5", 7, 1152000, 5, 1785000, 0, 235.68, 43.5, 0),
      ("Tensor G5", 7, 1152000, 5, 1862000, 0, 259.9, 44.37, 0),
      ("Tensor G5", 7, 1152000, 5, 1939000, 0, 269.77, 46.48, 0),
      ("Tensor G5", 7, 1152000, 5, 2092000, 0, 289.72, 53.39, 0),
      ("Tensor G5", 7, 1152000, 5, 2188000, 0, 308.76, 53.57, 0),
      ("Tensor G5", 7, 1152000, 5, 2284000, 0, 325.39, 55.94, 0),
      ("Tensor G5", 7, 1152000, 5, 2400000, 0, 330.07, 58.81, 0),
      ("Tensor G5", 7, 1152000, 5, 2534000, 0, 379.01, 66.59, 0),
      ("Tensor G5", 7, 1152000, 5, 2688000, 0, 405.14, 72.41, 0),
      ("Tensor G5", 7, 1152000, 5, 2841000, 0, 471.8, 91.26, 0),
      ("Tensor G5", 7, 1152000, 5, 2937000, 0, 528.13, 102.63, 0),
      ("Tensor G5", 7, 1152000, 5, 3052000, 0, 592.55, 123.17, 0),
      ("Tensor G5", 7, 1305000, 5, 177000, 0, 206.0, 33.03, 0),
      ("Tensor G5", 7, 1305000, 5, 266000, 0, 209.61, 31.71, 0),
      ("Tensor G5", 7, 1305000, 5, 400000, 0, 196.38, 31.72, 0),
      ("Tensor G5", 7, 1305000, 5, 533000, 0, 201.55, 33.25, 0),
      ("Tensor G5", 7, 1305000, 5, 652000, 0, 203.34, 32.84, 0),
      ("Tensor G5", 7, 1305000, 5, 729000, 0, 207.76, 32.51, 0),
      ("Tensor G5", 7, 1305000, 5, 921000, 0, 195.66, 32.98, 0),
      ("Tensor G5", 7, 1305000, 5, 1075000, 0, 206.9, 32.87, 0),
      ("Tensor G5", 7, 1305000, 5, 1267000, 0, 222.51, 35.04, 0),
      ("Tensor G5", 7, 1305000, 5, 1401000, 0, 228.32, 38.14, 0),
      ("Tensor G5", 7, 1305000, 5, 1536000, 0, 243.44, 39.08, 0),
      ("Tensor G5", 7, 1305000, 5, 1670000, 0, 260.22, 41.21, 0),
      ("Tensor G5", 7, 1305000, 5, 1785000, 0, 260.4, 43.11, 0),
      ("Tensor G5", 7, 1305000, 5, 1862000, 0, 282.85, 44.87, 0),
      ("Tensor G5", 7, 1305000, 5, 1939000, 0, 290.94, 46.8, 0),
      ("Tensor G5", 7, 1305000, 5, 2092000, 0, 314.77, 55.51, 0),
      ("Tensor G5", 7, 1305000, 5, 2188000, 0, 322.39, 54.62, 0),
      ("Tensor G5", 7, 1305000, 5, 2284000, 0, 355.52, 57.03, 0),
      ("Tensor G5", 7, 1305000, 5, 2400000, 0, 363.86, 58.99, 0),
      ("Tensor G5", 7, 1305000, 5, 2534000, 0, 393.56, 66.2, 0),
      ("Tensor G5", 7, 1305000, 5, 2688000, 0, 436.48, 75.88, 0),
      ("Tensor G5", 7, 1305000, 5, 2841000, 0, 516.99, 92.28, 0),
      ("Tensor G5", 7, 1305000, 5, 2937000, 0, 572.41, 101.99, 0),
      ("Tensor G5", 7, 1305000, 5, 3052000, 0, 655.68, 119.01, 0),
      ("Tensor G5", 7, 1420000, 5, 177000, 0, 236.11, 33.77, 0),
      ("Tensor G5", 7, 1420000, 5, 266000, 0, 232.09, 33.67, 0),
      ("Tensor G5", 7, 1420000, 5, 400000, 0, 234.07, 34.25, 0),
      ("Tensor G5", 7, 1420000, 5, 533000, 0, 232.02, 33.97, 0),
      ("Tensor G5", 7, 1420000, 5, 652000, 0, 234.54, 35.05, 0),
      ("Tensor G5", 7, 1420000, 5, 729000, 0, 223.7, 36.17, 0),
      ("Tensor G5", 7, 1420000, 5, 921000, 0, 234.65, 35.16, 0),
      ("Tensor G5", 7, 1420000, 5, 1075000, 0, 228.58, 36.32, 0),
      ("Tensor G5", 7, 1420000, 5, 1267000, 0, 234.83, 35.24, 0),
      ("Tensor G5", 7, 1420000, 5, 1401000, 0, 245.99, 36.79, 0),
      ("Tensor G5", 7, 1420000, 5, 1536000, 0, 256.67, 39.78, 0),
      ("Tensor G5", 7, 1420000, 5, 1670000, 0, 274.77, 40.58, 0),
      ("Tensor G5", 7, 1420000, 5, 1785000, 0, 265.94, 42.09, 0),
      ("Tensor G5", 7, 1420000, 5, 1862000, 0, 305.33, 44.64, 0),
      ("Tensor G5", 7, 1420000, 5, 1939000, 0, 309.79, 47.46, 0),
      ("Tensor G5", 7, 1420000, 5, 2092000, 0, 340.75, 51.34, 0),
      ("Tensor G5", 7, 1420000, 5, 2188000, 0, 341.58, 53.84, 0),
      ("Tensor G5", 7, 1420000, 5, 2284000, 0, 376.85, 56.21, 0),
      ("Tensor G5", 7, 1420000, 5, 2400000, 0, 383.0, 61.93, 0),
      ("Tensor G5", 7, 1420000, 5, 2534000, 0, 433.95, 65.92, 0),
      ("Tensor G5", 7, 1420000, 5, 2688000, 0, 479.61, 73.17, 0),
      ("Tensor G5", 7, 1420000, 5, 2841000, 0, 527.26, 90.02, 0),
      ("Tensor G5", 7, 1420000, 5, 2937000, 0, 616.15, 105.13, 0),
      ("Tensor G5", 7, 1420000, 5, 3052000, 0, 665.23, 124.37, 0),
      ("Tensor G5", 7, 1593000, 5, 177000, 0, 265.47, 35.96, 0),
      ("Tensor G5", 7, 1593000, 5, 266000, 0, 261.52, 35.41, 0),
      ("Tensor G5", 7, 1593000, 5, 400000, 0, 262.9, 35.89, 0),
      ("Tensor G5", 7, 1593000, 5, 533000, 0, 259.88, 35.46, 0),
      ("Tensor G5", 7, 1593000, 5, 652000, 0, 259.91, 37.91, 0),
      ("Tensor G5", 7, 1593000, 5, 729000, 0, 259.47, 36.25, 0),
      ("Tensor G5", 7, 1593000, 5, 921000, 0, 264.24, 36.7, 0),
      ("Tensor G5", 7, 1593000, 5, 1075000, 0, 262.45, 36.58, 0),
      ("Tensor G5", 7, 1593000, 5, 1267000, 0, 254.84, 37.36, 0),
      ("Tensor G5", 7, 1593000, 5, 1401000, 0, 245.49, 38.48, 0),
      ("Tensor G5", 7, 1593000, 5, 1536000, 0, 283.89, 39.08, 0),
      ("Tensor G5", 7, 1593000, 5, 1670000, 0, 291.15, 41.08, 0),
      ("Tensor G5", 7, 1593000, 5, 1785000, 0, 296.56, 42.75, 0),
      ("Tensor G5", 7, 1593000, 5, 1862000, 0, 325.67, 45.21, 0),
      ("Tensor G5", 7, 1593000, 5, 1939000, 0, 335.5, 47.03, 0),
      ("Tensor G5", 7, 1593000, 5, 2092000, 0, 365.91, 51.79, 0),
      ("Tensor G5", 7, 1593000, 5, 2188000, 0, 384.29, 54.53, 0),
      ("Tensor G5", 7, 1593000, 5, 2284000, 0, 405.42, 57.27, 0),
      ("Tensor G5", 7, 1593000, 5, 2400000, 0, 427.69, 59.47, 0),
      ("Tensor G5", 7, 1593000, 5, 2534000, 0, 468.16, 66.17, 0),
      ("Tensor G5", 7, 1593000, 5, 2688000, 0, 496.26, 74.05, 0),
      ("Tensor G5", 7, 1593000, 5, 2841000, 0, 587.98, 91.33, 0),
      ("Tensor G5", 7, 1593000, 5, 2937000, 0, 652.26, 102.81, 0),
      ("Tensor G5", 7, 1593000, 5, 3052000, 0, 718.81, 120.84, 0),
      ("Tensor G5", 7, 1766000, 5, 177000, 0, 280.59, 37.12, 0),
      ("Tensor G5", 7, 1766000, 5, 266000, 0, 303.38, 37.12, 0),
      ("Tensor G5", 7, 1766000, 5, 400000, 0, 295.04, 37.21, 0),
      ("Tensor G5", 7, 1766000, 5, 533000, 0, 303.66, 37.24, 0),
      ("Tensor G5", 7, 1766000, 5, 652000, 0, 302.21, 37.81, 0),
      ("Tensor G5", 7, 1766000, 5, 729000, 0, 299.55, 38.22, 0),
      ("Tensor G5", 7, 1766000, 5, 921000, 0, 298.38, 38.5, 0),
      ("Tensor G5", 7, 1766000, 5, 1075000, 0, 297.9, 38.44, 0),
      ("Tensor G5", 7, 1766000, 5, 1267000, 0, 289.11, 39.31, 0),
      ("Tensor G5", 7, 1766000, 5, 1401000, 0, 296.83, 38.8, 0),
      ("Tensor G5", 7, 1766000, 5, 1536000, 0, 301.05, 39.7, 0),
      ("Tensor G5", 7, 1766000, 5, 1670000, 0, 314.23, 41.21, 0),
      ("Tensor G5", 7, 1766000, 5, 1785000, 0, 302.99, 42.92, 0),
      ("Tensor G5", 7, 1766000, 5, 1862000, 0, 339.53, 45.82, 0),
      ("Tensor G5", 7, 1766000, 5, 1939000, 0, 362.59, 47.8, 0),
      ("Tensor G5", 7, 1766000, 5, 2092000, 0, 393.72, 51.48, 0),
      ("Tensor G5", 7, 1766000, 5, 2188000, 0, 423.54, 53.96, 0),
      ("Tensor G5", 7, 1766000, 5, 2284000, 0, 406.29, 58.29, 0),
      ("Tensor G5", 7, 1766000, 5, 2400000, 0, 468.06, 59.63, 0),
      ("Tensor G5", 7, 1766000, 5, 2534000, 0, 494.42, 66.81, 0),
      ("Tensor G5", 7, 1766000, 5, 2688000, 0, 530.79, 76.13, 0),
      ("Tensor G5", 7, 1766000, 5, 2841000, 0, 616.92, 93.85, 0),
      ("Tensor G5", 7, 1766000, 5, 2937000, 0, 712.46, 102.92, 0),
      ("Tensor G5", 7, 1766000, 5, 3052000, 0, 789.5, 121.76, 0),
      ("Tensor G5", 7, 1920000, 5, 177000, 0, 332.58, 38.6, 0),
      ("Tensor G5", 7, 1920000, 5, 266000, 0, 323.21, 39.29, 0),
      ("Tensor G5", 7, 1920000, 5, 400000, 0, 325.09, 38.98, 0),
      ("Tensor G5", 7, 1920000, 5, 533000, 0, 328.51, 39.28, 0),
      ("Tensor G5", 7, 1920000, 5, 652000, 0, 325.0, 39.92, 0),
      ("Tensor G5", 7, 1920000, 5, 729000, 0, 321.69, 40.06, 0),
      ("Tensor G5", 7, 1920000, 5, 921000, 0, 323.16, 39.96, 0),
      ("Tensor G5", 7, 1920000, 5, 1075000, 0, 332.68, 40.43, 0),
      ("Tensor G5", 7, 1920000, 5, 1267000, 0, 328.36, 41.06, 0),
      ("Tensor G5", 7, 1920000, 5, 1401000, 0, 316.36, 41.76, 0),
      ("Tensor G5", 7, 1920000, 5, 1536000, 0, 327.09, 41.45, 0),
      ("Tensor G5", 7, 1920000, 5, 1670000, 0, 330.43, 43.64, 0),
      ("Tensor G5", 7, 1920000, 5, 1785000, 0, 334.34, 42.79, 0),
      ("Tensor G5", 7, 1920000, 5, 1862000, 0, 363.3, 45.29, 0),
      ("Tensor G5", 7, 1920000, 5, 1939000, 0, 394.3, 47.41, 0),
      ("Tensor G5", 7, 1920000, 5, 2092000, 0, 411.27, 52.67, 0),
      ("Tensor G5", 7, 1920000, 5, 2188000, 0, 435.46, 55.29, 0),
      ("Tensor G5", 7, 1920000, 5, 2284000, 0, 458.1, 58.39, 0),
      ("Tensor G5", 7, 1920000, 5, 2400000, 0, 494.3, 59.94, 0),
      ("Tensor G5", 7, 1920000, 5, 2534000, 0, 531.61, 67.75, 0),
      ("Tensor G5", 7, 1920000, 5, 2688000, 0, 568.05, 74.1, 0),
      ("Tensor G5", 7, 1920000, 5, 2841000, 0, 670.54, 90.67, 0),
      ("Tensor G5", 7, 1920000, 5, 2937000, 0, 718.25, 103.09, 0),
      ("Tensor G5", 7, 1920000, 5, 3052000, 0, 832.39, 121.4, 0),
      ("Tensor G5", 7, 2073000, 5, 177000, 0, 363.7, 40.12, 0),
      ("Tensor G5", 7, 2073000, 5, 266000, 0, 349.24, 40.2, 0),
      ("Tensor G5", 7, 2073000, 5, 400000, 0, 359.11, 40.24, 0),
      ("Tensor G5", 7, 2073000, 5, 533000, 0, 342.85, 40.86, 0),
      ("Tensor G5", 7, 2073000, 5, 652000, 0, 356.73, 40.76, 0),
      ("Tensor G5", 7, 2073000, 5, 729000, 0, 362.21, 41.05, 0),
      ("Tensor G5", 7, 2073000, 5, 921000, 0, 355.09, 42.41, 0),
      ("Tensor G5", 7, 2073000, 5, 1075000, 0, 348.97, 41.59, 0),
      ("Tensor G5", 7, 2073000, 5, 1267000, 0, 356.04, 42.81, 0),
      ("Tensor G5", 7, 2073000, 5, 1401000, 0, 338.42, 42.69, 0),
      ("Tensor G5", 7, 2073000, 5, 1536000, 0, 351.92, 42.9, 0),
      ("Tensor G5", 7, 2073000, 5, 1670000, 0, 356.18, 42.84, 0),
      ("Tensor G5", 7, 2073000, 5, 1785000, 0, 366.09, 43.75, 0),
      ("Tensor G5", 7, 2073000, 5, 1862000, 0, 374.5, 46.27, 0),
      ("Tensor G5", 7, 2073000, 5, 1939000, 0, 397.59, 48.48, 0),
      ("Tensor G5", 7, 2073000, 5, 2092000, 0, 448.09, 52.3, 0),
      ("Tensor G5", 7, 2073000, 5, 2188000, 0, 431.73, 54.64, 0),
      ("Tensor G5", 7, 2073000, 5, 2284000, 0, 492.31, 57.19, 0),
      ("Tensor G5", 7, 2073000, 5, 2400000, 0, 502.14, 61.52, 0),
      ("Tensor G5", 7, 2073000, 5, 2534000, 0, 552.46, 67.59, 0),
      ("Tensor G5", 7, 2073000, 5, 2688000, 0, 616.1, 75.54, 0),
      ("Tensor G5", 7, 2073000, 5, 2841000, 0, 710.16, 92.09, 0),
      ("Tensor G5", 7, 2073000, 5, 2937000, 0, 780.86, 103.54, 0),
      ("Tensor G5", 7, 2073000, 5, 3052000, 0, 889.63, 122.34, 0),
      ("Tensor G5", 7, 2208000, 5, 177000, 0, 406.47, 43.66, 0),
      ("Tensor G5", 7, 2208000, 5, 266000, 0, 391.08, 44.39, 0),
      ("Tensor G5", 7, 2208000, 5, 400000, 0, 381.36, 43.95, 0),
      ("Tensor G5", 7, 2208000, 5, 533000, 0, 396.63, 43.85, 0),
      ("Tensor G5", 7, 2208000, 5, 652000, 0, 393.28, 47.14, 0),
      ("Tensor G5", 7, 2208000, 5, 729000, 0, 399.44, 44.54, 0),
      ("Tensor G5", 7, 2208000, 5, 921000, 0, 408.61, 44.87, 0),
      ("Tensor G5", 7, 2208000, 5, 1075000, 0, 379.87, 45.29, 0),
      ("Tensor G5", 7, 2208000, 5, 1267000, 0, 401.59, 45.26, 0),
      ("Tensor G5", 7, 2208000, 5, 1401000, 0, 405.85, 45.7, 0),
      ("Tensor G5", 7, 2208000, 5, 1536000, 0, 401.0, 46.1, 0),
      ("Tensor G5", 7, 2208000, 5, 1670000, 0, 395.45, 47.37, 0),
      ("Tensor G5", 7, 2208000, 5, 1785000, 0, 384.38, 46.32, 0),
      ("Tensor G5", 7, 2208000, 5, 1862000, 0, 398.61, 48.28, 0),
      ("Tensor G5", 7, 2208000, 5, 1939000, 0, 409.76, 49.26, 0),
      ("Tensor G5", 7, 2208000, 5, 2092000, 0, 470.62, 52.38, 0),
      ("Tensor G5", 7, 2208000, 5, 2188000, 0, 475.12, 55.67, 0),
      ("Tensor G5", 7, 2208000, 5, 2284000, 0, 480.36, 57.85, 0),
      ("Tensor G5", 7, 2208000, 5, 2400000, 0, 518.46, 60.24, 0),
      ("Tensor G5", 7, 2208000, 5, 2534000, 0, 591.13, 68.98, 0),
      ("Tensor G5", 7, 2208000, 5, 2688000, 0, 642.56, 74.56, 0),
      ("Tensor G5", 7, 2208000, 5, 2841000, 0, 687.4, 91.61, 0),
      ("Tensor G5", 7, 2208000, 5, 2937000, 0, 761.67, 103.84, 0),
      ("Tensor G5", 7, 2208000, 5, 3052000, 0, 873.3, 123.49, 0),
      ("Tensor G5", 7, 2342000, 5, 177000, 0, 461.44, 47.17, 0),
      ("Tensor G5", 7, 2342000, 5, 266000, 0, 455.77, 47.34, 0),
      ("Tensor G5", 7, 2342000, 5, 400000, 0, 456.2, 47.3, 0),
      ("Tensor G5", 7, 2342000, 5, 533000, 0, 446.95, 47.76, 0),
      ("Tensor G5", 7, 2342000, 5, 652000, 0, 455.7, 47.71, 0),
      ("Tensor G5", 7, 2342000, 5, 729000, 0, 443.69, 48.47, 0),
      ("Tensor G5", 7, 2342000, 5, 921000, 0, 444.26, 48.32, 0),
      ("Tensor G5", 7, 2342000, 5, 1075000, 0, 442.18, 49.0, 0),
      ("Tensor G5", 7, 2342000, 5, 1267000, 0, 441.94, 49.45, 0),
      ("Tensor G5", 7, 2342000, 5, 1401000, 0, 445.18, 49.47, 0),
      ("Tensor G5", 7, 2342000, 5, 1536000, 0, 459.07, 49.29, 0),
      ("Tensor G5", 7, 2342000, 5, 1670000, 0, 456.34, 50.35, 0),
      ("Tensor G5", 7, 2342000, 5, 1785000, 0, 451.88, 49.75, 0),
      ("Tensor G5", 7, 2342000, 5, 1862000, 0, 448.62, 50.18, 0),
      ("Tensor G5", 7, 2342000, 5, 1939000, 0, 451.57, 51.31, 0),
      ("Tensor G5", 7, 2342000, 5, 2092000, 0, 486.42, 52.48, 0),
      ("Tensor G5", 7, 2342000, 5, 2188000, 0, 505.71, 55.32, 0),
      ("Tensor G5", 7, 2342000, 5, 2284000, 0, 512.77, 58.72, 0),
      ("Tensor G5", 7, 2342000, 5, 2400000, 0, 528.61, 61.35, 0),
      ("Tensor G5", 7, 2342000, 5, 2534000, 0, 591.33, 67.86, 0),
      ("Tensor G5", 7, 2342000, 5, 2688000, 0, 652.7, 75.0, 0),
      ("Tensor G5", 7, 2342000, 5, 2841000, 0, 766.34, 91.73, 0),
      ("Tensor G5", 7, 2342000, 5, 2937000, 0, 857.24, 104.75, 0),
      ("Tensor G5", 7, 2342000, 5, 3052000, 0, 930.58, 122.71, 0),
      ("Tensor G5", 7, 2457000, 5, 177000, 0, 497.82, 50.2, 0),
      ("Tensor G5", 7, 2457000, 5, 266000, 0, 504.86, 50.33, 0),
      ("Tensor G5", 7, 2457000, 5, 400000, 0, 499.21, 51.36, 0),
      ("Tensor G5", 7, 2457000, 5, 533000, 0, 496.54, 51.38, 0),
      ("Tensor G5", 7, 2457000, 5, 652000, 0, 489.68, 52.41, 0),
      ("Tensor G5", 7, 2457000, 5, 729000, 0, 512.97, 51.73, 0),
      ("Tensor G5", 7, 2457000, 5, 921000, 0, 500.67, 52.11, 0),
      ("Tensor G5", 7, 2457000, 5, 1075000, 0, 498.25, 52.16, 0),
      ("Tensor G5", 7, 2457000, 5, 1267000, 0, 507.43, 53.22, 0),
      ("Tensor G5", 7, 2457000, 5, 1401000, 0, 475.89, 53.3, 0),
      ("Tensor G5", 7, 2457000, 5, 1536000, 0, 501.36, 53.43, 0),
      ("Tensor G5", 7, 2457000, 5, 1670000, 0, 496.23, 53.67, 0),
      ("Tensor G5", 7, 2457000, 5, 1785000, 0, 489.72, 53.69, 0),
      ("Tensor G5", 7, 2457000, 5, 1862000, 0, 474.74, 54.68, 0),
      ("Tensor G5", 7, 2457000, 5, 1939000, 0, 494.42, 55.16, 0),
      ("Tensor G5", 7, 2457000, 5, 2092000, 0, 504.96, 54.82, 0),
      ("Tensor G5", 7, 2457000, 5, 2188000, 0, 508.68, 55.49, 0),
      ("Tensor G5", 7, 2457000, 5, 2284000, 0, 539.25, 57.92, 0),
      ("Tensor G5", 7, 2457000, 5, 2400000, 0, 554.86, 61.81, 0),
      ("Tensor G5", 7, 2457000, 5, 2534000, 0, 616.42, 68.59, 0),
      ("Tensor G5", 7, 2457000, 5, 2688000, 0, 664.17, 75.8, 0),
      ("Tensor G5", 7, 2457000, 5, 2841000, 0, 783.64, 91.65, 0),
      ("Tensor G5", 7, 2457000, 5, 2937000, 0, 865.55, 107.21, 0),
      ("Tensor G5", 7, 2457000, 5, 3052000, 0, 964.28, 123.18, 0),
      ("Tensor G5", 7, 2592000, 5, 177000, 0, 547.61, 53.29, 0),
      ("Tensor G5", 7, 2592000, 5, 266000, 0, 539.42, 53.95, 0),
      ("Tensor G5", 7, 2592000, 5, 400000, 0, 539.99, 53.51, 0),
      ("Tensor G5", 7, 2592000, 5, 533000, 0, 548.5, 54.21, 0),
      ("Tensor G5", 7, 2592000, 5, 652000, 0, 562.36, 54.85, 0),
      ("Tensor G5", 7, 2592000, 5, 729000, 0, 536.28, 54.66, 0),
      ("Tensor G5", 7, 2592000, 5, 921000, 0, 545.69, 56.01, 0),
      ("Tensor G5", 7, 2592000, 5, 1075000, 0, 555.89, 56.38, 0),
      ("Tensor G5", 7, 2592000, 5, 1267000, 0, 565.56, 55.91, 0),
      ("Tensor G5", 7, 2592000, 5, 1401000, 0, 548.31, 56.66, 0),
      ("Tensor G5", 7, 2592000, 5, 1536000, 0, 522.09, 57.43, 0),
      ("Tensor G5", 7, 2592000, 5, 1670000, 0, 537.5, 57.89, 0),
      ("Tensor G5", 7, 2592000, 5, 1785000, 0, 556.59, 58.21, 0),
      ("Tensor G5", 7, 2592000, 5, 1862000, 0, 548.0, 58.0, 0),
      ("Tensor G5", 7, 2592000, 5, 1939000, 0, 552.35, 57.87, 0),
      ("Tensor G5", 7, 2592000, 5, 2092000, 0, 547.05, 58.3, 0),
      ("Tensor G5", 7, 2592000, 5, 2188000, 0, 552.4, 57.85, 0),
      ("Tensor G5", 7, 2592000, 5, 2284000, 0, 549.62, 59.26, 0),
      ("Tensor G5", 7, 2592000, 5, 2400000, 0, 578.35, 62.17, 0),
      ("Tensor G5", 7, 2592000, 5, 2534000, 0, 649.03, 69.47, 0),
      ("Tensor G5", 7, 2592000, 5, 2688000, 0, 685.66, 75.25, 0),
      ("Tensor G5", 7, 2592000, 5, 2841000, 0, 818.44, 92.08, 0),
      ("Tensor G5", 7, 2592000, 5, 2937000, 0, 894.29, 107.03, 0),
      ("Tensor G5", 7, 2592000, 5, 3052000, 0, 1004.41, 123.87, 0),
      ("Tensor G5", 7, 2707000, 5, 177000, 0, 600.23, 56.72, 0),
      ("Tensor G5", 7, 2707000, 5, 266000, 0, 584.99, 58.47, 0),
      ("Tensor G5", 7, 2707000, 5, 400000, 0, 597.1, 57.54, 0),
      ("Tensor G5", 7, 2707000, 5, 533000, 0, 567.2, 58.37, 0),
      ("Tensor G5", 7, 2707000, 5, 652000, 0, 583.63, 58.52, 0),
      ("Tensor G5", 7, 2707000, 5, 729000, 0, 600.72, 58.75, 0),
      ("Tensor G5", 7, 2707000, 5, 921000, 0, 587.35, 59.36, 0),
      ("Tensor G5", 7, 2707000, 5, 1075000, 0, 604.12, 59.29, 0),
      ("Tensor G5", 7, 2707000, 5, 1267000, 0, 591.98, 60.48, 0),
      ("Tensor G5", 7, 2707000, 5, 1401000, 0, 615.48, 61.11, 0),
      ("Tensor G5", 7, 2707000, 5, 1536000, 0, 613.84, 60.77, 0),
      ("Tensor G5", 7, 2707000, 5, 1670000, 0, 591.48, 61.34, 0),
      ("Tensor G5", 7, 2707000, 5, 1785000, 0, 607.08, 60.86, 0),
      ("Tensor G5", 7, 2707000, 5, 1862000, 0, 605.97, 62.8, 0),
      ("Tensor G5", 7, 2707000, 5, 1939000, 0, 598.74, 62.66, 0),
      ("Tensor G5", 7, 2707000, 5, 2092000, 0, 615.31, 61.44, 0),
      ("Tensor G5", 7, 2707000, 5, 2188000, 0, 620.28, 61.57, 0),
      ("Tensor G5", 7, 2707000, 5, 2284000, 0, 605.46, 62.13, 0),
      ("Tensor G5", 7, 2707000, 5, 2400000, 0, 608.66, 62.72, 0),
      ("Tensor G5", 7, 2707000, 5, 2534000, 0, 663.95, 68.68, 0),
      ("Tensor G5", 7, 2707000, 5, 2688000, 0, 725.62, 77.8, 0),
      ("Tensor G5", 7, 2707000, 5, 2841000, 0, 833.35, 92.59, 0),
      ("Tensor G5", 7, 2707000, 5, 2937000, 0, 939.85, 108.46, 0),
      ("Tensor G5", 7, 2707000, 5, 3052000, 0, 1015.25, 124.35, 0),
      ("Tensor G5", 7, 2937000, 5, 177000, 0, 685.32, 65.01, 0),
      ("Tensor G5", 7, 2937000, 5, 266000, 0, 693.28, 64.16, 0),
      ("Tensor G5", 7, 2937000, 5, 400000, 0, 666.68, 63.42, 0),
      ("Tensor G5", 7, 2937000, 5, 533000, 0, 694.99, 64.78, 0),
      ("Tensor G5", 7, 2937000, 5, 652000, 0, 708.17, 64.59, 0),
      ("Tensor G5", 7, 2937000, 5, 729000, 0, 696.8, 65.26, 0),
      ("Tensor G5", 7, 2937000, 5, 921000, 0, 715.94, 65.84, 0),
      ("Tensor G5", 7, 2937000, 5, 1075000, 0, 693.99, 67.02, 0),
      ("Tensor G5", 7, 2937000, 5, 1267000, 0, 689.19, 68.52, 0),
      ("Tensor G5", 7, 2937000, 5, 1401000, 0, 718.09, 67.32, 0),
      ("Tensor G5", 7, 2937000, 5, 1536000, 0, 709.66, 67.45, 0),
      ("Tensor G5", 7, 2937000, 5, 1670000, 0, 699.56, 68.16, 0),
      ("Tensor G5", 7, 2937000, 5, 1785000, 0, 722.07, 70.12, 0),
      ("Tensor G5", 7, 2937000, 5, 1862000, 0, 699.92, 69.4, 0),
      ("Tensor G5", 7, 2937000, 5, 1939000, 0, 724.52, 68.29, 0),
      ("Tensor G5", 7, 2937000, 5, 2092000, 0, 713.08, 69.09, 0),
      ("Tensor G5", 7, 2937000, 5, 2188000, 0, 703.57, 68.71, 0),
      ("Tensor G5", 7, 2937000, 5, 2284000, 0, 664.83, 70.25, 0),
      ("Tensor G5", 7, 2937000, 5, 2400000, 0, 697.95, 71.31, 0),
      ("Tensor G5", 7, 2937000, 5, 2534000, 0, 698.94, 71.59, 0),
      ("Tensor G5", 7, 2937000, 5, 2688000, 0, 782.04, 77.99, 0),
      ("Tensor G5", 7, 2937000, 5, 2841000, 0, 907.05, 93.09, 0),
      ("Tensor G5", 7, 2937000, 5, 2937000, 0, 946.72, 110.73, 0),
      ("Tensor G5", 7, 2937000, 5, 3052000, 0, 1098.8, 126.18, 0),
      ("Tensor G5", 7, 3168000, 5, 177000, 0, 902.54, 81.96, 0),
      ("Tensor G5", 7, 3168000, 5, 266000, 0, 914.04, 82.53, 0),
      ("Tensor G5", 7, 3168000, 5, 400000, 0, 910.13, 81.73, 0),
      ("Tensor G5", 7, 3168000, 5, 533000, 0, 887.79, 82.66, 0),
      ("Tensor G5", 7, 3168000, 5, 652000, 0, 904.97, 84.27, 0),
      ("Tensor G5", 7, 3168000, 5, 729000, 0, 910.22, 82.34, 0),
      ("Tensor G5", 7, 3168000, 5, 921000, 0, 908.96, 83.44, 0),
      ("Tensor G5", 7, 3168000, 5, 1075000, 0, 908.71, 85.21, 0),
      ("Tensor G5", 7, 3168000, 5, 1267000, 0, 883.89, 84.46, 0),
      ("Tensor G5", 7, 3168000, 5, 1401000, 0, 919.61, 86.03, 0),
      ("Tensor G5", 7, 3168000, 5, 1536000, 0, 910.07, 85.84, 0),
      ("Tensor G5", 7, 3168000, 5, 1670000, 0, 911.51, 86.56, 0),
      ("Tensor G5", 7, 3168000, 5, 1785000, 0, 906.75, 87.26, 0),
      ("Tensor G5", 7, 3168000, 5, 1862000, 0, 908.98, 87.18, 0),
      ("Tensor G5", 7, 3168000, 5, 1939000, 0, 889.93, 92.82, 0),
      ("Tensor G5", 7, 3168000, 5, 2092000, 0, 897.85, 87.96, 0),
      ("Tensor G5", 7, 3168000, 5, 2188000, 0, 902.7, 92.48, 0),
      ("Tensor G5", 7, 3168000, 5, 2284000, 0, 914.39, 89.5, 0),
      ("Tensor G5", 7, 3168000, 5, 2400000, 0, 901.65, 88.67, 0),
      ("Tensor G5", 7, 3168000, 5, 2534000, 0, 934.79, 89.4, 0),
      ("Tensor G5", 7, 3168000, 5, 2688000, 0, 915.89, 89.86, 0),
      ("Tensor G5", 7, 3168000, 5, 2841000, 0, 926.26, 94.3, 0),
      ("Tensor G5", 7, 3168000, 5, 2937000, 0, 1055.09, 107.54, 0),
      ("Tensor G5", 7, 3168000, 5, 3052000, 0, 1138.41, 125.6, 0),
      ("Tensor G5", 7, 3398000, 5, 177000, 0, 1213.57, 81.71, 0),
      ("Tensor G5", 7, 3398000, 5, 266000, 0, 1195.86, 82.68, 0),
      ("Tensor G5", 7, 3398000, 5, 400000, 0, 1233.59, 81.62, 0),
      ("Tensor G5", 7, 3398000, 5, 533000, 0, 1212.3, 81.53, 0),
      ("Tensor G5", 7, 3398000, 5, 652000, 0, 1145.61, 82.41, 0),
      ("Tensor G5", 7, 3398000, 5, 729000, 0, 1190.54, 84.88, 0),
      ("Tensor G5", 7, 3398000, 5, 921000, 0, 1210.9, 83.93, 0),
      ("Tensor G5", 7, 3398000, 5, 1075000, 0, 1200.5, 85.47, 0),
      ("Tensor G5", 7, 3398000, 5, 1267000, 0, 1184.77, 91.84, 0),
      ("Tensor G5", 7, 3398000, 5, 1401000, 0, 1159.8, 86.05, 0),
      ("Tensor G5", 7, 3398000, 5, 1536000, 0, 1206.85, 87.01, 0),
      ("Tensor G5", 7, 3398000, 5, 1670000, 0, 1194.58, 87.47, 0),
      ("Tensor G5", 7, 3398000, 5, 1785000, 0, 1210.84, 88.49, 0),
      ("Tensor G5", 7, 3398000, 5, 1862000, 0, 1217.49, 87.31, 0),
      ("Tensor G5", 7, 3398000, 5, 1939000, 0, 1146.45, 87.73, 0),
      ("Tensor G5", 7, 3398000, 5, 2092000, 0, 1208.94, 87.83, 0),
      ("Tensor G5", 7, 3398000, 5, 2188000, 0, 1243.76, 89.33, 0),
      ("Tensor G5", 7, 3398000, 5, 2284000, 0, 1206.29, 88.03, 0),
      ("Tensor G5", 7, 3398000, 5, 2400000, 0, 1220.44, 90.14, 0),
      ("Tensor G5", 7, 3398000, 5, 2534000, 0, 1187.59, 89.08, 0),
      ("Tensor G5", 7, 3398000, 5, 2688000, 0, 1201.57, 91.64, 0),
      ("Tensor G5", 7, 3398000, 5, 2841000, 0, 1181.33, 93.42, 0),
      ("Tensor G5", 7, 3398000, 5, 2937000, 0, 1142.78, 108.47, 0),
      ("Tensor G5", 7, 3398000, 5, 3052000, 0, 1186.51, 126.27, 0),
      ("Tensor G5", 7, 3590000, 5, 177000, 0, 1500.31, 82.06, 0),
      ("Tensor G5", 7, 3590000, 5, 266000, 0, 1489.02, 81.4, 0),
      ("Tensor G5", 7, 3590000, 5, 400000, 0, 1546.7, 83.26, 0),
      ("Tensor G5", 7, 3590000, 5, 533000, 0, 1534.54, 81.82, 0),
      ("Tensor G5", 7, 3590000, 5, 652000, 0, 1529.59, 83.89, 0),
      ("Tensor G5", 7, 3590000, 5, 729000, 0, 1493.22, 83.07, 0),
      ("Tensor G5", 7, 3590000, 5, 921000, 0, 1559.3, 84.5, 0),
      ("Tensor G5", 7, 3590000, 5, 1075000, 0, 1494.73, 84.58, 0),
      ("Tensor G5", 7, 3590000, 5, 1267000, 0, 1517.87, 85.14, 0),
      ("Tensor G5", 7, 3590000, 5, 1401000, 0, 1532.96, 85.05, 0),
      ("Tensor G5", 7, 3590000, 5, 1536000, 0, 1446.21, 85.84, 0),
      ("Tensor G5", 7, 3590000, 5, 1670000, 0, 1501.52, 89.26, 0),
      ("Tensor G5", 7, 3590000, 5, 1785000, 0, 1494.8, 87.33, 0),
      ("Tensor G5", 7, 3590000, 5, 1862000, 0, 1564.85, 86.69, 0),
      ("Tensor G5", 7, 3590000, 5, 1939000, 0, 1524.97, 88.18, 0),
      ("Tensor G5", 7, 3590000, 5, 2092000, 0, 1423.09, 88.05, 0),
      ("Tensor G5", 7, 3590000, 5, 2188000, 0, 1508.22, 89.42, 0),
      ("Tensor G5", 7, 3590000, 5, 2284000, 0, 1537.47, 88.41, 0),
      ("Tensor G5", 7, 3590000, 5, 2400000, 0, 1532.72, 90.83, 0),
      ("Tensor G5", 7, 3590000, 5, 2534000, 0, 1560.42, 91.01, 0),
      ("Tensor G5", 7, 3590000, 5, 2688000, 0, 1520.32, 89.77, 0),
      ("Tensor G5", 7, 3590000, 5, 2841000, 0, 1520.45, 94.62, 0),
      ("Tensor G5", 7, 3590000, 5, 2937000, 0, 1476.76, 107.87, 0),
      ("Tensor G5", 7, 3590000, 5, 3052000, 0, 1399.22, 127.65, 0),
      ("Tensor G5", 7, 3782000, 5, 177000, 0, 2220.4, 82.53, 0),
      ("Tensor G5", 7, 3782000, 5, 266000, 0, 2102.59, 82.31, 0),
      ("Tensor G5", 7, 3782000, 5, 400000, 0, 2248.02, 82.13, 0),
      ("Tensor G5", 7, 3782000, 5, 533000, 0, 2252.44, 83.74, 0),
      ("Tensor G5", 7, 3782000, 5, 652000, 0, 2246.73, 83.47, 0),
      ("Tensor G5", 7, 3782000, 5, 729000, 0, 2245.28, 84.19, 0),
      ("Tensor G5", 7, 3782000, 5, 921000, 0, 2083.53, 84.31, 0),
      ("Tensor G5", 7, 3782000, 5, 1075000, 0, 2199.26, 84.97, 0),
      ("Tensor G5", 7, 3782000, 5, 1267000, 0, 2255.14, 85.35, 0),
      ("Tensor G5", 7, 3782000, 5, 1401000, 0, 2232.93, 84.83, 0),
      ("Tensor G5", 7, 3782000, 5, 1536000, 0, 2259.91, 88.08, 0),
      ("Tensor G5", 7, 3782000, 5, 1670000, 0, 2069.17, 87.45, 0),
      ("Tensor G5", 7, 3782000, 5, 1785000, 0, 2244.54, 86.79, 0),
      ("Tensor G5", 7, 3782000, 5, 1862000, 0, 2279.67, 88.74, 0),
      ("Tensor G5", 7, 3782000, 5, 1939000, 0, 2239.08, 88.77, 0),
      ("Tensor G5", 7, 3782000, 5, 2092000, 0, 2211.24, 88.48, 0),
      ("Tensor G5", 7, 3782000, 5, 2188000, 0, 2122.59, 87.85, 0),
      ("Tensor G5", 7, 3782000, 5, 2284000, 0, 2068.34, 88.42, 0),
      ("Tensor G5", 7, 3782000, 5, 2400000, 0, 2147.31, 89.46, 0),
      ("Tensor G5", 7, 3782000, 5, 2534000, 0, 2246.26, 88.61, 0),
      ("Tensor G5", 7, 3782000, 5, 2688000, 0, 2312.77, 89.96, 0),
      ("Tensor G5", 7, 3782000, 5, 2841000, 0, 2158.99, 94.69, 0),
      ("Tensor G5", 7, 3782000, 5, 2937000, 0, 2186.74, 107.79, 0),
      ("Tensor G5", 7, 3782000, 5, 3052000, 0, 2105.34, 126.13, 0)) AS _values
  )
SELECT
  *
FROM data;
