/* SPDX-FileCopyrightText: 2005 - Paolo Borelli
 * SPDX-FileCopyrightText: 2025 - Sébastien Wilmet
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#pragma once

#if !defined (TEPL_H_INSIDE) && !defined (TEPL_COMPILATION)
#error "Only <tepl/tepl.h> can be included directly."
#endif

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define TEPL_TYPE_STATUSBAR             (tepl_statusbar_get_type ())
#define TEPL_STATUSBAR(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), TEPL_TYPE_STATUSBAR, TeplStatusbar))
#define TEPL_STATUSBAR_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), TEPL_TYPE_STATUSBAR, TeplStatusbarClass))
#define TEPL_IS_STATUSBAR(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TEPL_TYPE_STATUSBAR))
#define TEPL_IS_STATUSBAR_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), TEPL_TYPE_STATUSBAR))
#define TEPL_STATUSBAR_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), TEPL_TYPE_STATUSBAR, TeplStatusbarClass))

typedef struct _TeplStatusbar         TeplStatusbar;
typedef struct _TeplStatusbarClass    TeplStatusbarClass;
typedef struct _TeplStatusbarPrivate  TeplStatusbarPrivate;

struct _TeplStatusbar
{
	GtkStatusbar parent;

	TeplStatusbarPrivate *priv;
};

struct _TeplStatusbarClass
{
	GtkStatusbarClass parent_class;
};

G_MODULE_EXPORT
GType		tepl_statusbar_get_type			(void) G_GNUC_CONST;

G_MODULE_EXPORT
TeplStatusbar *	tepl_statusbar_new			(void);

G_MODULE_EXPORT
void		tepl_statusbar_flash_message		(TeplStatusbar *statusbar,
							 guint          context_id,
							 const gchar   *msg);

G_MODULE_EXPORT
void		tepl_statusbar_flash_generic_message	(TeplStatusbar *statusbar,
							 const gchar   *msg);

G_END_DECLS
