/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * Copyright (C) 2020 BayLibre, SAS
 * Author: Neil Armstrong <narmstrong@baylibre.com>
 * Copyright (C) 2017 Amlogic, Inc. All rights reserved.
 */

#ifndef __GE2D_REGS__
#define __GE2D_REGS__

/* Registers starts at (GE2D_REG(0x8a0 * 4) */
#define GE2D_REG(x) ((0x8a0 + (x)) * 4)

#define GE2D_GEN_CTRL0 GE2D_REG(0x00)

#define GE2D_DST_BYTEMASK_ONLY		BIT(31)
#define GE2D_DST_BITMASK_EN		BIT(30)
#define GE2D_SRC2_KEY_EN		BIT(29)
#define GE2D_SRC2_KEY_MODE		BIT(28)
#define GE2D_SRC1_KEY_EN		BIT(27)
#define GE2D_SRC1_KEY_MODE		BIT(26)
#define GE2D_DST1_8B_MODE_SEL		GENMASK(25, 24)
#define GE2D_DST_CLIP_MODE		BIT(23)
#define GE2D_SRC2_8B_MODE_SEL		GENMASK(16, 15)
#define GE2D_SRC2_FILL_MODE		BIT(14)
#define GE2D_SRC2_PIC_STRUCT		GENMASK(13, 12)
#define GE2D_SRC2_X_YC_RATIO		BIT(11)
#define GE2D_SRC1_8B_MODE_SEL		GENMASK(6, 5)
#define GE2D_SRC1_FILL_MODE		BIT(4)
#define GE2D_SRC1_LUT_EN		BIT(3)
#define GE2D_SRC1_PIC_STRUCT		GENMASK(2, 1)

#define GE2D_GEN_CTRL1 GE2D_REG(0x01)

#define GE2D_SOFT_RST			BIT(31)
#define GE2D_DST_WRITE_RESP_CNT_RST	BIT(30)
#define GE2D_DST_WRITE_RESP_CNT_ADD_DIS	BIT(29)
#define GE2D_COLOR_CONVERSION_MODE1	BIT(26)
#define GE2D_INTERRUPT_CTRL		GENMASK(25, 24)
#define GE2D_SRC2_BURST_SIZE_CTRL	GENMASK(23, 22)
#define GE2D_SRC1_BURST_SIZE_CTRL	GENMASK(21, 16)
#define GE2D_DST1_PIC_STRUCT		GENMASK(15, 14)
#define GE2D_SRC_RD_CTRL		GENMASK(13, 12)
#define GE2D_DST2_URGENT_EN		BIT(11)
#define GE2D_SRC1_URGENT_EN		BIT(10)
#define GE2D_SRC2_URGENT_EN		BIT(9)
#define GE2D_DST1_URGENT_EN		BIT(8)
#define GE2D_SRC1_GB_ALPHA		GENMASK(7, 0)

#define GE2D_GEN_CTRL2 GE2D_REG(0x02)

#define GE2D_ALPHA_CONVERSION_MODE0	BIT(31)
#define GE2D_COLOR_CONVERSION_MODE0	BIT(30)
#define GE2D_SRC1_GB_ALPHA_EN		BIT(29)
#define GE2D_DST1_COLOR_ROUND_MODE	BIT(28)
#define GE2D_SRC2_COLOR_EXPAND_MODE	BIT(27)
#define GE2D_SRC2_ALPHA_EXPAND_MODE	BIT(26)
#define GE2D_SRC1_COLOR_EXPAND_MODE	BIT(25)
#define GE2D_SRC1_ALPHA_EXPAND_MODE	BIT(24)
#define GE2D_DST_LITTLE_ENDIAN		BIT(23)
#define GE2D_DST1_COLOR_MAP		GENMASK(22, 19)
#define GE2D_ALU_MULT_MODE		BIT(18)
#define GE2D_DST1_FORMAT		GENMASK(17, 16)
#define GE2D_SRC2_LITTLE_ENDIAN		BIT(15)
#define GE2D_SRC2_COLOR_MAP		GENMASK(14, 11)
#define GE2D_ALPHA_CONVERSION_MODE1	BIT(10)
#define GE2D_SRC2_FORMAT		GENMASK(9, 8)
#define GE2D_SRC1_LITTLE_ENDIAN		BIT(7)
#define GE2D_SRC1_COLOR_MAP		GENMASK(6, 3)
#define GE2D_SRC1_DEEPCOLOR		BIT(2)
#define GE2D_SRC1_FORMAT		GENMASK(1, 0)

#define GE2D_FORMAT_8BIT	0
#define GE2D_FORMAT_16BIT	1
#define GE2D_FORMAT_24BIT	2
#define GE2D_FORMAT_32BIT	3

/* 16 bit */
#define GE2D_COLOR_MAP_YUV422		0
#define GE2D_COLOR_MAP_RGB655		1
#define GE2D_COLOR_MAP_YUV655		1
#define GE2D_COLOR_MAP_RGB844		2
#define GE2D_COLOR_MAP_YUV844		2
#define GE2D_COLOR_MAP_RGBA6442		3
#define GE2D_COLOR_MAP_YUVA6442		3
#define GE2D_COLOR_MAP_RGBA4444		4
#define GE2D_COLOR_MAP_YUVA4444		4
#define GE2D_COLOR_MAP_RGB565		5
#define GE2D_COLOR_MAP_YUV565		5
#define GE2D_COLOR_MAP_ARGB4444		6
#define GE2D_COLOR_MAP_AYUV4444		6
#define GE2D_COLOR_MAP_ARGB1555		7
#define GE2D_COLOR_MAP_AYUV1555		7
#define GE2D_COLOR_MAP_RGBA4642		8
#define GE2D_COLOR_MAP_YUVA4642		8

/* 24 bit */
#define GE2D_COLOR_MAP_RGB888		0
#define GE2D_COLOR_MAP_YUV444		0
#define GE2D_COLOR_MAP_RGBA5658		1
#define GE2D_COLOR_MAP_YUVA5658		1
#define GE2D_COLOR_MAP_ARGB8565		2
#define GE2D_COLOR_MAP_AYUV8565		2
#define GE2D_COLOR_MAP_RGBA6666		3
#define GE2D_COLOR_MAP_YUVA6666		3
#define GE2D_COLOR_MAP_ARGB6666		4
#define GE2D_COLOR_MAP_AYUV6666		4
#define GE2D_COLOR_MAP_BGR888		5
#define GE2D_COLOR_MAP_VUY888		5

/* 32 bit */
#define GE2D_COLOR_MAP_RGBA8888		0
#define GE2D_COLOR_MAP_YUVA8888		0
#define GE2D_COLOR_MAP_ARGB8888		1
#define GE2D_COLOR_MAP_AYUV8888		1
#define GE2D_COLOR_MAP_ABGR8888		2
#define GE2D_COLOR_MAP_AVUY8888		2
#define GE2D_COLOR_MAP_BGRA8888		3
#define GE2D_COLOR_MAP_VUYA8888		3

#define GE2D_CMD_CTRL GE2D_REG(0x03)

#define GE2D_SRC2_FILL_COLOR_EN		BIT(9)
#define GE2D_SRC1_FILL_COLOR_EN		BIT(8)
#define GE2D_DST_XY_SWAP		BIT(7)
#define GE2D_DST_X_REV			BIT(6)
#define GE2D_DST_Y_REV			BIT(5)
#define GE2D_SRC2_X_REV			BIT(4)
#define GE2D_SRC2_Y_REV			BIT(3)
#define GE2D_SRC1_X_REV			BIT(2)
#define GE2D_SRC1_Y_REV			BIT(1)
#define GE2D_CBUS_CMD_WR		BIT(0)

#define GE2D_STATUS0 GE2D_REG(0x04)

#define GE2D_DST_WRITE_RSP_CNT		GENMASK(28, 17)
#define GE2D_DP_STATUS			GENMASK(16, 7)
#define GE2D_R1CMD_RDY			BIT(6)
#define GE2D_R2CMD_RDY			BIT(5)
#define GE2D_PDPCMD_VALID		BIT(4)
#define GE2D_DPCMD_RDY			BIT(3)
#define GE2D_BUF_CMD_VALID		BIT(2)
#define GE2D_CURR_CMD_VALID		BIT(1)
#define GE2D_GE2D_BUSY			BIT(0)

#define GE2D_STATUS1 GE2D_REG(0x05)

#define GE2D_WR_DST1_STATUS		GENMASK(29, 16)
#define GE2D_RD_SRC2_FIFO_EMPTY		BIT(15)
#define GE2D_RD_SRC2_FIFO_OVERFLOW	BIT(14)
#define GE2D_RD_SRC2_STATE_Y		GENMASK(13, 12)
#define GE2D_RD_SRC2_WIN_ERR		BIT(11)
#define GE2D_RD_SRC2_CMD_BUSY		BIT(10)
#define GE2D_RD_SRC1_FIFO_EMPTY		BIT(9)
#define GE2D_RD_SRC1_FIFO_OVERFLOW	BIT(8)
#define GE2D_RD_SRC1_STATE_CR		GENMASK(7, 6)
#define GE2D_RD_SRC1_STATE_CB		GENMASK(5, 4)
#define GE2D_RD_SRC1_STATE_Y		GENMASK(3, 2)
#define GE2D_RD_SRC1_WIN_ERR		BIT(1)
#define GE2D_RD_SRC1_CMD_BUSY		BIT(0)

#define GE2D_SRC1_DEF_COLOR GE2D_REG(0x06)

#define GE2D_COLOR_R_Y			GENMASK(31, 24)
#define GE2D_COLOR_B_CB			GENMASK(23, 16)
#define GE2D_COLOR_B_CR			GENMASK(15, 8)
#define GE2D_COLOR_ALPHA		GENMASK(7, 0)

#define GE2D_SRC1_CLIPX_START_END GE2D_REG(0x07)

#define GE2D_START_EXTRA	BIT(31) /* For GE2D_SRC1_CLIPX/Y_START_END */
#define GE2D_START_EXTRA0	BIT(30)	/* For GE2D_SRC1_X/Y_START_END */
#define GE2D_START		GENMASK(28, 16)
#define GE2D_END_EXTRA		BIT(15) /* For GE2D_SRC1_CLIPX/Y_START_END */
#define GE2D_END_EXTRA0		BIT(14)	/* For GE2D_SRC1_X/Y_START_END */
#define GE2D_END		GENMASK(12, 0)

#define GE2D_SRC1_CLIPY_START_END GE2D_REG(0x08)
#define GE2D_SRC1_CANVAS GE2D_REG(0x09)

#define GE2D_SRC1_CANVAS_ADDR	GENMASK(31, 24)

#define GE2D_SRC1_X_START_END GE2D_REG(0x0a)
#define GE2D_SRC1_Y_START_END GE2D_REG(0x0b)
#define GE2D_SRC1_LUT_ADDR GE2D_REG(0x0c)

#define GE2D_LUT_READ		BIT(8)
#define GE2D_LUT_ADDR		GENMASK(7, 0)

#define GE2D_SRC1_LUT_DAT GE2D_REG(0x0d)
#define GE2D_SRC1_FMT_CTRL GE2D_REG(0x0e)
#define GE2D_SRC2_DEF_COLOR GE2D_REG(0x0f)
#define GE2D_SRC2_CLIPX_START_END GE2D_REG(0x10)
#define GE2D_SRC2_CLIPY_START_END GE2D_REG(0x11)
#define GE2D_SRC2_X_START_END GE2D_REG(0x12)
#define GE2D_SRC2_Y_START_END GE2D_REG(0x13)
#define GE2D_DST_CLIPX_START_END GE2D_REG(0x14)
#define GE2D_DST_CLIPY_START_END GE2D_REG(0x15)
#define GE2D_DST_X_START_END GE2D_REG(0x16)
#define GE2D_DST_Y_START_END GE2D_REG(0x17)
#define GE2D_SRC2_DST_CANVAS GE2D_REG(0x18)

#define GE2D_DST2_CANVAS_ADDR	GENMASK(23, 16)
#define GE2D_SRC2_CANVAS_ADDR	GENMASK(15, 8)
#define GE2D_DST1_CANVAS_ADDR	GENMASK(7, 0)

#define GE2D_VSC_START_PHASE_STEP GE2D_REG(0x19)
#define GE2D_VSC_PHASE_SLOPE GE2D_REG(0x1a)
#define GE2D_VSC_INI_CTRL GE2D_REG(0x1b)
#define GE2D_HSC_START_PHASE_STEP GE2D_REG(0x1c)
#define GE2D_HSC_PHASE_SLOPE GE2D_REG(0x1d)
#define GE2D_HSC_INI_CTRL GE2D_REG(0x1e)
#define GE2D_HSC_ADV_CTRL GE2D_REG(0x1f)
#define GE2D_SC_MISC_CTRL GE2D_REG(0x20)
#define GE2D_VSC_NRND_POINT GE2D_REG(0x21)
#define GE2D_VSC_NRND_PHASE GE2D_REG(0x22)
#define GE2D_HSC_NRND_POINT GE2D_REG(0x23)
#define GE2D_HSC_NRND_PHASE GE2D_REG(0x24)
#define GE2D_MATRIX_PRE_OFFSET GE2D_REG(0x25)
#define GE2D_MATRIX_COEF00_01 GE2D_REG(0x26)
#define GE2D_MATRIX_COEF02_10 GE2D_REG(0x27)
#define GE2D_MATRIX_COEF11_12 GE2D_REG(0x28)
#define GE2D_MATRIX_COEF20_21 GE2D_REG(0x29)
#define GE2D_MATRIX_COEF22_CTRL GE2D_REG(0x2a)
#define GE2D_MATRIX_OFFSET GE2D_REG(0x2b)
#define GE2D_ALU_OP_CTRL GE2D_REG(0x2c)

#define GE2D_SRC1_COLOR_MULT_ALPHA_SEL	GENMASK(26, 25)
#define GE2D_SRC2_COLOR_MULT_ALPHA_SEL	BIT(24)
#define GE2D_ALU_BLEND_MODE		GENMASK(22, 20)

#define OPERATION_ADD           0    /* Cd = Cs*Fs+Cd*Fd */
#define OPERATION_SUB           1    /* Cd = Cs*Fs-Cd*Fd */
#define OPERATION_REVERSE_SUB   2    /* Cd = Cd*Fd-Cs*Fs */
#define OPERATION_MIN           3    /* Cd = Min(Cd*Fd,Cs*Fs) */
#define OPERATION_MAX           4    /* Cd = Max(Cd*Fd,Cs*Fs) */
#define OPERATION_LOGIC         5

#define GE2D_ALU_SRC_COLOR_BLEND_FACTOR	GENMASK(19, 16)
#define GE2D_ALU_DST_COLOR_BLEND_FACTOR	GENMASK(15, 12)

#define COLOR_FACTOR_ZERO                     0
#define COLOR_FACTOR_ONE                      1
#define COLOR_FACTOR_SRC_COLOR                2
#define COLOR_FACTOR_ONE_MINUS_SRC_COLOR      3
#define COLOR_FACTOR_DST_COLOR                4
#define COLOR_FACTOR_ONE_MINUS_DST_COLOR      5
#define COLOR_FACTOR_SRC_ALPHA                6
#define COLOR_FACTOR_ONE_MINUS_SRC_ALPHA      7
#define COLOR_FACTOR_DST_ALPHA                8
#define COLOR_FACTOR_ONE_MINUS_DST_ALPHA      9
#define COLOR_FACTOR_CONST_COLOR              10
#define COLOR_FACTOR_ONE_MINUS_CONST_COLOR    11
#define COLOR_FACTOR_CONST_ALPHA              12
#define COLOR_FACTOR_ONE_MINUS_CONST_ALPHA    13
#define COLOR_FACTOR_SRC_ALPHA_SATURATE       14

#define GE2D_ALU_OPERATION_LOGIC	GENMASK(15, 12)

#define LOGIC_OPERATION_CLEAR       0
#define LOGIC_OPERATION_COPY        1
#define LOGIC_OPERATION_NOOP        2
#define LOGIC_OPERATION_SET         3
#define LOGIC_OPERATION_COPY_INVERT 4
#define LOGIC_OPERATION_INVERT      5
#define LOGIC_OPERATION_AND_REVERSE 6
#define LOGIC_OPERATION_OR_REVERSE  7
#define LOGIC_OPERATION_AND         8
#define LOGIC_OPERATION_OR          9
#define LOGIC_OPERATION_NAND        10
#define LOGIC_OPERATION_NOR         11
#define LOGIC_OPERATION_XOR         12
#define LOGIC_OPERATION_EQUIV       13
#define LOGIC_OPERATION_AND_INVERT  14
#define LOGIC_OPERATION_OR_INVERT   15

#define GE2D_ALU_ALPHA_BLEND_MODE	GENMASK(10, 8)
#define GE2D_ALU_SRC_ALPHA_BLEND_FACTOR	GENMASK(7, 4)
#define GE2D_ALU_DST_ALPHA_BLEND_FACTOR	GENMASK(3, 0)

#define ALPHA_FACTOR_ZERO                     0
#define ALPHA_FACTOR_ONE                      1
#define ALPHA_FACTOR_SRC_ALPHA                2
#define ALPHA_FACTOR_ONE_MINUS_SRC_ALPHA      3
#define ALPHA_FACTOR_DST_ALPHA                4
#define ALPHA_FACTOR_ONE_MINUS_DST_ALPHA      5
#define ALPHA_FACTOR_CONST_ALPHA              6
#define ALPHA_FACTOR_ONE_MINUS_CONST_ALPHA    7

#define GE2D_ALU_ALPHA_OPERATION_LOGIC	GENMASK(3, 0)

#define GE2D_ALU_COLOR_OP(__op, __src_factor, __dst_factor) \
	(FIELD_PREP(GE2D_ALU_BLEND_MODE, __op) | \
	 FIELD_PREP(GE2D_ALU_SRC_COLOR_BLEND_FACTOR, __src_factor) | \
	 FIELD_PREP(GE2D_ALU_DST_COLOR_BLEND_FACTOR, __dst_factor))

#define GE2D_ALU_DO_COLOR_OPERATION_LOGIC(__op, __src_factor) \
	GE2D_ALU_COLOR_OP(OPERATION_LOGIC, __src_factor, __op)

#define GE2D_ALU_ALPHA_OP(__op, __src_factor, __dst_factor) \
	(FIELD_PREP(GE2D_ALU_ALPHA_BLEND_MODE, __op) | \
	 FIELD_PREP(GE2D_ALU_SRC_ALPHA_BLEND_FACTOR, __src_factor) | \
	 FIELD_PREP(GE2D_ALU_DST_ALPHA_BLEND_FACTOR, __dst_factor))

#define GE2D_ALU_DO_ALPHA_OPERATION_LOGIC(__op, __src_factor) \
	GE2D_ALU_ALPHA_OP(OPERATION_LOGIC, __src_factor, __op)

#define GE2D_ALU_CONST_COLOR GE2D_REG(0x2d)
#define GE2D_SRC1_KEY GE2D_REG(0x2e)
#define GE2D_SRC1_KEY_MASK GE2D_REG(0x2f)
#define GE2D_SRC2_KEY GE2D_REG(0x30)
#define GE2D_SRC2_KEY_MASK GE2D_REG(0x31)
#define GE2D_DST_BITMASK GE2D_REG(0x32)
#define GE2D_DP_ONOFF_CTRL GE2D_REG(0x33)
#define GE2D_SCALE_COEF_IDX GE2D_REG(0x34)
#define GE2D_SCALE_COEF GE2D_REG(0x35)
#define GE2D_SRC_OUTSIDE_ALPHA GE2D_REG(0x36)
#define GE2D_ANTIFLICK_CTRL0 GE2D_REG(0x38)
#define GE2D_ANTIFLICK_CTRL1 GE2D_REG(0x39)
#define GE2D_ANTIFLICK_COLOR_FILT0 GE2D_REG(0x3a)
#define GE2D_ANTIFLICK_COLOR_FILT1 GE2D_REG(0x3b)
#define GE2D_ANTIFLICK_COLOR_FILT2 GE2D_REG(0x3c)
#define GE2D_ANTIFLICK_COLOR_FILT3 GE2D_REG(0x3d)
#define GE2D_ANTIFLICK_ALPHA_FILT0 GE2D_REG(0x3e)
#define GE2D_ANTIFLICK_ALPHA_FILT1 GE2D_REG(0x3f)
#define GE2D_ANTIFLICK_ALPHA_FILT2 GE2D_REG(0x40)
#define GE2D_ANTIFLICK_ALPHA_FILT3 GE2D_REG(0x41)
#define GE2D_SRC1_RANGE_MAP_Y_CTRL GE2D_REG(0x43)
#define GE2D_SRC1_RANGE_MAP_CB_CTRL GE2D_REG(0x44)
#define GE2D_SRC1_RANGE_MAP_CR_CTRL GE2D_REG(0x45)
#define GE2D_ARB_BURST_NUM GE2D_REG(0x46)
#define GE2D_TID_TOKEN GE2D_REG(0x47)
#define GE2D_GEN_CTRL3 GE2D_REG(0x48)

#define GE2D_DST2_BYTEMASK_VAL		GENMASK(31, 28)
#define GE2D_DST2_PIC_STRUCT		GENMASK(27, 26)
#define GE2D_DST2_8B_MODE_SEL		GENMASK(25, 24)
#define GE2D_DST2_COLOR_MAP		GENMASK(22, 19)
#define GE2D_DST2_FORMAT		GENMASK(17, 16)
#define GE2D_DST2_COLOR_ROUND_MODE	BIT(14)
#define GE2D_DST2_X_DISCARD_MODE	GENMASK(13, 12)
#define GE2D_DST2_Y_DISCARD_MODE	GENMASK(11, 10)
#define GE2D_DST2_ENABLE		BIT(8)
#define GE2D_DST1_X_DISCARD_MODE	GENMASK(5, 4)
#define GE2D_DST1_Y_DISCARD_MODE	GENMASK(3, 2)
#define GE2D_DST1_ENABLE		BIT(0)

#define GE2D_STATUS2 GE2D_REG(0x49)
#define GE2D_GEN_CTRL4 GE2D_REG(0x4a)
#define GE2D_DST1_BADDR_CTRL  GE2D_REG(0x51)
#define GE2D_DST1_STRIDE_CTRL GE2D_REG(0x52)

#define GE2D_STRIDE_SIZE	GENMASK(19, 0)

#define GE2D_SRC1_BADDR_CTRL  GE2D_REG(0x53)
#define GE2D_SRC1_STRIDE_CTRL GE2D_REG(0x54)
#define GE2D_SRC2_BADDR_CTRL  GE2D_REG(0x55)
#define GE2D_SRC2_STRIDE_CTRL GE2D_REG(0x56)

#endif /* __GE2D_REGS__ */
