// Code generated by smithy-go-codegen DO NOT EDIT.

package mediaconvert

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/mediaconvert/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpAssociateCertificate struct {
}

func (*awsRestjson1_serializeOpAssociateCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAssociateCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/certificates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAssociateCertificateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAssociateCertificateInput(v *AssociateCertificateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAssociateCertificateInput(v *AssociateCertificateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("arn")
		ok.String(*v.Arn)
	}

	return nil
}

type awsRestjson1_serializeOpCancelJob struct {
}

func (*awsRestjson1_serializeOpCancelJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/jobs/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelJobInput(v *CancelJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateJob struct {
}

func (*awsRestjson1_serializeOpCreateJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateJobInput(v *CreateJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateJobInput(v *CreateJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccelerationSettings != nil {
		ok := object.Key("accelerationSettings")
		if err := awsRestjson1_serializeDocumentAccelerationSettings(v.AccelerationSettings, ok); err != nil {
			return err
		}
	}

	if len(v.BillingTagsSource) > 0 {
		ok := object.Key("billingTagsSource")
		ok.String(string(v.BillingTagsSource))
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("clientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if v.HopDestinations != nil {
		ok := object.Key("hopDestinations")
		if err := awsRestjson1_serializeDocument__listOfHopDestination(v.HopDestinations, ok); err != nil {
			return err
		}
	}

	if v.JobTemplate != nil {
		ok := object.Key("jobTemplate")
		ok.String(*v.JobTemplate)
	}

	if v.Priority != nil {
		ok := object.Key("priority")
		ok.Integer(*v.Priority)
	}

	if v.Queue != nil {
		ok := object.Key("queue")
		ok.String(*v.Queue)
	}

	if v.Role != nil {
		ok := object.Key("role")
		ok.String(*v.Role)
	}

	if v.Settings != nil {
		ok := object.Key("settings")
		if err := awsRestjson1_serializeDocumentJobSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	if len(v.SimulateReservedQueue) > 0 {
		ok := object.Key("simulateReservedQueue")
		ok.String(string(v.SimulateReservedQueue))
	}

	if len(v.StatusUpdateInterval) > 0 {
		ok := object.Key("statusUpdateInterval")
		ok.String(string(v.StatusUpdateInterval))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.UserMetadata != nil {
		ok := object.Key("userMetadata")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.UserMetadata, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateJobTemplate struct {
}

func (*awsRestjson1_serializeOpCreateJobTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateJobTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateJobTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/jobTemplates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateJobTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateJobTemplateInput(v *CreateJobTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateJobTemplateInput(v *CreateJobTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccelerationSettings != nil {
		ok := object.Key("accelerationSettings")
		if err := awsRestjson1_serializeDocumentAccelerationSettings(v.AccelerationSettings, ok); err != nil {
			return err
		}
	}

	if v.Category != nil {
		ok := object.Key("category")
		ok.String(*v.Category)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.HopDestinations != nil {
		ok := object.Key("hopDestinations")
		if err := awsRestjson1_serializeDocument__listOfHopDestination(v.HopDestinations, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Priority != nil {
		ok := object.Key("priority")
		ok.Integer(*v.Priority)
	}

	if v.Queue != nil {
		ok := object.Key("queue")
		ok.String(*v.Queue)
	}

	if v.Settings != nil {
		ok := object.Key("settings")
		if err := awsRestjson1_serializeDocumentJobTemplateSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	if len(v.StatusUpdateInterval) > 0 {
		ok := object.Key("statusUpdateInterval")
		ok.String(string(v.StatusUpdateInterval))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreatePreset struct {
}

func (*awsRestjson1_serializeOpCreatePreset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePreset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePresetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/presets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePresetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePresetInput(v *CreatePresetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePresetInput(v *CreatePresetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Category != nil {
		ok := object.Key("category")
		ok.String(*v.Category)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Settings != nil {
		ok := object.Key("settings")
		if err := awsRestjson1_serializeDocumentPresetSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateQueue struct {
}

func (*awsRestjson1_serializeOpCreateQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/queues")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateQueueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateQueueInput(v *CreateQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateQueueInput(v *CreateQueueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.PricingPlan) > 0 {
		ok := object.Key("pricingPlan")
		ok.String(string(v.PricingPlan))
	}

	if v.ReservationPlanSettings != nil {
		ok := object.Key("reservationPlanSettings")
		if err := awsRestjson1_serializeDocumentReservationPlanSettings(v.ReservationPlanSettings, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteJobTemplate struct {
}

func (*awsRestjson1_serializeOpDeleteJobTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteJobTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteJobTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/jobTemplates/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteJobTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteJobTemplateInput(v *DeleteJobTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePolicy struct {
}

func (*awsRestjson1_serializeOpDeletePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePolicyInput(v *DeletePolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDeletePreset struct {
}

func (*awsRestjson1_serializeOpDeletePreset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePreset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePresetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/presets/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePresetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePresetInput(v *DeletePresetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteQueue struct {
}

func (*awsRestjson1_serializeOpDeleteQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/queues/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteQueueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteQueueInput(v *DeleteQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeEndpoints struct {
}

func (*awsRestjson1_serializeOpDescribeEndpoints) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeEndpoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEndpointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/endpoints")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDescribeEndpointsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeEndpointsInput(v *DescribeEndpointsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDescribeEndpointsInput(v *DescribeEndpointsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if len(v.Mode) > 0 {
		ok := object.Key("mode")
		ok.String(string(v.Mode))
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpDisassociateCertificate struct {
}

func (*awsRestjson1_serializeOpDisassociateCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDisassociateCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/certificates/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDisassociateCertificateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDisassociateCertificateInput(v *DisassociateCertificateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetJob struct {
}

func (*awsRestjson1_serializeOpGetJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/jobs/{Id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetJobInput(v *GetJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("Id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetJobTemplate struct {
}

func (*awsRestjson1_serializeOpGetJobTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetJobTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/jobTemplates/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetJobTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetJobTemplateInput(v *GetJobTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetPolicy struct {
}

func (*awsRestjson1_serializeOpGetPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPolicyInput(v *GetPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetPreset struct {
}

func (*awsRestjson1_serializeOpGetPreset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPreset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPresetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/presets/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPresetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPresetInput(v *GetPresetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetQueue struct {
}

func (*awsRestjson1_serializeOpGetQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/queues/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetQueueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetQueueInput(v *GetQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListJobs struct {
}

func (*awsRestjson1_serializeOpListJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJobsInput(v *ListJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.Order) > 0 {
		encoder.SetQuery("order").String(string(v.Order))
	}

	if v.Queue != nil {
		encoder.SetQuery("queue").String(*v.Queue)
	}

	if len(v.Status) > 0 {
		encoder.SetQuery("status").String(string(v.Status))
	}

	return nil
}

type awsRestjson1_serializeOpListJobTemplates struct {
}

func (*awsRestjson1_serializeOpListJobTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListJobTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/jobTemplates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListJobTemplatesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListJobTemplatesInput(v *ListJobTemplatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Category != nil {
		encoder.SetQuery("category").String(*v.Category)
	}

	if len(v.ListBy) > 0 {
		encoder.SetQuery("listBy").String(string(v.ListBy))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.Order) > 0 {
		encoder.SetQuery("order").String(string(v.Order))
	}

	return nil
}

type awsRestjson1_serializeOpListPresets struct {
}

func (*awsRestjson1_serializeOpListPresets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPresets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPresetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/presets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPresetsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPresetsInput(v *ListPresetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Category != nil {
		encoder.SetQuery("category").String(*v.Category)
	}

	if len(v.ListBy) > 0 {
		encoder.SetQuery("listBy").String(string(v.ListBy))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.Order) > 0 {
		encoder.SetQuery("order").String(string(v.Order))
	}

	return nil
}

type awsRestjson1_serializeOpListQueues struct {
}

func (*awsRestjson1_serializeOpListQueues) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListQueues) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListQueuesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/queues")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListQueuesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListQueuesInput(v *ListQueuesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ListBy) > 0 {
		encoder.SetQuery("listBy").String(string(v.ListBy))
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if len(v.Order) > 0 {
		encoder.SetQuery("order").String(string(v.Order))
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/tags/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutPolicy struct {
}

func (*awsRestjson1_serializeOpPutPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutPolicyInput(v *PutPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutPolicyInput(v *PutPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("policy")
		if err := awsRestjson1_serializeDocumentPolicy(v.Policy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("arn")
		ok.String(*v.Arn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/tags/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TagKeys != nil {
		ok := object.Key("tagKeys")
		if err := awsRestjson1_serializeDocument__listOf__string(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateJobTemplate struct {
}

func (*awsRestjson1_serializeOpUpdateJobTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateJobTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateJobTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/jobTemplates/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateJobTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateJobTemplateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateJobTemplateInput(v *UpdateJobTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateJobTemplateInput(v *UpdateJobTemplateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccelerationSettings != nil {
		ok := object.Key("accelerationSettings")
		if err := awsRestjson1_serializeDocumentAccelerationSettings(v.AccelerationSettings, ok); err != nil {
			return err
		}
	}

	if v.Category != nil {
		ok := object.Key("category")
		ok.String(*v.Category)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.HopDestinations != nil {
		ok := object.Key("hopDestinations")
		if err := awsRestjson1_serializeDocument__listOfHopDestination(v.HopDestinations, ok); err != nil {
			return err
		}
	}

	if v.Priority != nil {
		ok := object.Key("priority")
		ok.Integer(*v.Priority)
	}

	if v.Queue != nil {
		ok := object.Key("queue")
		ok.String(*v.Queue)
	}

	if v.Settings != nil {
		ok := object.Key("settings")
		if err := awsRestjson1_serializeDocumentJobTemplateSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	if len(v.StatusUpdateInterval) > 0 {
		ok := object.Key("statusUpdateInterval")
		ok.String(string(v.StatusUpdateInterval))
	}

	return nil
}

type awsRestjson1_serializeOpUpdatePreset struct {
}

func (*awsRestjson1_serializeOpUpdatePreset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdatePreset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePresetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/presets/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdatePresetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdatePresetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdatePresetInput(v *UpdatePresetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdatePresetInput(v *UpdatePresetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Category != nil {
		ok := object.Key("category")
		ok.String(*v.Category)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Settings != nil {
		ok := object.Key("settings")
		if err := awsRestjson1_serializeDocumentPresetSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateQueue struct {
}

func (*awsRestjson1_serializeOpUpdateQueue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateQueue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateQueueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/2017-08-29/queues/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateQueueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateQueueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateQueueInput(v *UpdateQueueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateQueueInput(v *UpdateQueueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ReservationPlanSettings != nil {
		ok := object.Key("reservationPlanSettings")
		if err := awsRestjson1_serializeDocumentReservationPlanSettings(v.ReservationPlanSettings, ok); err != nil {
			return err
		}
	}

	if len(v.Status) > 0 {
		ok := object.Key("status")
		ok.String(string(v.Status))
	}

	return nil
}

func awsRestjson1_serializeDocument__listOf__doubleMinNegative60Max6(v []float64, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		switch {
		case math.IsNaN(v[i]):
			av.String("NaN")

		case math.IsInf(v[i], 1):
			av.String("Infinity")

		case math.IsInf(v[i], -1):
			av.String("-Infinity")

		default:
			av.Double(v[i])

		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOf__integerMin1Max2147483647(v []int32, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocument__listOf__integerMin32Max8182(v []int32, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocument__listOf__integerMinNegative60Max6(v []int32, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocument__listOf__string(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocument__listOf__stringMin1(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocument__listOf__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocument__listOf__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocument__listOf__stringPatternS3ASSETMAPXml(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAllowedRenditionSize(v []types.AllowedRenditionSize, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAllowedRenditionSize(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAudioChannelTag(v []types.AudioChannelTag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAudioDescription(v []types.AudioDescription, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAudioDescription(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfAutomatedAbrRule(v []types.AutomatedAbrRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAutomatedAbrRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfCaptionDescription(v []types.CaptionDescription, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCaptionDescription(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfCaptionDescriptionPreset(v []types.CaptionDescriptionPreset, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCaptionDescriptionPreset(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfCmafAdditionalManifest(v []types.CmafAdditionalManifest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCmafAdditionalManifest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfColorConversion3DLUTSetting(v []types.ColorConversion3DLUTSetting, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentColorConversion3DLUTSetting(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfDashAdditionalManifest(v []types.DashAdditionalManifest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDashAdditionalManifest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfForceIncludeRenditionSize(v []types.ForceIncludeRenditionSize, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentForceIncludeRenditionSize(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfHlsAdditionalManifest(v []types.HlsAdditionalManifest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentHlsAdditionalManifest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfHlsAdMarkers(v []types.HlsAdMarkers, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfHlsCaptionLanguageMapping(v []types.HlsCaptionLanguageMapping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentHlsCaptionLanguageMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfHopDestination(v []types.HopDestination, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentHopDestination(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfId3Insertion(v []types.Id3Insertion, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentId3Insertion(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfInput(v []types.Input, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInput(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfInputClipping(v []types.InputClipping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInputClipping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfInputTemplate(v []types.InputTemplate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInputTemplate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfInsertableImage(v []types.InsertableImage, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInsertableImage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfMsSmoothAdditionalManifest(v []types.MsSmoothAdditionalManifest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMsSmoothAdditionalManifest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfOutput(v []types.Output, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentOutput(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfOutputChannelMapping(v []types.OutputChannelMapping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentOutputChannelMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfOutputGroup(v []types.OutputGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentOutputGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfTeletextPageType(v []types.TeletextPageType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfVideoOverlay(v []types.VideoOverlay, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentVideoOverlay(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfVideoOverlayInputClipping(v []types.VideoOverlayInputClipping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentVideoOverlayInputClipping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__mapOf__string(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocument__mapOfAudioSelector(v map[string]types.AudioSelector, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentAudioSelector(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__mapOfAudioSelectorGroup(v map[string]types.AudioSelectorGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentAudioSelectorGroup(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__mapOfCaptionSelector(v map[string]types.CaptionSelector, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentCaptionSelector(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAacSettings(v *types.AacSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AudioDescriptionBroadcasterMix) > 0 {
		ok := object.Key("audioDescriptionBroadcasterMix")
		ok.String(string(v.AudioDescriptionBroadcasterMix))
	}

	if v.Bitrate != nil {
		ok := object.Key("bitrate")
		ok.Integer(*v.Bitrate)
	}

	if len(v.CodecProfile) > 0 {
		ok := object.Key("codecProfile")
		ok.String(string(v.CodecProfile))
	}

	if len(v.CodingMode) > 0 {
		ok := object.Key("codingMode")
		ok.String(string(v.CodingMode))
	}

	if len(v.RateControlMode) > 0 {
		ok := object.Key("rateControlMode")
		ok.String(string(v.RateControlMode))
	}

	if len(v.RawFormat) > 0 {
		ok := object.Key("rawFormat")
		ok.String(string(v.RawFormat))
	}

	if v.SampleRate != nil {
		ok := object.Key("sampleRate")
		ok.Integer(*v.SampleRate)
	}

	if len(v.Specification) > 0 {
		ok := object.Key("specification")
		ok.String(string(v.Specification))
	}

	if len(v.VbrQuality) > 0 {
		ok := object.Key("vbrQuality")
		ok.String(string(v.VbrQuality))
	}

	return nil
}

func awsRestjson1_serializeDocumentAc3Settings(v *types.Ac3Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bitrate != nil {
		ok := object.Key("bitrate")
		ok.Integer(*v.Bitrate)
	}

	if len(v.BitstreamMode) > 0 {
		ok := object.Key("bitstreamMode")
		ok.String(string(v.BitstreamMode))
	}

	if len(v.CodingMode) > 0 {
		ok := object.Key("codingMode")
		ok.String(string(v.CodingMode))
	}

	if v.Dialnorm != nil {
		ok := object.Key("dialnorm")
		ok.Integer(*v.Dialnorm)
	}

	if len(v.DynamicRangeCompressionLine) > 0 {
		ok := object.Key("dynamicRangeCompressionLine")
		ok.String(string(v.DynamicRangeCompressionLine))
	}

	if len(v.DynamicRangeCompressionProfile) > 0 {
		ok := object.Key("dynamicRangeCompressionProfile")
		ok.String(string(v.DynamicRangeCompressionProfile))
	}

	if len(v.DynamicRangeCompressionRf) > 0 {
		ok := object.Key("dynamicRangeCompressionRf")
		ok.String(string(v.DynamicRangeCompressionRf))
	}

	if len(v.LfeFilter) > 0 {
		ok := object.Key("lfeFilter")
		ok.String(string(v.LfeFilter))
	}

	if len(v.MetadataControl) > 0 {
		ok := object.Key("metadataControl")
		ok.String(string(v.MetadataControl))
	}

	if v.SampleRate != nil {
		ok := object.Key("sampleRate")
		ok.Integer(*v.SampleRate)
	}

	return nil
}

func awsRestjson1_serializeDocumentAccelerationSettings(v *types.AccelerationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Mode) > 0 {
		ok := object.Key("mode")
		ok.String(string(v.Mode))
	}

	return nil
}

func awsRestjson1_serializeDocumentAdvancedInputFilterSettings(v *types.AdvancedInputFilterSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AddTexture) > 0 {
		ok := object.Key("addTexture")
		ok.String(string(v.AddTexture))
	}

	if len(v.Sharpening) > 0 {
		ok := object.Key("sharpening")
		ok.String(string(v.Sharpening))
	}

	return nil
}

func awsRestjson1_serializeDocumentAiffSettings(v *types.AiffSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BitDepth != nil {
		ok := object.Key("bitDepth")
		ok.Integer(*v.BitDepth)
	}

	if v.Channels != nil {
		ok := object.Key("channels")
		ok.Integer(*v.Channels)
	}

	if v.SampleRate != nil {
		ok := object.Key("sampleRate")
		ok.Integer(*v.SampleRate)
	}

	return nil
}

func awsRestjson1_serializeDocumentAllowedRenditionSize(v *types.AllowedRenditionSize, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Height != nil {
		ok := object.Key("height")
		ok.Integer(*v.Height)
	}

	if len(v.Required) > 0 {
		ok := object.Key("required")
		ok.String(string(v.Required))
	}

	if v.Width != nil {
		ok := object.Key("width")
		ok.Integer(*v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentAncillarySourceSettings(v *types.AncillarySourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Convert608To708) > 0 {
		ok := object.Key("convert608To708")
		ok.String(string(v.Convert608To708))
	}

	if v.SourceAncillaryChannelNumber != nil {
		ok := object.Key("sourceAncillaryChannelNumber")
		ok.Integer(*v.SourceAncillaryChannelNumber)
	}

	if len(v.TerminateCaptions) > 0 {
		ok := object.Key("terminateCaptions")
		ok.String(string(v.TerminateCaptions))
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioChannelTaggingSettings(v *types.AudioChannelTaggingSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ChannelTag) > 0 {
		ok := object.Key("channelTag")
		ok.String(string(v.ChannelTag))
	}

	if v.ChannelTags != nil {
		ok := object.Key("channelTags")
		if err := awsRestjson1_serializeDocument__listOfAudioChannelTag(v.ChannelTags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioCodecSettings(v *types.AudioCodecSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AacSettings != nil {
		ok := object.Key("aacSettings")
		if err := awsRestjson1_serializeDocumentAacSettings(v.AacSettings, ok); err != nil {
			return err
		}
	}

	if v.Ac3Settings != nil {
		ok := object.Key("ac3Settings")
		if err := awsRestjson1_serializeDocumentAc3Settings(v.Ac3Settings, ok); err != nil {
			return err
		}
	}

	if v.AiffSettings != nil {
		ok := object.Key("aiffSettings")
		if err := awsRestjson1_serializeDocumentAiffSettings(v.AiffSettings, ok); err != nil {
			return err
		}
	}

	if len(v.Codec) > 0 {
		ok := object.Key("codec")
		ok.String(string(v.Codec))
	}

	if v.Eac3AtmosSettings != nil {
		ok := object.Key("eac3AtmosSettings")
		if err := awsRestjson1_serializeDocumentEac3AtmosSettings(v.Eac3AtmosSettings, ok); err != nil {
			return err
		}
	}

	if v.Eac3Settings != nil {
		ok := object.Key("eac3Settings")
		if err := awsRestjson1_serializeDocumentEac3Settings(v.Eac3Settings, ok); err != nil {
			return err
		}
	}

	if v.FlacSettings != nil {
		ok := object.Key("flacSettings")
		if err := awsRestjson1_serializeDocumentFlacSettings(v.FlacSettings, ok); err != nil {
			return err
		}
	}

	if v.Mp2Settings != nil {
		ok := object.Key("mp2Settings")
		if err := awsRestjson1_serializeDocumentMp2Settings(v.Mp2Settings, ok); err != nil {
			return err
		}
	}

	if v.Mp3Settings != nil {
		ok := object.Key("mp3Settings")
		if err := awsRestjson1_serializeDocumentMp3Settings(v.Mp3Settings, ok); err != nil {
			return err
		}
	}

	if v.OpusSettings != nil {
		ok := object.Key("opusSettings")
		if err := awsRestjson1_serializeDocumentOpusSettings(v.OpusSettings, ok); err != nil {
			return err
		}
	}

	if v.VorbisSettings != nil {
		ok := object.Key("vorbisSettings")
		if err := awsRestjson1_serializeDocumentVorbisSettings(v.VorbisSettings, ok); err != nil {
			return err
		}
	}

	if v.WavSettings != nil {
		ok := object.Key("wavSettings")
		if err := awsRestjson1_serializeDocumentWavSettings(v.WavSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioDescription(v *types.AudioDescription, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioChannelTaggingSettings != nil {
		ok := object.Key("audioChannelTaggingSettings")
		if err := awsRestjson1_serializeDocumentAudioChannelTaggingSettings(v.AudioChannelTaggingSettings, ok); err != nil {
			return err
		}
	}

	if v.AudioNormalizationSettings != nil {
		ok := object.Key("audioNormalizationSettings")
		if err := awsRestjson1_serializeDocumentAudioNormalizationSettings(v.AudioNormalizationSettings, ok); err != nil {
			return err
		}
	}

	if v.AudioSourceName != nil {
		ok := object.Key("audioSourceName")
		ok.String(*v.AudioSourceName)
	}

	if v.AudioType != nil {
		ok := object.Key("audioType")
		ok.Integer(*v.AudioType)
	}

	if len(v.AudioTypeControl) > 0 {
		ok := object.Key("audioTypeControl")
		ok.String(string(v.AudioTypeControl))
	}

	if v.CodecSettings != nil {
		ok := object.Key("codecSettings")
		if err := awsRestjson1_serializeDocumentAudioCodecSettings(v.CodecSettings, ok); err != nil {
			return err
		}
	}

	if v.CustomLanguageCode != nil {
		ok := object.Key("customLanguageCode")
		ok.String(*v.CustomLanguageCode)
	}

	if len(v.LanguageCode) > 0 {
		ok := object.Key("languageCode")
		ok.String(string(v.LanguageCode))
	}

	if len(v.LanguageCodeControl) > 0 {
		ok := object.Key("languageCodeControl")
		ok.String(string(v.LanguageCodeControl))
	}

	if v.RemixSettings != nil {
		ok := object.Key("remixSettings")
		if err := awsRestjson1_serializeDocumentRemixSettings(v.RemixSettings, ok); err != nil {
			return err
		}
	}

	if v.StreamName != nil {
		ok := object.Key("streamName")
		ok.String(*v.StreamName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioNormalizationSettings(v *types.AudioNormalizationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Algorithm) > 0 {
		ok := object.Key("algorithm")
		ok.String(string(v.Algorithm))
	}

	if len(v.AlgorithmControl) > 0 {
		ok := object.Key("algorithmControl")
		ok.String(string(v.AlgorithmControl))
	}

	if v.CorrectionGateLevel != nil {
		ok := object.Key("correctionGateLevel")
		ok.Integer(*v.CorrectionGateLevel)
	}

	if len(v.LoudnessLogging) > 0 {
		ok := object.Key("loudnessLogging")
		ok.String(string(v.LoudnessLogging))
	}

	if len(v.PeakCalculation) > 0 {
		ok := object.Key("peakCalculation")
		ok.String(string(v.PeakCalculation))
	}

	if v.TargetLkfs != nil {
		ok := object.Key("targetLkfs")
		switch {
		case math.IsNaN(*v.TargetLkfs):
			ok.String("NaN")

		case math.IsInf(*v.TargetLkfs, 1):
			ok.String("Infinity")

		case math.IsInf(*v.TargetLkfs, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.TargetLkfs)

		}
	}

	if v.TruePeakLimiterThreshold != nil {
		ok := object.Key("truePeakLimiterThreshold")
		switch {
		case math.IsNaN(*v.TruePeakLimiterThreshold):
			ok.String("NaN")

		case math.IsInf(*v.TruePeakLimiterThreshold, 1):
			ok.String("Infinity")

		case math.IsInf(*v.TruePeakLimiterThreshold, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.TruePeakLimiterThreshold)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioSelector(v *types.AudioSelector, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AudioDurationCorrection) > 0 {
		ok := object.Key("audioDurationCorrection")
		ok.String(string(v.AudioDurationCorrection))
	}

	if v.CustomLanguageCode != nil {
		ok := object.Key("customLanguageCode")
		ok.String(*v.CustomLanguageCode)
	}

	if len(v.DefaultSelection) > 0 {
		ok := object.Key("defaultSelection")
		ok.String(string(v.DefaultSelection))
	}

	if v.ExternalAudioFileInput != nil {
		ok := object.Key("externalAudioFileInput")
		ok.String(*v.ExternalAudioFileInput)
	}

	if v.HlsRenditionGroupSettings != nil {
		ok := object.Key("hlsRenditionGroupSettings")
		if err := awsRestjson1_serializeDocumentHlsRenditionGroupSettings(v.HlsRenditionGroupSettings, ok); err != nil {
			return err
		}
	}

	if len(v.LanguageCode) > 0 {
		ok := object.Key("languageCode")
		ok.String(string(v.LanguageCode))
	}

	if v.Offset != nil {
		ok := object.Key("offset")
		ok.Integer(*v.Offset)
	}

	if v.Pids != nil {
		ok := object.Key("pids")
		if err := awsRestjson1_serializeDocument__listOf__integerMin1Max2147483647(v.Pids, ok); err != nil {
			return err
		}
	}

	if v.ProgramSelection != nil {
		ok := object.Key("programSelection")
		ok.Integer(*v.ProgramSelection)
	}

	if v.RemixSettings != nil {
		ok := object.Key("remixSettings")
		if err := awsRestjson1_serializeDocumentRemixSettings(v.RemixSettings, ok); err != nil {
			return err
		}
	}

	if len(v.SelectorType) > 0 {
		ok := object.Key("selectorType")
		ok.String(string(v.SelectorType))
	}

	if v.Tracks != nil {
		ok := object.Key("tracks")
		if err := awsRestjson1_serializeDocument__listOf__integerMin1Max2147483647(v.Tracks, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioSelectorGroup(v *types.AudioSelectorGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioSelectorNames != nil {
		ok := object.Key("audioSelectorNames")
		if err := awsRestjson1_serializeDocument__listOf__stringMin1(v.AudioSelectorNames, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAutomatedAbrRule(v *types.AutomatedAbrRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedRenditions != nil {
		ok := object.Key("allowedRenditions")
		if err := awsRestjson1_serializeDocument__listOfAllowedRenditionSize(v.AllowedRenditions, ok); err != nil {
			return err
		}
	}

	if v.ForceIncludeRenditions != nil {
		ok := object.Key("forceIncludeRenditions")
		if err := awsRestjson1_serializeDocument__listOfForceIncludeRenditionSize(v.ForceIncludeRenditions, ok); err != nil {
			return err
		}
	}

	if v.MinBottomRenditionSize != nil {
		ok := object.Key("minBottomRenditionSize")
		if err := awsRestjson1_serializeDocumentMinBottomRenditionSize(v.MinBottomRenditionSize, ok); err != nil {
			return err
		}
	}

	if v.MinTopRenditionSize != nil {
		ok := object.Key("minTopRenditionSize")
		if err := awsRestjson1_serializeDocumentMinTopRenditionSize(v.MinTopRenditionSize, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentAutomatedAbrSettings(v *types.AutomatedAbrSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxAbrBitrate != nil {
		ok := object.Key("maxAbrBitrate")
		ok.Integer(*v.MaxAbrBitrate)
	}

	if v.MaxRenditions != nil {
		ok := object.Key("maxRenditions")
		ok.Integer(*v.MaxRenditions)
	}

	if v.MinAbrBitrate != nil {
		ok := object.Key("minAbrBitrate")
		ok.Integer(*v.MinAbrBitrate)
	}

	if v.Rules != nil {
		ok := object.Key("rules")
		if err := awsRestjson1_serializeDocument__listOfAutomatedAbrRule(v.Rules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAutomatedEncodingSettings(v *types.AutomatedEncodingSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AbrSettings != nil {
		ok := object.Key("abrSettings")
		if err := awsRestjson1_serializeDocumentAutomatedAbrSettings(v.AbrSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAv1QvbrSettings(v *types.Av1QvbrSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.QvbrQualityLevel != nil {
		ok := object.Key("qvbrQualityLevel")
		ok.Integer(*v.QvbrQualityLevel)
	}

	if v.QvbrQualityLevelFineTune != nil {
		ok := object.Key("qvbrQualityLevelFineTune")
		switch {
		case math.IsNaN(*v.QvbrQualityLevelFineTune):
			ok.String("NaN")

		case math.IsInf(*v.QvbrQualityLevelFineTune, 1):
			ok.String("Infinity")

		case math.IsInf(*v.QvbrQualityLevelFineTune, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.QvbrQualityLevelFineTune)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAv1Settings(v *types.Av1Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AdaptiveQuantization) > 0 {
		ok := object.Key("adaptiveQuantization")
		ok.String(string(v.AdaptiveQuantization))
	}

	if len(v.BitDepth) > 0 {
		ok := object.Key("bitDepth")
		ok.String(string(v.BitDepth))
	}

	if len(v.FilmGrainSynthesis) > 0 {
		ok := object.Key("filmGrainSynthesis")
		ok.String(string(v.FilmGrainSynthesis))
	}

	if len(v.FramerateControl) > 0 {
		ok := object.Key("framerateControl")
		ok.String(string(v.FramerateControl))
	}

	if len(v.FramerateConversionAlgorithm) > 0 {
		ok := object.Key("framerateConversionAlgorithm")
		ok.String(string(v.FramerateConversionAlgorithm))
	}

	if v.FramerateDenominator != nil {
		ok := object.Key("framerateDenominator")
		ok.Integer(*v.FramerateDenominator)
	}

	if v.FramerateNumerator != nil {
		ok := object.Key("framerateNumerator")
		ok.Integer(*v.FramerateNumerator)
	}

	if v.GopSize != nil {
		ok := object.Key("gopSize")
		switch {
		case math.IsNaN(*v.GopSize):
			ok.String("NaN")

		case math.IsInf(*v.GopSize, 1):
			ok.String("Infinity")

		case math.IsInf(*v.GopSize, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.GopSize)

		}
	}

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	if v.NumberBFramesBetweenReferenceFrames != nil {
		ok := object.Key("numberBFramesBetweenReferenceFrames")
		ok.Integer(*v.NumberBFramesBetweenReferenceFrames)
	}

	if v.QvbrSettings != nil {
		ok := object.Key("qvbrSettings")
		if err := awsRestjson1_serializeDocumentAv1QvbrSettings(v.QvbrSettings, ok); err != nil {
			return err
		}
	}

	if len(v.RateControlMode) > 0 {
		ok := object.Key("rateControlMode")
		ok.String(string(v.RateControlMode))
	}

	if v.Slices != nil {
		ok := object.Key("slices")
		ok.Integer(*v.Slices)
	}

	if len(v.SpatialAdaptiveQuantization) > 0 {
		ok := object.Key("spatialAdaptiveQuantization")
		ok.String(string(v.SpatialAdaptiveQuantization))
	}

	return nil
}

func awsRestjson1_serializeDocumentAvailBlanking(v *types.AvailBlanking, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailBlankingImage != nil {
		ok := object.Key("availBlankingImage")
		ok.String(*v.AvailBlankingImage)
	}

	return nil
}

func awsRestjson1_serializeDocumentAvcIntraSettings(v *types.AvcIntraSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AvcIntraClass) > 0 {
		ok := object.Key("avcIntraClass")
		ok.String(string(v.AvcIntraClass))
	}

	if v.AvcIntraUhdSettings != nil {
		ok := object.Key("avcIntraUhdSettings")
		if err := awsRestjson1_serializeDocumentAvcIntraUhdSettings(v.AvcIntraUhdSettings, ok); err != nil {
			return err
		}
	}

	if len(v.FramerateControl) > 0 {
		ok := object.Key("framerateControl")
		ok.String(string(v.FramerateControl))
	}

	if len(v.FramerateConversionAlgorithm) > 0 {
		ok := object.Key("framerateConversionAlgorithm")
		ok.String(string(v.FramerateConversionAlgorithm))
	}

	if v.FramerateDenominator != nil {
		ok := object.Key("framerateDenominator")
		ok.Integer(*v.FramerateDenominator)
	}

	if v.FramerateNumerator != nil {
		ok := object.Key("framerateNumerator")
		ok.Integer(*v.FramerateNumerator)
	}

	if len(v.InterlaceMode) > 0 {
		ok := object.Key("interlaceMode")
		ok.String(string(v.InterlaceMode))
	}

	if len(v.ScanTypeConversionMode) > 0 {
		ok := object.Key("scanTypeConversionMode")
		ok.String(string(v.ScanTypeConversionMode))
	}

	if len(v.SlowPal) > 0 {
		ok := object.Key("slowPal")
		ok.String(string(v.SlowPal))
	}

	if len(v.Telecine) > 0 {
		ok := object.Key("telecine")
		ok.String(string(v.Telecine))
	}

	return nil
}

func awsRestjson1_serializeDocumentAvcIntraUhdSettings(v *types.AvcIntraUhdSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.QualityTuningLevel) > 0 {
		ok := object.Key("qualityTuningLevel")
		ok.String(string(v.QualityTuningLevel))
	}

	return nil
}

func awsRestjson1_serializeDocumentBandwidthReductionFilter(v *types.BandwidthReductionFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Sharpening) > 0 {
		ok := object.Key("sharpening")
		ok.String(string(v.Sharpening))
	}

	if len(v.Strength) > 0 {
		ok := object.Key("strength")
		ok.String(string(v.Strength))
	}

	return nil
}

func awsRestjson1_serializeDocumentBurninDestinationSettings(v *types.BurninDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Alignment) > 0 {
		ok := object.Key("alignment")
		ok.String(string(v.Alignment))
	}

	if len(v.ApplyFontColor) > 0 {
		ok := object.Key("applyFontColor")
		ok.String(string(v.ApplyFontColor))
	}

	if len(v.BackgroundColor) > 0 {
		ok := object.Key("backgroundColor")
		ok.String(string(v.BackgroundColor))
	}

	if v.BackgroundOpacity != nil {
		ok := object.Key("backgroundOpacity")
		ok.Integer(*v.BackgroundOpacity)
	}

	if len(v.FallbackFont) > 0 {
		ok := object.Key("fallbackFont")
		ok.String(string(v.FallbackFont))
	}

	if len(v.FontColor) > 0 {
		ok := object.Key("fontColor")
		ok.String(string(v.FontColor))
	}

	if v.FontFileBold != nil {
		ok := object.Key("fontFileBold")
		ok.String(*v.FontFileBold)
	}

	if v.FontFileBoldItalic != nil {
		ok := object.Key("fontFileBoldItalic")
		ok.String(*v.FontFileBoldItalic)
	}

	if v.FontFileItalic != nil {
		ok := object.Key("fontFileItalic")
		ok.String(*v.FontFileItalic)
	}

	if v.FontFileRegular != nil {
		ok := object.Key("fontFileRegular")
		ok.String(*v.FontFileRegular)
	}

	if v.FontOpacity != nil {
		ok := object.Key("fontOpacity")
		ok.Integer(*v.FontOpacity)
	}

	if v.FontResolution != nil {
		ok := object.Key("fontResolution")
		ok.Integer(*v.FontResolution)
	}

	if len(v.FontScript) > 0 {
		ok := object.Key("fontScript")
		ok.String(string(v.FontScript))
	}

	if v.FontSize != nil {
		ok := object.Key("fontSize")
		ok.Integer(*v.FontSize)
	}

	if v.HexFontColor != nil {
		ok := object.Key("hexFontColor")
		ok.String(*v.HexFontColor)
	}

	if len(v.OutlineColor) > 0 {
		ok := object.Key("outlineColor")
		ok.String(string(v.OutlineColor))
	}

	if v.OutlineSize != nil {
		ok := object.Key("outlineSize")
		ok.Integer(*v.OutlineSize)
	}

	if len(v.ShadowColor) > 0 {
		ok := object.Key("shadowColor")
		ok.String(string(v.ShadowColor))
	}

	if v.ShadowOpacity != nil {
		ok := object.Key("shadowOpacity")
		ok.Integer(*v.ShadowOpacity)
	}

	if v.ShadowXOffset != nil {
		ok := object.Key("shadowXOffset")
		ok.Integer(*v.ShadowXOffset)
	}

	if v.ShadowYOffset != nil {
		ok := object.Key("shadowYOffset")
		ok.Integer(*v.ShadowYOffset)
	}

	if len(v.StylePassthrough) > 0 {
		ok := object.Key("stylePassthrough")
		ok.String(string(v.StylePassthrough))
	}

	if len(v.TeletextSpacing) > 0 {
		ok := object.Key("teletextSpacing")
		ok.String(string(v.TeletextSpacing))
	}

	if v.XPosition != nil {
		ok := object.Key("xPosition")
		ok.Integer(*v.XPosition)
	}

	if v.YPosition != nil {
		ok := object.Key("yPosition")
		ok.Integer(*v.YPosition)
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionDescription(v *types.CaptionDescription, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CaptionSelectorName != nil {
		ok := object.Key("captionSelectorName")
		ok.String(*v.CaptionSelectorName)
	}

	if v.CustomLanguageCode != nil {
		ok := object.Key("customLanguageCode")
		ok.String(*v.CustomLanguageCode)
	}

	if v.DestinationSettings != nil {
		ok := object.Key("destinationSettings")
		if err := awsRestjson1_serializeDocumentCaptionDestinationSettings(v.DestinationSettings, ok); err != nil {
			return err
		}
	}

	if len(v.LanguageCode) > 0 {
		ok := object.Key("languageCode")
		ok.String(string(v.LanguageCode))
	}

	if v.LanguageDescription != nil {
		ok := object.Key("languageDescription")
		ok.String(*v.LanguageDescription)
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionDescriptionPreset(v *types.CaptionDescriptionPreset, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomLanguageCode != nil {
		ok := object.Key("customLanguageCode")
		ok.String(*v.CustomLanguageCode)
	}

	if v.DestinationSettings != nil {
		ok := object.Key("destinationSettings")
		if err := awsRestjson1_serializeDocumentCaptionDestinationSettings(v.DestinationSettings, ok); err != nil {
			return err
		}
	}

	if len(v.LanguageCode) > 0 {
		ok := object.Key("languageCode")
		ok.String(string(v.LanguageCode))
	}

	if v.LanguageDescription != nil {
		ok := object.Key("languageDescription")
		ok.String(*v.LanguageDescription)
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionDestinationSettings(v *types.CaptionDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BurninDestinationSettings != nil {
		ok := object.Key("burninDestinationSettings")
		if err := awsRestjson1_serializeDocumentBurninDestinationSettings(v.BurninDestinationSettings, ok); err != nil {
			return err
		}
	}

	if len(v.DestinationType) > 0 {
		ok := object.Key("destinationType")
		ok.String(string(v.DestinationType))
	}

	if v.DvbSubDestinationSettings != nil {
		ok := object.Key("dvbSubDestinationSettings")
		if err := awsRestjson1_serializeDocumentDvbSubDestinationSettings(v.DvbSubDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.EmbeddedDestinationSettings != nil {
		ok := object.Key("embeddedDestinationSettings")
		if err := awsRestjson1_serializeDocumentEmbeddedDestinationSettings(v.EmbeddedDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.ImscDestinationSettings != nil {
		ok := object.Key("imscDestinationSettings")
		if err := awsRestjson1_serializeDocumentImscDestinationSettings(v.ImscDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.SccDestinationSettings != nil {
		ok := object.Key("sccDestinationSettings")
		if err := awsRestjson1_serializeDocumentSccDestinationSettings(v.SccDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.SrtDestinationSettings != nil {
		ok := object.Key("srtDestinationSettings")
		if err := awsRestjson1_serializeDocumentSrtDestinationSettings(v.SrtDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.TeletextDestinationSettings != nil {
		ok := object.Key("teletextDestinationSettings")
		if err := awsRestjson1_serializeDocumentTeletextDestinationSettings(v.TeletextDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.TtmlDestinationSettings != nil {
		ok := object.Key("ttmlDestinationSettings")
		if err := awsRestjson1_serializeDocumentTtmlDestinationSettings(v.TtmlDestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.WebvttDestinationSettings != nil {
		ok := object.Key("webvttDestinationSettings")
		if err := awsRestjson1_serializeDocumentWebvttDestinationSettings(v.WebvttDestinationSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionSelector(v *types.CaptionSelector, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomLanguageCode != nil {
		ok := object.Key("customLanguageCode")
		ok.String(*v.CustomLanguageCode)
	}

	if len(v.LanguageCode) > 0 {
		ok := object.Key("languageCode")
		ok.String(string(v.LanguageCode))
	}

	if v.SourceSettings != nil {
		ok := object.Key("sourceSettings")
		if err := awsRestjson1_serializeDocumentCaptionSourceSettings(v.SourceSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionSourceFramerate(v *types.CaptionSourceFramerate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FramerateDenominator != nil {
		ok := object.Key("framerateDenominator")
		ok.Integer(*v.FramerateDenominator)
	}

	if v.FramerateNumerator != nil {
		ok := object.Key("framerateNumerator")
		ok.Integer(*v.FramerateNumerator)
	}

	return nil
}

func awsRestjson1_serializeDocumentCaptionSourceSettings(v *types.CaptionSourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AncillarySourceSettings != nil {
		ok := object.Key("ancillarySourceSettings")
		if err := awsRestjson1_serializeDocumentAncillarySourceSettings(v.AncillarySourceSettings, ok); err != nil {
			return err
		}
	}

	if v.DvbSubSourceSettings != nil {
		ok := object.Key("dvbSubSourceSettings")
		if err := awsRestjson1_serializeDocumentDvbSubSourceSettings(v.DvbSubSourceSettings, ok); err != nil {
			return err
		}
	}

	if v.EmbeddedSourceSettings != nil {
		ok := object.Key("embeddedSourceSettings")
		if err := awsRestjson1_serializeDocumentEmbeddedSourceSettings(v.EmbeddedSourceSettings, ok); err != nil {
			return err
		}
	}

	if v.FileSourceSettings != nil {
		ok := object.Key("fileSourceSettings")
		if err := awsRestjson1_serializeDocumentFileSourceSettings(v.FileSourceSettings, ok); err != nil {
			return err
		}
	}

	if len(v.SourceType) > 0 {
		ok := object.Key("sourceType")
		ok.String(string(v.SourceType))
	}

	if v.TeletextSourceSettings != nil {
		ok := object.Key("teletextSourceSettings")
		if err := awsRestjson1_serializeDocumentTeletextSourceSettings(v.TeletextSourceSettings, ok); err != nil {
			return err
		}
	}

	if v.TrackSourceSettings != nil {
		ok := object.Key("trackSourceSettings")
		if err := awsRestjson1_serializeDocumentTrackSourceSettings(v.TrackSourceSettings, ok); err != nil {
			return err
		}
	}

	if v.WebvttHlsSourceSettings != nil {
		ok := object.Key("webvttHlsSourceSettings")
		if err := awsRestjson1_serializeDocumentWebvttHlsSourceSettings(v.WebvttHlsSourceSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentChannelMapping(v *types.ChannelMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OutputChannels != nil {
		ok := object.Key("outputChannels")
		if err := awsRestjson1_serializeDocument__listOfOutputChannelMapping(v.OutputChannels, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentClipLimits(v *types.ClipLimits, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaximumRGBTolerance != nil {
		ok := object.Key("maximumRGBTolerance")
		ok.Integer(*v.MaximumRGBTolerance)
	}

	if v.MaximumYUV != nil {
		ok := object.Key("maximumYUV")
		ok.Integer(*v.MaximumYUV)
	}

	if v.MinimumRGBTolerance != nil {
		ok := object.Key("minimumRGBTolerance")
		ok.Integer(*v.MinimumRGBTolerance)
	}

	if v.MinimumYUV != nil {
		ok := object.Key("minimumYUV")
		ok.Integer(*v.MinimumYUV)
	}

	return nil
}

func awsRestjson1_serializeDocumentCmafAdditionalManifest(v *types.CmafAdditionalManifest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ManifestNameModifier != nil {
		ok := object.Key("manifestNameModifier")
		ok.String(*v.ManifestNameModifier)
	}

	if v.SelectedOutputs != nil {
		ok := object.Key("selectedOutputs")
		if err := awsRestjson1_serializeDocument__listOf__stringMin1(v.SelectedOutputs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCmafEncryptionSettings(v *types.CmafEncryptionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConstantInitializationVector != nil {
		ok := object.Key("constantInitializationVector")
		ok.String(*v.ConstantInitializationVector)
	}

	if len(v.EncryptionMethod) > 0 {
		ok := object.Key("encryptionMethod")
		ok.String(string(v.EncryptionMethod))
	}

	if len(v.InitializationVectorInManifest) > 0 {
		ok := object.Key("initializationVectorInManifest")
		ok.String(string(v.InitializationVectorInManifest))
	}

	if v.SpekeKeyProvider != nil {
		ok := object.Key("spekeKeyProvider")
		if err := awsRestjson1_serializeDocumentSpekeKeyProviderCmaf(v.SpekeKeyProvider, ok); err != nil {
			return err
		}
	}

	if v.StaticKeyProvider != nil {
		ok := object.Key("staticKeyProvider")
		if err := awsRestjson1_serializeDocumentStaticKeyProvider(v.StaticKeyProvider, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentCmafGroupSettings(v *types.CmafGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalManifests != nil {
		ok := object.Key("additionalManifests")
		if err := awsRestjson1_serializeDocument__listOfCmafAdditionalManifest(v.AdditionalManifests, ok); err != nil {
			return err
		}
	}

	if v.BaseUrl != nil {
		ok := object.Key("baseUrl")
		ok.String(*v.BaseUrl)
	}

	if len(v.ClientCache) > 0 {
		ok := object.Key("clientCache")
		ok.String(string(v.ClientCache))
	}

	if len(v.CodecSpecification) > 0 {
		ok := object.Key("codecSpecification")
		ok.String(string(v.CodecSpecification))
	}

	if len(v.DashManifestStyle) > 0 {
		ok := object.Key("dashManifestStyle")
		ok.String(string(v.DashManifestStyle))
	}

	if v.Destination != nil {
		ok := object.Key("destination")
		ok.String(*v.Destination)
	}

	if v.DestinationSettings != nil {
		ok := object.Key("destinationSettings")
		if err := awsRestjson1_serializeDocumentDestinationSettings(v.DestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentCmafEncryptionSettings(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.FragmentLength != nil {
		ok := object.Key("fragmentLength")
		ok.Integer(*v.FragmentLength)
	}

	if len(v.ImageBasedTrickPlay) > 0 {
		ok := object.Key("imageBasedTrickPlay")
		ok.String(string(v.ImageBasedTrickPlay))
	}

	if v.ImageBasedTrickPlaySettings != nil {
		ok := object.Key("imageBasedTrickPlaySettings")
		if err := awsRestjson1_serializeDocumentCmafImageBasedTrickPlaySettings(v.ImageBasedTrickPlaySettings, ok); err != nil {
			return err
		}
	}

	if len(v.ManifestCompression) > 0 {
		ok := object.Key("manifestCompression")
		ok.String(string(v.ManifestCompression))
	}

	if len(v.ManifestDurationFormat) > 0 {
		ok := object.Key("manifestDurationFormat")
		ok.String(string(v.ManifestDurationFormat))
	}

	if v.MinBufferTime != nil {
		ok := object.Key("minBufferTime")
		ok.Integer(*v.MinBufferTime)
	}

	if v.MinFinalSegmentLength != nil {
		ok := object.Key("minFinalSegmentLength")
		switch {
		case math.IsNaN(*v.MinFinalSegmentLength):
			ok.String("NaN")

		case math.IsInf(*v.MinFinalSegmentLength, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MinFinalSegmentLength, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MinFinalSegmentLength)

		}
	}

	if len(v.MpdManifestBandwidthType) > 0 {
		ok := object.Key("mpdManifestBandwidthType")
		ok.String(string(v.MpdManifestBandwidthType))
	}

	if len(v.MpdProfile) > 0 {
		ok := object.Key("mpdProfile")
		ok.String(string(v.MpdProfile))
	}

	if len(v.PtsOffsetHandlingForBFrames) > 0 {
		ok := object.Key("ptsOffsetHandlingForBFrames")
		ok.String(string(v.PtsOffsetHandlingForBFrames))
	}

	if len(v.SegmentControl) > 0 {
		ok := object.Key("segmentControl")
		ok.String(string(v.SegmentControl))
	}

	if v.SegmentLength != nil {
		ok := object.Key("segmentLength")
		ok.Integer(*v.SegmentLength)
	}

	if len(v.SegmentLengthControl) > 0 {
		ok := object.Key("segmentLengthControl")
		ok.String(string(v.SegmentLengthControl))
	}

	if len(v.StreamInfResolution) > 0 {
		ok := object.Key("streamInfResolution")
		ok.String(string(v.StreamInfResolution))
	}

	if len(v.TargetDurationCompatibilityMode) > 0 {
		ok := object.Key("targetDurationCompatibilityMode")
		ok.String(string(v.TargetDurationCompatibilityMode))
	}

	if len(v.VideoCompositionOffsets) > 0 {
		ok := object.Key("videoCompositionOffsets")
		ok.String(string(v.VideoCompositionOffsets))
	}

	if len(v.WriteDashManifest) > 0 {
		ok := object.Key("writeDashManifest")
		ok.String(string(v.WriteDashManifest))
	}

	if len(v.WriteHlsManifest) > 0 {
		ok := object.Key("writeHlsManifest")
		ok.String(string(v.WriteHlsManifest))
	}

	if len(v.WriteSegmentTimelineInRepresentation) > 0 {
		ok := object.Key("writeSegmentTimelineInRepresentation")
		ok.String(string(v.WriteSegmentTimelineInRepresentation))
	}

	return nil
}

func awsRestjson1_serializeDocumentCmafImageBasedTrickPlaySettings(v *types.CmafImageBasedTrickPlaySettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.IntervalCadence) > 0 {
		ok := object.Key("intervalCadence")
		ok.String(string(v.IntervalCadence))
	}

	if v.ThumbnailHeight != nil {
		ok := object.Key("thumbnailHeight")
		ok.Integer(*v.ThumbnailHeight)
	}

	if v.ThumbnailInterval != nil {
		ok := object.Key("thumbnailInterval")
		switch {
		case math.IsNaN(*v.ThumbnailInterval):
			ok.String("NaN")

		case math.IsInf(*v.ThumbnailInterval, 1):
			ok.String("Infinity")

		case math.IsInf(*v.ThumbnailInterval, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.ThumbnailInterval)

		}
	}

	if v.ThumbnailWidth != nil {
		ok := object.Key("thumbnailWidth")
		ok.Integer(*v.ThumbnailWidth)
	}

	if v.TileHeight != nil {
		ok := object.Key("tileHeight")
		ok.Integer(*v.TileHeight)
	}

	if v.TileWidth != nil {
		ok := object.Key("tileWidth")
		ok.Integer(*v.TileWidth)
	}

	return nil
}

func awsRestjson1_serializeDocumentCmfcSettings(v *types.CmfcSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AudioDuration) > 0 {
		ok := object.Key("audioDuration")
		ok.String(string(v.AudioDuration))
	}

	if v.AudioGroupId != nil {
		ok := object.Key("audioGroupId")
		ok.String(*v.AudioGroupId)
	}

	if v.AudioRenditionSets != nil {
		ok := object.Key("audioRenditionSets")
		ok.String(*v.AudioRenditionSets)
	}

	if len(v.AudioTrackType) > 0 {
		ok := object.Key("audioTrackType")
		ok.String(string(v.AudioTrackType))
	}

	if len(v.DescriptiveVideoServiceFlag) > 0 {
		ok := object.Key("descriptiveVideoServiceFlag")
		ok.String(string(v.DescriptiveVideoServiceFlag))
	}

	if len(v.IFrameOnlyManifest) > 0 {
		ok := object.Key("iFrameOnlyManifest")
		ok.String(string(v.IFrameOnlyManifest))
	}

	if len(v.KlvMetadata) > 0 {
		ok := object.Key("klvMetadata")
		ok.String(string(v.KlvMetadata))
	}

	if len(v.ManifestMetadataSignaling) > 0 {
		ok := object.Key("manifestMetadataSignaling")
		ok.String(string(v.ManifestMetadataSignaling))
	}

	if len(v.Scte35Esam) > 0 {
		ok := object.Key("scte35Esam")
		ok.String(string(v.Scte35Esam))
	}

	if len(v.Scte35Source) > 0 {
		ok := object.Key("scte35Source")
		ok.String(string(v.Scte35Source))
	}

	if len(v.TimedMetadata) > 0 {
		ok := object.Key("timedMetadata")
		ok.String(string(v.TimedMetadata))
	}

	if len(v.TimedMetadataBoxVersion) > 0 {
		ok := object.Key("timedMetadataBoxVersion")
		ok.String(string(v.TimedMetadataBoxVersion))
	}

	if v.TimedMetadataSchemeIdUri != nil {
		ok := object.Key("timedMetadataSchemeIdUri")
		ok.String(*v.TimedMetadataSchemeIdUri)
	}

	if v.TimedMetadataValue != nil {
		ok := object.Key("timedMetadataValue")
		ok.String(*v.TimedMetadataValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentColorConversion3DLUTSetting(v *types.ColorConversion3DLUTSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FileInput != nil {
		ok := object.Key("fileInput")
		ok.String(*v.FileInput)
	}

	if len(v.InputColorSpace) > 0 {
		ok := object.Key("inputColorSpace")
		ok.String(string(v.InputColorSpace))
	}

	if v.InputMasteringLuminance != nil {
		ok := object.Key("inputMasteringLuminance")
		ok.Integer(*v.InputMasteringLuminance)
	}

	if len(v.OutputColorSpace) > 0 {
		ok := object.Key("outputColorSpace")
		ok.String(string(v.OutputColorSpace))
	}

	if v.OutputMasteringLuminance != nil {
		ok := object.Key("outputMasteringLuminance")
		ok.Integer(*v.OutputMasteringLuminance)
	}

	return nil
}

func awsRestjson1_serializeDocumentColorCorrector(v *types.ColorCorrector, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Brightness != nil {
		ok := object.Key("brightness")
		ok.Integer(*v.Brightness)
	}

	if v.ClipLimits != nil {
		ok := object.Key("clipLimits")
		if err := awsRestjson1_serializeDocumentClipLimits(v.ClipLimits, ok); err != nil {
			return err
		}
	}

	if len(v.ColorSpaceConversion) > 0 {
		ok := object.Key("colorSpaceConversion")
		ok.String(string(v.ColorSpaceConversion))
	}

	if v.Contrast != nil {
		ok := object.Key("contrast")
		ok.Integer(*v.Contrast)
	}

	if v.Hdr10Metadata != nil {
		ok := object.Key("hdr10Metadata")
		if err := awsRestjson1_serializeDocumentHdr10Metadata(v.Hdr10Metadata, ok); err != nil {
			return err
		}
	}

	if len(v.HdrToSdrToneMapper) > 0 {
		ok := object.Key("hdrToSdrToneMapper")
		ok.String(string(v.HdrToSdrToneMapper))
	}

	if v.Hue != nil {
		ok := object.Key("hue")
		ok.Integer(*v.Hue)
	}

	if v.MaxLuminance != nil {
		ok := object.Key("maxLuminance")
		ok.Integer(*v.MaxLuminance)
	}

	if len(v.SampleRangeConversion) > 0 {
		ok := object.Key("sampleRangeConversion")
		ok.String(string(v.SampleRangeConversion))
	}

	if v.Saturation != nil {
		ok := object.Key("saturation")
		ok.Integer(*v.Saturation)
	}

	if v.SdrReferenceWhiteLevel != nil {
		ok := object.Key("sdrReferenceWhiteLevel")
		ok.Integer(*v.SdrReferenceWhiteLevel)
	}

	return nil
}

func awsRestjson1_serializeDocumentContainerSettings(v *types.ContainerSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CmfcSettings != nil {
		ok := object.Key("cmfcSettings")
		if err := awsRestjson1_serializeDocumentCmfcSettings(v.CmfcSettings, ok); err != nil {
			return err
		}
	}

	if len(v.Container) > 0 {
		ok := object.Key("container")
		ok.String(string(v.Container))
	}

	if v.F4vSettings != nil {
		ok := object.Key("f4vSettings")
		if err := awsRestjson1_serializeDocumentF4vSettings(v.F4vSettings, ok); err != nil {
			return err
		}
	}

	if v.M2tsSettings != nil {
		ok := object.Key("m2tsSettings")
		if err := awsRestjson1_serializeDocumentM2tsSettings(v.M2tsSettings, ok); err != nil {
			return err
		}
	}

	if v.M3u8Settings != nil {
		ok := object.Key("m3u8Settings")
		if err := awsRestjson1_serializeDocumentM3u8Settings(v.M3u8Settings, ok); err != nil {
			return err
		}
	}

	if v.MovSettings != nil {
		ok := object.Key("movSettings")
		if err := awsRestjson1_serializeDocumentMovSettings(v.MovSettings, ok); err != nil {
			return err
		}
	}

	if v.Mp4Settings != nil {
		ok := object.Key("mp4Settings")
		if err := awsRestjson1_serializeDocumentMp4Settings(v.Mp4Settings, ok); err != nil {
			return err
		}
	}

	if v.MpdSettings != nil {
		ok := object.Key("mpdSettings")
		if err := awsRestjson1_serializeDocumentMpdSettings(v.MpdSettings, ok); err != nil {
			return err
		}
	}

	if v.MxfSettings != nil {
		ok := object.Key("mxfSettings")
		if err := awsRestjson1_serializeDocumentMxfSettings(v.MxfSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDashAdditionalManifest(v *types.DashAdditionalManifest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ManifestNameModifier != nil {
		ok := object.Key("manifestNameModifier")
		ok.String(*v.ManifestNameModifier)
	}

	if v.SelectedOutputs != nil {
		ok := object.Key("selectedOutputs")
		if err := awsRestjson1_serializeDocument__listOf__stringMin1(v.SelectedOutputs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDashIsoEncryptionSettings(v *types.DashIsoEncryptionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.PlaybackDeviceCompatibility) > 0 {
		ok := object.Key("playbackDeviceCompatibility")
		ok.String(string(v.PlaybackDeviceCompatibility))
	}

	if v.SpekeKeyProvider != nil {
		ok := object.Key("spekeKeyProvider")
		if err := awsRestjson1_serializeDocumentSpekeKeyProvider(v.SpekeKeyProvider, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDashIsoGroupSettings(v *types.DashIsoGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalManifests != nil {
		ok := object.Key("additionalManifests")
		if err := awsRestjson1_serializeDocument__listOfDashAdditionalManifest(v.AdditionalManifests, ok); err != nil {
			return err
		}
	}

	if len(v.AudioChannelConfigSchemeIdUri) > 0 {
		ok := object.Key("audioChannelConfigSchemeIdUri")
		ok.String(string(v.AudioChannelConfigSchemeIdUri))
	}

	if v.BaseUrl != nil {
		ok := object.Key("baseUrl")
		ok.String(*v.BaseUrl)
	}

	if len(v.DashManifestStyle) > 0 {
		ok := object.Key("dashManifestStyle")
		ok.String(string(v.DashManifestStyle))
	}

	if v.Destination != nil {
		ok := object.Key("destination")
		ok.String(*v.Destination)
	}

	if v.DestinationSettings != nil {
		ok := object.Key("destinationSettings")
		if err := awsRestjson1_serializeDocumentDestinationSettings(v.DestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentDashIsoEncryptionSettings(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.FragmentLength != nil {
		ok := object.Key("fragmentLength")
		ok.Integer(*v.FragmentLength)
	}

	if len(v.HbbtvCompliance) > 0 {
		ok := object.Key("hbbtvCompliance")
		ok.String(string(v.HbbtvCompliance))
	}

	if len(v.ImageBasedTrickPlay) > 0 {
		ok := object.Key("imageBasedTrickPlay")
		ok.String(string(v.ImageBasedTrickPlay))
	}

	if v.ImageBasedTrickPlaySettings != nil {
		ok := object.Key("imageBasedTrickPlaySettings")
		if err := awsRestjson1_serializeDocumentDashIsoImageBasedTrickPlaySettings(v.ImageBasedTrickPlaySettings, ok); err != nil {
			return err
		}
	}

	if v.MinBufferTime != nil {
		ok := object.Key("minBufferTime")
		ok.Integer(*v.MinBufferTime)
	}

	if v.MinFinalSegmentLength != nil {
		ok := object.Key("minFinalSegmentLength")
		switch {
		case math.IsNaN(*v.MinFinalSegmentLength):
			ok.String("NaN")

		case math.IsInf(*v.MinFinalSegmentLength, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MinFinalSegmentLength, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MinFinalSegmentLength)

		}
	}

	if len(v.MpdManifestBandwidthType) > 0 {
		ok := object.Key("mpdManifestBandwidthType")
		ok.String(string(v.MpdManifestBandwidthType))
	}

	if len(v.MpdProfile) > 0 {
		ok := object.Key("mpdProfile")
		ok.String(string(v.MpdProfile))
	}

	if len(v.PtsOffsetHandlingForBFrames) > 0 {
		ok := object.Key("ptsOffsetHandlingForBFrames")
		ok.String(string(v.PtsOffsetHandlingForBFrames))
	}

	if len(v.SegmentControl) > 0 {
		ok := object.Key("segmentControl")
		ok.String(string(v.SegmentControl))
	}

	if v.SegmentLength != nil {
		ok := object.Key("segmentLength")
		ok.Integer(*v.SegmentLength)
	}

	if len(v.SegmentLengthControl) > 0 {
		ok := object.Key("segmentLengthControl")
		ok.String(string(v.SegmentLengthControl))
	}

	if len(v.VideoCompositionOffsets) > 0 {
		ok := object.Key("videoCompositionOffsets")
		ok.String(string(v.VideoCompositionOffsets))
	}

	if len(v.WriteSegmentTimelineInRepresentation) > 0 {
		ok := object.Key("writeSegmentTimelineInRepresentation")
		ok.String(string(v.WriteSegmentTimelineInRepresentation))
	}

	return nil
}

func awsRestjson1_serializeDocumentDashIsoImageBasedTrickPlaySettings(v *types.DashIsoImageBasedTrickPlaySettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.IntervalCadence) > 0 {
		ok := object.Key("intervalCadence")
		ok.String(string(v.IntervalCadence))
	}

	if v.ThumbnailHeight != nil {
		ok := object.Key("thumbnailHeight")
		ok.Integer(*v.ThumbnailHeight)
	}

	if v.ThumbnailInterval != nil {
		ok := object.Key("thumbnailInterval")
		switch {
		case math.IsNaN(*v.ThumbnailInterval):
			ok.String("NaN")

		case math.IsInf(*v.ThumbnailInterval, 1):
			ok.String("Infinity")

		case math.IsInf(*v.ThumbnailInterval, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.ThumbnailInterval)

		}
	}

	if v.ThumbnailWidth != nil {
		ok := object.Key("thumbnailWidth")
		ok.Integer(*v.ThumbnailWidth)
	}

	if v.TileHeight != nil {
		ok := object.Key("tileHeight")
		ok.Integer(*v.TileHeight)
	}

	if v.TileWidth != nil {
		ok := object.Key("tileWidth")
		ok.Integer(*v.TileWidth)
	}

	return nil
}

func awsRestjson1_serializeDocumentDeinterlacer(v *types.Deinterlacer, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Algorithm) > 0 {
		ok := object.Key("algorithm")
		ok.String(string(v.Algorithm))
	}

	if len(v.Control) > 0 {
		ok := object.Key("control")
		ok.String(string(v.Control))
	}

	if len(v.Mode) > 0 {
		ok := object.Key("mode")
		ok.String(string(v.Mode))
	}

	return nil
}

func awsRestjson1_serializeDocumentDestinationSettings(v *types.DestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Settings != nil {
		ok := object.Key("s3Settings")
		if err := awsRestjson1_serializeDocumentS3DestinationSettings(v.S3Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDolbyVision(v *types.DolbyVision, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.L6Metadata != nil {
		ok := object.Key("l6Metadata")
		if err := awsRestjson1_serializeDocumentDolbyVisionLevel6Metadata(v.L6Metadata, ok); err != nil {
			return err
		}
	}

	if len(v.L6Mode) > 0 {
		ok := object.Key("l6Mode")
		ok.String(string(v.L6Mode))
	}

	if len(v.Mapping) > 0 {
		ok := object.Key("mapping")
		ok.String(string(v.Mapping))
	}

	if len(v.Profile) > 0 {
		ok := object.Key("profile")
		ok.String(string(v.Profile))
	}

	return nil
}

func awsRestjson1_serializeDocumentDolbyVisionLevel6Metadata(v *types.DolbyVisionLevel6Metadata, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxCll != nil {
		ok := object.Key("maxCll")
		ok.Integer(*v.MaxCll)
	}

	if v.MaxFall != nil {
		ok := object.Key("maxFall")
		ok.Integer(*v.MaxFall)
	}

	return nil
}

func awsRestjson1_serializeDocumentDvbNitSettings(v *types.DvbNitSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NetworkId != nil {
		ok := object.Key("networkId")
		ok.Integer(*v.NetworkId)
	}

	if v.NetworkName != nil {
		ok := object.Key("networkName")
		ok.String(*v.NetworkName)
	}

	if v.NitInterval != nil {
		ok := object.Key("nitInterval")
		ok.Integer(*v.NitInterval)
	}

	return nil
}

func awsRestjson1_serializeDocumentDvbSdtSettings(v *types.DvbSdtSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.OutputSdt) > 0 {
		ok := object.Key("outputSdt")
		ok.String(string(v.OutputSdt))
	}

	if v.SdtInterval != nil {
		ok := object.Key("sdtInterval")
		ok.Integer(*v.SdtInterval)
	}

	if v.ServiceName != nil {
		ok := object.Key("serviceName")
		ok.String(*v.ServiceName)
	}

	if v.ServiceProviderName != nil {
		ok := object.Key("serviceProviderName")
		ok.String(*v.ServiceProviderName)
	}

	return nil
}

func awsRestjson1_serializeDocumentDvbSubDestinationSettings(v *types.DvbSubDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Alignment) > 0 {
		ok := object.Key("alignment")
		ok.String(string(v.Alignment))
	}

	if len(v.ApplyFontColor) > 0 {
		ok := object.Key("applyFontColor")
		ok.String(string(v.ApplyFontColor))
	}

	if len(v.BackgroundColor) > 0 {
		ok := object.Key("backgroundColor")
		ok.String(string(v.BackgroundColor))
	}

	if v.BackgroundOpacity != nil {
		ok := object.Key("backgroundOpacity")
		ok.Integer(*v.BackgroundOpacity)
	}

	if len(v.DdsHandling) > 0 {
		ok := object.Key("ddsHandling")
		ok.String(string(v.DdsHandling))
	}

	if v.DdsXCoordinate != nil {
		ok := object.Key("ddsXCoordinate")
		ok.Integer(*v.DdsXCoordinate)
	}

	if v.DdsYCoordinate != nil {
		ok := object.Key("ddsYCoordinate")
		ok.Integer(*v.DdsYCoordinate)
	}

	if len(v.FallbackFont) > 0 {
		ok := object.Key("fallbackFont")
		ok.String(string(v.FallbackFont))
	}

	if len(v.FontColor) > 0 {
		ok := object.Key("fontColor")
		ok.String(string(v.FontColor))
	}

	if v.FontFileBold != nil {
		ok := object.Key("fontFileBold")
		ok.String(*v.FontFileBold)
	}

	if v.FontFileBoldItalic != nil {
		ok := object.Key("fontFileBoldItalic")
		ok.String(*v.FontFileBoldItalic)
	}

	if v.FontFileItalic != nil {
		ok := object.Key("fontFileItalic")
		ok.String(*v.FontFileItalic)
	}

	if v.FontFileRegular != nil {
		ok := object.Key("fontFileRegular")
		ok.String(*v.FontFileRegular)
	}

	if v.FontOpacity != nil {
		ok := object.Key("fontOpacity")
		ok.Integer(*v.FontOpacity)
	}

	if v.FontResolution != nil {
		ok := object.Key("fontResolution")
		ok.Integer(*v.FontResolution)
	}

	if len(v.FontScript) > 0 {
		ok := object.Key("fontScript")
		ok.String(string(v.FontScript))
	}

	if v.FontSize != nil {
		ok := object.Key("fontSize")
		ok.Integer(*v.FontSize)
	}

	if v.Height != nil {
		ok := object.Key("height")
		ok.Integer(*v.Height)
	}

	if v.HexFontColor != nil {
		ok := object.Key("hexFontColor")
		ok.String(*v.HexFontColor)
	}

	if len(v.OutlineColor) > 0 {
		ok := object.Key("outlineColor")
		ok.String(string(v.OutlineColor))
	}

	if v.OutlineSize != nil {
		ok := object.Key("outlineSize")
		ok.Integer(*v.OutlineSize)
	}

	if len(v.ShadowColor) > 0 {
		ok := object.Key("shadowColor")
		ok.String(string(v.ShadowColor))
	}

	if v.ShadowOpacity != nil {
		ok := object.Key("shadowOpacity")
		ok.Integer(*v.ShadowOpacity)
	}

	if v.ShadowXOffset != nil {
		ok := object.Key("shadowXOffset")
		ok.Integer(*v.ShadowXOffset)
	}

	if v.ShadowYOffset != nil {
		ok := object.Key("shadowYOffset")
		ok.Integer(*v.ShadowYOffset)
	}

	if len(v.StylePassthrough) > 0 {
		ok := object.Key("stylePassthrough")
		ok.String(string(v.StylePassthrough))
	}

	if len(v.SubtitlingType) > 0 {
		ok := object.Key("subtitlingType")
		ok.String(string(v.SubtitlingType))
	}

	if len(v.TeletextSpacing) > 0 {
		ok := object.Key("teletextSpacing")
		ok.String(string(v.TeletextSpacing))
	}

	if v.Width != nil {
		ok := object.Key("width")
		ok.Integer(*v.Width)
	}

	if v.XPosition != nil {
		ok := object.Key("xPosition")
		ok.Integer(*v.XPosition)
	}

	if v.YPosition != nil {
		ok := object.Key("yPosition")
		ok.Integer(*v.YPosition)
	}

	return nil
}

func awsRestjson1_serializeDocumentDvbSubSourceSettings(v *types.DvbSubSourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Pid != nil {
		ok := object.Key("pid")
		ok.Integer(*v.Pid)
	}

	return nil
}

func awsRestjson1_serializeDocumentDvbTdtSettings(v *types.DvbTdtSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TdtInterval != nil {
		ok := object.Key("tdtInterval")
		ok.Integer(*v.TdtInterval)
	}

	return nil
}

func awsRestjson1_serializeDocumentEac3AtmosSettings(v *types.Eac3AtmosSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bitrate != nil {
		ok := object.Key("bitrate")
		ok.Integer(*v.Bitrate)
	}

	if len(v.BitstreamMode) > 0 {
		ok := object.Key("bitstreamMode")
		ok.String(string(v.BitstreamMode))
	}

	if len(v.CodingMode) > 0 {
		ok := object.Key("codingMode")
		ok.String(string(v.CodingMode))
	}

	if len(v.DialogueIntelligence) > 0 {
		ok := object.Key("dialogueIntelligence")
		ok.String(string(v.DialogueIntelligence))
	}

	if len(v.DownmixControl) > 0 {
		ok := object.Key("downmixControl")
		ok.String(string(v.DownmixControl))
	}

	if len(v.DynamicRangeCompressionLine) > 0 {
		ok := object.Key("dynamicRangeCompressionLine")
		ok.String(string(v.DynamicRangeCompressionLine))
	}

	if len(v.DynamicRangeCompressionRf) > 0 {
		ok := object.Key("dynamicRangeCompressionRf")
		ok.String(string(v.DynamicRangeCompressionRf))
	}

	if len(v.DynamicRangeControl) > 0 {
		ok := object.Key("dynamicRangeControl")
		ok.String(string(v.DynamicRangeControl))
	}

	if v.LoRoCenterMixLevel != nil {
		ok := object.Key("loRoCenterMixLevel")
		switch {
		case math.IsNaN(*v.LoRoCenterMixLevel):
			ok.String("NaN")

		case math.IsInf(*v.LoRoCenterMixLevel, 1):
			ok.String("Infinity")

		case math.IsInf(*v.LoRoCenterMixLevel, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.LoRoCenterMixLevel)

		}
	}

	if v.LoRoSurroundMixLevel != nil {
		ok := object.Key("loRoSurroundMixLevel")
		switch {
		case math.IsNaN(*v.LoRoSurroundMixLevel):
			ok.String("NaN")

		case math.IsInf(*v.LoRoSurroundMixLevel, 1):
			ok.String("Infinity")

		case math.IsInf(*v.LoRoSurroundMixLevel, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.LoRoSurroundMixLevel)

		}
	}

	if v.LtRtCenterMixLevel != nil {
		ok := object.Key("ltRtCenterMixLevel")
		switch {
		case math.IsNaN(*v.LtRtCenterMixLevel):
			ok.String("NaN")

		case math.IsInf(*v.LtRtCenterMixLevel, 1):
			ok.String("Infinity")

		case math.IsInf(*v.LtRtCenterMixLevel, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.LtRtCenterMixLevel)

		}
	}

	if v.LtRtSurroundMixLevel != nil {
		ok := object.Key("ltRtSurroundMixLevel")
		switch {
		case math.IsNaN(*v.LtRtSurroundMixLevel):
			ok.String("NaN")

		case math.IsInf(*v.LtRtSurroundMixLevel, 1):
			ok.String("Infinity")

		case math.IsInf(*v.LtRtSurroundMixLevel, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.LtRtSurroundMixLevel)

		}
	}

	if len(v.MeteringMode) > 0 {
		ok := object.Key("meteringMode")
		ok.String(string(v.MeteringMode))
	}

	if v.SampleRate != nil {
		ok := object.Key("sampleRate")
		ok.Integer(*v.SampleRate)
	}

	if v.SpeechThreshold != nil {
		ok := object.Key("speechThreshold")
		ok.Integer(*v.SpeechThreshold)
	}

	if len(v.StereoDownmix) > 0 {
		ok := object.Key("stereoDownmix")
		ok.String(string(v.StereoDownmix))
	}

	if len(v.SurroundExMode) > 0 {
		ok := object.Key("surroundExMode")
		ok.String(string(v.SurroundExMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentEac3Settings(v *types.Eac3Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AttenuationControl) > 0 {
		ok := object.Key("attenuationControl")
		ok.String(string(v.AttenuationControl))
	}

	if v.Bitrate != nil {
		ok := object.Key("bitrate")
		ok.Integer(*v.Bitrate)
	}

	if len(v.BitstreamMode) > 0 {
		ok := object.Key("bitstreamMode")
		ok.String(string(v.BitstreamMode))
	}

	if len(v.CodingMode) > 0 {
		ok := object.Key("codingMode")
		ok.String(string(v.CodingMode))
	}

	if len(v.DcFilter) > 0 {
		ok := object.Key("dcFilter")
		ok.String(string(v.DcFilter))
	}

	if v.Dialnorm != nil {
		ok := object.Key("dialnorm")
		ok.Integer(*v.Dialnorm)
	}

	if len(v.DynamicRangeCompressionLine) > 0 {
		ok := object.Key("dynamicRangeCompressionLine")
		ok.String(string(v.DynamicRangeCompressionLine))
	}

	if len(v.DynamicRangeCompressionRf) > 0 {
		ok := object.Key("dynamicRangeCompressionRf")
		ok.String(string(v.DynamicRangeCompressionRf))
	}

	if len(v.LfeControl) > 0 {
		ok := object.Key("lfeControl")
		ok.String(string(v.LfeControl))
	}

	if len(v.LfeFilter) > 0 {
		ok := object.Key("lfeFilter")
		ok.String(string(v.LfeFilter))
	}

	if v.LoRoCenterMixLevel != nil {
		ok := object.Key("loRoCenterMixLevel")
		switch {
		case math.IsNaN(*v.LoRoCenterMixLevel):
			ok.String("NaN")

		case math.IsInf(*v.LoRoCenterMixLevel, 1):
			ok.String("Infinity")

		case math.IsInf(*v.LoRoCenterMixLevel, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.LoRoCenterMixLevel)

		}
	}

	if v.LoRoSurroundMixLevel != nil {
		ok := object.Key("loRoSurroundMixLevel")
		switch {
		case math.IsNaN(*v.LoRoSurroundMixLevel):
			ok.String("NaN")

		case math.IsInf(*v.LoRoSurroundMixLevel, 1):
			ok.String("Infinity")

		case math.IsInf(*v.LoRoSurroundMixLevel, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.LoRoSurroundMixLevel)

		}
	}

	if v.LtRtCenterMixLevel != nil {
		ok := object.Key("ltRtCenterMixLevel")
		switch {
		case math.IsNaN(*v.LtRtCenterMixLevel):
			ok.String("NaN")

		case math.IsInf(*v.LtRtCenterMixLevel, 1):
			ok.String("Infinity")

		case math.IsInf(*v.LtRtCenterMixLevel, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.LtRtCenterMixLevel)

		}
	}

	if v.LtRtSurroundMixLevel != nil {
		ok := object.Key("ltRtSurroundMixLevel")
		switch {
		case math.IsNaN(*v.LtRtSurroundMixLevel):
			ok.String("NaN")

		case math.IsInf(*v.LtRtSurroundMixLevel, 1):
			ok.String("Infinity")

		case math.IsInf(*v.LtRtSurroundMixLevel, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.LtRtSurroundMixLevel)

		}
	}

	if len(v.MetadataControl) > 0 {
		ok := object.Key("metadataControl")
		ok.String(string(v.MetadataControl))
	}

	if len(v.PassthroughControl) > 0 {
		ok := object.Key("passthroughControl")
		ok.String(string(v.PassthroughControl))
	}

	if len(v.PhaseControl) > 0 {
		ok := object.Key("phaseControl")
		ok.String(string(v.PhaseControl))
	}

	if v.SampleRate != nil {
		ok := object.Key("sampleRate")
		ok.Integer(*v.SampleRate)
	}

	if len(v.StereoDownmix) > 0 {
		ok := object.Key("stereoDownmix")
		ok.String(string(v.StereoDownmix))
	}

	if len(v.SurroundExMode) > 0 {
		ok := object.Key("surroundExMode")
		ok.String(string(v.SurroundExMode))
	}

	if len(v.SurroundMode) > 0 {
		ok := object.Key("surroundMode")
		ok.String(string(v.SurroundMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentEmbeddedDestinationSettings(v *types.EmbeddedDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination608ChannelNumber != nil {
		ok := object.Key("destination608ChannelNumber")
		ok.Integer(*v.Destination608ChannelNumber)
	}

	if v.Destination708ServiceNumber != nil {
		ok := object.Key("destination708ServiceNumber")
		ok.Integer(*v.Destination708ServiceNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentEmbeddedSourceSettings(v *types.EmbeddedSourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Convert608To708) > 0 {
		ok := object.Key("convert608To708")
		ok.String(string(v.Convert608To708))
	}

	if v.Source608ChannelNumber != nil {
		ok := object.Key("source608ChannelNumber")
		ok.Integer(*v.Source608ChannelNumber)
	}

	if v.Source608TrackNumber != nil {
		ok := object.Key("source608TrackNumber")
		ok.Integer(*v.Source608TrackNumber)
	}

	if len(v.TerminateCaptions) > 0 {
		ok := object.Key("terminateCaptions")
		ok.String(string(v.TerminateCaptions))
	}

	return nil
}

func awsRestjson1_serializeDocumentEsamManifestConfirmConditionNotification(v *types.EsamManifestConfirmConditionNotification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MccXml != nil {
		ok := object.Key("mccXml")
		ok.String(*v.MccXml)
	}

	return nil
}

func awsRestjson1_serializeDocumentEsamSettings(v *types.EsamSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ManifestConfirmConditionNotification != nil {
		ok := object.Key("manifestConfirmConditionNotification")
		if err := awsRestjson1_serializeDocumentEsamManifestConfirmConditionNotification(v.ManifestConfirmConditionNotification, ok); err != nil {
			return err
		}
	}

	if v.ResponseSignalPreroll != nil {
		ok := object.Key("responseSignalPreroll")
		ok.Integer(*v.ResponseSignalPreroll)
	}

	if v.SignalProcessingNotification != nil {
		ok := object.Key("signalProcessingNotification")
		if err := awsRestjson1_serializeDocumentEsamSignalProcessingNotification(v.SignalProcessingNotification, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEsamSignalProcessingNotification(v *types.EsamSignalProcessingNotification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SccXml != nil {
		ok := object.Key("sccXml")
		ok.String(*v.SccXml)
	}

	return nil
}

func awsRestjson1_serializeDocumentExtendedDataServices(v *types.ExtendedDataServices, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CopyProtectionAction) > 0 {
		ok := object.Key("copyProtectionAction")
		ok.String(string(v.CopyProtectionAction))
	}

	if len(v.VchipAction) > 0 {
		ok := object.Key("vchipAction")
		ok.String(string(v.VchipAction))
	}

	return nil
}

func awsRestjson1_serializeDocumentF4vSettings(v *types.F4vSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MoovPlacement) > 0 {
		ok := object.Key("moovPlacement")
		ok.String(string(v.MoovPlacement))
	}

	return nil
}

func awsRestjson1_serializeDocumentFileGroupSettings(v *types.FileGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("destination")
		ok.String(*v.Destination)
	}

	if v.DestinationSettings != nil {
		ok := object.Key("destinationSettings")
		if err := awsRestjson1_serializeDocumentDestinationSettings(v.DestinationSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFileSourceSettings(v *types.FileSourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Convert608To708) > 0 {
		ok := object.Key("convert608To708")
		ok.String(string(v.Convert608To708))
	}

	if len(v.ConvertPaintToPop) > 0 {
		ok := object.Key("convertPaintToPop")
		ok.String(string(v.ConvertPaintToPop))
	}

	if v.Framerate != nil {
		ok := object.Key("framerate")
		if err := awsRestjson1_serializeDocumentCaptionSourceFramerate(v.Framerate, ok); err != nil {
			return err
		}
	}

	if v.SourceFile != nil {
		ok := object.Key("sourceFile")
		ok.String(*v.SourceFile)
	}

	if v.TimeDelta != nil {
		ok := object.Key("timeDelta")
		ok.Integer(*v.TimeDelta)
	}

	if len(v.TimeDeltaUnits) > 0 {
		ok := object.Key("timeDeltaUnits")
		ok.String(string(v.TimeDeltaUnits))
	}

	return nil
}

func awsRestjson1_serializeDocumentFlacSettings(v *types.FlacSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BitDepth != nil {
		ok := object.Key("bitDepth")
		ok.Integer(*v.BitDepth)
	}

	if v.Channels != nil {
		ok := object.Key("channels")
		ok.Integer(*v.Channels)
	}

	if v.SampleRate != nil {
		ok := object.Key("sampleRate")
		ok.Integer(*v.SampleRate)
	}

	return nil
}

func awsRestjson1_serializeDocumentForceIncludeRenditionSize(v *types.ForceIncludeRenditionSize, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Height != nil {
		ok := object.Key("height")
		ok.Integer(*v.Height)
	}

	if v.Width != nil {
		ok := object.Key("width")
		ok.Integer(*v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentFrameCaptureSettings(v *types.FrameCaptureSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FramerateDenominator != nil {
		ok := object.Key("framerateDenominator")
		ok.Integer(*v.FramerateDenominator)
	}

	if v.FramerateNumerator != nil {
		ok := object.Key("framerateNumerator")
		ok.Integer(*v.FramerateNumerator)
	}

	if v.MaxCaptures != nil {
		ok := object.Key("maxCaptures")
		ok.Integer(*v.MaxCaptures)
	}

	if v.Quality != nil {
		ok := object.Key("quality")
		ok.Integer(*v.Quality)
	}

	return nil
}

func awsRestjson1_serializeDocumentH264QvbrSettings(v *types.H264QvbrSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxAverageBitrate != nil {
		ok := object.Key("maxAverageBitrate")
		ok.Integer(*v.MaxAverageBitrate)
	}

	if v.QvbrQualityLevel != nil {
		ok := object.Key("qvbrQualityLevel")
		ok.Integer(*v.QvbrQualityLevel)
	}

	if v.QvbrQualityLevelFineTune != nil {
		ok := object.Key("qvbrQualityLevelFineTune")
		switch {
		case math.IsNaN(*v.QvbrQualityLevelFineTune):
			ok.String("NaN")

		case math.IsInf(*v.QvbrQualityLevelFineTune, 1):
			ok.String("Infinity")

		case math.IsInf(*v.QvbrQualityLevelFineTune, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.QvbrQualityLevelFineTune)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentH264Settings(v *types.H264Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AdaptiveQuantization) > 0 {
		ok := object.Key("adaptiveQuantization")
		ok.String(string(v.AdaptiveQuantization))
	}

	if v.BandwidthReductionFilter != nil {
		ok := object.Key("bandwidthReductionFilter")
		if err := awsRestjson1_serializeDocumentBandwidthReductionFilter(v.BandwidthReductionFilter, ok); err != nil {
			return err
		}
	}

	if v.Bitrate != nil {
		ok := object.Key("bitrate")
		ok.Integer(*v.Bitrate)
	}

	if len(v.CodecLevel) > 0 {
		ok := object.Key("codecLevel")
		ok.String(string(v.CodecLevel))
	}

	if len(v.CodecProfile) > 0 {
		ok := object.Key("codecProfile")
		ok.String(string(v.CodecProfile))
	}

	if len(v.DynamicSubGop) > 0 {
		ok := object.Key("dynamicSubGop")
		ok.String(string(v.DynamicSubGop))
	}

	if len(v.EndOfStreamMarkers) > 0 {
		ok := object.Key("endOfStreamMarkers")
		ok.String(string(v.EndOfStreamMarkers))
	}

	if len(v.EntropyEncoding) > 0 {
		ok := object.Key("entropyEncoding")
		ok.String(string(v.EntropyEncoding))
	}

	if len(v.FieldEncoding) > 0 {
		ok := object.Key("fieldEncoding")
		ok.String(string(v.FieldEncoding))
	}

	if len(v.FlickerAdaptiveQuantization) > 0 {
		ok := object.Key("flickerAdaptiveQuantization")
		ok.String(string(v.FlickerAdaptiveQuantization))
	}

	if len(v.FramerateControl) > 0 {
		ok := object.Key("framerateControl")
		ok.String(string(v.FramerateControl))
	}

	if len(v.FramerateConversionAlgorithm) > 0 {
		ok := object.Key("framerateConversionAlgorithm")
		ok.String(string(v.FramerateConversionAlgorithm))
	}

	if v.FramerateDenominator != nil {
		ok := object.Key("framerateDenominator")
		ok.Integer(*v.FramerateDenominator)
	}

	if v.FramerateNumerator != nil {
		ok := object.Key("framerateNumerator")
		ok.Integer(*v.FramerateNumerator)
	}

	if len(v.GopBReference) > 0 {
		ok := object.Key("gopBReference")
		ok.String(string(v.GopBReference))
	}

	if v.GopClosedCadence != nil {
		ok := object.Key("gopClosedCadence")
		ok.Integer(*v.GopClosedCadence)
	}

	if v.GopSize != nil {
		ok := object.Key("gopSize")
		switch {
		case math.IsNaN(*v.GopSize):
			ok.String("NaN")

		case math.IsInf(*v.GopSize, 1):
			ok.String("Infinity")

		case math.IsInf(*v.GopSize, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.GopSize)

		}
	}

	if len(v.GopSizeUnits) > 0 {
		ok := object.Key("gopSizeUnits")
		ok.String(string(v.GopSizeUnits))
	}

	if v.HrdBufferFinalFillPercentage != nil {
		ok := object.Key("hrdBufferFinalFillPercentage")
		ok.Integer(*v.HrdBufferFinalFillPercentage)
	}

	if v.HrdBufferInitialFillPercentage != nil {
		ok := object.Key("hrdBufferInitialFillPercentage")
		ok.Integer(*v.HrdBufferInitialFillPercentage)
	}

	if v.HrdBufferSize != nil {
		ok := object.Key("hrdBufferSize")
		ok.Integer(*v.HrdBufferSize)
	}

	if len(v.InterlaceMode) > 0 {
		ok := object.Key("interlaceMode")
		ok.String(string(v.InterlaceMode))
	}

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	if v.MinIInterval != nil {
		ok := object.Key("minIInterval")
		ok.Integer(*v.MinIInterval)
	}

	if v.NumberBFramesBetweenReferenceFrames != nil {
		ok := object.Key("numberBFramesBetweenReferenceFrames")
		ok.Integer(*v.NumberBFramesBetweenReferenceFrames)
	}

	if v.NumberReferenceFrames != nil {
		ok := object.Key("numberReferenceFrames")
		ok.Integer(*v.NumberReferenceFrames)
	}

	if len(v.ParControl) > 0 {
		ok := object.Key("parControl")
		ok.String(string(v.ParControl))
	}

	if v.ParDenominator != nil {
		ok := object.Key("parDenominator")
		ok.Integer(*v.ParDenominator)
	}

	if v.ParNumerator != nil {
		ok := object.Key("parNumerator")
		ok.Integer(*v.ParNumerator)
	}

	if len(v.QualityTuningLevel) > 0 {
		ok := object.Key("qualityTuningLevel")
		ok.String(string(v.QualityTuningLevel))
	}

	if v.QvbrSettings != nil {
		ok := object.Key("qvbrSettings")
		if err := awsRestjson1_serializeDocumentH264QvbrSettings(v.QvbrSettings, ok); err != nil {
			return err
		}
	}

	if len(v.RateControlMode) > 0 {
		ok := object.Key("rateControlMode")
		ok.String(string(v.RateControlMode))
	}

	if len(v.RepeatPps) > 0 {
		ok := object.Key("repeatPps")
		ok.String(string(v.RepeatPps))
	}

	if len(v.ScanTypeConversionMode) > 0 {
		ok := object.Key("scanTypeConversionMode")
		ok.String(string(v.ScanTypeConversionMode))
	}

	if len(v.SceneChangeDetect) > 0 {
		ok := object.Key("sceneChangeDetect")
		ok.String(string(v.SceneChangeDetect))
	}

	if v.Slices != nil {
		ok := object.Key("slices")
		ok.Integer(*v.Slices)
	}

	if len(v.SlowPal) > 0 {
		ok := object.Key("slowPal")
		ok.String(string(v.SlowPal))
	}

	if v.Softness != nil {
		ok := object.Key("softness")
		ok.Integer(*v.Softness)
	}

	if len(v.SpatialAdaptiveQuantization) > 0 {
		ok := object.Key("spatialAdaptiveQuantization")
		ok.String(string(v.SpatialAdaptiveQuantization))
	}

	if len(v.Syntax) > 0 {
		ok := object.Key("syntax")
		ok.String(string(v.Syntax))
	}

	if len(v.Telecine) > 0 {
		ok := object.Key("telecine")
		ok.String(string(v.Telecine))
	}

	if len(v.TemporalAdaptiveQuantization) > 0 {
		ok := object.Key("temporalAdaptiveQuantization")
		ok.String(string(v.TemporalAdaptiveQuantization))
	}

	if len(v.UnregisteredSeiTimecode) > 0 {
		ok := object.Key("unregisteredSeiTimecode")
		ok.String(string(v.UnregisteredSeiTimecode))
	}

	return nil
}

func awsRestjson1_serializeDocumentH265QvbrSettings(v *types.H265QvbrSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxAverageBitrate != nil {
		ok := object.Key("maxAverageBitrate")
		ok.Integer(*v.MaxAverageBitrate)
	}

	if v.QvbrQualityLevel != nil {
		ok := object.Key("qvbrQualityLevel")
		ok.Integer(*v.QvbrQualityLevel)
	}

	if v.QvbrQualityLevelFineTune != nil {
		ok := object.Key("qvbrQualityLevelFineTune")
		switch {
		case math.IsNaN(*v.QvbrQualityLevelFineTune):
			ok.String("NaN")

		case math.IsInf(*v.QvbrQualityLevelFineTune, 1):
			ok.String("Infinity")

		case math.IsInf(*v.QvbrQualityLevelFineTune, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.QvbrQualityLevelFineTune)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentH265Settings(v *types.H265Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AdaptiveQuantization) > 0 {
		ok := object.Key("adaptiveQuantization")
		ok.String(string(v.AdaptiveQuantization))
	}

	if len(v.AlternateTransferFunctionSei) > 0 {
		ok := object.Key("alternateTransferFunctionSei")
		ok.String(string(v.AlternateTransferFunctionSei))
	}

	if v.BandwidthReductionFilter != nil {
		ok := object.Key("bandwidthReductionFilter")
		if err := awsRestjson1_serializeDocumentBandwidthReductionFilter(v.BandwidthReductionFilter, ok); err != nil {
			return err
		}
	}

	if v.Bitrate != nil {
		ok := object.Key("bitrate")
		ok.Integer(*v.Bitrate)
	}

	if len(v.CodecLevel) > 0 {
		ok := object.Key("codecLevel")
		ok.String(string(v.CodecLevel))
	}

	if len(v.CodecProfile) > 0 {
		ok := object.Key("codecProfile")
		ok.String(string(v.CodecProfile))
	}

	if len(v.DynamicSubGop) > 0 {
		ok := object.Key("dynamicSubGop")
		ok.String(string(v.DynamicSubGop))
	}

	if len(v.EndOfStreamMarkers) > 0 {
		ok := object.Key("endOfStreamMarkers")
		ok.String(string(v.EndOfStreamMarkers))
	}

	if len(v.FlickerAdaptiveQuantization) > 0 {
		ok := object.Key("flickerAdaptiveQuantization")
		ok.String(string(v.FlickerAdaptiveQuantization))
	}

	if len(v.FramerateControl) > 0 {
		ok := object.Key("framerateControl")
		ok.String(string(v.FramerateControl))
	}

	if len(v.FramerateConversionAlgorithm) > 0 {
		ok := object.Key("framerateConversionAlgorithm")
		ok.String(string(v.FramerateConversionAlgorithm))
	}

	if v.FramerateDenominator != nil {
		ok := object.Key("framerateDenominator")
		ok.Integer(*v.FramerateDenominator)
	}

	if v.FramerateNumerator != nil {
		ok := object.Key("framerateNumerator")
		ok.Integer(*v.FramerateNumerator)
	}

	if len(v.GopBReference) > 0 {
		ok := object.Key("gopBReference")
		ok.String(string(v.GopBReference))
	}

	if v.GopClosedCadence != nil {
		ok := object.Key("gopClosedCadence")
		ok.Integer(*v.GopClosedCadence)
	}

	if v.GopSize != nil {
		ok := object.Key("gopSize")
		switch {
		case math.IsNaN(*v.GopSize):
			ok.String("NaN")

		case math.IsInf(*v.GopSize, 1):
			ok.String("Infinity")

		case math.IsInf(*v.GopSize, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.GopSize)

		}
	}

	if len(v.GopSizeUnits) > 0 {
		ok := object.Key("gopSizeUnits")
		ok.String(string(v.GopSizeUnits))
	}

	if v.HrdBufferFinalFillPercentage != nil {
		ok := object.Key("hrdBufferFinalFillPercentage")
		ok.Integer(*v.HrdBufferFinalFillPercentage)
	}

	if v.HrdBufferInitialFillPercentage != nil {
		ok := object.Key("hrdBufferInitialFillPercentage")
		ok.Integer(*v.HrdBufferInitialFillPercentage)
	}

	if v.HrdBufferSize != nil {
		ok := object.Key("hrdBufferSize")
		ok.Integer(*v.HrdBufferSize)
	}

	if len(v.InterlaceMode) > 0 {
		ok := object.Key("interlaceMode")
		ok.String(string(v.InterlaceMode))
	}

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	if v.MinIInterval != nil {
		ok := object.Key("minIInterval")
		ok.Integer(*v.MinIInterval)
	}

	if v.NumberBFramesBetweenReferenceFrames != nil {
		ok := object.Key("numberBFramesBetweenReferenceFrames")
		ok.Integer(*v.NumberBFramesBetweenReferenceFrames)
	}

	if v.NumberReferenceFrames != nil {
		ok := object.Key("numberReferenceFrames")
		ok.Integer(*v.NumberReferenceFrames)
	}

	if len(v.ParControl) > 0 {
		ok := object.Key("parControl")
		ok.String(string(v.ParControl))
	}

	if v.ParDenominator != nil {
		ok := object.Key("parDenominator")
		ok.Integer(*v.ParDenominator)
	}

	if v.ParNumerator != nil {
		ok := object.Key("parNumerator")
		ok.Integer(*v.ParNumerator)
	}

	if len(v.QualityTuningLevel) > 0 {
		ok := object.Key("qualityTuningLevel")
		ok.String(string(v.QualityTuningLevel))
	}

	if v.QvbrSettings != nil {
		ok := object.Key("qvbrSettings")
		if err := awsRestjson1_serializeDocumentH265QvbrSettings(v.QvbrSettings, ok); err != nil {
			return err
		}
	}

	if len(v.RateControlMode) > 0 {
		ok := object.Key("rateControlMode")
		ok.String(string(v.RateControlMode))
	}

	if len(v.SampleAdaptiveOffsetFilterMode) > 0 {
		ok := object.Key("sampleAdaptiveOffsetFilterMode")
		ok.String(string(v.SampleAdaptiveOffsetFilterMode))
	}

	if len(v.ScanTypeConversionMode) > 0 {
		ok := object.Key("scanTypeConversionMode")
		ok.String(string(v.ScanTypeConversionMode))
	}

	if len(v.SceneChangeDetect) > 0 {
		ok := object.Key("sceneChangeDetect")
		ok.String(string(v.SceneChangeDetect))
	}

	if v.Slices != nil {
		ok := object.Key("slices")
		ok.Integer(*v.Slices)
	}

	if len(v.SlowPal) > 0 {
		ok := object.Key("slowPal")
		ok.String(string(v.SlowPal))
	}

	if len(v.SpatialAdaptiveQuantization) > 0 {
		ok := object.Key("spatialAdaptiveQuantization")
		ok.String(string(v.SpatialAdaptiveQuantization))
	}

	if len(v.Telecine) > 0 {
		ok := object.Key("telecine")
		ok.String(string(v.Telecine))
	}

	if len(v.TemporalAdaptiveQuantization) > 0 {
		ok := object.Key("temporalAdaptiveQuantization")
		ok.String(string(v.TemporalAdaptiveQuantization))
	}

	if len(v.TemporalIds) > 0 {
		ok := object.Key("temporalIds")
		ok.String(string(v.TemporalIds))
	}

	if len(v.Tiles) > 0 {
		ok := object.Key("tiles")
		ok.String(string(v.Tiles))
	}

	if len(v.UnregisteredSeiTimecode) > 0 {
		ok := object.Key("unregisteredSeiTimecode")
		ok.String(string(v.UnregisteredSeiTimecode))
	}

	if len(v.WriteMp4PackagingType) > 0 {
		ok := object.Key("writeMp4PackagingType")
		ok.String(string(v.WriteMp4PackagingType))
	}

	return nil
}

func awsRestjson1_serializeDocumentHdr10Metadata(v *types.Hdr10Metadata, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BluePrimaryX != nil {
		ok := object.Key("bluePrimaryX")
		ok.Integer(*v.BluePrimaryX)
	}

	if v.BluePrimaryY != nil {
		ok := object.Key("bluePrimaryY")
		ok.Integer(*v.BluePrimaryY)
	}

	if v.GreenPrimaryX != nil {
		ok := object.Key("greenPrimaryX")
		ok.Integer(*v.GreenPrimaryX)
	}

	if v.GreenPrimaryY != nil {
		ok := object.Key("greenPrimaryY")
		ok.Integer(*v.GreenPrimaryY)
	}

	if v.MaxContentLightLevel != nil {
		ok := object.Key("maxContentLightLevel")
		ok.Integer(*v.MaxContentLightLevel)
	}

	if v.MaxFrameAverageLightLevel != nil {
		ok := object.Key("maxFrameAverageLightLevel")
		ok.Integer(*v.MaxFrameAverageLightLevel)
	}

	if v.MaxLuminance != nil {
		ok := object.Key("maxLuminance")
		ok.Integer(*v.MaxLuminance)
	}

	if v.MinLuminance != nil {
		ok := object.Key("minLuminance")
		ok.Integer(*v.MinLuminance)
	}

	if v.RedPrimaryX != nil {
		ok := object.Key("redPrimaryX")
		ok.Integer(*v.RedPrimaryX)
	}

	if v.RedPrimaryY != nil {
		ok := object.Key("redPrimaryY")
		ok.Integer(*v.RedPrimaryY)
	}

	if v.WhitePointX != nil {
		ok := object.Key("whitePointX")
		ok.Integer(*v.WhitePointX)
	}

	if v.WhitePointY != nil {
		ok := object.Key("whitePointY")
		ok.Integer(*v.WhitePointY)
	}

	return nil
}

func awsRestjson1_serializeDocumentHdr10Plus(v *types.Hdr10Plus, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MasteringMonitorNits != nil {
		ok := object.Key("masteringMonitorNits")
		ok.Integer(*v.MasteringMonitorNits)
	}

	if v.TargetMonitorNits != nil {
		ok := object.Key("targetMonitorNits")
		ok.Integer(*v.TargetMonitorNits)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsAdditionalManifest(v *types.HlsAdditionalManifest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ManifestNameModifier != nil {
		ok := object.Key("manifestNameModifier")
		ok.String(*v.ManifestNameModifier)
	}

	if v.SelectedOutputs != nil {
		ok := object.Key("selectedOutputs")
		if err := awsRestjson1_serializeDocument__listOf__stringMin1(v.SelectedOutputs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsCaptionLanguageMapping(v *types.HlsCaptionLanguageMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CaptionChannel != nil {
		ok := object.Key("captionChannel")
		ok.Integer(*v.CaptionChannel)
	}

	if v.CustomLanguageCode != nil {
		ok := object.Key("customLanguageCode")
		ok.String(*v.CustomLanguageCode)
	}

	if len(v.LanguageCode) > 0 {
		ok := object.Key("languageCode")
		ok.String(string(v.LanguageCode))
	}

	if v.LanguageDescription != nil {
		ok := object.Key("languageDescription")
		ok.String(*v.LanguageDescription)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsEncryptionSettings(v *types.HlsEncryptionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConstantInitializationVector != nil {
		ok := object.Key("constantInitializationVector")
		ok.String(*v.ConstantInitializationVector)
	}

	if len(v.EncryptionMethod) > 0 {
		ok := object.Key("encryptionMethod")
		ok.String(string(v.EncryptionMethod))
	}

	if len(v.InitializationVectorInManifest) > 0 {
		ok := object.Key("initializationVectorInManifest")
		ok.String(string(v.InitializationVectorInManifest))
	}

	if len(v.OfflineEncrypted) > 0 {
		ok := object.Key("offlineEncrypted")
		ok.String(string(v.OfflineEncrypted))
	}

	if v.SpekeKeyProvider != nil {
		ok := object.Key("spekeKeyProvider")
		if err := awsRestjson1_serializeDocumentSpekeKeyProvider(v.SpekeKeyProvider, ok); err != nil {
			return err
		}
	}

	if v.StaticKeyProvider != nil {
		ok := object.Key("staticKeyProvider")
		if err := awsRestjson1_serializeDocumentStaticKeyProvider(v.StaticKeyProvider, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsGroupSettings(v *types.HlsGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalManifests != nil {
		ok := object.Key("additionalManifests")
		if err := awsRestjson1_serializeDocument__listOfHlsAdditionalManifest(v.AdditionalManifests, ok); err != nil {
			return err
		}
	}

	if v.AdMarkers != nil {
		ok := object.Key("adMarkers")
		if err := awsRestjson1_serializeDocument__listOfHlsAdMarkers(v.AdMarkers, ok); err != nil {
			return err
		}
	}

	if len(v.AudioOnlyHeader) > 0 {
		ok := object.Key("audioOnlyHeader")
		ok.String(string(v.AudioOnlyHeader))
	}

	if v.BaseUrl != nil {
		ok := object.Key("baseUrl")
		ok.String(*v.BaseUrl)
	}

	if v.CaptionLanguageMappings != nil {
		ok := object.Key("captionLanguageMappings")
		if err := awsRestjson1_serializeDocument__listOfHlsCaptionLanguageMapping(v.CaptionLanguageMappings, ok); err != nil {
			return err
		}
	}

	if len(v.CaptionLanguageSetting) > 0 {
		ok := object.Key("captionLanguageSetting")
		ok.String(string(v.CaptionLanguageSetting))
	}

	if len(v.CaptionSegmentLengthControl) > 0 {
		ok := object.Key("captionSegmentLengthControl")
		ok.String(string(v.CaptionSegmentLengthControl))
	}

	if len(v.ClientCache) > 0 {
		ok := object.Key("clientCache")
		ok.String(string(v.ClientCache))
	}

	if len(v.CodecSpecification) > 0 {
		ok := object.Key("codecSpecification")
		ok.String(string(v.CodecSpecification))
	}

	if v.Destination != nil {
		ok := object.Key("destination")
		ok.String(*v.Destination)
	}

	if v.DestinationSettings != nil {
		ok := object.Key("destinationSettings")
		if err := awsRestjson1_serializeDocumentDestinationSettings(v.DestinationSettings, ok); err != nil {
			return err
		}
	}

	if len(v.DirectoryStructure) > 0 {
		ok := object.Key("directoryStructure")
		ok.String(string(v.DirectoryStructure))
	}

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentHlsEncryptionSettings(v.Encryption, ok); err != nil {
			return err
		}
	}

	if len(v.ImageBasedTrickPlay) > 0 {
		ok := object.Key("imageBasedTrickPlay")
		ok.String(string(v.ImageBasedTrickPlay))
	}

	if v.ImageBasedTrickPlaySettings != nil {
		ok := object.Key("imageBasedTrickPlaySettings")
		if err := awsRestjson1_serializeDocumentHlsImageBasedTrickPlaySettings(v.ImageBasedTrickPlaySettings, ok); err != nil {
			return err
		}
	}

	if len(v.ManifestCompression) > 0 {
		ok := object.Key("manifestCompression")
		ok.String(string(v.ManifestCompression))
	}

	if len(v.ManifestDurationFormat) > 0 {
		ok := object.Key("manifestDurationFormat")
		ok.String(string(v.ManifestDurationFormat))
	}

	if v.MinFinalSegmentLength != nil {
		ok := object.Key("minFinalSegmentLength")
		switch {
		case math.IsNaN(*v.MinFinalSegmentLength):
			ok.String("NaN")

		case math.IsInf(*v.MinFinalSegmentLength, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MinFinalSegmentLength, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MinFinalSegmentLength)

		}
	}

	if v.MinSegmentLength != nil {
		ok := object.Key("minSegmentLength")
		ok.Integer(*v.MinSegmentLength)
	}

	if len(v.OutputSelection) > 0 {
		ok := object.Key("outputSelection")
		ok.String(string(v.OutputSelection))
	}

	if len(v.ProgramDateTime) > 0 {
		ok := object.Key("programDateTime")
		ok.String(string(v.ProgramDateTime))
	}

	if v.ProgramDateTimePeriod != nil {
		ok := object.Key("programDateTimePeriod")
		ok.Integer(*v.ProgramDateTimePeriod)
	}

	if len(v.ProgressiveWriteHlsManifest) > 0 {
		ok := object.Key("progressiveWriteHlsManifest")
		ok.String(string(v.ProgressiveWriteHlsManifest))
	}

	if len(v.SegmentControl) > 0 {
		ok := object.Key("segmentControl")
		ok.String(string(v.SegmentControl))
	}

	if v.SegmentLength != nil {
		ok := object.Key("segmentLength")
		ok.Integer(*v.SegmentLength)
	}

	if len(v.SegmentLengthControl) > 0 {
		ok := object.Key("segmentLengthControl")
		ok.String(string(v.SegmentLengthControl))
	}

	if v.SegmentsPerSubdirectory != nil {
		ok := object.Key("segmentsPerSubdirectory")
		ok.Integer(*v.SegmentsPerSubdirectory)
	}

	if len(v.StreamInfResolution) > 0 {
		ok := object.Key("streamInfResolution")
		ok.String(string(v.StreamInfResolution))
	}

	if len(v.TargetDurationCompatibilityMode) > 0 {
		ok := object.Key("targetDurationCompatibilityMode")
		ok.String(string(v.TargetDurationCompatibilityMode))
	}

	if len(v.TimedMetadataId3Frame) > 0 {
		ok := object.Key("timedMetadataId3Frame")
		ok.String(string(v.TimedMetadataId3Frame))
	}

	if v.TimedMetadataId3Period != nil {
		ok := object.Key("timedMetadataId3Period")
		ok.Integer(*v.TimedMetadataId3Period)
	}

	if v.TimestampDeltaMilliseconds != nil {
		ok := object.Key("timestampDeltaMilliseconds")
		ok.Integer(*v.TimestampDeltaMilliseconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsImageBasedTrickPlaySettings(v *types.HlsImageBasedTrickPlaySettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.IntervalCadence) > 0 {
		ok := object.Key("intervalCadence")
		ok.String(string(v.IntervalCadence))
	}

	if v.ThumbnailHeight != nil {
		ok := object.Key("thumbnailHeight")
		ok.Integer(*v.ThumbnailHeight)
	}

	if v.ThumbnailInterval != nil {
		ok := object.Key("thumbnailInterval")
		switch {
		case math.IsNaN(*v.ThumbnailInterval):
			ok.String("NaN")

		case math.IsInf(*v.ThumbnailInterval, 1):
			ok.String("Infinity")

		case math.IsInf(*v.ThumbnailInterval, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.ThumbnailInterval)

		}
	}

	if v.ThumbnailWidth != nil {
		ok := object.Key("thumbnailWidth")
		ok.Integer(*v.ThumbnailWidth)
	}

	if v.TileHeight != nil {
		ok := object.Key("tileHeight")
		ok.Integer(*v.TileHeight)
	}

	if v.TileWidth != nil {
		ok := object.Key("tileWidth")
		ok.Integer(*v.TileWidth)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsRenditionGroupSettings(v *types.HlsRenditionGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RenditionGroupId != nil {
		ok := object.Key("renditionGroupId")
		ok.String(*v.RenditionGroupId)
	}

	if len(v.RenditionLanguageCode) > 0 {
		ok := object.Key("renditionLanguageCode")
		ok.String(string(v.RenditionLanguageCode))
	}

	if v.RenditionName != nil {
		ok := object.Key("renditionName")
		ok.String(*v.RenditionName)
	}

	return nil
}

func awsRestjson1_serializeDocumentHlsSettings(v *types.HlsSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioGroupId != nil {
		ok := object.Key("audioGroupId")
		ok.String(*v.AudioGroupId)
	}

	if len(v.AudioOnlyContainer) > 0 {
		ok := object.Key("audioOnlyContainer")
		ok.String(string(v.AudioOnlyContainer))
	}

	if v.AudioRenditionSets != nil {
		ok := object.Key("audioRenditionSets")
		ok.String(*v.AudioRenditionSets)
	}

	if len(v.AudioTrackType) > 0 {
		ok := object.Key("audioTrackType")
		ok.String(string(v.AudioTrackType))
	}

	if len(v.DescriptiveVideoServiceFlag) > 0 {
		ok := object.Key("descriptiveVideoServiceFlag")
		ok.String(string(v.DescriptiveVideoServiceFlag))
	}

	if len(v.IFrameOnlyManifest) > 0 {
		ok := object.Key("iFrameOnlyManifest")
		ok.String(string(v.IFrameOnlyManifest))
	}

	if v.SegmentModifier != nil {
		ok := object.Key("segmentModifier")
		ok.String(*v.SegmentModifier)
	}

	return nil
}

func awsRestjson1_serializeDocumentHopDestination(v *types.HopDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Priority != nil {
		ok := object.Key("priority")
		ok.Integer(*v.Priority)
	}

	if v.Queue != nil {
		ok := object.Key("queue")
		ok.String(*v.Queue)
	}

	if v.WaitMinutes != nil {
		ok := object.Key("waitMinutes")
		ok.Integer(*v.WaitMinutes)
	}

	return nil
}

func awsRestjson1_serializeDocumentId3Insertion(v *types.Id3Insertion, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id3 != nil {
		ok := object.Key("id3")
		ok.String(*v.Id3)
	}

	if v.Timecode != nil {
		ok := object.Key("timecode")
		ok.String(*v.Timecode)
	}

	return nil
}

func awsRestjson1_serializeDocumentImageInserter(v *types.ImageInserter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InsertableImages != nil {
		ok := object.Key("insertableImages")
		if err := awsRestjson1_serializeDocument__listOfInsertableImage(v.InsertableImages, ok); err != nil {
			return err
		}
	}

	if v.SdrReferenceWhiteLevel != nil {
		ok := object.Key("sdrReferenceWhiteLevel")
		ok.Integer(*v.SdrReferenceWhiteLevel)
	}

	return nil
}

func awsRestjson1_serializeDocumentImscDestinationSettings(v *types.ImscDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Accessibility) > 0 {
		ok := object.Key("accessibility")
		ok.String(string(v.Accessibility))
	}

	if len(v.StylePassthrough) > 0 {
		ok := object.Key("stylePassthrough")
		ok.String(string(v.StylePassthrough))
	}

	return nil
}

func awsRestjson1_serializeDocumentInput(v *types.Input, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AdvancedInputFilter) > 0 {
		ok := object.Key("advancedInputFilter")
		ok.String(string(v.AdvancedInputFilter))
	}

	if v.AdvancedInputFilterSettings != nil {
		ok := object.Key("advancedInputFilterSettings")
		if err := awsRestjson1_serializeDocumentAdvancedInputFilterSettings(v.AdvancedInputFilterSettings, ok); err != nil {
			return err
		}
	}

	if v.AudioSelectorGroups != nil {
		ok := object.Key("audioSelectorGroups")
		if err := awsRestjson1_serializeDocument__mapOfAudioSelectorGroup(v.AudioSelectorGroups, ok); err != nil {
			return err
		}
	}

	if v.AudioSelectors != nil {
		ok := object.Key("audioSelectors")
		if err := awsRestjson1_serializeDocument__mapOfAudioSelector(v.AudioSelectors, ok); err != nil {
			return err
		}
	}

	if v.CaptionSelectors != nil {
		ok := object.Key("captionSelectors")
		if err := awsRestjson1_serializeDocument__mapOfCaptionSelector(v.CaptionSelectors, ok); err != nil {
			return err
		}
	}

	if v.Crop != nil {
		ok := object.Key("crop")
		if err := awsRestjson1_serializeDocumentRectangle(v.Crop, ok); err != nil {
			return err
		}
	}

	if len(v.DeblockFilter) > 0 {
		ok := object.Key("deblockFilter")
		ok.String(string(v.DeblockFilter))
	}

	if v.DecryptionSettings != nil {
		ok := object.Key("decryptionSettings")
		if err := awsRestjson1_serializeDocumentInputDecryptionSettings(v.DecryptionSettings, ok); err != nil {
			return err
		}
	}

	if len(v.DenoiseFilter) > 0 {
		ok := object.Key("denoiseFilter")
		ok.String(string(v.DenoiseFilter))
	}

	if v.DolbyVisionMetadataXml != nil {
		ok := object.Key("dolbyVisionMetadataXml")
		ok.String(*v.DolbyVisionMetadataXml)
	}

	if v.FileInput != nil {
		ok := object.Key("fileInput")
		ok.String(*v.FileInput)
	}

	if len(v.FilterEnable) > 0 {
		ok := object.Key("filterEnable")
		ok.String(string(v.FilterEnable))
	}

	if v.FilterStrength != nil {
		ok := object.Key("filterStrength")
		ok.Integer(*v.FilterStrength)
	}

	if v.ImageInserter != nil {
		ok := object.Key("imageInserter")
		if err := awsRestjson1_serializeDocumentImageInserter(v.ImageInserter, ok); err != nil {
			return err
		}
	}

	if v.InputClippings != nil {
		ok := object.Key("inputClippings")
		if err := awsRestjson1_serializeDocument__listOfInputClipping(v.InputClippings, ok); err != nil {
			return err
		}
	}

	if len(v.InputScanType) > 0 {
		ok := object.Key("inputScanType")
		ok.String(string(v.InputScanType))
	}

	if v.Position != nil {
		ok := object.Key("position")
		if err := awsRestjson1_serializeDocumentRectangle(v.Position, ok); err != nil {
			return err
		}
	}

	if v.ProgramNumber != nil {
		ok := object.Key("programNumber")
		ok.Integer(*v.ProgramNumber)
	}

	if len(v.PsiControl) > 0 {
		ok := object.Key("psiControl")
		ok.String(string(v.PsiControl))
	}

	if v.SupplementalImps != nil {
		ok := object.Key("supplementalImps")
		if err := awsRestjson1_serializeDocument__listOf__stringPatternS3ASSETMAPXml(v.SupplementalImps, ok); err != nil {
			return err
		}
	}

	if len(v.TimecodeSource) > 0 {
		ok := object.Key("timecodeSource")
		ok.String(string(v.TimecodeSource))
	}

	if v.TimecodeStart != nil {
		ok := object.Key("timecodeStart")
		ok.String(*v.TimecodeStart)
	}

	if v.VideoGenerator != nil {
		ok := object.Key("videoGenerator")
		if err := awsRestjson1_serializeDocumentInputVideoGenerator(v.VideoGenerator, ok); err != nil {
			return err
		}
	}

	if v.VideoOverlays != nil {
		ok := object.Key("videoOverlays")
		if err := awsRestjson1_serializeDocument__listOfVideoOverlay(v.VideoOverlays, ok); err != nil {
			return err
		}
	}

	if v.VideoSelector != nil {
		ok := object.Key("videoSelector")
		if err := awsRestjson1_serializeDocumentVideoSelector(v.VideoSelector, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInputClipping(v *types.InputClipping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTimecode != nil {
		ok := object.Key("endTimecode")
		ok.String(*v.EndTimecode)
	}

	if v.StartTimecode != nil {
		ok := object.Key("startTimecode")
		ok.String(*v.StartTimecode)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputDecryptionSettings(v *types.InputDecryptionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DecryptionMode) > 0 {
		ok := object.Key("decryptionMode")
		ok.String(string(v.DecryptionMode))
	}

	if v.EncryptedDecryptionKey != nil {
		ok := object.Key("encryptedDecryptionKey")
		ok.String(*v.EncryptedDecryptionKey)
	}

	if v.InitializationVector != nil {
		ok := object.Key("initializationVector")
		ok.String(*v.InitializationVector)
	}

	if v.KmsKeyRegion != nil {
		ok := object.Key("kmsKeyRegion")
		ok.String(*v.KmsKeyRegion)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputTemplate(v *types.InputTemplate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AdvancedInputFilter) > 0 {
		ok := object.Key("advancedInputFilter")
		ok.String(string(v.AdvancedInputFilter))
	}

	if v.AdvancedInputFilterSettings != nil {
		ok := object.Key("advancedInputFilterSettings")
		if err := awsRestjson1_serializeDocumentAdvancedInputFilterSettings(v.AdvancedInputFilterSettings, ok); err != nil {
			return err
		}
	}

	if v.AudioSelectorGroups != nil {
		ok := object.Key("audioSelectorGroups")
		if err := awsRestjson1_serializeDocument__mapOfAudioSelectorGroup(v.AudioSelectorGroups, ok); err != nil {
			return err
		}
	}

	if v.AudioSelectors != nil {
		ok := object.Key("audioSelectors")
		if err := awsRestjson1_serializeDocument__mapOfAudioSelector(v.AudioSelectors, ok); err != nil {
			return err
		}
	}

	if v.CaptionSelectors != nil {
		ok := object.Key("captionSelectors")
		if err := awsRestjson1_serializeDocument__mapOfCaptionSelector(v.CaptionSelectors, ok); err != nil {
			return err
		}
	}

	if v.Crop != nil {
		ok := object.Key("crop")
		if err := awsRestjson1_serializeDocumentRectangle(v.Crop, ok); err != nil {
			return err
		}
	}

	if len(v.DeblockFilter) > 0 {
		ok := object.Key("deblockFilter")
		ok.String(string(v.DeblockFilter))
	}

	if len(v.DenoiseFilter) > 0 {
		ok := object.Key("denoiseFilter")
		ok.String(string(v.DenoiseFilter))
	}

	if v.DolbyVisionMetadataXml != nil {
		ok := object.Key("dolbyVisionMetadataXml")
		ok.String(*v.DolbyVisionMetadataXml)
	}

	if len(v.FilterEnable) > 0 {
		ok := object.Key("filterEnable")
		ok.String(string(v.FilterEnable))
	}

	if v.FilterStrength != nil {
		ok := object.Key("filterStrength")
		ok.Integer(*v.FilterStrength)
	}

	if v.ImageInserter != nil {
		ok := object.Key("imageInserter")
		if err := awsRestjson1_serializeDocumentImageInserter(v.ImageInserter, ok); err != nil {
			return err
		}
	}

	if v.InputClippings != nil {
		ok := object.Key("inputClippings")
		if err := awsRestjson1_serializeDocument__listOfInputClipping(v.InputClippings, ok); err != nil {
			return err
		}
	}

	if len(v.InputScanType) > 0 {
		ok := object.Key("inputScanType")
		ok.String(string(v.InputScanType))
	}

	if v.Position != nil {
		ok := object.Key("position")
		if err := awsRestjson1_serializeDocumentRectangle(v.Position, ok); err != nil {
			return err
		}
	}

	if v.ProgramNumber != nil {
		ok := object.Key("programNumber")
		ok.Integer(*v.ProgramNumber)
	}

	if len(v.PsiControl) > 0 {
		ok := object.Key("psiControl")
		ok.String(string(v.PsiControl))
	}

	if len(v.TimecodeSource) > 0 {
		ok := object.Key("timecodeSource")
		ok.String(string(v.TimecodeSource))
	}

	if v.TimecodeStart != nil {
		ok := object.Key("timecodeStart")
		ok.String(*v.TimecodeStart)
	}

	if v.VideoOverlays != nil {
		ok := object.Key("videoOverlays")
		if err := awsRestjson1_serializeDocument__listOfVideoOverlay(v.VideoOverlays, ok); err != nil {
			return err
		}
	}

	if v.VideoSelector != nil {
		ok := object.Key("videoSelector")
		if err := awsRestjson1_serializeDocumentVideoSelector(v.VideoSelector, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInputVideoGenerator(v *types.InputVideoGenerator, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Duration != nil {
		ok := object.Key("duration")
		ok.Integer(*v.Duration)
	}

	return nil
}

func awsRestjson1_serializeDocumentInsertableImage(v *types.InsertableImage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Duration != nil {
		ok := object.Key("duration")
		ok.Integer(*v.Duration)
	}

	if v.FadeIn != nil {
		ok := object.Key("fadeIn")
		ok.Integer(*v.FadeIn)
	}

	if v.FadeOut != nil {
		ok := object.Key("fadeOut")
		ok.Integer(*v.FadeOut)
	}

	if v.Height != nil {
		ok := object.Key("height")
		ok.Integer(*v.Height)
	}

	if v.ImageInserterInput != nil {
		ok := object.Key("imageInserterInput")
		ok.String(*v.ImageInserterInput)
	}

	if v.ImageX != nil {
		ok := object.Key("imageX")
		ok.Integer(*v.ImageX)
	}

	if v.ImageY != nil {
		ok := object.Key("imageY")
		ok.Integer(*v.ImageY)
	}

	if v.Layer != nil {
		ok := object.Key("layer")
		ok.Integer(*v.Layer)
	}

	if v.Opacity != nil {
		ok := object.Key("opacity")
		ok.Integer(*v.Opacity)
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		ok.String(*v.StartTime)
	}

	if v.Width != nil {
		ok := object.Key("width")
		ok.Integer(*v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentJobSettings(v *types.JobSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdAvailOffset != nil {
		ok := object.Key("adAvailOffset")
		ok.Integer(*v.AdAvailOffset)
	}

	if v.AvailBlanking != nil {
		ok := object.Key("availBlanking")
		if err := awsRestjson1_serializeDocumentAvailBlanking(v.AvailBlanking, ok); err != nil {
			return err
		}
	}

	if v.ColorConversion3DLUTSettings != nil {
		ok := object.Key("colorConversion3DLUTSettings")
		if err := awsRestjson1_serializeDocument__listOfColorConversion3DLUTSetting(v.ColorConversion3DLUTSettings, ok); err != nil {
			return err
		}
	}

	if v.Esam != nil {
		ok := object.Key("esam")
		if err := awsRestjson1_serializeDocumentEsamSettings(v.Esam, ok); err != nil {
			return err
		}
	}

	if v.ExtendedDataServices != nil {
		ok := object.Key("extendedDataServices")
		if err := awsRestjson1_serializeDocumentExtendedDataServices(v.ExtendedDataServices, ok); err != nil {
			return err
		}
	}

	if v.FollowSource != nil {
		ok := object.Key("followSource")
		ok.Integer(*v.FollowSource)
	}

	if v.Inputs != nil {
		ok := object.Key("inputs")
		if err := awsRestjson1_serializeDocument__listOfInput(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.KantarWatermark != nil {
		ok := object.Key("kantarWatermark")
		if err := awsRestjson1_serializeDocumentKantarWatermarkSettings(v.KantarWatermark, ok); err != nil {
			return err
		}
	}

	if v.MotionImageInserter != nil {
		ok := object.Key("motionImageInserter")
		if err := awsRestjson1_serializeDocumentMotionImageInserter(v.MotionImageInserter, ok); err != nil {
			return err
		}
	}

	if v.NielsenConfiguration != nil {
		ok := object.Key("nielsenConfiguration")
		if err := awsRestjson1_serializeDocumentNielsenConfiguration(v.NielsenConfiguration, ok); err != nil {
			return err
		}
	}

	if v.NielsenNonLinearWatermark != nil {
		ok := object.Key("nielsenNonLinearWatermark")
		if err := awsRestjson1_serializeDocumentNielsenNonLinearWatermarkSettings(v.NielsenNonLinearWatermark, ok); err != nil {
			return err
		}
	}

	if v.OutputGroups != nil {
		ok := object.Key("outputGroups")
		if err := awsRestjson1_serializeDocument__listOfOutputGroup(v.OutputGroups, ok); err != nil {
			return err
		}
	}

	if v.TimecodeConfig != nil {
		ok := object.Key("timecodeConfig")
		if err := awsRestjson1_serializeDocumentTimecodeConfig(v.TimecodeConfig, ok); err != nil {
			return err
		}
	}

	if v.TimedMetadataInsertion != nil {
		ok := object.Key("timedMetadataInsertion")
		if err := awsRestjson1_serializeDocumentTimedMetadataInsertion(v.TimedMetadataInsertion, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentJobTemplateSettings(v *types.JobTemplateSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdAvailOffset != nil {
		ok := object.Key("adAvailOffset")
		ok.Integer(*v.AdAvailOffset)
	}

	if v.AvailBlanking != nil {
		ok := object.Key("availBlanking")
		if err := awsRestjson1_serializeDocumentAvailBlanking(v.AvailBlanking, ok); err != nil {
			return err
		}
	}

	if v.ColorConversion3DLUTSettings != nil {
		ok := object.Key("colorConversion3DLUTSettings")
		if err := awsRestjson1_serializeDocument__listOfColorConversion3DLUTSetting(v.ColorConversion3DLUTSettings, ok); err != nil {
			return err
		}
	}

	if v.Esam != nil {
		ok := object.Key("esam")
		if err := awsRestjson1_serializeDocumentEsamSettings(v.Esam, ok); err != nil {
			return err
		}
	}

	if v.ExtendedDataServices != nil {
		ok := object.Key("extendedDataServices")
		if err := awsRestjson1_serializeDocumentExtendedDataServices(v.ExtendedDataServices, ok); err != nil {
			return err
		}
	}

	if v.FollowSource != nil {
		ok := object.Key("followSource")
		ok.Integer(*v.FollowSource)
	}

	if v.Inputs != nil {
		ok := object.Key("inputs")
		if err := awsRestjson1_serializeDocument__listOfInputTemplate(v.Inputs, ok); err != nil {
			return err
		}
	}

	if v.KantarWatermark != nil {
		ok := object.Key("kantarWatermark")
		if err := awsRestjson1_serializeDocumentKantarWatermarkSettings(v.KantarWatermark, ok); err != nil {
			return err
		}
	}

	if v.MotionImageInserter != nil {
		ok := object.Key("motionImageInserter")
		if err := awsRestjson1_serializeDocumentMotionImageInserter(v.MotionImageInserter, ok); err != nil {
			return err
		}
	}

	if v.NielsenConfiguration != nil {
		ok := object.Key("nielsenConfiguration")
		if err := awsRestjson1_serializeDocumentNielsenConfiguration(v.NielsenConfiguration, ok); err != nil {
			return err
		}
	}

	if v.NielsenNonLinearWatermark != nil {
		ok := object.Key("nielsenNonLinearWatermark")
		if err := awsRestjson1_serializeDocumentNielsenNonLinearWatermarkSettings(v.NielsenNonLinearWatermark, ok); err != nil {
			return err
		}
	}

	if v.OutputGroups != nil {
		ok := object.Key("outputGroups")
		if err := awsRestjson1_serializeDocument__listOfOutputGroup(v.OutputGroups, ok); err != nil {
			return err
		}
	}

	if v.TimecodeConfig != nil {
		ok := object.Key("timecodeConfig")
		if err := awsRestjson1_serializeDocumentTimecodeConfig(v.TimecodeConfig, ok); err != nil {
			return err
		}
	}

	if v.TimedMetadataInsertion != nil {
		ok := object.Key("timedMetadataInsertion")
		if err := awsRestjson1_serializeDocumentTimedMetadataInsertion(v.TimedMetadataInsertion, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentKantarWatermarkSettings(v *types.KantarWatermarkSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChannelName != nil {
		ok := object.Key("channelName")
		ok.String(*v.ChannelName)
	}

	if v.ContentReference != nil {
		ok := object.Key("contentReference")
		ok.String(*v.ContentReference)
	}

	if v.CredentialsSecretName != nil {
		ok := object.Key("credentialsSecretName")
		ok.String(*v.CredentialsSecretName)
	}

	if v.FileOffset != nil {
		ok := object.Key("fileOffset")
		switch {
		case math.IsNaN(*v.FileOffset):
			ok.String("NaN")

		case math.IsInf(*v.FileOffset, 1):
			ok.String("Infinity")

		case math.IsInf(*v.FileOffset, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.FileOffset)

		}
	}

	if v.KantarLicenseId != nil {
		ok := object.Key("kantarLicenseId")
		ok.Integer(*v.KantarLicenseId)
	}

	if v.KantarServerUrl != nil {
		ok := object.Key("kantarServerUrl")
		ok.String(*v.KantarServerUrl)
	}

	if v.LogDestination != nil {
		ok := object.Key("logDestination")
		ok.String(*v.LogDestination)
	}

	if v.Metadata3 != nil {
		ok := object.Key("metadata3")
		ok.String(*v.Metadata3)
	}

	if v.Metadata4 != nil {
		ok := object.Key("metadata4")
		ok.String(*v.Metadata4)
	}

	if v.Metadata5 != nil {
		ok := object.Key("metadata5")
		ok.String(*v.Metadata5)
	}

	if v.Metadata6 != nil {
		ok := object.Key("metadata6")
		ok.String(*v.Metadata6)
	}

	if v.Metadata7 != nil {
		ok := object.Key("metadata7")
		ok.String(*v.Metadata7)
	}

	if v.Metadata8 != nil {
		ok := object.Key("metadata8")
		ok.String(*v.Metadata8)
	}

	return nil
}

func awsRestjson1_serializeDocumentM2tsScte35Esam(v *types.M2tsScte35Esam, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Scte35EsamPid != nil {
		ok := object.Key("scte35EsamPid")
		ok.Integer(*v.Scte35EsamPid)
	}

	return nil
}

func awsRestjson1_serializeDocumentM2tsSettings(v *types.M2tsSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AudioBufferModel) > 0 {
		ok := object.Key("audioBufferModel")
		ok.String(string(v.AudioBufferModel))
	}

	if len(v.AudioDuration) > 0 {
		ok := object.Key("audioDuration")
		ok.String(string(v.AudioDuration))
	}

	if v.AudioFramesPerPes != nil {
		ok := object.Key("audioFramesPerPes")
		ok.Integer(*v.AudioFramesPerPes)
	}

	if v.AudioPids != nil {
		ok := object.Key("audioPids")
		if err := awsRestjson1_serializeDocument__listOf__integerMin32Max8182(v.AudioPids, ok); err != nil {
			return err
		}
	}

	if v.Bitrate != nil {
		ok := object.Key("bitrate")
		ok.Integer(*v.Bitrate)
	}

	if len(v.BufferModel) > 0 {
		ok := object.Key("bufferModel")
		ok.String(string(v.BufferModel))
	}

	if len(v.DataPTSControl) > 0 {
		ok := object.Key("dataPTSControl")
		ok.String(string(v.DataPTSControl))
	}

	if v.DvbNitSettings != nil {
		ok := object.Key("dvbNitSettings")
		if err := awsRestjson1_serializeDocumentDvbNitSettings(v.DvbNitSettings, ok); err != nil {
			return err
		}
	}

	if v.DvbSdtSettings != nil {
		ok := object.Key("dvbSdtSettings")
		if err := awsRestjson1_serializeDocumentDvbSdtSettings(v.DvbSdtSettings, ok); err != nil {
			return err
		}
	}

	if v.DvbSubPids != nil {
		ok := object.Key("dvbSubPids")
		if err := awsRestjson1_serializeDocument__listOf__integerMin32Max8182(v.DvbSubPids, ok); err != nil {
			return err
		}
	}

	if v.DvbTdtSettings != nil {
		ok := object.Key("dvbTdtSettings")
		if err := awsRestjson1_serializeDocumentDvbTdtSettings(v.DvbTdtSettings, ok); err != nil {
			return err
		}
	}

	if v.DvbTeletextPid != nil {
		ok := object.Key("dvbTeletextPid")
		ok.Integer(*v.DvbTeletextPid)
	}

	if len(v.EbpAudioInterval) > 0 {
		ok := object.Key("ebpAudioInterval")
		ok.String(string(v.EbpAudioInterval))
	}

	if len(v.EbpPlacement) > 0 {
		ok := object.Key("ebpPlacement")
		ok.String(string(v.EbpPlacement))
	}

	if len(v.EsRateInPes) > 0 {
		ok := object.Key("esRateInPes")
		ok.String(string(v.EsRateInPes))
	}

	if len(v.ForceTsVideoEbpOrder) > 0 {
		ok := object.Key("forceTsVideoEbpOrder")
		ok.String(string(v.ForceTsVideoEbpOrder))
	}

	if v.FragmentTime != nil {
		ok := object.Key("fragmentTime")
		switch {
		case math.IsNaN(*v.FragmentTime):
			ok.String("NaN")

		case math.IsInf(*v.FragmentTime, 1):
			ok.String("Infinity")

		case math.IsInf(*v.FragmentTime, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.FragmentTime)

		}
	}

	if len(v.KlvMetadata) > 0 {
		ok := object.Key("klvMetadata")
		ok.String(string(v.KlvMetadata))
	}

	if v.MaxPcrInterval != nil {
		ok := object.Key("maxPcrInterval")
		ok.Integer(*v.MaxPcrInterval)
	}

	if v.MinEbpInterval != nil {
		ok := object.Key("minEbpInterval")
		ok.Integer(*v.MinEbpInterval)
	}

	if len(v.NielsenId3) > 0 {
		ok := object.Key("nielsenId3")
		ok.String(string(v.NielsenId3))
	}

	if v.NullPacketBitrate != nil {
		ok := object.Key("nullPacketBitrate")
		switch {
		case math.IsNaN(*v.NullPacketBitrate):
			ok.String("NaN")

		case math.IsInf(*v.NullPacketBitrate, 1):
			ok.String("Infinity")

		case math.IsInf(*v.NullPacketBitrate, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.NullPacketBitrate)

		}
	}

	if v.PatInterval != nil {
		ok := object.Key("patInterval")
		ok.Integer(*v.PatInterval)
	}

	if len(v.PcrControl) > 0 {
		ok := object.Key("pcrControl")
		ok.String(string(v.PcrControl))
	}

	if v.PcrPid != nil {
		ok := object.Key("pcrPid")
		ok.Integer(*v.PcrPid)
	}

	if v.PmtInterval != nil {
		ok := object.Key("pmtInterval")
		ok.Integer(*v.PmtInterval)
	}

	if v.PmtPid != nil {
		ok := object.Key("pmtPid")
		ok.Integer(*v.PmtPid)
	}

	if len(v.PreventBufferUnderflow) > 0 {
		ok := object.Key("preventBufferUnderflow")
		ok.String(string(v.PreventBufferUnderflow))
	}

	if v.PrivateMetadataPid != nil {
		ok := object.Key("privateMetadataPid")
		ok.Integer(*v.PrivateMetadataPid)
	}

	if v.ProgramNumber != nil {
		ok := object.Key("programNumber")
		ok.Integer(*v.ProgramNumber)
	}

	if v.PtsOffset != nil {
		ok := object.Key("ptsOffset")
		ok.Integer(*v.PtsOffset)
	}

	if len(v.PtsOffsetMode) > 0 {
		ok := object.Key("ptsOffsetMode")
		ok.String(string(v.PtsOffsetMode))
	}

	if len(v.RateMode) > 0 {
		ok := object.Key("rateMode")
		ok.String(string(v.RateMode))
	}

	if v.Scte35Esam != nil {
		ok := object.Key("scte35Esam")
		if err := awsRestjson1_serializeDocumentM2tsScte35Esam(v.Scte35Esam, ok); err != nil {
			return err
		}
	}

	if v.Scte35Pid != nil {
		ok := object.Key("scte35Pid")
		ok.Integer(*v.Scte35Pid)
	}

	if len(v.Scte35Source) > 0 {
		ok := object.Key("scte35Source")
		ok.String(string(v.Scte35Source))
	}

	if len(v.SegmentationMarkers) > 0 {
		ok := object.Key("segmentationMarkers")
		ok.String(string(v.SegmentationMarkers))
	}

	if len(v.SegmentationStyle) > 0 {
		ok := object.Key("segmentationStyle")
		ok.String(string(v.SegmentationStyle))
	}

	if v.SegmentationTime != nil {
		ok := object.Key("segmentationTime")
		switch {
		case math.IsNaN(*v.SegmentationTime):
			ok.String("NaN")

		case math.IsInf(*v.SegmentationTime, 1):
			ok.String("Infinity")

		case math.IsInf(*v.SegmentationTime, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.SegmentationTime)

		}
	}

	if v.TimedMetadataPid != nil {
		ok := object.Key("timedMetadataPid")
		ok.Integer(*v.TimedMetadataPid)
	}

	if v.TransportStreamId != nil {
		ok := object.Key("transportStreamId")
		ok.Integer(*v.TransportStreamId)
	}

	if v.VideoPid != nil {
		ok := object.Key("videoPid")
		ok.Integer(*v.VideoPid)
	}

	return nil
}

func awsRestjson1_serializeDocumentM3u8Settings(v *types.M3u8Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AudioDuration) > 0 {
		ok := object.Key("audioDuration")
		ok.String(string(v.AudioDuration))
	}

	if v.AudioFramesPerPes != nil {
		ok := object.Key("audioFramesPerPes")
		ok.Integer(*v.AudioFramesPerPes)
	}

	if v.AudioPids != nil {
		ok := object.Key("audioPids")
		if err := awsRestjson1_serializeDocument__listOf__integerMin32Max8182(v.AudioPids, ok); err != nil {
			return err
		}
	}

	if len(v.DataPTSControl) > 0 {
		ok := object.Key("dataPTSControl")
		ok.String(string(v.DataPTSControl))
	}

	if v.MaxPcrInterval != nil {
		ok := object.Key("maxPcrInterval")
		ok.Integer(*v.MaxPcrInterval)
	}

	if len(v.NielsenId3) > 0 {
		ok := object.Key("nielsenId3")
		ok.String(string(v.NielsenId3))
	}

	if v.PatInterval != nil {
		ok := object.Key("patInterval")
		ok.Integer(*v.PatInterval)
	}

	if len(v.PcrControl) > 0 {
		ok := object.Key("pcrControl")
		ok.String(string(v.PcrControl))
	}

	if v.PcrPid != nil {
		ok := object.Key("pcrPid")
		ok.Integer(*v.PcrPid)
	}

	if v.PmtInterval != nil {
		ok := object.Key("pmtInterval")
		ok.Integer(*v.PmtInterval)
	}

	if v.PmtPid != nil {
		ok := object.Key("pmtPid")
		ok.Integer(*v.PmtPid)
	}

	if v.PrivateMetadataPid != nil {
		ok := object.Key("privateMetadataPid")
		ok.Integer(*v.PrivateMetadataPid)
	}

	if v.ProgramNumber != nil {
		ok := object.Key("programNumber")
		ok.Integer(*v.ProgramNumber)
	}

	if v.PtsOffset != nil {
		ok := object.Key("ptsOffset")
		ok.Integer(*v.PtsOffset)
	}

	if len(v.PtsOffsetMode) > 0 {
		ok := object.Key("ptsOffsetMode")
		ok.String(string(v.PtsOffsetMode))
	}

	if v.Scte35Pid != nil {
		ok := object.Key("scte35Pid")
		ok.Integer(*v.Scte35Pid)
	}

	if len(v.Scte35Source) > 0 {
		ok := object.Key("scte35Source")
		ok.String(string(v.Scte35Source))
	}

	if len(v.TimedMetadata) > 0 {
		ok := object.Key("timedMetadata")
		ok.String(string(v.TimedMetadata))
	}

	if v.TimedMetadataPid != nil {
		ok := object.Key("timedMetadataPid")
		ok.Integer(*v.TimedMetadataPid)
	}

	if v.TransportStreamId != nil {
		ok := object.Key("transportStreamId")
		ok.Integer(*v.TransportStreamId)
	}

	if v.VideoPid != nil {
		ok := object.Key("videoPid")
		ok.Integer(*v.VideoPid)
	}

	return nil
}

func awsRestjson1_serializeDocumentMinBottomRenditionSize(v *types.MinBottomRenditionSize, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Height != nil {
		ok := object.Key("height")
		ok.Integer(*v.Height)
	}

	if v.Width != nil {
		ok := object.Key("width")
		ok.Integer(*v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentMinTopRenditionSize(v *types.MinTopRenditionSize, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Height != nil {
		ok := object.Key("height")
		ok.Integer(*v.Height)
	}

	if v.Width != nil {
		ok := object.Key("width")
		ok.Integer(*v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentMotionImageInserter(v *types.MotionImageInserter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Framerate != nil {
		ok := object.Key("framerate")
		if err := awsRestjson1_serializeDocumentMotionImageInsertionFramerate(v.Framerate, ok); err != nil {
			return err
		}
	}

	if v.Input != nil {
		ok := object.Key("input")
		ok.String(*v.Input)
	}

	if len(v.InsertionMode) > 0 {
		ok := object.Key("insertionMode")
		ok.String(string(v.InsertionMode))
	}

	if v.Offset != nil {
		ok := object.Key("offset")
		if err := awsRestjson1_serializeDocumentMotionImageInsertionOffset(v.Offset, ok); err != nil {
			return err
		}
	}

	if len(v.Playback) > 0 {
		ok := object.Key("playback")
		ok.String(string(v.Playback))
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		ok.String(*v.StartTime)
	}

	return nil
}

func awsRestjson1_serializeDocumentMotionImageInsertionFramerate(v *types.MotionImageInsertionFramerate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FramerateDenominator != nil {
		ok := object.Key("framerateDenominator")
		ok.Integer(*v.FramerateDenominator)
	}

	if v.FramerateNumerator != nil {
		ok := object.Key("framerateNumerator")
		ok.Integer(*v.FramerateNumerator)
	}

	return nil
}

func awsRestjson1_serializeDocumentMotionImageInsertionOffset(v *types.MotionImageInsertionOffset, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ImageX != nil {
		ok := object.Key("imageX")
		ok.Integer(*v.ImageX)
	}

	if v.ImageY != nil {
		ok := object.Key("imageY")
		ok.Integer(*v.ImageY)
	}

	return nil
}

func awsRestjson1_serializeDocumentMovSettings(v *types.MovSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ClapAtom) > 0 {
		ok := object.Key("clapAtom")
		ok.String(string(v.ClapAtom))
	}

	if len(v.CslgAtom) > 0 {
		ok := object.Key("cslgAtom")
		ok.String(string(v.CslgAtom))
	}

	if len(v.Mpeg2FourCCControl) > 0 {
		ok := object.Key("mpeg2FourCCControl")
		ok.String(string(v.Mpeg2FourCCControl))
	}

	if len(v.PaddingControl) > 0 {
		ok := object.Key("paddingControl")
		ok.String(string(v.PaddingControl))
	}

	if len(v.Reference) > 0 {
		ok := object.Key("reference")
		ok.String(string(v.Reference))
	}

	return nil
}

func awsRestjson1_serializeDocumentMp2Settings(v *types.Mp2Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bitrate != nil {
		ok := object.Key("bitrate")
		ok.Integer(*v.Bitrate)
	}

	if v.Channels != nil {
		ok := object.Key("channels")
		ok.Integer(*v.Channels)
	}

	if v.SampleRate != nil {
		ok := object.Key("sampleRate")
		ok.Integer(*v.SampleRate)
	}

	return nil
}

func awsRestjson1_serializeDocumentMp3Settings(v *types.Mp3Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bitrate != nil {
		ok := object.Key("bitrate")
		ok.Integer(*v.Bitrate)
	}

	if v.Channels != nil {
		ok := object.Key("channels")
		ok.Integer(*v.Channels)
	}

	if len(v.RateControlMode) > 0 {
		ok := object.Key("rateControlMode")
		ok.String(string(v.RateControlMode))
	}

	if v.SampleRate != nil {
		ok := object.Key("sampleRate")
		ok.Integer(*v.SampleRate)
	}

	if v.VbrQuality != nil {
		ok := object.Key("vbrQuality")
		ok.Integer(*v.VbrQuality)
	}

	return nil
}

func awsRestjson1_serializeDocumentMp4Settings(v *types.Mp4Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AudioDuration) > 0 {
		ok := object.Key("audioDuration")
		ok.String(string(v.AudioDuration))
	}

	if len(v.CslgAtom) > 0 {
		ok := object.Key("cslgAtom")
		ok.String(string(v.CslgAtom))
	}

	if v.CttsVersion != nil {
		ok := object.Key("cttsVersion")
		ok.Integer(*v.CttsVersion)
	}

	if len(v.FreeSpaceBox) > 0 {
		ok := object.Key("freeSpaceBox")
		ok.String(string(v.FreeSpaceBox))
	}

	if len(v.MoovPlacement) > 0 {
		ok := object.Key("moovPlacement")
		ok.String(string(v.MoovPlacement))
	}

	if v.Mp4MajorBrand != nil {
		ok := object.Key("mp4MajorBrand")
		ok.String(*v.Mp4MajorBrand)
	}

	return nil
}

func awsRestjson1_serializeDocumentMpdSettings(v *types.MpdSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AccessibilityCaptionHints) > 0 {
		ok := object.Key("accessibilityCaptionHints")
		ok.String(string(v.AccessibilityCaptionHints))
	}

	if len(v.AudioDuration) > 0 {
		ok := object.Key("audioDuration")
		ok.String(string(v.AudioDuration))
	}

	if len(v.CaptionContainerType) > 0 {
		ok := object.Key("captionContainerType")
		ok.String(string(v.CaptionContainerType))
	}

	if len(v.KlvMetadata) > 0 {
		ok := object.Key("klvMetadata")
		ok.String(string(v.KlvMetadata))
	}

	if len(v.ManifestMetadataSignaling) > 0 {
		ok := object.Key("manifestMetadataSignaling")
		ok.String(string(v.ManifestMetadataSignaling))
	}

	if len(v.Scte35Esam) > 0 {
		ok := object.Key("scte35Esam")
		ok.String(string(v.Scte35Esam))
	}

	if len(v.Scte35Source) > 0 {
		ok := object.Key("scte35Source")
		ok.String(string(v.Scte35Source))
	}

	if len(v.TimedMetadata) > 0 {
		ok := object.Key("timedMetadata")
		ok.String(string(v.TimedMetadata))
	}

	if len(v.TimedMetadataBoxVersion) > 0 {
		ok := object.Key("timedMetadataBoxVersion")
		ok.String(string(v.TimedMetadataBoxVersion))
	}

	if v.TimedMetadataSchemeIdUri != nil {
		ok := object.Key("timedMetadataSchemeIdUri")
		ok.String(*v.TimedMetadataSchemeIdUri)
	}

	if v.TimedMetadataValue != nil {
		ok := object.Key("timedMetadataValue")
		ok.String(*v.TimedMetadataValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentMpeg2Settings(v *types.Mpeg2Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AdaptiveQuantization) > 0 {
		ok := object.Key("adaptiveQuantization")
		ok.String(string(v.AdaptiveQuantization))
	}

	if v.Bitrate != nil {
		ok := object.Key("bitrate")
		ok.Integer(*v.Bitrate)
	}

	if len(v.CodecLevel) > 0 {
		ok := object.Key("codecLevel")
		ok.String(string(v.CodecLevel))
	}

	if len(v.CodecProfile) > 0 {
		ok := object.Key("codecProfile")
		ok.String(string(v.CodecProfile))
	}

	if len(v.DynamicSubGop) > 0 {
		ok := object.Key("dynamicSubGop")
		ok.String(string(v.DynamicSubGop))
	}

	if len(v.FramerateControl) > 0 {
		ok := object.Key("framerateControl")
		ok.String(string(v.FramerateControl))
	}

	if len(v.FramerateConversionAlgorithm) > 0 {
		ok := object.Key("framerateConversionAlgorithm")
		ok.String(string(v.FramerateConversionAlgorithm))
	}

	if v.FramerateDenominator != nil {
		ok := object.Key("framerateDenominator")
		ok.Integer(*v.FramerateDenominator)
	}

	if v.FramerateNumerator != nil {
		ok := object.Key("framerateNumerator")
		ok.Integer(*v.FramerateNumerator)
	}

	if v.GopClosedCadence != nil {
		ok := object.Key("gopClosedCadence")
		ok.Integer(*v.GopClosedCadence)
	}

	if v.GopSize != nil {
		ok := object.Key("gopSize")
		switch {
		case math.IsNaN(*v.GopSize):
			ok.String("NaN")

		case math.IsInf(*v.GopSize, 1):
			ok.String("Infinity")

		case math.IsInf(*v.GopSize, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.GopSize)

		}
	}

	if len(v.GopSizeUnits) > 0 {
		ok := object.Key("gopSizeUnits")
		ok.String(string(v.GopSizeUnits))
	}

	if v.HrdBufferFinalFillPercentage != nil {
		ok := object.Key("hrdBufferFinalFillPercentage")
		ok.Integer(*v.HrdBufferFinalFillPercentage)
	}

	if v.HrdBufferInitialFillPercentage != nil {
		ok := object.Key("hrdBufferInitialFillPercentage")
		ok.Integer(*v.HrdBufferInitialFillPercentage)
	}

	if v.HrdBufferSize != nil {
		ok := object.Key("hrdBufferSize")
		ok.Integer(*v.HrdBufferSize)
	}

	if len(v.InterlaceMode) > 0 {
		ok := object.Key("interlaceMode")
		ok.String(string(v.InterlaceMode))
	}

	if len(v.IntraDcPrecision) > 0 {
		ok := object.Key("intraDcPrecision")
		ok.String(string(v.IntraDcPrecision))
	}

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	if v.MinIInterval != nil {
		ok := object.Key("minIInterval")
		ok.Integer(*v.MinIInterval)
	}

	if v.NumberBFramesBetweenReferenceFrames != nil {
		ok := object.Key("numberBFramesBetweenReferenceFrames")
		ok.Integer(*v.NumberBFramesBetweenReferenceFrames)
	}

	if len(v.ParControl) > 0 {
		ok := object.Key("parControl")
		ok.String(string(v.ParControl))
	}

	if v.ParDenominator != nil {
		ok := object.Key("parDenominator")
		ok.Integer(*v.ParDenominator)
	}

	if v.ParNumerator != nil {
		ok := object.Key("parNumerator")
		ok.Integer(*v.ParNumerator)
	}

	if len(v.QualityTuningLevel) > 0 {
		ok := object.Key("qualityTuningLevel")
		ok.String(string(v.QualityTuningLevel))
	}

	if len(v.RateControlMode) > 0 {
		ok := object.Key("rateControlMode")
		ok.String(string(v.RateControlMode))
	}

	if len(v.ScanTypeConversionMode) > 0 {
		ok := object.Key("scanTypeConversionMode")
		ok.String(string(v.ScanTypeConversionMode))
	}

	if len(v.SceneChangeDetect) > 0 {
		ok := object.Key("sceneChangeDetect")
		ok.String(string(v.SceneChangeDetect))
	}

	if len(v.SlowPal) > 0 {
		ok := object.Key("slowPal")
		ok.String(string(v.SlowPal))
	}

	if v.Softness != nil {
		ok := object.Key("softness")
		ok.Integer(*v.Softness)
	}

	if len(v.SpatialAdaptiveQuantization) > 0 {
		ok := object.Key("spatialAdaptiveQuantization")
		ok.String(string(v.SpatialAdaptiveQuantization))
	}

	if len(v.Syntax) > 0 {
		ok := object.Key("syntax")
		ok.String(string(v.Syntax))
	}

	if len(v.Telecine) > 0 {
		ok := object.Key("telecine")
		ok.String(string(v.Telecine))
	}

	if len(v.TemporalAdaptiveQuantization) > 0 {
		ok := object.Key("temporalAdaptiveQuantization")
		ok.String(string(v.TemporalAdaptiveQuantization))
	}

	return nil
}

func awsRestjson1_serializeDocumentMsSmoothAdditionalManifest(v *types.MsSmoothAdditionalManifest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ManifestNameModifier != nil {
		ok := object.Key("manifestNameModifier")
		ok.String(*v.ManifestNameModifier)
	}

	if v.SelectedOutputs != nil {
		ok := object.Key("selectedOutputs")
		if err := awsRestjson1_serializeDocument__listOf__stringMin1(v.SelectedOutputs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMsSmoothEncryptionSettings(v *types.MsSmoothEncryptionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SpekeKeyProvider != nil {
		ok := object.Key("spekeKeyProvider")
		if err := awsRestjson1_serializeDocumentSpekeKeyProvider(v.SpekeKeyProvider, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMsSmoothGroupSettings(v *types.MsSmoothGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalManifests != nil {
		ok := object.Key("additionalManifests")
		if err := awsRestjson1_serializeDocument__listOfMsSmoothAdditionalManifest(v.AdditionalManifests, ok); err != nil {
			return err
		}
	}

	if len(v.AudioDeduplication) > 0 {
		ok := object.Key("audioDeduplication")
		ok.String(string(v.AudioDeduplication))
	}

	if v.Destination != nil {
		ok := object.Key("destination")
		ok.String(*v.Destination)
	}

	if v.DestinationSettings != nil {
		ok := object.Key("destinationSettings")
		if err := awsRestjson1_serializeDocumentDestinationSettings(v.DestinationSettings, ok); err != nil {
			return err
		}
	}

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentMsSmoothEncryptionSettings(v.Encryption, ok); err != nil {
			return err
		}
	}

	if v.FragmentLength != nil {
		ok := object.Key("fragmentLength")
		ok.Integer(*v.FragmentLength)
	}

	if len(v.FragmentLengthControl) > 0 {
		ok := object.Key("fragmentLengthControl")
		ok.String(string(v.FragmentLengthControl))
	}

	if len(v.ManifestEncoding) > 0 {
		ok := object.Key("manifestEncoding")
		ok.String(string(v.ManifestEncoding))
	}

	return nil
}

func awsRestjson1_serializeDocumentMxfSettings(v *types.MxfSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AfdSignaling) > 0 {
		ok := object.Key("afdSignaling")
		ok.String(string(v.AfdSignaling))
	}

	if len(v.Profile) > 0 {
		ok := object.Key("profile")
		ok.String(string(v.Profile))
	}

	if v.XavcProfileSettings != nil {
		ok := object.Key("xavcProfileSettings")
		if err := awsRestjson1_serializeDocumentMxfXavcProfileSettings(v.XavcProfileSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMxfXavcProfileSettings(v *types.MxfXavcProfileSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DurationMode) > 0 {
		ok := object.Key("durationMode")
		ok.String(string(v.DurationMode))
	}

	if v.MaxAncDataSize != nil {
		ok := object.Key("maxAncDataSize")
		ok.Integer(*v.MaxAncDataSize)
	}

	return nil
}

func awsRestjson1_serializeDocumentNexGuardFileMarkerSettings(v *types.NexGuardFileMarkerSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.License != nil {
		ok := object.Key("license")
		ok.String(*v.License)
	}

	if v.Payload != nil {
		ok := object.Key("payload")
		ok.Integer(*v.Payload)
	}

	if v.Preset != nil {
		ok := object.Key("preset")
		ok.String(*v.Preset)
	}

	if len(v.Strength) > 0 {
		ok := object.Key("strength")
		ok.String(string(v.Strength))
	}

	return nil
}

func awsRestjson1_serializeDocumentNielsenConfiguration(v *types.NielsenConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BreakoutCode != nil {
		ok := object.Key("breakoutCode")
		ok.Integer(*v.BreakoutCode)
	}

	if v.DistributorId != nil {
		ok := object.Key("distributorId")
		ok.String(*v.DistributorId)
	}

	return nil
}

func awsRestjson1_serializeDocumentNielsenNonLinearWatermarkSettings(v *types.NielsenNonLinearWatermarkSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ActiveWatermarkProcess) > 0 {
		ok := object.Key("activeWatermarkProcess")
		ok.String(string(v.ActiveWatermarkProcess))
	}

	if v.AdiFilename != nil {
		ok := object.Key("adiFilename")
		ok.String(*v.AdiFilename)
	}

	if v.AssetId != nil {
		ok := object.Key("assetId")
		ok.String(*v.AssetId)
	}

	if v.AssetName != nil {
		ok := object.Key("assetName")
		ok.String(*v.AssetName)
	}

	if v.CbetSourceId != nil {
		ok := object.Key("cbetSourceId")
		ok.String(*v.CbetSourceId)
	}

	if v.EpisodeId != nil {
		ok := object.Key("episodeId")
		ok.String(*v.EpisodeId)
	}

	if v.MetadataDestination != nil {
		ok := object.Key("metadataDestination")
		ok.String(*v.MetadataDestination)
	}

	if v.SourceId != nil {
		ok := object.Key("sourceId")
		ok.Integer(*v.SourceId)
	}

	if len(v.SourceWatermarkStatus) > 0 {
		ok := object.Key("sourceWatermarkStatus")
		ok.String(string(v.SourceWatermarkStatus))
	}

	if v.TicServerUrl != nil {
		ok := object.Key("ticServerUrl")
		ok.String(*v.TicServerUrl)
	}

	if len(v.UniqueTicPerAudioTrack) > 0 {
		ok := object.Key("uniqueTicPerAudioTrack")
		ok.String(string(v.UniqueTicPerAudioTrack))
	}

	return nil
}

func awsRestjson1_serializeDocumentNoiseReducer(v *types.NoiseReducer, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Filter) > 0 {
		ok := object.Key("filter")
		ok.String(string(v.Filter))
	}

	if v.FilterSettings != nil {
		ok := object.Key("filterSettings")
		if err := awsRestjson1_serializeDocumentNoiseReducerFilterSettings(v.FilterSettings, ok); err != nil {
			return err
		}
	}

	if v.SpatialFilterSettings != nil {
		ok := object.Key("spatialFilterSettings")
		if err := awsRestjson1_serializeDocumentNoiseReducerSpatialFilterSettings(v.SpatialFilterSettings, ok); err != nil {
			return err
		}
	}

	if v.TemporalFilterSettings != nil {
		ok := object.Key("temporalFilterSettings")
		if err := awsRestjson1_serializeDocumentNoiseReducerTemporalFilterSettings(v.TemporalFilterSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNoiseReducerFilterSettings(v *types.NoiseReducerFilterSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Strength != nil {
		ok := object.Key("strength")
		ok.Integer(*v.Strength)
	}

	return nil
}

func awsRestjson1_serializeDocumentNoiseReducerSpatialFilterSettings(v *types.NoiseReducerSpatialFilterSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PostFilterSharpenStrength != nil {
		ok := object.Key("postFilterSharpenStrength")
		ok.Integer(*v.PostFilterSharpenStrength)
	}

	if v.Speed != nil {
		ok := object.Key("speed")
		ok.Integer(*v.Speed)
	}

	if v.Strength != nil {
		ok := object.Key("strength")
		ok.Integer(*v.Strength)
	}

	return nil
}

func awsRestjson1_serializeDocumentNoiseReducerTemporalFilterSettings(v *types.NoiseReducerTemporalFilterSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggressiveMode != nil {
		ok := object.Key("aggressiveMode")
		ok.Integer(*v.AggressiveMode)
	}

	if len(v.PostTemporalSharpening) > 0 {
		ok := object.Key("postTemporalSharpening")
		ok.String(string(v.PostTemporalSharpening))
	}

	if len(v.PostTemporalSharpeningStrength) > 0 {
		ok := object.Key("postTemporalSharpeningStrength")
		ok.String(string(v.PostTemporalSharpeningStrength))
	}

	if v.Speed != nil {
		ok := object.Key("speed")
		ok.Integer(*v.Speed)
	}

	if v.Strength != nil {
		ok := object.Key("strength")
		ok.Integer(*v.Strength)
	}

	return nil
}

func awsRestjson1_serializeDocumentOpusSettings(v *types.OpusSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bitrate != nil {
		ok := object.Key("bitrate")
		ok.Integer(*v.Bitrate)
	}

	if v.Channels != nil {
		ok := object.Key("channels")
		ok.Integer(*v.Channels)
	}

	if v.SampleRate != nil {
		ok := object.Key("sampleRate")
		ok.Integer(*v.SampleRate)
	}

	return nil
}

func awsRestjson1_serializeDocumentOutput(v *types.Output, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioDescriptions != nil {
		ok := object.Key("audioDescriptions")
		if err := awsRestjson1_serializeDocument__listOfAudioDescription(v.AudioDescriptions, ok); err != nil {
			return err
		}
	}

	if v.CaptionDescriptions != nil {
		ok := object.Key("captionDescriptions")
		if err := awsRestjson1_serializeDocument__listOfCaptionDescription(v.CaptionDescriptions, ok); err != nil {
			return err
		}
	}

	if v.ContainerSettings != nil {
		ok := object.Key("containerSettings")
		if err := awsRestjson1_serializeDocumentContainerSettings(v.ContainerSettings, ok); err != nil {
			return err
		}
	}

	if v.Extension != nil {
		ok := object.Key("extension")
		ok.String(*v.Extension)
	}

	if v.NameModifier != nil {
		ok := object.Key("nameModifier")
		ok.String(*v.NameModifier)
	}

	if v.OutputSettings != nil {
		ok := object.Key("outputSettings")
		if err := awsRestjson1_serializeDocumentOutputSettings(v.OutputSettings, ok); err != nil {
			return err
		}
	}

	if v.Preset != nil {
		ok := object.Key("preset")
		ok.String(*v.Preset)
	}

	if v.VideoDescription != nil {
		ok := object.Key("videoDescription")
		if err := awsRestjson1_serializeDocumentVideoDescription(v.VideoDescription, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputChannelMapping(v *types.OutputChannelMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputChannels != nil {
		ok := object.Key("inputChannels")
		if err := awsRestjson1_serializeDocument__listOf__integerMinNegative60Max6(v.InputChannels, ok); err != nil {
			return err
		}
	}

	if v.InputChannelsFineTune != nil {
		ok := object.Key("inputChannelsFineTune")
		if err := awsRestjson1_serializeDocument__listOf__doubleMinNegative60Max6(v.InputChannelsFineTune, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputGroup(v *types.OutputGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutomatedEncodingSettings != nil {
		ok := object.Key("automatedEncodingSettings")
		if err := awsRestjson1_serializeDocumentAutomatedEncodingSettings(v.AutomatedEncodingSettings, ok); err != nil {
			return err
		}
	}

	if v.CustomName != nil {
		ok := object.Key("customName")
		ok.String(*v.CustomName)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.OutputGroupSettings != nil {
		ok := object.Key("outputGroupSettings")
		if err := awsRestjson1_serializeDocumentOutputGroupSettings(v.OutputGroupSettings, ok); err != nil {
			return err
		}
	}

	if v.Outputs != nil {
		ok := object.Key("outputs")
		if err := awsRestjson1_serializeDocument__listOfOutput(v.Outputs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputGroupSettings(v *types.OutputGroupSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CmafGroupSettings != nil {
		ok := object.Key("cmafGroupSettings")
		if err := awsRestjson1_serializeDocumentCmafGroupSettings(v.CmafGroupSettings, ok); err != nil {
			return err
		}
	}

	if v.DashIsoGroupSettings != nil {
		ok := object.Key("dashIsoGroupSettings")
		if err := awsRestjson1_serializeDocumentDashIsoGroupSettings(v.DashIsoGroupSettings, ok); err != nil {
			return err
		}
	}

	if v.FileGroupSettings != nil {
		ok := object.Key("fileGroupSettings")
		if err := awsRestjson1_serializeDocumentFileGroupSettings(v.FileGroupSettings, ok); err != nil {
			return err
		}
	}

	if v.HlsGroupSettings != nil {
		ok := object.Key("hlsGroupSettings")
		if err := awsRestjson1_serializeDocumentHlsGroupSettings(v.HlsGroupSettings, ok); err != nil {
			return err
		}
	}

	if v.MsSmoothGroupSettings != nil {
		ok := object.Key("msSmoothGroupSettings")
		if err := awsRestjson1_serializeDocumentMsSmoothGroupSettings(v.MsSmoothGroupSettings, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputSettings(v *types.OutputSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HlsSettings != nil {
		ok := object.Key("hlsSettings")
		if err := awsRestjson1_serializeDocumentHlsSettings(v.HlsSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPartnerWatermarking(v *types.PartnerWatermarking, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NexguardFileMarkerSettings != nil {
		ok := object.Key("nexguardFileMarkerSettings")
		if err := awsRestjson1_serializeDocumentNexGuardFileMarkerSettings(v.NexguardFileMarkerSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPolicy(v *types.Policy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.HttpInputs) > 0 {
		ok := object.Key("httpInputs")
		ok.String(string(v.HttpInputs))
	}

	if len(v.HttpsInputs) > 0 {
		ok := object.Key("httpsInputs")
		ok.String(string(v.HttpsInputs))
	}

	if len(v.S3Inputs) > 0 {
		ok := object.Key("s3Inputs")
		ok.String(string(v.S3Inputs))
	}

	return nil
}

func awsRestjson1_serializeDocumentPresetSettings(v *types.PresetSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioDescriptions != nil {
		ok := object.Key("audioDescriptions")
		if err := awsRestjson1_serializeDocument__listOfAudioDescription(v.AudioDescriptions, ok); err != nil {
			return err
		}
	}

	if v.CaptionDescriptions != nil {
		ok := object.Key("captionDescriptions")
		if err := awsRestjson1_serializeDocument__listOfCaptionDescriptionPreset(v.CaptionDescriptions, ok); err != nil {
			return err
		}
	}

	if v.ContainerSettings != nil {
		ok := object.Key("containerSettings")
		if err := awsRestjson1_serializeDocumentContainerSettings(v.ContainerSettings, ok); err != nil {
			return err
		}
	}

	if v.VideoDescription != nil {
		ok := object.Key("videoDescription")
		if err := awsRestjson1_serializeDocumentVideoDescription(v.VideoDescription, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentProresSettings(v *types.ProresSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ChromaSampling) > 0 {
		ok := object.Key("chromaSampling")
		ok.String(string(v.ChromaSampling))
	}

	if len(v.CodecProfile) > 0 {
		ok := object.Key("codecProfile")
		ok.String(string(v.CodecProfile))
	}

	if len(v.FramerateControl) > 0 {
		ok := object.Key("framerateControl")
		ok.String(string(v.FramerateControl))
	}

	if len(v.FramerateConversionAlgorithm) > 0 {
		ok := object.Key("framerateConversionAlgorithm")
		ok.String(string(v.FramerateConversionAlgorithm))
	}

	if v.FramerateDenominator != nil {
		ok := object.Key("framerateDenominator")
		ok.Integer(*v.FramerateDenominator)
	}

	if v.FramerateNumerator != nil {
		ok := object.Key("framerateNumerator")
		ok.Integer(*v.FramerateNumerator)
	}

	if len(v.InterlaceMode) > 0 {
		ok := object.Key("interlaceMode")
		ok.String(string(v.InterlaceMode))
	}

	if len(v.ParControl) > 0 {
		ok := object.Key("parControl")
		ok.String(string(v.ParControl))
	}

	if v.ParDenominator != nil {
		ok := object.Key("parDenominator")
		ok.Integer(*v.ParDenominator)
	}

	if v.ParNumerator != nil {
		ok := object.Key("parNumerator")
		ok.Integer(*v.ParNumerator)
	}

	if len(v.ScanTypeConversionMode) > 0 {
		ok := object.Key("scanTypeConversionMode")
		ok.String(string(v.ScanTypeConversionMode))
	}

	if len(v.SlowPal) > 0 {
		ok := object.Key("slowPal")
		ok.String(string(v.SlowPal))
	}

	if len(v.Telecine) > 0 {
		ok := object.Key("telecine")
		ok.String(string(v.Telecine))
	}

	return nil
}

func awsRestjson1_serializeDocumentRectangle(v *types.Rectangle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Height != nil {
		ok := object.Key("height")
		ok.Integer(*v.Height)
	}

	if v.Width != nil {
		ok := object.Key("width")
		ok.Integer(*v.Width)
	}

	if v.X != nil {
		ok := object.Key("x")
		ok.Integer(*v.X)
	}

	if v.Y != nil {
		ok := object.Key("y")
		ok.Integer(*v.Y)
	}

	return nil
}

func awsRestjson1_serializeDocumentRemixSettings(v *types.RemixSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioDescriptionAudioChannel != nil {
		ok := object.Key("audioDescriptionAudioChannel")
		ok.Integer(*v.AudioDescriptionAudioChannel)
	}

	if v.AudioDescriptionDataChannel != nil {
		ok := object.Key("audioDescriptionDataChannel")
		ok.Integer(*v.AudioDescriptionDataChannel)
	}

	if v.ChannelMapping != nil {
		ok := object.Key("channelMapping")
		if err := awsRestjson1_serializeDocumentChannelMapping(v.ChannelMapping, ok); err != nil {
			return err
		}
	}

	if v.ChannelsIn != nil {
		ok := object.Key("channelsIn")
		ok.Integer(*v.ChannelsIn)
	}

	if v.ChannelsOut != nil {
		ok := object.Key("channelsOut")
		ok.Integer(*v.ChannelsOut)
	}

	return nil
}

func awsRestjson1_serializeDocumentReservationPlanSettings(v *types.ReservationPlanSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Commitment) > 0 {
		ok := object.Key("commitment")
		ok.String(string(v.Commitment))
	}

	if len(v.RenewalType) > 0 {
		ok := object.Key("renewalType")
		ok.String(string(v.RenewalType))
	}

	if v.ReservedSlots != nil {
		ok := object.Key("reservedSlots")
		ok.Integer(*v.ReservedSlots)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3DestinationAccessControl(v *types.S3DestinationAccessControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CannedAcl) > 0 {
		ok := object.Key("cannedAcl")
		ok.String(string(v.CannedAcl))
	}

	return nil
}

func awsRestjson1_serializeDocumentS3DestinationSettings(v *types.S3DestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessControl != nil {
		ok := object.Key("accessControl")
		if err := awsRestjson1_serializeDocumentS3DestinationAccessControl(v.AccessControl, ok); err != nil {
			return err
		}
	}

	if v.Encryption != nil {
		ok := object.Key("encryption")
		if err := awsRestjson1_serializeDocumentS3EncryptionSettings(v.Encryption, ok); err != nil {
			return err
		}
	}

	if len(v.StorageClass) > 0 {
		ok := object.Key("storageClass")
		ok.String(string(v.StorageClass))
	}

	return nil
}

func awsRestjson1_serializeDocumentS3EncryptionSettings(v *types.S3EncryptionSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EncryptionType) > 0 {
		ok := object.Key("encryptionType")
		ok.String(string(v.EncryptionType))
	}

	if v.KmsEncryptionContext != nil {
		ok := object.Key("kmsEncryptionContext")
		ok.String(*v.KmsEncryptionContext)
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("kmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentSccDestinationSettings(v *types.SccDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Framerate) > 0 {
		ok := object.Key("framerate")
		ok.String(string(v.Framerate))
	}

	return nil
}

func awsRestjson1_serializeDocumentSpekeKeyProvider(v *types.SpekeKeyProvider, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateArn != nil {
		ok := object.Key("certificateArn")
		ok.String(*v.CertificateArn)
	}

	if v.ResourceId != nil {
		ok := object.Key("resourceId")
		ok.String(*v.ResourceId)
	}

	if v.SystemIds != nil {
		ok := object.Key("systemIds")
		if err := awsRestjson1_serializeDocument__listOf__stringPattern09aFAF809aFAF409aFAF409aFAF409aFAF12(v.SystemIds, ok); err != nil {
			return err
		}
	}

	if v.Url != nil {
		ok := object.Key("url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentSpekeKeyProviderCmaf(v *types.SpekeKeyProviderCmaf, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateArn != nil {
		ok := object.Key("certificateArn")
		ok.String(*v.CertificateArn)
	}

	if v.DashSignaledSystemIds != nil {
		ok := object.Key("dashSignaledSystemIds")
		if err := awsRestjson1_serializeDocument__listOf__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12(v.DashSignaledSystemIds, ok); err != nil {
			return err
		}
	}

	if v.HlsSignaledSystemIds != nil {
		ok := object.Key("hlsSignaledSystemIds")
		if err := awsRestjson1_serializeDocument__listOf__stringMin36Max36Pattern09aFAF809aFAF409aFAF409aFAF409aFAF12(v.HlsSignaledSystemIds, ok); err != nil {
			return err
		}
	}

	if v.ResourceId != nil {
		ok := object.Key("resourceId")
		ok.String(*v.ResourceId)
	}

	if v.Url != nil {
		ok := object.Key("url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentSrtDestinationSettings(v *types.SrtDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.StylePassthrough) > 0 {
		ok := object.Key("stylePassthrough")
		ok.String(string(v.StylePassthrough))
	}

	return nil
}

func awsRestjson1_serializeDocumentStaticKeyProvider(v *types.StaticKeyProvider, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyFormat != nil {
		ok := object.Key("keyFormat")
		ok.String(*v.KeyFormat)
	}

	if v.KeyFormatVersions != nil {
		ok := object.Key("keyFormatVersions")
		ok.String(*v.KeyFormatVersions)
	}

	if v.StaticKeyValue != nil {
		ok := object.Key("staticKeyValue")
		ok.String(*v.StaticKeyValue)
	}

	if v.Url != nil {
		ok := object.Key("url")
		ok.String(*v.Url)
	}

	return nil
}

func awsRestjson1_serializeDocumentTeletextDestinationSettings(v *types.TeletextDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PageNumber != nil {
		ok := object.Key("pageNumber")
		ok.String(*v.PageNumber)
	}

	if v.PageTypes != nil {
		ok := object.Key("pageTypes")
		if err := awsRestjson1_serializeDocument__listOfTeletextPageType(v.PageTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTeletextSourceSettings(v *types.TeletextSourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PageNumber != nil {
		ok := object.Key("pageNumber")
		ok.String(*v.PageNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentTimecodeBurnin(v *types.TimecodeBurnin, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FontSize != nil {
		ok := object.Key("fontSize")
		ok.Integer(*v.FontSize)
	}

	if len(v.Position) > 0 {
		ok := object.Key("position")
		ok.String(string(v.Position))
	}

	if v.Prefix != nil {
		ok := object.Key("prefix")
		ok.String(*v.Prefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentTimecodeConfig(v *types.TimecodeConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Anchor != nil {
		ok := object.Key("anchor")
		ok.String(*v.Anchor)
	}

	if len(v.Source) > 0 {
		ok := object.Key("source")
		ok.String(string(v.Source))
	}

	if v.Start != nil {
		ok := object.Key("start")
		ok.String(*v.Start)
	}

	if v.TimestampOffset != nil {
		ok := object.Key("timestampOffset")
		ok.String(*v.TimestampOffset)
	}

	return nil
}

func awsRestjson1_serializeDocumentTimedMetadataInsertion(v *types.TimedMetadataInsertion, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id3Insertions != nil {
		ok := object.Key("id3Insertions")
		if err := awsRestjson1_serializeDocument__listOfId3Insertion(v.Id3Insertions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTrackSourceSettings(v *types.TrackSourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TrackNumber != nil {
		ok := object.Key("trackNumber")
		ok.Integer(*v.TrackNumber)
	}

	return nil
}

func awsRestjson1_serializeDocumentTtmlDestinationSettings(v *types.TtmlDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.StylePassthrough) > 0 {
		ok := object.Key("stylePassthrough")
		ok.String(string(v.StylePassthrough))
	}

	return nil
}

func awsRestjson1_serializeDocumentUncompressedSettings(v *types.UncompressedSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Fourcc) > 0 {
		ok := object.Key("fourcc")
		ok.String(string(v.Fourcc))
	}

	if len(v.FramerateControl) > 0 {
		ok := object.Key("framerateControl")
		ok.String(string(v.FramerateControl))
	}

	if len(v.FramerateConversionAlgorithm) > 0 {
		ok := object.Key("framerateConversionAlgorithm")
		ok.String(string(v.FramerateConversionAlgorithm))
	}

	if v.FramerateDenominator != nil {
		ok := object.Key("framerateDenominator")
		ok.Integer(*v.FramerateDenominator)
	}

	if v.FramerateNumerator != nil {
		ok := object.Key("framerateNumerator")
		ok.Integer(*v.FramerateNumerator)
	}

	if len(v.InterlaceMode) > 0 {
		ok := object.Key("interlaceMode")
		ok.String(string(v.InterlaceMode))
	}

	if len(v.ScanTypeConversionMode) > 0 {
		ok := object.Key("scanTypeConversionMode")
		ok.String(string(v.ScanTypeConversionMode))
	}

	if len(v.SlowPal) > 0 {
		ok := object.Key("slowPal")
		ok.String(string(v.SlowPal))
	}

	if len(v.Telecine) > 0 {
		ok := object.Key("telecine")
		ok.String(string(v.Telecine))
	}

	return nil
}

func awsRestjson1_serializeDocumentVc3Settings(v *types.Vc3Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FramerateControl) > 0 {
		ok := object.Key("framerateControl")
		ok.String(string(v.FramerateControl))
	}

	if len(v.FramerateConversionAlgorithm) > 0 {
		ok := object.Key("framerateConversionAlgorithm")
		ok.String(string(v.FramerateConversionAlgorithm))
	}

	if v.FramerateDenominator != nil {
		ok := object.Key("framerateDenominator")
		ok.Integer(*v.FramerateDenominator)
	}

	if v.FramerateNumerator != nil {
		ok := object.Key("framerateNumerator")
		ok.Integer(*v.FramerateNumerator)
	}

	if len(v.InterlaceMode) > 0 {
		ok := object.Key("interlaceMode")
		ok.String(string(v.InterlaceMode))
	}

	if len(v.ScanTypeConversionMode) > 0 {
		ok := object.Key("scanTypeConversionMode")
		ok.String(string(v.ScanTypeConversionMode))
	}

	if len(v.SlowPal) > 0 {
		ok := object.Key("slowPal")
		ok.String(string(v.SlowPal))
	}

	if len(v.Telecine) > 0 {
		ok := object.Key("telecine")
		ok.String(string(v.Telecine))
	}

	if len(v.Vc3Class) > 0 {
		ok := object.Key("vc3Class")
		ok.String(string(v.Vc3Class))
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoCodecSettings(v *types.VideoCodecSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Av1Settings != nil {
		ok := object.Key("av1Settings")
		if err := awsRestjson1_serializeDocumentAv1Settings(v.Av1Settings, ok); err != nil {
			return err
		}
	}

	if v.AvcIntraSettings != nil {
		ok := object.Key("avcIntraSettings")
		if err := awsRestjson1_serializeDocumentAvcIntraSettings(v.AvcIntraSettings, ok); err != nil {
			return err
		}
	}

	if len(v.Codec) > 0 {
		ok := object.Key("codec")
		ok.String(string(v.Codec))
	}

	if v.FrameCaptureSettings != nil {
		ok := object.Key("frameCaptureSettings")
		if err := awsRestjson1_serializeDocumentFrameCaptureSettings(v.FrameCaptureSettings, ok); err != nil {
			return err
		}
	}

	if v.H264Settings != nil {
		ok := object.Key("h264Settings")
		if err := awsRestjson1_serializeDocumentH264Settings(v.H264Settings, ok); err != nil {
			return err
		}
	}

	if v.H265Settings != nil {
		ok := object.Key("h265Settings")
		if err := awsRestjson1_serializeDocumentH265Settings(v.H265Settings, ok); err != nil {
			return err
		}
	}

	if v.Mpeg2Settings != nil {
		ok := object.Key("mpeg2Settings")
		if err := awsRestjson1_serializeDocumentMpeg2Settings(v.Mpeg2Settings, ok); err != nil {
			return err
		}
	}

	if v.ProresSettings != nil {
		ok := object.Key("proresSettings")
		if err := awsRestjson1_serializeDocumentProresSettings(v.ProresSettings, ok); err != nil {
			return err
		}
	}

	if v.UncompressedSettings != nil {
		ok := object.Key("uncompressedSettings")
		if err := awsRestjson1_serializeDocumentUncompressedSettings(v.UncompressedSettings, ok); err != nil {
			return err
		}
	}

	if v.Vc3Settings != nil {
		ok := object.Key("vc3Settings")
		if err := awsRestjson1_serializeDocumentVc3Settings(v.Vc3Settings, ok); err != nil {
			return err
		}
	}

	if v.Vp8Settings != nil {
		ok := object.Key("vp8Settings")
		if err := awsRestjson1_serializeDocumentVp8Settings(v.Vp8Settings, ok); err != nil {
			return err
		}
	}

	if v.Vp9Settings != nil {
		ok := object.Key("vp9Settings")
		if err := awsRestjson1_serializeDocumentVp9Settings(v.Vp9Settings, ok); err != nil {
			return err
		}
	}

	if v.XavcSettings != nil {
		ok := object.Key("xavcSettings")
		if err := awsRestjson1_serializeDocumentXavcSettings(v.XavcSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoDescription(v *types.VideoDescription, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AfdSignaling) > 0 {
		ok := object.Key("afdSignaling")
		ok.String(string(v.AfdSignaling))
	}

	if len(v.AntiAlias) > 0 {
		ok := object.Key("antiAlias")
		ok.String(string(v.AntiAlias))
	}

	if v.CodecSettings != nil {
		ok := object.Key("codecSettings")
		if err := awsRestjson1_serializeDocumentVideoCodecSettings(v.CodecSettings, ok); err != nil {
			return err
		}
	}

	if len(v.ColorMetadata) > 0 {
		ok := object.Key("colorMetadata")
		ok.String(string(v.ColorMetadata))
	}

	if v.Crop != nil {
		ok := object.Key("crop")
		if err := awsRestjson1_serializeDocumentRectangle(v.Crop, ok); err != nil {
			return err
		}
	}

	if len(v.DropFrameTimecode) > 0 {
		ok := object.Key("dropFrameTimecode")
		ok.String(string(v.DropFrameTimecode))
	}

	if v.FixedAfd != nil {
		ok := object.Key("fixedAfd")
		ok.Integer(*v.FixedAfd)
	}

	if v.Height != nil {
		ok := object.Key("height")
		ok.Integer(*v.Height)
	}

	if v.Position != nil {
		ok := object.Key("position")
		if err := awsRestjson1_serializeDocumentRectangle(v.Position, ok); err != nil {
			return err
		}
	}

	if len(v.RespondToAfd) > 0 {
		ok := object.Key("respondToAfd")
		ok.String(string(v.RespondToAfd))
	}

	if len(v.ScalingBehavior) > 0 {
		ok := object.Key("scalingBehavior")
		ok.String(string(v.ScalingBehavior))
	}

	if v.Sharpness != nil {
		ok := object.Key("sharpness")
		ok.Integer(*v.Sharpness)
	}

	if len(v.TimecodeInsertion) > 0 {
		ok := object.Key("timecodeInsertion")
		ok.String(string(v.TimecodeInsertion))
	}

	if v.VideoPreprocessors != nil {
		ok := object.Key("videoPreprocessors")
		if err := awsRestjson1_serializeDocumentVideoPreprocessor(v.VideoPreprocessors, ok); err != nil {
			return err
		}
	}

	if v.Width != nil {
		ok := object.Key("width")
		ok.Integer(*v.Width)
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoOverlay(v *types.VideoOverlay, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTimecode != nil {
		ok := object.Key("endTimecode")
		ok.String(*v.EndTimecode)
	}

	if v.Input != nil {
		ok := object.Key("input")
		if err := awsRestjson1_serializeDocumentVideoOverlayInput(v.Input, ok); err != nil {
			return err
		}
	}

	if v.StartTimecode != nil {
		ok := object.Key("startTimecode")
		ok.String(*v.StartTimecode)
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoOverlayInput(v *types.VideoOverlayInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FileInput != nil {
		ok := object.Key("fileInput")
		ok.String(*v.FileInput)
	}

	if v.InputClippings != nil {
		ok := object.Key("inputClippings")
		if err := awsRestjson1_serializeDocument__listOfVideoOverlayInputClipping(v.InputClippings, ok); err != nil {
			return err
		}
	}

	if len(v.TimecodeSource) > 0 {
		ok := object.Key("timecodeSource")
		ok.String(string(v.TimecodeSource))
	}

	if v.TimecodeStart != nil {
		ok := object.Key("timecodeStart")
		ok.String(*v.TimecodeStart)
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoOverlayInputClipping(v *types.VideoOverlayInputClipping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTimecode != nil {
		ok := object.Key("endTimecode")
		ok.String(*v.EndTimecode)
	}

	if v.StartTimecode != nil {
		ok := object.Key("startTimecode")
		ok.String(*v.StartTimecode)
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoPreprocessor(v *types.VideoPreprocessor, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ColorCorrector != nil {
		ok := object.Key("colorCorrector")
		if err := awsRestjson1_serializeDocumentColorCorrector(v.ColorCorrector, ok); err != nil {
			return err
		}
	}

	if v.Deinterlacer != nil {
		ok := object.Key("deinterlacer")
		if err := awsRestjson1_serializeDocumentDeinterlacer(v.Deinterlacer, ok); err != nil {
			return err
		}
	}

	if v.DolbyVision != nil {
		ok := object.Key("dolbyVision")
		if err := awsRestjson1_serializeDocumentDolbyVision(v.DolbyVision, ok); err != nil {
			return err
		}
	}

	if v.Hdr10Plus != nil {
		ok := object.Key("hdr10Plus")
		if err := awsRestjson1_serializeDocumentHdr10Plus(v.Hdr10Plus, ok); err != nil {
			return err
		}
	}

	if v.ImageInserter != nil {
		ok := object.Key("imageInserter")
		if err := awsRestjson1_serializeDocumentImageInserter(v.ImageInserter, ok); err != nil {
			return err
		}
	}

	if v.NoiseReducer != nil {
		ok := object.Key("noiseReducer")
		if err := awsRestjson1_serializeDocumentNoiseReducer(v.NoiseReducer, ok); err != nil {
			return err
		}
	}

	if v.PartnerWatermarking != nil {
		ok := object.Key("partnerWatermarking")
		if err := awsRestjson1_serializeDocumentPartnerWatermarking(v.PartnerWatermarking, ok); err != nil {
			return err
		}
	}

	if v.TimecodeBurnin != nil {
		ok := object.Key("timecodeBurnin")
		if err := awsRestjson1_serializeDocumentTimecodeBurnin(v.TimecodeBurnin, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentVideoSelector(v *types.VideoSelector, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AlphaBehavior) > 0 {
		ok := object.Key("alphaBehavior")
		ok.String(string(v.AlphaBehavior))
	}

	if len(v.ColorSpace) > 0 {
		ok := object.Key("colorSpace")
		ok.String(string(v.ColorSpace))
	}

	if len(v.ColorSpaceUsage) > 0 {
		ok := object.Key("colorSpaceUsage")
		ok.String(string(v.ColorSpaceUsage))
	}

	if len(v.EmbeddedTimecodeOverride) > 0 {
		ok := object.Key("embeddedTimecodeOverride")
		ok.String(string(v.EmbeddedTimecodeOverride))
	}

	if v.Hdr10Metadata != nil {
		ok := object.Key("hdr10Metadata")
		if err := awsRestjson1_serializeDocumentHdr10Metadata(v.Hdr10Metadata, ok); err != nil {
			return err
		}
	}

	if v.MaxLuminance != nil {
		ok := object.Key("maxLuminance")
		ok.Integer(*v.MaxLuminance)
	}

	if len(v.PadVideo) > 0 {
		ok := object.Key("padVideo")
		ok.String(string(v.PadVideo))
	}

	if v.Pid != nil {
		ok := object.Key("pid")
		ok.Integer(*v.Pid)
	}

	if v.ProgramNumber != nil {
		ok := object.Key("programNumber")
		ok.Integer(*v.ProgramNumber)
	}

	if len(v.Rotate) > 0 {
		ok := object.Key("rotate")
		ok.String(string(v.Rotate))
	}

	if len(v.SampleRange) > 0 {
		ok := object.Key("sampleRange")
		ok.String(string(v.SampleRange))
	}

	return nil
}

func awsRestjson1_serializeDocumentVorbisSettings(v *types.VorbisSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Channels != nil {
		ok := object.Key("channels")
		ok.Integer(*v.Channels)
	}

	if v.SampleRate != nil {
		ok := object.Key("sampleRate")
		ok.Integer(*v.SampleRate)
	}

	if v.VbrQuality != nil {
		ok := object.Key("vbrQuality")
		ok.Integer(*v.VbrQuality)
	}

	return nil
}

func awsRestjson1_serializeDocumentVp8Settings(v *types.Vp8Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bitrate != nil {
		ok := object.Key("bitrate")
		ok.Integer(*v.Bitrate)
	}

	if len(v.FramerateControl) > 0 {
		ok := object.Key("framerateControl")
		ok.String(string(v.FramerateControl))
	}

	if len(v.FramerateConversionAlgorithm) > 0 {
		ok := object.Key("framerateConversionAlgorithm")
		ok.String(string(v.FramerateConversionAlgorithm))
	}

	if v.FramerateDenominator != nil {
		ok := object.Key("framerateDenominator")
		ok.Integer(*v.FramerateDenominator)
	}

	if v.FramerateNumerator != nil {
		ok := object.Key("framerateNumerator")
		ok.Integer(*v.FramerateNumerator)
	}

	if v.GopSize != nil {
		ok := object.Key("gopSize")
		switch {
		case math.IsNaN(*v.GopSize):
			ok.String("NaN")

		case math.IsInf(*v.GopSize, 1):
			ok.String("Infinity")

		case math.IsInf(*v.GopSize, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.GopSize)

		}
	}

	if v.HrdBufferSize != nil {
		ok := object.Key("hrdBufferSize")
		ok.Integer(*v.HrdBufferSize)
	}

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	if len(v.ParControl) > 0 {
		ok := object.Key("parControl")
		ok.String(string(v.ParControl))
	}

	if v.ParDenominator != nil {
		ok := object.Key("parDenominator")
		ok.Integer(*v.ParDenominator)
	}

	if v.ParNumerator != nil {
		ok := object.Key("parNumerator")
		ok.Integer(*v.ParNumerator)
	}

	if len(v.QualityTuningLevel) > 0 {
		ok := object.Key("qualityTuningLevel")
		ok.String(string(v.QualityTuningLevel))
	}

	if len(v.RateControlMode) > 0 {
		ok := object.Key("rateControlMode")
		ok.String(string(v.RateControlMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentVp9Settings(v *types.Vp9Settings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bitrate != nil {
		ok := object.Key("bitrate")
		ok.Integer(*v.Bitrate)
	}

	if len(v.FramerateControl) > 0 {
		ok := object.Key("framerateControl")
		ok.String(string(v.FramerateControl))
	}

	if len(v.FramerateConversionAlgorithm) > 0 {
		ok := object.Key("framerateConversionAlgorithm")
		ok.String(string(v.FramerateConversionAlgorithm))
	}

	if v.FramerateDenominator != nil {
		ok := object.Key("framerateDenominator")
		ok.Integer(*v.FramerateDenominator)
	}

	if v.FramerateNumerator != nil {
		ok := object.Key("framerateNumerator")
		ok.Integer(*v.FramerateNumerator)
	}

	if v.GopSize != nil {
		ok := object.Key("gopSize")
		switch {
		case math.IsNaN(*v.GopSize):
			ok.String("NaN")

		case math.IsInf(*v.GopSize, 1):
			ok.String("Infinity")

		case math.IsInf(*v.GopSize, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.GopSize)

		}
	}

	if v.HrdBufferSize != nil {
		ok := object.Key("hrdBufferSize")
		ok.Integer(*v.HrdBufferSize)
	}

	if v.MaxBitrate != nil {
		ok := object.Key("maxBitrate")
		ok.Integer(*v.MaxBitrate)
	}

	if len(v.ParControl) > 0 {
		ok := object.Key("parControl")
		ok.String(string(v.ParControl))
	}

	if v.ParDenominator != nil {
		ok := object.Key("parDenominator")
		ok.Integer(*v.ParDenominator)
	}

	if v.ParNumerator != nil {
		ok := object.Key("parNumerator")
		ok.Integer(*v.ParNumerator)
	}

	if len(v.QualityTuningLevel) > 0 {
		ok := object.Key("qualityTuningLevel")
		ok.String(string(v.QualityTuningLevel))
	}

	if len(v.RateControlMode) > 0 {
		ok := object.Key("rateControlMode")
		ok.String(string(v.RateControlMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentWavSettings(v *types.WavSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BitDepth != nil {
		ok := object.Key("bitDepth")
		ok.Integer(*v.BitDepth)
	}

	if v.Channels != nil {
		ok := object.Key("channels")
		ok.Integer(*v.Channels)
	}

	if len(v.Format) > 0 {
		ok := object.Key("format")
		ok.String(string(v.Format))
	}

	if v.SampleRate != nil {
		ok := object.Key("sampleRate")
		ok.Integer(*v.SampleRate)
	}

	return nil
}

func awsRestjson1_serializeDocumentWebvttDestinationSettings(v *types.WebvttDestinationSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Accessibility) > 0 {
		ok := object.Key("accessibility")
		ok.String(string(v.Accessibility))
	}

	if len(v.StylePassthrough) > 0 {
		ok := object.Key("stylePassthrough")
		ok.String(string(v.StylePassthrough))
	}

	return nil
}

func awsRestjson1_serializeDocumentWebvttHlsSourceSettings(v *types.WebvttHlsSourceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RenditionGroupId != nil {
		ok := object.Key("renditionGroupId")
		ok.String(*v.RenditionGroupId)
	}

	if len(v.RenditionLanguageCode) > 0 {
		ok := object.Key("renditionLanguageCode")
		ok.String(string(v.RenditionLanguageCode))
	}

	if v.RenditionName != nil {
		ok := object.Key("renditionName")
		ok.String(*v.RenditionName)
	}

	return nil
}

func awsRestjson1_serializeDocumentXavc4kIntraCbgProfileSettings(v *types.Xavc4kIntraCbgProfileSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.XavcClass) > 0 {
		ok := object.Key("xavcClass")
		ok.String(string(v.XavcClass))
	}

	return nil
}

func awsRestjson1_serializeDocumentXavc4kIntraVbrProfileSettings(v *types.Xavc4kIntraVbrProfileSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.XavcClass) > 0 {
		ok := object.Key("xavcClass")
		ok.String(string(v.XavcClass))
	}

	return nil
}

func awsRestjson1_serializeDocumentXavc4kProfileSettings(v *types.Xavc4kProfileSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BitrateClass) > 0 {
		ok := object.Key("bitrateClass")
		ok.String(string(v.BitrateClass))
	}

	if len(v.CodecProfile) > 0 {
		ok := object.Key("codecProfile")
		ok.String(string(v.CodecProfile))
	}

	if len(v.FlickerAdaptiveQuantization) > 0 {
		ok := object.Key("flickerAdaptiveQuantization")
		ok.String(string(v.FlickerAdaptiveQuantization))
	}

	if len(v.GopBReference) > 0 {
		ok := object.Key("gopBReference")
		ok.String(string(v.GopBReference))
	}

	if v.GopClosedCadence != nil {
		ok := object.Key("gopClosedCadence")
		ok.Integer(*v.GopClosedCadence)
	}

	if v.HrdBufferSize != nil {
		ok := object.Key("hrdBufferSize")
		ok.Integer(*v.HrdBufferSize)
	}

	if len(v.QualityTuningLevel) > 0 {
		ok := object.Key("qualityTuningLevel")
		ok.String(string(v.QualityTuningLevel))
	}

	if v.Slices != nil {
		ok := object.Key("slices")
		ok.Integer(*v.Slices)
	}

	return nil
}

func awsRestjson1_serializeDocumentXavcHdIntraCbgProfileSettings(v *types.XavcHdIntraCbgProfileSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.XavcClass) > 0 {
		ok := object.Key("xavcClass")
		ok.String(string(v.XavcClass))
	}

	return nil
}

func awsRestjson1_serializeDocumentXavcHdProfileSettings(v *types.XavcHdProfileSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BitrateClass) > 0 {
		ok := object.Key("bitrateClass")
		ok.String(string(v.BitrateClass))
	}

	if len(v.FlickerAdaptiveQuantization) > 0 {
		ok := object.Key("flickerAdaptiveQuantization")
		ok.String(string(v.FlickerAdaptiveQuantization))
	}

	if len(v.GopBReference) > 0 {
		ok := object.Key("gopBReference")
		ok.String(string(v.GopBReference))
	}

	if v.GopClosedCadence != nil {
		ok := object.Key("gopClosedCadence")
		ok.Integer(*v.GopClosedCadence)
	}

	if v.HrdBufferSize != nil {
		ok := object.Key("hrdBufferSize")
		ok.Integer(*v.HrdBufferSize)
	}

	if len(v.InterlaceMode) > 0 {
		ok := object.Key("interlaceMode")
		ok.String(string(v.InterlaceMode))
	}

	if len(v.QualityTuningLevel) > 0 {
		ok := object.Key("qualityTuningLevel")
		ok.String(string(v.QualityTuningLevel))
	}

	if v.Slices != nil {
		ok := object.Key("slices")
		ok.Integer(*v.Slices)
	}

	if len(v.Telecine) > 0 {
		ok := object.Key("telecine")
		ok.String(string(v.Telecine))
	}

	return nil
}

func awsRestjson1_serializeDocumentXavcSettings(v *types.XavcSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AdaptiveQuantization) > 0 {
		ok := object.Key("adaptiveQuantization")
		ok.String(string(v.AdaptiveQuantization))
	}

	if len(v.EntropyEncoding) > 0 {
		ok := object.Key("entropyEncoding")
		ok.String(string(v.EntropyEncoding))
	}

	if len(v.FramerateControl) > 0 {
		ok := object.Key("framerateControl")
		ok.String(string(v.FramerateControl))
	}

	if len(v.FramerateConversionAlgorithm) > 0 {
		ok := object.Key("framerateConversionAlgorithm")
		ok.String(string(v.FramerateConversionAlgorithm))
	}

	if v.FramerateDenominator != nil {
		ok := object.Key("framerateDenominator")
		ok.Integer(*v.FramerateDenominator)
	}

	if v.FramerateNumerator != nil {
		ok := object.Key("framerateNumerator")
		ok.Integer(*v.FramerateNumerator)
	}

	if len(v.Profile) > 0 {
		ok := object.Key("profile")
		ok.String(string(v.Profile))
	}

	if len(v.SlowPal) > 0 {
		ok := object.Key("slowPal")
		ok.String(string(v.SlowPal))
	}

	if v.Softness != nil {
		ok := object.Key("softness")
		ok.Integer(*v.Softness)
	}

	if len(v.SpatialAdaptiveQuantization) > 0 {
		ok := object.Key("spatialAdaptiveQuantization")
		ok.String(string(v.SpatialAdaptiveQuantization))
	}

	if len(v.TemporalAdaptiveQuantization) > 0 {
		ok := object.Key("temporalAdaptiveQuantization")
		ok.String(string(v.TemporalAdaptiveQuantization))
	}

	if v.Xavc4kIntraCbgProfileSettings != nil {
		ok := object.Key("xavc4kIntraCbgProfileSettings")
		if err := awsRestjson1_serializeDocumentXavc4kIntraCbgProfileSettings(v.Xavc4kIntraCbgProfileSettings, ok); err != nil {
			return err
		}
	}

	if v.Xavc4kIntraVbrProfileSettings != nil {
		ok := object.Key("xavc4kIntraVbrProfileSettings")
		if err := awsRestjson1_serializeDocumentXavc4kIntraVbrProfileSettings(v.Xavc4kIntraVbrProfileSettings, ok); err != nil {
			return err
		}
	}

	if v.Xavc4kProfileSettings != nil {
		ok := object.Key("xavc4kProfileSettings")
		if err := awsRestjson1_serializeDocumentXavc4kProfileSettings(v.Xavc4kProfileSettings, ok); err != nil {
			return err
		}
	}

	if v.XavcHdIntraCbgProfileSettings != nil {
		ok := object.Key("xavcHdIntraCbgProfileSettings")
		if err := awsRestjson1_serializeDocumentXavcHdIntraCbgProfileSettings(v.XavcHdIntraCbgProfileSettings, ok); err != nil {
			return err
		}
	}

	if v.XavcHdProfileSettings != nil {
		ok := object.Key("xavcHdProfileSettings")
		if err := awsRestjson1_serializeDocumentXavcHdProfileSettings(v.XavcHdProfileSettings, ok); err != nil {
			return err
		}
	}

	return nil
}
