//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armautomanage

import "time"

// AssignmentReportProperties - Data related to the report detail.
type AssignmentReportProperties struct {
	// End time of the configuration profile assignment processing.
	EndTime *string `json:"endTime,omitempty"`

	// Start time of the configuration profile assignment processing.
	StartTime *string `json:"startTime,omitempty"`

	// READ-ONLY; The configurationProfile linked to the assignment.
	ConfigurationProfile *string `json:"configurationProfile,omitempty" azure:"ro"`

	// READ-ONLY; Duration of the configuration profile assignment processing.
	Duration *string `json:"duration,omitempty" azure:"ro"`

	// READ-ONLY; Error message, if any, returned by the configuration profile assignment processing.
	Error *ErrorDetail `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; Last modified time of the configuration profile assignment processing.
	LastModifiedTime *string `json:"lastModifiedTime,omitempty" azure:"ro"`

	// READ-ONLY; Version of the report format
	ReportFormatVersion *string `json:"reportFormatVersion,omitempty" azure:"ro"`

	// READ-ONLY; List of resources processed by the configuration profile assignment.
	Resources []*ReportResource `json:"resources,omitempty" azure:"ro"`

	// READ-ONLY; The status of the configuration profile assignment.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Type of the configuration profile assignment processing (Initial/Consistency).
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BestPractice - Definition of the Automanage best practice.
type BestPractice struct {
	// Properties of the best practice.
	Properties *ConfigurationProfileProperties `json:"properties,omitempty"`

	// READ-ONLY; The fully qualified ID for the best practice. For example, /providers/Microsoft.Automanage/bestPractices/azureBestPracticesProduction
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the best practice. For example, azureBestPracticesProduction
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. For example, Microsoft.Automanage/bestPractices
	Type *string `json:"type,omitempty" azure:"ro"`
}

// BestPracticeList - The response of the list best practice operation.
type BestPracticeList struct {
	// Result of the list best practice operation.
	Value []*BestPractice `json:"value,omitempty"`
}

// BestPracticesClientGetOptions contains the optional parameters for the BestPracticesClient.Get method.
type BestPracticesClientGetOptions struct {
	// placeholder for future optional parameters
}

// BestPracticesClientListByTenantOptions contains the optional parameters for the BestPracticesClient.ListByTenant method.
type BestPracticesClientListByTenantOptions struct {
	// placeholder for future optional parameters
}

// BestPracticesVersionsClientGetOptions contains the optional parameters for the BestPracticesVersionsClient.Get method.
type BestPracticesVersionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// BestPracticesVersionsClientListByTenantOptions contains the optional parameters for the BestPracticesVersionsClient.ListByTenant
// method.
type BestPracticesVersionsClientListByTenantOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfile - Definition of the configuration profile.
type ConfigurationProfile struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Properties of the configuration profile.
	Properties *ConfigurationProfileProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConfigurationProfileAssignment - Configuration profile assignment is an association between a VM and automanage profile
// configuration.
type ConfigurationProfileAssignment struct {
	// Properties of the configuration profile assignment.
	Properties *ConfigurationProfileAssignmentProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure resource id. Indicates if this resource is managed by another Azure resource.
	ManagedBy *string `json:"managedBy,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConfigurationProfileAssignmentList - The response of the list configuration profile assignment operation.
type ConfigurationProfileAssignmentList struct {
	// Result of the list configuration profile assignment operation.
	Value []*ConfigurationProfileAssignment `json:"value,omitempty"`
}

// ConfigurationProfileAssignmentProperties - Automanage configuration profile assignment properties.
type ConfigurationProfileAssignmentProperties struct {
	// The Automanage configurationProfile ARM Resource URI.
	ConfigurationProfile *string `json:"configurationProfile,omitempty"`

	// READ-ONLY; The status of onboarding, which only appears in the response.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The target VM resource URI
	TargetID *string `json:"targetId,omitempty" azure:"ro"`
}

// ConfigurationProfileAssignmentsClientCreateOrUpdateOptions contains the optional parameters for the ConfigurationProfileAssignmentsClient.CreateOrUpdate
// method.
type ConfigurationProfileAssignmentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfileAssignmentsClientDeleteOptions contains the optional parameters for the ConfigurationProfileAssignmentsClient.Delete
// method.
type ConfigurationProfileAssignmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfileAssignmentsClientGetOptions contains the optional parameters for the ConfigurationProfileAssignmentsClient.Get
// method.
type ConfigurationProfileAssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfileAssignmentsClientListByClusterNameOptions contains the optional parameters for the ConfigurationProfileAssignmentsClient.ListByClusterName
// method.
type ConfigurationProfileAssignmentsClientListByClusterNameOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfileAssignmentsClientListByMachineNameOptions contains the optional parameters for the ConfigurationProfileAssignmentsClient.ListByMachineName
// method.
type ConfigurationProfileAssignmentsClientListByMachineNameOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfileAssignmentsClientListBySubscriptionOptions contains the optional parameters for the ConfigurationProfileAssignmentsClient.ListBySubscription
// method.
type ConfigurationProfileAssignmentsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfileAssignmentsClientListByVirtualMachinesOptions contains the optional parameters for the ConfigurationProfileAssignmentsClient.ListByVirtualMachines
// method.
type ConfigurationProfileAssignmentsClientListByVirtualMachinesOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfileAssignmentsClientListOptions contains the optional parameters for the ConfigurationProfileAssignmentsClient.List
// method.
type ConfigurationProfileAssignmentsClientListOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfileHCIAssignmentsClientCreateOrUpdateOptions contains the optional parameters for the ConfigurationProfileHCIAssignmentsClient.CreateOrUpdate
// method.
type ConfigurationProfileHCIAssignmentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfileHCIAssignmentsClientDeleteOptions contains the optional parameters for the ConfigurationProfileHCIAssignmentsClient.Delete
// method.
type ConfigurationProfileHCIAssignmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfileHCIAssignmentsClientGetOptions contains the optional parameters for the ConfigurationProfileHCIAssignmentsClient.Get
// method.
type ConfigurationProfileHCIAssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfileHCRPAssignmentsClientCreateOrUpdateOptions contains the optional parameters for the ConfigurationProfileHCRPAssignmentsClient.CreateOrUpdate
// method.
type ConfigurationProfileHCRPAssignmentsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfileHCRPAssignmentsClientDeleteOptions contains the optional parameters for the ConfigurationProfileHCRPAssignmentsClient.Delete
// method.
type ConfigurationProfileHCRPAssignmentsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfileHCRPAssignmentsClientGetOptions contains the optional parameters for the ConfigurationProfileHCRPAssignmentsClient.Get
// method.
type ConfigurationProfileHCRPAssignmentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfileList - The response of the list configuration profile operation.
type ConfigurationProfileList struct {
	// Result of the list ConfigurationProfile operation.
	Value []*ConfigurationProfile `json:"value,omitempty"`
}

// ConfigurationProfileProperties - Automanage configuration profile properties.
type ConfigurationProfileProperties struct {
	// configuration dictionary of the configuration profile.
	Configuration interface{} `json:"configuration,omitempty"`
}

// ConfigurationProfileUpdate - Definition of the configuration profile.
type ConfigurationProfileUpdate struct {
	// Properties of the configuration profile.
	Properties *ConfigurationProfileProperties `json:"properties,omitempty"`

	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ConfigurationProfilesClientCreateOrUpdateOptions contains the optional parameters for the ConfigurationProfilesClient.CreateOrUpdate
// method.
type ConfigurationProfilesClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfilesClientDeleteOptions contains the optional parameters for the ConfigurationProfilesClient.Delete method.
type ConfigurationProfilesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfilesClientGetOptions contains the optional parameters for the ConfigurationProfilesClient.Get method.
type ConfigurationProfilesClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfilesClientListByResourceGroupOptions contains the optional parameters for the ConfigurationProfilesClient.ListByResourceGroup
// method.
type ConfigurationProfilesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfilesClientListBySubscriptionOptions contains the optional parameters for the ConfigurationProfilesClient.ListBySubscription
// method.
type ConfigurationProfilesClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfilesClientUpdateOptions contains the optional parameters for the ConfigurationProfilesClient.Update method.
type ConfigurationProfilesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfilesVersionsClientCreateOrUpdateOptions contains the optional parameters for the ConfigurationProfilesVersionsClient.CreateOrUpdate
// method.
type ConfigurationProfilesVersionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfilesVersionsClientDeleteOptions contains the optional parameters for the ConfigurationProfilesVersionsClient.Delete
// method.
type ConfigurationProfilesVersionsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfilesVersionsClientGetOptions contains the optional parameters for the ConfigurationProfilesVersionsClient.Get
// method.
type ConfigurationProfilesVersionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConfigurationProfilesVersionsClientListChildResourcesOptions contains the optional parameters for the ConfigurationProfilesVersionsClient.ListChildResources
// method.
type ConfigurationProfilesVersionsClientListChildResourcesOptions struct {
	// placeholder for future optional parameters
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// HCIReportsClientGetOptions contains the optional parameters for the HCIReportsClient.Get method.
type HCIReportsClientGetOptions struct {
	// placeholder for future optional parameters
}

// HCIReportsClientListByConfigurationProfileAssignmentsOptions contains the optional parameters for the HCIReportsClient.ListByConfigurationProfileAssignments
// method.
type HCIReportsClientListByConfigurationProfileAssignmentsOptions struct {
	// placeholder for future optional parameters
}

// HCRPReportsClientGetOptions contains the optional parameters for the HCRPReportsClient.Get method.
type HCRPReportsClientGetOptions struct {
	// placeholder for future optional parameters
}

// HCRPReportsClientListByConfigurationProfileAssignmentsOptions contains the optional parameters for the HCRPReportsClient.ListByConfigurationProfileAssignments
// method.
type HCRPReportsClientListByConfigurationProfileAssignmentsOptions struct {
	// placeholder for future optional parameters
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType `json:"actionType,omitempty" azure:"ro"`

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool `json:"isDataAction,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin `json:"origin,omitempty" azure:"ro"`
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Report - Definition of the report.
type Report struct {
	// The properties for the report.
	Properties *AssignmentReportProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReportList - The response of the list report operation.
type ReportList struct {
	// Result of the list report operation.
	Value []*Report `json:"value,omitempty"`
}

// ReportResource - Details about the resource processed by the configuration profile assignment
type ReportResource struct {
	// READ-ONLY; Error message, if any, returned when deploying the resource.
	Error *ErrorDetail `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; ARM id of the resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Status of the resource.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ReportsClientGetOptions contains the optional parameters for the ReportsClient.Get method.
type ReportsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ReportsClientListByConfigurationProfileAssignmentsOptions contains the optional parameters for the ReportsClient.ListByConfigurationProfileAssignments
// method.
type ReportsClientListByConfigurationProfileAssignmentsOptions struct {
	// placeholder for future optional parameters
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServicePrincipal - The Service Principal Id for the subscription.
type ServicePrincipal struct {
	// The Service Principal properties for the subscription
	Properties *ServicePrincipalProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServicePrincipalListResult - The list of ServicePrincipals.
type ServicePrincipalListResult struct {
	// The list of servicePrincipals.
	Value []*ServicePrincipal `json:"value,omitempty"`
}

// ServicePrincipalProperties - The Service Principal properties for the subscription.
type ServicePrincipalProperties struct {
	// READ-ONLY; Returns the contributor RBAC Role exist or not for the Service Principal Id.
	AuthorizationSet *bool `json:"authorizationSet,omitempty" azure:"ro"`

	// READ-ONLY; The Service Principal Id for the subscription.
	ServicePrincipalID *string `json:"servicePrincipalId,omitempty" azure:"ro"`
}

// ServicePrincipalsClientGetOptions contains the optional parameters for the ServicePrincipalsClient.Get method.
type ServicePrincipalsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServicePrincipalsClientListBySubscriptionOptions contains the optional parameters for the ServicePrincipalsClient.ListBySubscription
// method.
type ServicePrincipalsClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// UpdateResource - Represents an update resource
type UpdateResource struct {
	// The tags of the resource.
	Tags map[string]*string `json:"tags,omitempty"`
}
