# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class DeidentificationOperationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum of supported Operation Types."""

    REDACT = "Redact"
    """Redact Operation will remove all entities of PHI and replace them with a placeholder value."""
    SURROGATE = "Surrogate"
    """Surrogation Operation will replace all entities of PHI with a surrogate value."""
    TAG = "Tag"
    """Tag Operation will detect all entities of PHI, their type, and return their locations in the
    document."""
    SURROGATE_ONLY = "SurrogateOnly"
    """SurrogateOnly Operation will replace only specified entities of PHI with surrogate values."""


class OperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum describing allowed operation states."""

    NOT_STARTED = "NotStarted"
    """The operation has not started."""
    RUNNING = "Running"
    """The operation is in progress."""
    SUCCEEDED = "Succeeded"
    """The operation has completed successfully."""
    FAILED = "Failed"
    """The operation has failed."""
    CANCELED = "Canceled"
    """The operation has been canceled by the user."""


class PhiCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """List of PHI Entities."""

    UNKNOWN = "Unknown"
    """Unknown PHI Type."""
    ACCOUNT = "Account"
    """Account Number."""
    AGE = "Age"
    """Age."""
    BIO_ID = "BioID"
    """Biological Identifier, such as a fingerprint or retinal scan."""
    CITY = "City"
    """City."""
    COUNTRY_OR_REGION = "CountryOrRegion"
    """Country or Region."""
    DATE = "Date"
    """Date."""
    DEVICE = "Device"
    """Device ID or serial numbers."""
    DOCTOR = "Doctor"
    """Doctor's Name."""
    EMAIL = "Email"
    """Email Addresses."""
    FAX = "Fax"
    """Fax Number."""
    HEALTH_PLAN = "HealthPlan"
    """Health Plan ID Numbers."""
    HOSPITAL = "Hospital"
    """Hospital Name."""
    ID_NUM = "IDNum"
    """Id Number, eg. passport number."""
    IP_ADDRESS = "IPAddress"
    """IP Address."""
    LICENSE = "License"
    """License, eg. Driver's license or medical license."""
    LOCATION_OTHER = "LocationOther"
    """Location Other, eg. Golden Gate Park."""
    MEDICAL_RECORD = "MedicalRecord"
    """Medical Record Number."""
    ORGANIZATION = "Organization"
    """Organization, eg. Microsoft."""
    PATIENT = "Patient"
    """Patient Name."""
    PHONE = "Phone"
    """Phone Number."""
    PROFESSION = "Profession"
    """Profession."""
    SOCIAL_SECURITY = "SocialSecurity"
    """Social Security Number."""
    STATE = "State"
    """State."""
    STREET = "Street"
    """Street."""
    URL = "Url"
    """Web URL."""
    USERNAME = "Username"
    """Usernames, eg. a social media handle."""
    VEHICLE = "Vehicle"
    """Vehicle IDs, eg. license plate or VIN number."""
    ZIP = "Zip"
    """Zip Code."""


class TextEncodingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Encoding type for text offset and length calculations."""

    UTF8 = "Utf8"
    """UTF-8 encoding."""
    UTF16 = "Utf16"
    """UTF-16 encoding. Primary encoding used by .NET, Java, and JavaScript."""
    CODE_POINT = "CodePoint"
    """CodePoint encoding. Primary encoding used by Python."""
