# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.billing.aio import BillingManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestBillingManagementBillingRoleAssignmentsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(BillingManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delete_by_billing_profile(self, resource_group):
        response = await self.client.billing_role_assignments.delete_by_billing_profile(
            billing_account_name="str",
            billing_profile_name="str",
            billing_role_assignment_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_billing_profile(self, resource_group):
        response = await self.client.billing_role_assignments.get_by_billing_profile(
            billing_account_name="str",
            billing_profile_name="str",
            billing_role_assignment_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_billing_profile(self, resource_group):
        response = self.client.billing_role_assignments.list_by_billing_profile(
            billing_account_name="str",
            billing_profile_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_by_billing_profile(self, resource_group):
        response = await (
            await self.client.billing_role_assignments.begin_create_by_billing_profile(
                billing_account_name="str",
                billing_profile_name="str",
                parameters={
                    "roleDefinitionId": "str",
                    "billingAccountDisplayName": "str",
                    "billingAccountId": "str",
                    "billingProfileDisplayName": "str",
                    "billingProfileId": "str",
                    "billingRequestId": "str",
                    "createdByPrincipalId": "str",
                    "createdByPrincipalPuid": "str",
                    "createdByPrincipalTenantId": "str",
                    "createdByUserEmailAddress": "str",
                    "createdOn": "2020-02-20 00:00:00",
                    "customerDisplayName": "str",
                    "customerId": "str",
                    "invoiceSectionDisplayName": "str",
                    "invoiceSectionId": "str",
                    "modifiedByPrincipalId": "str",
                    "modifiedByPrincipalPuid": "str",
                    "modifiedByPrincipalTenantId": "str",
                    "modifiedByUserEmailAddress": "str",
                    "modifiedOn": "2020-02-20 00:00:00",
                    "principalDisplayName": "str",
                    "principalId": "str",
                    "principalPuid": "str",
                    "principalTenantId": "str",
                    "principalTenantName": "str",
                    "principalType": "str",
                    "provisioningState": "str",
                    "scope": "str",
                    "userAuthenticationType": "str",
                    "userEmailAddress": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delete_by_customer(self, resource_group):
        response = await self.client.billing_role_assignments.delete_by_customer(
            billing_account_name="str",
            billing_profile_name="str",
            customer_name="str",
            billing_role_assignment_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_customer(self, resource_group):
        response = await self.client.billing_role_assignments.get_by_customer(
            billing_account_name="str",
            billing_profile_name="str",
            customer_name="str",
            billing_role_assignment_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_customer(self, resource_group):
        response = self.client.billing_role_assignments.list_by_customer(
            billing_account_name="str",
            billing_profile_name="str",
            customer_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_by_customer(self, resource_group):
        response = await (
            await self.client.billing_role_assignments.begin_create_by_customer(
                billing_account_name="str",
                billing_profile_name="str",
                customer_name="str",
                parameters={
                    "roleDefinitionId": "str",
                    "billingAccountDisplayName": "str",
                    "billingAccountId": "str",
                    "billingProfileDisplayName": "str",
                    "billingProfileId": "str",
                    "billingRequestId": "str",
                    "createdByPrincipalId": "str",
                    "createdByPrincipalPuid": "str",
                    "createdByPrincipalTenantId": "str",
                    "createdByUserEmailAddress": "str",
                    "createdOn": "2020-02-20 00:00:00",
                    "customerDisplayName": "str",
                    "customerId": "str",
                    "invoiceSectionDisplayName": "str",
                    "invoiceSectionId": "str",
                    "modifiedByPrincipalId": "str",
                    "modifiedByPrincipalPuid": "str",
                    "modifiedByPrincipalTenantId": "str",
                    "modifiedByUserEmailAddress": "str",
                    "modifiedOn": "2020-02-20 00:00:00",
                    "principalDisplayName": "str",
                    "principalId": "str",
                    "principalPuid": "str",
                    "principalTenantId": "str",
                    "principalTenantName": "str",
                    "principalType": "str",
                    "provisioningState": "str",
                    "scope": "str",
                    "userAuthenticationType": "str",
                    "userEmailAddress": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_resolve_by_customer(self, resource_group):
        response = await (
            await self.client.billing_role_assignments.begin_resolve_by_customer(
                billing_account_name="str",
                billing_profile_name="str",
                customer_name="str",
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delete_by_invoice_section(self, resource_group):
        response = await self.client.billing_role_assignments.delete_by_invoice_section(
            billing_account_name="str",
            billing_profile_name="str",
            invoice_section_name="str",
            billing_role_assignment_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_invoice_section(self, resource_group):
        response = await self.client.billing_role_assignments.get_by_invoice_section(
            billing_account_name="str",
            billing_profile_name="str",
            invoice_section_name="str",
            billing_role_assignment_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_invoice_section(self, resource_group):
        response = self.client.billing_role_assignments.list_by_invoice_section(
            billing_account_name="str",
            billing_profile_name="str",
            invoice_section_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_by_invoice_section(self, resource_group):
        response = await (
            await self.client.billing_role_assignments.begin_create_by_invoice_section(
                billing_account_name="str",
                billing_profile_name="str",
                invoice_section_name="str",
                parameters={
                    "roleDefinitionId": "str",
                    "billingAccountDisplayName": "str",
                    "billingAccountId": "str",
                    "billingProfileDisplayName": "str",
                    "billingProfileId": "str",
                    "billingRequestId": "str",
                    "createdByPrincipalId": "str",
                    "createdByPrincipalPuid": "str",
                    "createdByPrincipalTenantId": "str",
                    "createdByUserEmailAddress": "str",
                    "createdOn": "2020-02-20 00:00:00",
                    "customerDisplayName": "str",
                    "customerId": "str",
                    "invoiceSectionDisplayName": "str",
                    "invoiceSectionId": "str",
                    "modifiedByPrincipalId": "str",
                    "modifiedByPrincipalPuid": "str",
                    "modifiedByPrincipalTenantId": "str",
                    "modifiedByUserEmailAddress": "str",
                    "modifiedOn": "2020-02-20 00:00:00",
                    "principalDisplayName": "str",
                    "principalId": "str",
                    "principalPuid": "str",
                    "principalTenantId": "str",
                    "principalTenantName": "str",
                    "principalType": "str",
                    "provisioningState": "str",
                    "scope": "str",
                    "userAuthenticationType": "str",
                    "userEmailAddress": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_resolve_by_invoice_section(self, resource_group):
        response = await (
            await self.client.billing_role_assignments.begin_resolve_by_invoice_section(
                billing_account_name="str",
                billing_profile_name="str",
                invoice_section_name="str",
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_resolve_by_billing_profile(self, resource_group):
        response = await (
            await self.client.billing_role_assignments.begin_resolve_by_billing_profile(
                billing_account_name="str",
                billing_profile_name="str",
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delete_by_billing_account(self, resource_group):
        response = await self.client.billing_role_assignments.delete_by_billing_account(
            billing_account_name="str",
            billing_role_assignment_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_billing_account(self, resource_group):
        response = await self.client.billing_role_assignments.get_by_billing_account(
            billing_account_name="str",
            billing_role_assignment_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update_by_billing_account(self, resource_group):
        response = await (
            await self.client.billing_role_assignments.begin_create_or_update_by_billing_account(
                billing_account_name="str",
                billing_role_assignment_name="str",
                parameters={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "roleDefinitionId": "str",
                        "billingAccountDisplayName": "str",
                        "billingAccountId": "str",
                        "billingProfileDisplayName": "str",
                        "billingProfileId": "str",
                        "billingRequestId": "str",
                        "createdByPrincipalId": "str",
                        "createdByPrincipalPuid": "str",
                        "createdByPrincipalTenantId": "str",
                        "createdByUserEmailAddress": "str",
                        "createdOn": "2020-02-20 00:00:00",
                        "customerDisplayName": "str",
                        "customerId": "str",
                        "invoiceSectionDisplayName": "str",
                        "invoiceSectionId": "str",
                        "modifiedByPrincipalId": "str",
                        "modifiedByPrincipalPuid": "str",
                        "modifiedByPrincipalTenantId": "str",
                        "modifiedByUserEmailAddress": "str",
                        "modifiedOn": "2020-02-20 00:00:00",
                        "principalDisplayName": "str",
                        "principalId": "str",
                        "principalPuid": "str",
                        "principalTenantId": "str",
                        "principalTenantName": "str",
                        "principalType": "str",
                        "provisioningState": "str",
                        "scope": "str",
                        "userAuthenticationType": "str",
                        "userEmailAddress": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_billing_account(self, resource_group):
        response = self.client.billing_role_assignments.list_by_billing_account(
            billing_account_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_by_billing_account(self, resource_group):
        response = await (
            await self.client.billing_role_assignments.begin_create_by_billing_account(
                billing_account_name="str",
                parameters={
                    "roleDefinitionId": "str",
                    "billingAccountDisplayName": "str",
                    "billingAccountId": "str",
                    "billingProfileDisplayName": "str",
                    "billingProfileId": "str",
                    "billingRequestId": "str",
                    "createdByPrincipalId": "str",
                    "createdByPrincipalPuid": "str",
                    "createdByPrincipalTenantId": "str",
                    "createdByUserEmailAddress": "str",
                    "createdOn": "2020-02-20 00:00:00",
                    "customerDisplayName": "str",
                    "customerId": "str",
                    "invoiceSectionDisplayName": "str",
                    "invoiceSectionId": "str",
                    "modifiedByPrincipalId": "str",
                    "modifiedByPrincipalPuid": "str",
                    "modifiedByPrincipalTenantId": "str",
                    "modifiedByUserEmailAddress": "str",
                    "modifiedOn": "2020-02-20 00:00:00",
                    "principalDisplayName": "str",
                    "principalId": "str",
                    "principalPuid": "str",
                    "principalTenantId": "str",
                    "principalTenantName": "str",
                    "principalType": "str",
                    "provisioningState": "str",
                    "scope": "str",
                    "userAuthenticationType": "str",
                    "userEmailAddress": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delete_by_department(self, resource_group):
        response = await self.client.billing_role_assignments.delete_by_department(
            billing_account_name="str",
            department_name="str",
            billing_role_assignment_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_department(self, resource_group):
        response = await self.client.billing_role_assignments.get_by_department(
            billing_account_name="str",
            department_name="str",
            billing_role_assignment_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update_by_department(self, resource_group):
        response = await (
            await self.client.billing_role_assignments.begin_create_or_update_by_department(
                billing_account_name="str",
                department_name="str",
                billing_role_assignment_name="str",
                parameters={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "roleDefinitionId": "str",
                        "billingAccountDisplayName": "str",
                        "billingAccountId": "str",
                        "billingProfileDisplayName": "str",
                        "billingProfileId": "str",
                        "billingRequestId": "str",
                        "createdByPrincipalId": "str",
                        "createdByPrincipalPuid": "str",
                        "createdByPrincipalTenantId": "str",
                        "createdByUserEmailAddress": "str",
                        "createdOn": "2020-02-20 00:00:00",
                        "customerDisplayName": "str",
                        "customerId": "str",
                        "invoiceSectionDisplayName": "str",
                        "invoiceSectionId": "str",
                        "modifiedByPrincipalId": "str",
                        "modifiedByPrincipalPuid": "str",
                        "modifiedByPrincipalTenantId": "str",
                        "modifiedByUserEmailAddress": "str",
                        "modifiedOn": "2020-02-20 00:00:00",
                        "principalDisplayName": "str",
                        "principalId": "str",
                        "principalPuid": "str",
                        "principalTenantId": "str",
                        "principalTenantName": "str",
                        "principalType": "str",
                        "provisioningState": "str",
                        "scope": "str",
                        "userAuthenticationType": "str",
                        "userEmailAddress": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_department(self, resource_group):
        response = self.client.billing_role_assignments.list_by_department(
            billing_account_name="str",
            department_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delete_by_enrollment_account(self, resource_group):
        response = await self.client.billing_role_assignments.delete_by_enrollment_account(
            billing_account_name="str",
            enrollment_account_name="str",
            billing_role_assignment_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_by_enrollment_account(self, resource_group):
        response = await self.client.billing_role_assignments.get_by_enrollment_account(
            billing_account_name="str",
            enrollment_account_name="str",
            billing_role_assignment_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update_by_enrollment_account(self, resource_group):
        response = await (
            await self.client.billing_role_assignments.begin_create_or_update_by_enrollment_account(
                billing_account_name="str",
                enrollment_account_name="str",
                billing_role_assignment_name="str",
                parameters={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "roleDefinitionId": "str",
                        "billingAccountDisplayName": "str",
                        "billingAccountId": "str",
                        "billingProfileDisplayName": "str",
                        "billingProfileId": "str",
                        "billingRequestId": "str",
                        "createdByPrincipalId": "str",
                        "createdByPrincipalPuid": "str",
                        "createdByPrincipalTenantId": "str",
                        "createdByUserEmailAddress": "str",
                        "createdOn": "2020-02-20 00:00:00",
                        "customerDisplayName": "str",
                        "customerId": "str",
                        "invoiceSectionDisplayName": "str",
                        "invoiceSectionId": "str",
                        "modifiedByPrincipalId": "str",
                        "modifiedByPrincipalPuid": "str",
                        "modifiedByPrincipalTenantId": "str",
                        "modifiedByUserEmailAddress": "str",
                        "modifiedOn": "2020-02-20 00:00:00",
                        "principalDisplayName": "str",
                        "principalId": "str",
                        "principalPuid": "str",
                        "principalTenantId": "str",
                        "principalTenantName": "str",
                        "principalType": "str",
                        "provisioningState": "str",
                        "scope": "str",
                        "userAuthenticationType": "str",
                        "userEmailAddress": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_enrollment_account(self, resource_group):
        response = self.client.billing_role_assignments.list_by_enrollment_account(
            billing_account_name="str",
            enrollment_account_name="str",
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_resolve_by_billing_account(self, resource_group):
        response = await (
            await self.client.billing_role_assignments.begin_resolve_by_billing_account(
                billing_account_name="str",
                api_version="2024-04-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
