// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file aliasesCdrAux.hpp
 * This source file contains some definitions of CDR related functions.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__ALIASESCDRAUX_HPP
#define FAST_DDS_GENERATED__ALIASESCDRAUX_HPP

#include "aliases.hpp"
constexpr uint32_t AliasMap_max_cdr_typesize {8UL};
constexpr uint32_t AliasMap_max_key_cdr_typesize {0UL};



constexpr uint32_t AliasInt64_max_cdr_typesize {16UL};
constexpr uint32_t AliasInt64_max_key_cdr_typesize {0UL};


constexpr uint32_t AliasFloat128_max_cdr_typesize {24UL};
constexpr uint32_t AliasFloat128_max_key_cdr_typesize {0UL};

constexpr uint32_t AliasInt16_max_cdr_typesize {6UL};
constexpr uint32_t AliasInt16_max_key_cdr_typesize {0UL};


constexpr uint32_t AliasEnum_max_cdr_typesize {8UL};
constexpr uint32_t AliasEnum_max_key_cdr_typesize {0UL};



constexpr uint32_t AliasFloat64_max_cdr_typesize {16UL};
constexpr uint32_t AliasFloat64_max_key_cdr_typesize {0UL};

constexpr uint32_t AliasOctet_max_cdr_typesize {5UL};
constexpr uint32_t AliasOctet_max_key_cdr_typesize {0UL};

constexpr uint32_t AliasAlias_max_cdr_typesize {8UL};
constexpr uint32_t AliasAlias_max_key_cdr_typesize {0UL};


constexpr uint32_t AliasArray_max_cdr_typesize {8UL};
constexpr uint32_t AliasArray_max_key_cdr_typesize {0UL};

constexpr uint32_t AliasUint16_max_cdr_typesize {6UL};
constexpr uint32_t AliasUint16_max_key_cdr_typesize {0UL};

constexpr uint32_t AliasString16_max_cdr_typesize {518UL};
constexpr uint32_t AliasString16_max_key_cdr_typesize {0UL};



constexpr uint32_t AliasInt32_max_cdr_typesize {8UL};
constexpr uint32_t AliasInt32_max_key_cdr_typesize {0UL};


constexpr uint32_t AliasString8_max_cdr_typesize {264UL};
constexpr uint32_t AliasString8_max_key_cdr_typesize {0UL};



constexpr uint32_t AliasStruct_max_cdr_typesize {16UL};
constexpr uint32_t AliasStruct_max_key_cdr_typesize {0UL};









constexpr uint32_t AliasFloat32_max_cdr_typesize {8UL};
constexpr uint32_t AliasFloat32_max_key_cdr_typesize {0UL};


constexpr uint32_t AliasBitmask_max_cdr_typesize {8UL};
constexpr uint32_t AliasBitmask_max_key_cdr_typesize {0UL};

constexpr uint32_t AliasUnion_max_cdr_typesize {16UL};
constexpr uint32_t AliasUnion_max_key_cdr_typesize {0UL};

constexpr uint32_t AliasMultiArray_max_cdr_typesize {12UL};
constexpr uint32_t AliasMultiArray_max_key_cdr_typesize {0UL};

constexpr uint32_t AliasUInt32_max_cdr_typesize {8UL};
constexpr uint32_t AliasUInt32_max_key_cdr_typesize {0UL};

constexpr uint32_t AliasChar16_max_cdr_typesize {6UL};
constexpr uint32_t AliasChar16_max_key_cdr_typesize {0UL};






constexpr uint32_t AliasChar8_max_cdr_typesize {5UL};
constexpr uint32_t AliasChar8_max_key_cdr_typesize {0UL};

constexpr uint32_t AliasUInt64_max_cdr_typesize {16UL};
constexpr uint32_t AliasUInt64_max_key_cdr_typesize {0UL};




constexpr uint32_t AliasSequence_max_cdr_typesize {8UL};
constexpr uint32_t AliasSequence_max_key_cdr_typesize {0UL};







constexpr uint32_t AliasBool_max_cdr_typesize {5UL};
constexpr uint32_t AliasBool_max_key_cdr_typesize {0UL};


constexpr uint32_t AliasBitset_max_cdr_typesize {16UL};
constexpr uint32_t AliasBitset_max_key_cdr_typesize {0UL};



namespace eprosima {
namespace fastcdr {

class Cdr;
class CdrSizeCalculator;

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasInt16& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasUint16& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasInt32& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasUInt32& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasInt64& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasUInt64& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasFloat32& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasFloat64& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasFloat128& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasBool& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasOctet& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasChar8& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasChar16& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasString8& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasString16& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasEnum& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasBitmask& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasAlias& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasArray& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasMultiArray& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasSequence& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasMap& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasUnion& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasStruct& data);

eProsima_user_DllExport void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const AliasBitset& data);


} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__ALIASESCDRAUX_HPP

