---
myst:
  html_meta:
    keywords: LaTeX, programmation, syntaxe
---

# Comment rendre inactif un caractère ?

La commande `\string` permet de rendre inactif le caractère qui la suit. 
Plus précisément, si le caractère qui la suit est un caractère "actif" 
(comme `_` ou `^`), `\string` affiche ce caractère sans l'interpréter, 
sauf si c'est une contre-oblique, auquel cas elle affiche le nom complet 
de la commande qui la suit. La nuance n'a pas d'importance dans le cas 
de `\string\LaTeX` par exemple, mais est un peu plus sensible dans le cas 
de `\string\}`.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\LaTeX{} peut autoriser l'écriture de la chaine de caractère
\string\LaTeX. N'est-ce pas tout simplement 
\string_incroyable\string_ ?
\end{document}
```