// Code generated by smithy-go-codegen DO NOT EDIT.

package inspector2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/inspector2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a CIS scan list.
func (c *Client) ListCisScans(ctx context.Context, params *ListCisScansInput, optFns ...func(*Options)) (*ListCisScansOutput, error) {
	if params == nil {
		params = &ListCisScansInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCisScans", params, optFns, c.addOperationListCisScansMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCisScansOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCisScansInput struct {

	// The detail applied to the CIS scan.
	DetailLevel types.ListCisScansDetailLevel

	// The CIS scan filter criteria.
	FilterCriteria *types.ListCisScansFilterCriteria

	// The maximum number of results to be returned.
	MaxResults *int32

	// The pagination token from a previous request that's used to retrieve the next
	// page of results.
	NextToken *string

	// The CIS scans sort by order.
	SortBy types.ListCisScansSortBy

	// The CIS scans sort order.
	SortOrder types.CisSortOrder

	noSmithyDocumentSerde
}

type ListCisScansOutput struct {

	// The pagination token from a previous request that's used to retrieve the next
	// page of results.
	NextToken *string

	// The CIS scans.
	Scans []types.CisScan

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCisScansMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCisScans{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCisScans{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCisScans"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListCisScansValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCisScans(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCisScansPaginatorOptions is the paginator options for ListCisScans
type ListCisScansPaginatorOptions struct {
	// The maximum number of results to be returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCisScansPaginator is a paginator for ListCisScans
type ListCisScansPaginator struct {
	options   ListCisScansPaginatorOptions
	client    ListCisScansAPIClient
	params    *ListCisScansInput
	nextToken *string
	firstPage bool
}

// NewListCisScansPaginator returns a new ListCisScansPaginator
func NewListCisScansPaginator(client ListCisScansAPIClient, params *ListCisScansInput, optFns ...func(*ListCisScansPaginatorOptions)) *ListCisScansPaginator {
	if params == nil {
		params = &ListCisScansInput{}
	}

	options := ListCisScansPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCisScansPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCisScansPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCisScans page.
func (p *ListCisScansPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCisScansOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCisScans(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCisScansAPIClient is a client that implements the ListCisScans operation.
type ListCisScansAPIClient interface {
	ListCisScans(context.Context, *ListCisScansInput, ...func(*Options)) (*ListCisScansOutput, error)
}

var _ ListCisScansAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCisScans(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCisScans",
	}
}
