# frozen_string_literal: true

require_relative 'test_helper'

class ConstantsTest < Minitest::Test
  def test_compression_methods
    assert_equal(0, Zip::COMPRESSION_METHOD_STORE)
    assert_equal(1, Zip::COMPRESSION_METHOD_SHRINK)
    assert_equal(2, Zip::COMPRESSION_METHOD_REDUCE_1)
    assert_equal(3, Zip::COMPRESSION_METHOD_REDUCE_2)
    assert_equal(4, Zip::COMPRESSION_METHOD_REDUCE_3)
    assert_equal(5, Zip::COMPRESSION_METHOD_REDUCE_4)
    assert_equal(6, Zip::COMPRESSION_METHOD_IMPLODE)
    assert_equal(8, Zip::COMPRESSION_METHOD_DEFLATE)
    assert_equal(9, Zip::COMPRESSION_METHOD_DEFLATE_64)
    assert_equal(10, Zip::COMPRESSION_METHOD_PKWARE_DCLI)
    assert_equal(12, Zip::COMPRESSION_METHOD_BZIP2)
    assert_equal(14, Zip::COMPRESSION_METHOD_LZMA)
    assert_equal(16, Zip::COMPRESSION_METHOD_IBM_CMPSC)
    assert_equal(18, Zip::COMPRESSION_METHOD_IBM_TERSE)
    assert_equal(19, Zip::COMPRESSION_METHOD_IBM_LZ77)
    assert_equal(96, Zip::COMPRESSION_METHOD_JPEG)
    assert_equal(97, Zip::COMPRESSION_METHOD_WAVPACK)
    assert_equal(98, Zip::COMPRESSION_METHOD_PPMD)
    assert_equal(99, Zip::COMPRESSION_METHOD_AES)

    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_STORE])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_SHRINK])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_REDUCE_1])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_REDUCE_2])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_REDUCE_3])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_REDUCE_4])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_IMPLODE])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_DEFLATE])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_DEFLATE_64])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_PKWARE_DCLI])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_BZIP2])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_LZMA])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_IBM_CMPSC])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_IBM_TERSE])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_IBM_LZ77])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_JPEG])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_WAVPACK])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_PPMD])
    assert(Zip::COMPRESSION_METHODS[Zip::COMPRESSION_METHOD_AES])
  end
end
