"""Asynchronous client for the Open-Meteo API."""

from .exceptions import OpenMeteoConnectionError, OpenMeteoError
from .models import (
    AirQuality,
    AirQualityParameters,
    CurrentAirQuality,
    CurrentAirQualityUnits,
    CurrentWeather,
    DailyForecast,
    DailyForecastUnits,
    DailyParameters,
    Forecast,
    Geocoding,
    GeocodingResult,
    HourlyAirQuality,
    HourlyAirQualityUnits,
    HourlyForecast,
    HourlyForecastUnits,
    HourlyParameters,
    PrecipitationUnit,
    TemperatureUnit,
    TimeFormat,
    WindSpeedUnit,
)
from .open_meteo import OpenMeteo

__all__ = [
    "AirQuality",
    "AirQualityParameters",
    "CurrentAirQuality",
    "CurrentAirQualityUnits",
    "CurrentWeather",
    "DailyForecast",
    "DailyForecastUnits",
    "DailyParameters",
    "Forecast",
    "Geocoding",
    "GeocodingResult",
    "HourlyAirQuality",
    "HourlyAirQualityUnits",
    "HourlyForecast",
    "HourlyForecastUnits",
    "HourlyParameters",
    "OpenMeteo",
    "OpenMeteoConnectionError",
    "OpenMeteoError",
    "PrecipitationUnit",
    "TemperatureUnit",
    "TimeFormat",
    "WindSpeedUnit",
]
