'\" t
.\" Manual page created with latex2man on Wed Aug 16 11:09:44 PDT 2017
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_REG\\_STATES\\_ITERATE" "3" "16 August 2017" "Programming Library " "Programming Library "
.SH NAME
unw_reg_states_iterate
\-\- get register state info on current procedure 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_reg_states_iterate(unw_cursor_t *cp,
unw_reg_states_callbackcb,
void *token);
.br
.PP
.SH DESCRIPTION

.PP
The unw_reg_states_iterate()
routine provides 
information about the procedure that created the stack frame 
identified by argument cp\&.
The cb
argument is a pointer 
to a function of type unw_reg_states_callback
which is used to 
return the information. The function unw_reg_states_callback
has the 
following definition: 
.PP
int
( *unw_reg_states_callback)(void *token,
void *reg_states_data,
size_t
reg_states_data_size,
unw_word_t
start_ip,
unw_word_t
end_ip);
.PP
The callback function may be invoked several times for each call of unw_reg_states_iterate\&.
Each call is associcated with a instruction address range and a set of instructions on how to update register values when returning from the procedure in that address range. For each invocation, the arguments to the callback function are: 
.TP
void * token
 The token value passed to unw_reg_states_callback\&.
.br
.TP
void * reg_states_data
 A pointer to data about 
updating register values. This data, or a copy of it, can be passed 
to unw_apply_reg_state\&.
.br
.TP
int reg_states_data_size
 The size of the register update data. 
.br
.TP
unw_word_t start_ip
 The address of the first 
instruction of the address range. 
.br
.TP
unw_word_t end_ip
 The address of the first 
instruction \fIbeyond\fP
the end of the address range. 
.br
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_reg_states_iterate()
returns 
0. If the callback function returns a nonzero value, that indicates 
failure and the function returns immediately. Otherwise the negative 
value of one of the error\-codes below is returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_reg_states_iterate()
is thread\-safe. If cursor cp
is 
in the local address\-space, this routine is also safe to use from a 
signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_EUNSPEC
 An unspecified error occurred. 
.TP
UNW_ENOINFO
 Libunwind
was unable to locate 
unwind\-info for the procedure. 
.TP
UNW_EBADVERSION
 The unwind\-info for the procedure has 
version or format that is not understood by libunwind\&.
.PP
In addition, unw_reg_states_iterate()
may return any error 
returned by the access_mem()
call\-back (see 
unw_create_addr_space(3)).
.PP
.SH SEE ALSO

.PP
libunwind(3),
unw_apply_reg_state(3)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br
Email: \fBdmosberger@gmail.com\fP
.br
WWW: \fBhttp://www.nongnu.org/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
