# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict, Union, Optional
from typing_extensions import Literal, Required, TypeAlias, TypedDict

from .beta_direct_caller_param import BetaDirectCallerParam
from .beta_server_tool_caller_param import BetaServerToolCallerParam
from .beta_cache_control_ephemeral_param import BetaCacheControlEphemeralParam

__all__ = ["BetaToolUseBlockParam", "Caller"]

Caller: TypeAlias = Union[BetaDirectCallerParam, BetaServerToolCallerParam]


class BetaToolUseBlockParam(TypedDict, total=False):
    id: Required[str]

    input: Required[Dict[str, object]]

    name: Required[str]

    type: Required[Literal["tool_use"]]

    cache_control: Optional[BetaCacheControlEphemeralParam]
    """Create a cache control breakpoint at this content block."""

    caller: Caller
    """Tool invocation directly from the model."""
