NQC FAQ
=======

[General](#general-1)
-------
* What is NQC?
* What is LEGO MINDSTORMS?
* Does NQC support RIS 2.0?
* How can I get the RCX 2.0 firmware?

[NQC Program Download Errors](#nqc-program-download-errors-1)
---------------------------
* "No reply from rcx2" message when using NQC directly
* "Compile Failed no (or invalid) reply from RCX" message in BricxCC

[NQC Compiler Usage](#nqc-compiler-usage-1)
------------------
* I'm using Windows, and when I click on NQC a window with some text flashes on the screen then disappears. What's going on?
* I'm using the RCX 2.0 firmware but get errors when trying to call 2.0 functions (e.g. SetUserDisplay). What's wrong?
* How can I redirect errors to a file?
* Where is Spirit.ocx? RcxCC complains that it is not installed.

[IR Communication](#ir-communication-1)
----------------
* How do I get NQC to work with my USB IR tower?
* How do I use a computer to control the RCX?
* How do I use the IR tower with a USB Macintosh?
* Help, RcxCC/MacNQC/NQC can't communicate with my RCX!
* How do I use my computer IR port with the RCX?
* How can I get the USB IR tower to work under Win XP?

[Miscellaneous](#miscellaneous-1)
-------------
* Why doesn't NQC use the Spirit OCX?
* Does NQC support Vision Command?
* What computers/tools/etc do you use to develop NQC?

&nbsp;

Answers
=======

General
-------

### What is NQC?
NQC (Not Quite C) is a programming language for several LEGO MINDSTORMS products including the RCX, CyberMaster, and Scout. NQC's syntax is very similar to the C programming langauge, so experienced C programmers (and Java programmers) should find it very easy to get started with. Even if you aren't an experienced programmer, NQC is relatively easy to learn.

The two primary reasons people move up to NQC from the standard tools (RCX Code and Robolab) is that NQC is a textual langauge, and it is more powerful. Graphical languages are often easier to learn (no syntax errors!) but are generally more tedious to use than a textual langauge. The graphical metaphors of RCX Code (and to a certain extent Robolab) also significantly limit the types of programs you can write.

NQC uses the same firmware as LEGO's standard tools (RCX Code and Robolab). This means it is possible to have RCX Code, Robolab, and NQC programs loaded onto the RCX at the same time. NQC also benefits from the stability and user interface (e.g. the View button) provided by the standard firmware. On the minus side, NQC must live within the constraints of the standard firmware. For example, since the firmware does not provide floating point support, NQC cannot provide it either. Other altermatives for programming the RCX (notably legOS and pbForth) do not have such restrictions.

### What is LEGO MINDSTORMS?
LEGO MINDSTORMS is a series of LEGO sets that use special programmable bricks to allow construction of robots. The most versatile programmable brick is the RCX, which can be found in the Robotics Invention System set. A simpler brick, the Scout, can be found in the Robotics Discovery set. The simplest brick, Micro Scout, is featured in two sets with a Star Wars theme: Droid Developer Kit, and Dark Side Developer Kit. Even though it is the most expensive, the RCX based set is still the best value due to the versatility of the RCX itself. The Scout is a bit more limited, but still can be programmed (using NQC) to do some interesting things. The Micro-Scout is extremely limited, and it useful mainly as an accessory to another programmable brick such as the RCX or Scout. Further information on MINDSTORMS sets can be found at the official site: www.legomindstorms.com.

### Does NQC Support RIS 2.0?
The RCX in the RIS 2.0 is nearly identical to the 1.0 RCX. However, new firmware is used to give the RCX some new capabilities. Fortunately for existing RCX owners, this firmware is available for download from www.legomindstorms.com (as part of the RIS 2.0 SDK). NQC supports this new firmware (see here for more info).

RIS 2.0 also uses a new IR tower with a USB connection (instead of the eariler RS-232 based towers). Support for the USB tower under Windows and Mac OS X is currently in beta test. Support for Mac OS 9 will be added shortly and several other people are working on Linux support.

### How can I get the RCX 2.0 firmware?
The RCX 2.0 firmware is contained in a file named FIRM0328.LGO and is installed on your PC when you install the standard LEGO software. It is also installed as part of the Vision Command software and the 2.0 SDK.

Unfortunately, all previously mentioned sources for the firmware require software to be installed on a Windows computer. If you are using a different operating system, then you will need to download the earlier Beta version of the 2.0 SDK which was packaged as a .zip file rather than a full installer. This .zip file may then be expanded to get the FIRM0328.LGO file. The SDK 2.0 Beta can be found at http://mindstorms.lego.com/sdk2beta/default.asp.


NQC Program Download Errors
---------------------------

### "no (or invalid) reply" messages
When downloading a program in BricxCC or by using the NQC command-line compiler directly some users report that they get an error message saying that the reply from the brick was not received or that it was invalid. When using NQC directly the error is something like: "No reply from rcx2". From within BricxCC the error is something like: "Compile Failed no (or invalid) reply from RCX". These errors are caused by a problem with the LEGO USB Tower driver. Fixing it is very easy.

1. Open the LEGO USB Tower control panel applet in the Control Panel. The icon looks like the USB tower.
2. On the Advanced tab change the timeout values slightly and then click the Apply button at the bottom of the dialog.
3. Now change the values back to their original settings (200, 200, 100).
4. Close the applet window via the OK button.

Now you should no longer experience the "no reply" error when using NQC with the USB tower.


NQC Compiler Usage
------------------

### I'm using Windows, and when I click on NQC a window with some text flashes on the screen then disappears. What's going on?
NQC is a command line based tool - normally you run it by typing an appropriate command into an MS-DOS window. When you double-click the exe file it launches an MS-DOS console, runs NQC within it, then since NQC finishes almost immediately, the entire window disappears.

Some people prefer command line based tools because they allow you to use the text editor of your choice, etc. It also makes for identical behavior under Windows, Mac, and Linux. In order to use the command line version of NQC you'll need to do two things:

1. Use some sort of text editor (such as Notepad) to edit and save a source file for NQC to compile.
2. From an MS-DOS window type the appropriate NQC command. Its usually best to either put all of your programs and nqc.exe in the same directory, or make sure the directory containing NQC is in your command path. For example, to compile and download the program "test.nqc" using the default serial port you would type the following command:

```
nqc -d test.nqc
```

An alternative is to use the [RCX Command Center](http://www.cs.uu.nl/~markov/lego/) by Mark Overmars, which is a familiar Windows style application that provides a front end to the NQC compiler.

### I'm using the RCX 2.0 firmware but get errors when trying to call 2.0 functions (e.g. SetUserDisplay). What's wrong?
When NQC compiles a program it needs to know what kind of programmable brick you want it to generate code for (this is called the target for the compile). By default, NQC assumes you are targetting RCX 1.0. If you want to use RCX 2.0 features, you need to tell the compiler you are using an RCX 2.0 target. If you are using a command line version of NQC, then add -Trcx2 to the command line:

```
nqc -Trcx2 -d foo.nqc
```

If you don't want to type -Trcx2 all the time, then just use the environment variable NQC_OPTIONS - NQC reads this environment variable and inserts any options in this variable at the front of the command line. For example, if NQC_OPTIONS was set to -Trcx2 and you issued the following command

```
nqc -d foo.nqc
```

NQC would behave as if you actually typed

```
nqc -Trcx2 -d foo.nqc
```

The specifics of setting environment variables depends on your operating system and shell. For example, under Windows you could type the following in a command shell:

```
set NQC_OPTIONS=-Trcx2
```

If you want to always use RCX 2.0, then you can make this setting permament by editing the AUTOEXEC.BAT file and adding the above command to the end of the file. This way, the variable will get set every time Windows is started.

If you are using a GUI based version of NQC (such as MacNQC), then there should be some preference setting for the target - just make sure it is set to "RCX 2.0". Unfortunately, RcxCC does not have an "RCX 2.0" setting, but there is a workaround. Leave the target as "RCX" (which means RcxCC won't specify any target information and just rely on the fact that NQC defaults to RCX), then use the NQC_OPTIONS environment variable to specify RCX 2.0 (as described above).

### How can I redirect errors to a file?
Compile errors are written to stderr, not stdout. This is to allow the calling program to separate errors from the program listing (-l option) that appears on stdout. The normal redirection facility of a shell only redirects stdout, thus the errors will still be printed to the screen. Most shells have additional syntax that allows the stderr stream to be redirected (use `option->` in MPW, or `2>` for WinNT). I do not know of any mechanism to redirect stderr in Win95 command.com.

In addition, nqcc now supports (verion 1.1 b1) the ability to route error messages to stdout with the -E option.

### Where is Spirit.ocx? RcxCC complains that it is not installed.
NQC has never used Spirit.ocx, but RcxCC used to require Spirit.ocx for communication with the RCX. LEGO no longer supports Spirit.ocx as of RIS 2.0, but fortunately RcxCC has been updated to no longer require it. In addition, RcxCC has been renamed to BricxCC (due to trademark concerns from Lego). You can download the latest version of BricxCC here.


IR Communication
----------------

### How do I get NQC to work with my USB IR tower?
Presently, USB towers are only supported under Mac OS X, Linux, and 32-bit native Windows when using NQC version 2.4a4 or higher.

**IMPORTANT**: you need to tell NQC that you want it to look for a USB tower, otherwise it assumes you have a serial tower and uses the default serial port for your operating system (e.g. COM1 under Windows). Add -Susb to the command line or set the RCX_PORT environment variable to usb. When adding a command line option, put it near the beginning of the command:

```
nqc -Susb -d test.nqc
```

32-bit Windows only: NQC uses the USB driver installed by the Lego RIS 2.0 software, so you will need to install the RIS software and run it once with the USB tower connected in order for the driver to be correctly installed.

Mac OS X only: NQC talks directly to the USB tower. There is no driver, so you'll never see the tower show up in /dev.

FreeBSD (unoffical port): As of NQC 2.5a5, the USB tower is supported when running a FreeBSD build from 02/28/03 or later (the upcoming FreeBSD 5.1 will work).

### How do I use a computer to control the RCX?
There are two basic ways to do this: send raw commands to the RCX, or send 'messages' which are then listened to by a program running on the RCX.

#### Sending Messages
This is generally the simplest way to interact with the RCX. First you write a program for the RCX that continuously checks for received messages (using the Message() and ClearMessage() calls) and then dispatches the messages accordingly. The messages may have any value between 1 and 255. There is no predefined meaning for these messages - your program can do whatever it wants with each message.

There are several ways to send the message. You can use another RCX (or a Scout) by calling the SendMessage() function. You can also use the nqc command with the -msg option, for example to send message #3:

```
nqc -msg 3
```

You can use the LEGO remote control to send messages 1, 2, or 3. It is also possible to send the message by sending the appropriate command packet (see below)

#### Sending Raw Commands
Sending raw commands gives you complete control over the RCX. The commands (a.k.a. opcodes or bytecodes) and the general packet format are unofficially documented at http://graphics.stanford.edu/~kekoa/rcx/. For example, to make the RCX play system sound #3 (upward tones), you would send a two-byte command (shown in hex):

```
51 03
```

Messages are just a specific type of command - F7 followed by the message value, so message #4 would be the packet

```
F7 04
```

If you are using NQC, you can let NQC take care of all the details of packet formatting, getting an acknowledgement from the RCX, and retrying if a failure occurs. You do this with the -raw option, which takes a single parameter listing all of the bytes (in hex format) for the command:

```
nqc -raw 5103
```

If you are writing your own program, you can build up the packet yourself. A suitable packet (for the plays sound command) would be:

```
55 ff 00 51 ae 03 fc 54 ab
```

### How do I use the serial IR tower with a USB Macintosh?
You will need a USB to serial converter (such as the Keyspan TWIN adapter). If the adapter provides a 9-pin serial connector, then you should be able to use the standard Mindstorms cable between the adapter and the IR tower. If the adapter provides Mac-style serial connector, then you will also need an appropriate cable as desribed here.

_Note_: I have heard several reports of the Palm USB adapter not working. I am not sure if this is a problem with the adapter itself, or some unusual interaction between it and the OS. If you have been able to use a Palm USB adapter with MacNQC or NQC, please let me know. I would like to get a definitive answer on whether this adapter can be made to work. Personally, I use the Keyspan Twin adapter (USA-28X), and I've heard that both the Keyspan PDA adapter (USA-19) and Xircom PortGear USB also work.

If you are using MacNQC, then the popup menu in the Preferences dialog box will list all available serial ports (including those provided by USB converters).

If you are using the MPW version of NQC, then you will need to specify the serial port either on the command line (using the -S option) or in the RCX_PORT environment variable. Both methods require that you know the name of the serial port driver. The easiest way to make this work is to use the adapter's control panel to configure the serial port to "emulate the printer port". This will cause the serial port to be named "B", thus you could do either of the following:

```
nqc -SB -d foo.nqc
```

or

```
set -e RCX_PORT B
nqc -d foo.nqc
```

If you choose the second option, the set command only needs to be executed once per MPW session - adding it to a Startup file will make life simpler.

### Help, RcxCC/MacNQC/NQC can't communicate with my RCX!
In most cases, problems like this boil down to a configuration issue, bad cable, or dead battery. Here are some troubleshooting tips.

If the program says it cannot open the serial port, then this is almost certainly a configuration problem. For MacNQC, make sure you have a valid serial port selected in the Preferences dialog box. For NQC, make sure you have specified the appropriate serial port name (default is modem port, "B" is the printer port, see above for USB based macs). For RcxCC, I suggest trying once with auto-detection, and if that fails, then manually set the serial port in the RcxCC program.

If the program reports that it cannot communicate with the IR device, then either the program is talking to the wrong serial port (see the previous item), or there's a problem with the cable and/or battery. Make sure you have a fresh 9v battery installed in the IR tower, and if possible use the cable supplied by Lego.

If the program reports that it cannot communicate with the RCX, then communication with the IR tower is probably OK, and the problem is between the tower and the RCX.

* Certain light sources (bright sunlight, certain projection TVs) can cause interference...try using a towel or other item to shield the IR tower and RCX from other light.
* The tower and RCX should be about 6 inches apart. Tty the switch on the front of the tower in both positions - some people report better success with "near" mode, and some with "far" mode.
* Ensure you have firmware downloaded into the RCX. If the display only shows "1" on it, then firmware isn't installed yet...download the firmware using the Lego software or the -firmware option for NQC (the firmware itself must be copied from the Lego CD or downloaded from www.legomindstorms.com). Once the firmware is installed you should see something like "00.00 1" on the display.

If you have a terminal program (e.g. HyperTerminal for Windows, Zterm for the Mac), then you can check the IR tower directly. Open up a session to the appropriate serial port at 2400 baud, 1 stop bit, odd parity, and 8 data bits. Turn off local echo. Start typing a few characters. A green LED on the front of the IR tower should light up, and the characters you typed should be echoed back to the screen (with an occasional mistake depending on how much interference there is).

If you are using the command line version of NQC, then you can have it log any serial communication. This is helpful in trying to isolate where communication is failing. A good general-purpose test is

```
nqc -v -raw 10
```

Please include the output of this test in any e-mail to me regarding IR communication problems.

### How do I use my computer IR port with the RCX?
You can't. At least not easily.

Most computers use the IrDA protocols for IR communication. The RCX uses a proprietary protocol developed by Lego for communication. Quite simply, these protocols are incompatable.

#### What about IrCom? Doesn't that let me use the IR port as a regular serial port?
Yes and no. From an application's point of view, IrCom looks like a serial port (complete with hardware handshaking and control lines). However, the IrCom layer actually resides on top of normal IrDA communication, so what appears to the application to be async serial communication, is in fact a bunch of IrDA packets getting sent back and forth. Since the RCX doesn't understand IrDA packets, it can't understand IrCom either.

#### What if I access the hardware directly?
Even if you bypassed the IrDA protocol stacks on the computer and somehow managed to control the hardware directly (a task that is likely to be different for different computer vendors), it still may not be possible. The Lego protocols encode bits using a 38kHz carrier frequency. This frequency is generated an filtered in hardware. IrDA doesn't really use a carrier frequency, and the actual specs on bit times provide a lot of lattitued to device manufacturers. As a result, it is difficult to get generic IrDA hardware to generate the required 38kHz carrier reliably. Filtering the recieve side is even more problematic.

I would hesitate to say that this problem is "impossible" to solve, but people have been asking about this for over a year, and to my knowledge no general solution has emerged. There are, however, specialized solutions for specific pieces of hardware (usually PDAs or other handled devices such as a Palm III).

#### How can I get the USB IR tower to work under Win XP?
There appear to be some timing related difficulties when using NQC with the USB tower under Windows XP.  If you are having difficulty downloading programs, open the LEGO USB Tower control panel, select the Advanced Tab, and set the Read Timeout to 300 msec.  This generally fixes the problem.


Miscellaneous
-------------

### Why doesn't NQC use the Spirit OCX?
The Spirit OCX is only available on the PC. My personal preference is to use a Macintosh, so I needed to have a platform independent means for communicating with the RCX.

### Does NQC Support Vision Command?
Vision command programs run in two places...all of the image processing software runs on the PC, then sends messages to a program running on the RCX. The messages that are sent are ordinary RCX messages, and by using Message() and ClearMessage(), NQC programs can respond to them. Mike Gasperi calls this "Using Vision Command as a Smart Sensor".

Note that I have never tried this myself (Vision Command doesn't run on Mac), so I can't really help if things don't work as expected.

### What computers/tools/etc do you use to develop NQC?
All of the NQC development takes place on my Macintosh PowerBook. I use Metrowerks CodeWarrior to write and debug the code as a Macintosh application.

The Code Warrior project also has targets to build the MPW version of NQC as well as the Win32 version. Regression tests on the compiler are done on the PPC version of the MPW tool (via a couple of MPW scripts and a bunch of sample programs). Some minimal testing of the Win32 version is done from within Virtual PC - I just make sure that the build went fine and that the serial port works since that is really the only code custom to Win32.

For the source release, I boot into Mac OS X, copy over the NQC source tree and build it (using make, gcc, etc). A simple test (again just to make sure the serial port code for Unix is working) is performed. I then use a shell script to create a source release tree, strip out any unwanted binaries, and package the entire thing up as a .tar.gz. Recently, I've also been packaging up a Mac OS X binary version.

So there you have it...development for Mac, Windows, and Unix all done on my trusty PowerBook.

&nbsp;

------

Original FAQ by Dave Baum, with select updates by Matthew Sheets
