// Copyright 2021 Filippo Rusconi
// GPLv3+

#pragma once


/////////////////////// StdLib includes



/////////////////////// Qt includes
#include <QObject>
#include <QQmlEngine>
#include <QString>


#include "pappsomspp/config.h"
#include "pappsomspp/export-import-config.h"
#include "baseplotcontext.h"


/////////////////////// Local includes

namespace pappso
{

  /*  BEGIN CLASS JS REFERENCE
   *  namespace: pappso
   *  class name: MassSpecTracePlotContext
   */

class PMSPP_LIB_DECL MassSpecTracePlotContext : public BasePlotContext
{
  Q_OBJECT
  Q_PROPERTY(int lastZ MEMBER m_lastZ)
  Q_PROPERTY(double lastMz MEMBER m_lastMz)
  Q_PROPERTY(double lastTicIntensity MEMBER m_lastTicIntensity)
  Q_PROPERTY(double lastMr MEMBER m_lastMr)
  Q_PROPERTY(double lastResolvingPower MEMBER m_lastResolvingPower)

  QML_ELEMENT

  public:
  Q_INVOKABLE MassSpecTracePlotContext(QObject *parent = nullptr);

  virtual ~MassSpecTracePlotContext();

  Q_INVOKABLE MassSpecTracePlotContext *clone(QObject *parent = nullptr);
  Q_INVOKABLE void initialize(const BasePlotContext &other);
  Q_INVOKABLE void initialize(const MassSpecTracePlotContext &other);

  MassSpecTracePlotContext(const MassSpecTracePlotContext &other)            = delete;
  MassSpecTracePlotContext &operator=(const BasePlotContext &other)          = delete;
  MassSpecTracePlotContext &operator=(const MassSpecTracePlotContext &other) = delete;

  int m_lastZ                 = -1;
  double m_lastMz             = std::numeric_limits<double>::min();
  double m_lastTicIntensity   = std::numeric_limits<double>::min();
  double m_lastMr             = std::numeric_limits<double>::min();
  double m_lastResolvingPower = std::numeric_limits<double>::min();

  Q_INVOKABLE QString toString() const;

  static void registerJsConstructor(QJSEngine *engine);
};

  /*  END CLASS JS REFERENCE
   *  namespace: pappso
   *
   * class name: MassSpecTracePlotContext
   */
PAPPSO_REGISTER_JS_CLASS(pappso, MassSpecTracePlotContext)

} // namespace pappso
