/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Configuration
extends Properties {
    private final Map<String, Pattern> valueSeparatorMap = new HashMap<String, Pattern>();
    public static final String[] EMPTY_LIST = new String[0];
    public static final String COMMA_SEPARATOR = ",";
    private static final Logger LOG = Logger.getLogger(Configuration.class.getName());

    public Configuration(Properties defaults) {
        super(defaults);
    }

    private Configuration() {
    }

    public String getPrefixProperty(String prefix, String key, String Default) {
        String v = super.getProperty(prefix + "." + key);
        if (v != null) {
            return v;
        }
        return super.getProperty(key, Default);
    }

    public int getPrefixInteger(String prefix, String key, int Default) {
        String v = this.getPrefixProperty(prefix, key, null);
        if (v == null) {
            return Default;
        }
        try {
            int i = Integer.decode(v);
            return i;
        }
        catch (NumberFormatException e) {
            LOG.log(Level.WARNING, null, e);
            return Default;
        }
    }

    public String[] getPrefixPropertyList(String prefix, String key) {
        String v = this.getProperty(prefix + "." + key);
        if (v == null) {
            v = this.getProperty(key);
        }
        if (v == null) {
            return EMPTY_LIST;
        }
        return this.getValueSeparator(prefix).split(v);
    }

    public boolean getPrefixBoolean(String prefix, String key, boolean Default) {
        String b = this.getPrefixProperty(prefix, key, null);
        if (b == null) {
            return Default;
        }
        return Boolean.parseBoolean(b.trim());
    }

    public Color getPrefixColor(String prefix, String key, Color Default) {
        String c = this.getPrefixProperty(prefix, key, null);
        if (c == null) {
            return Default;
        }
        try {
            return Color.decode(c);
        }
        catch (NumberFormatException e) {
            return Default;
        }
    }

    public Configuration subConfig(String prefix, String keyPrefix) {
        Configuration sub = new Configuration();
        this.addToSubConf(sub, prefix.length() > 0 ? prefix + "." + keyPrefix : keyPrefix);
        return sub;
    }

    private void addToSubConf(Configuration subConf, String prefix) {
        int prefixLen = prefix.length();
        for (String k : this.stringPropertyNames()) {
            if (!k.startsWith(prefix)) continue;
            subConf.put(k.substring(prefixLen), this.getProperty(k));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern getValueSeparator(String prefix) {
        Map<String, Pattern> map = this.valueSeparatorMap;
        synchronized (map) {
            Pattern val = this.valueSeparatorMap.get(prefix);
            if (val == null) {
                val = Pattern.compile("\\s*" + this.getPrefixProperty(prefix, "ValueSeparator", COMMA_SEPARATOR) + "\\s*");
                this.valueSeparatorMap.put(prefix, val);
            }
            return val;
        }
    }
}

